<!DOCTYPE html>
<html lang="en">
  <head>

    <!-- Required meta tags -->
    <base href="<?php echo base_url(); ?>"/>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Meta -->
    <meta name="description" content="<?php echo $profil['favicon']; ?>">
    <meta name="author" content="ThemePixels">

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="assets/admin/img/<?php echo $profil['favicon']; ?>">

    <title><?php echo $title; ?> - <?php echo $profil['nama']; ?></title>

    <!-- vendor css -->
    <link href="assets/admin/lib/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="assets/admin/lib/ionicons/css/ionicons.min.css" rel="stylesheet">

    <!-- template css -->
    <link rel="stylesheet" href="assets/admin/css/cassie.css">

  </head>
  <body>

    <div class="signin-panel">
    	<img src="assets/admin/img/heart-8390212_1280.jpg">

      <div class="signin-sidebar">
        <div class="signin-sidebar-body">
          <a href="<?php echo uri_string(); ?>" class="sidebar-logo mg-b-40"><span><?php echo $profil['favicon']; ?></span></a>
          <h4 class="signin-title">Welcome back!</h4>
          <h5 class="signin-subtitle"><?php echo $title; ?></h5>

          <?php if($this->session->flashdata('error')): ?>
		<div class="alert alert-danger">
			<b><i class="fa fa-times-circle"></i></b> <?php echo $this->session->flashdata('error'); ?>
		</div>
		<?php endif; ?>
		<?php if($this->session->flashdata('flash')): ?>
		<div class="alert alert-success">
			<b><i class="fa fa-check-circle"></i></b> <?php echo $this->session->flashdata('flash'); ?>
		</div>
		<?php endif; ?>

          <form action="" method="post">
          	<input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
          	<?php if(uri_string() == 'auth') { ?>
          	<div class="signin-form">
	            <div class="form-group">
	              <label>Email</label>
	              <input type="text" class="form-control" placeholder="Enter your email address" name="email" autofocus>
	              <small class="text-danger"><?php echo form_error('email'); ?></small>
	            </div>

	            <div class="form-group">
	              <label class="d-flex justify-content-between">
	                <span>Password</span>
	                <a href="auth/lupa-password" class="tx-13">Lupa password?</a>
	              </label>
	              <input type="password" class="form-control" placeholder="Enter your password" name="password">
	              <small class="text-danger"><?php echo form_error('password'); ?></small>
	            </div>

	            <div class="form-group d-flex mg-b-0">
	              <button class="btn btn-brand-01 btn-uppercase flex-fill" type="submit">Login</button>
	            </div>
	          </div>
          	<?php }else if(uri_string() == 'auth/lupa-password') { ?>
          	<div class="signin-form">
	            <div class="form-group">
	              <label>Email</label>
	              <input type="text" class="form-control" placeholder="Enter your email address" name="email" autofocus>
	              <small class="text-danger"><?php echo form_error('email'); ?></small>
	            </div>

	            <div class="form-group">
	              <label class="d-flex justify-content-between">
	                <a href="auth" class="tx-13">Ingat password?</a>
	              </label>
	            </div>

	            <div class="form-group d-flex mg-b-0">
	              <button class="btn btn-brand-01 btn-uppercase flex-fill" type="submit">Submit</button>
	            </div>
	          </div>
          	<?php }else { ?>
          	<div class="signin-form">

	            <div class="form-group">
	              <label>Password Baru</label>
	              <input type="password" class="form-control" name="password1">
	              <small class="text-danger"><?php echo form_error('password1'); ?></small>
	            </div>

	            <div class="form-group">
	              <label>Konfirmasi Password Baru</label>
	              <input type="password" class="form-control" name="password2">
	              <small class="text-danger"><?php echo form_error('password2'); ?></small>
	            </div>

	            <div class="form-group d-flex mg-b-0">
	              <button class="btn btn-brand-01 btn-uppercase flex-fill" type="submit">Reset</button>
	            </div>
	          </div>
          	<?php } ?>
          </form>
        </div><!-- signin-sidebar-body -->
      </div><!-- signin-sidebar -->
    </div><!-- signin-panel -->

    <script src="assets/admin/lib/jquery/jquery.min.js"></script>
    <script src="assets/admin/lib/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/admin/lib/feather-icons/feather.min.js"></script>
    <script src="assets/admin/lib/perfect-scrollbar/perfect-scrollbar.min.js"></script>

    <script>
      $(function(){

        'use strict'

        feather.replace();

        new PerfectScrollbar('.signin-sidebar', {
          suppressScrollX: true
        });

      })
    </script>
    <script src="assets/admin/js/svg-inline.js"></script>
  </body>
</html>
