<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome_model extends CI_Model {
	public function data_artikel_index() {
		$this->db->order_by('post_tgl', 'DESC');
		return $this->db->get('tb_blog')->result_array();
	}

	public function data_artikel() {
		$this->db->select('*');
		$this->db->from('tb_blog');
		$this->db->join('tb_kategori', 'tb_kategori.kat_id = tb_blog.post_kategori');
		$this->db->order_by('post_tgl', 'DESC');
		return $this->db->get()->result_array();
	}

	public function data_artikelby($url) {
		$this->db->select('*');
		$this->db->from('tb_blog');
		$this->db->join('tb_kategori', 'tb_kategori.kat_id = tb_blog.post_kategori');
		$this->db->where('post_url', $url);
		return $this->db->get()->row_array();
	}

	public function blog_by($ini) {
		$this->db->select('*');
		$this->db->from('tb_blog');
		$this->db->join('tb_kategori', 'tb_kategori.kat_id = tb_blog.post_kategori');
		$this->db->where('post_kategori', $ini);
		return $this->db->get()->result_array();
	}

	public function blog_cari($key) {
		$this->db->select('*');
		$this->db->from('tb_blog');
		$this->db->join('tb_kategori', 'tb_kategori.kat_id = tb_blog.post_kategori');
		$this->db->like('post_judul', $key);
		$this->db->or_like('post_isi', $key);
		return $this->db->get()->result_array();
	}

	public function simpan_regis() {
		$data = array (
			'user_id'			=>   md5(rand()),
			'user_nama'			=>   ucwords($this->input->post('nama')),
			'user_telp'			=>   $this->input->post('telp'),
			'user_email'		=>   strtolower($this->input->post('email')),
			'user_password'		=>   password_hash($this->input->post('password2'), PASSWORD_DEFAULT),
			'user_foto'			=>   'icon-user.svg',
			'user_status'		=>   0,
		);
	
		$token = base64_encode(openssl_random_pseudo_bytes(32));
		$member_token = array (
			'email'					=>	strtolower($this->input->post('email')),
			'token'					=>	$token,
			'created'				=>	time()
		);
		$this->db->insert('tb_users', $data);
		$this->db->insert('tb_token', $member_token);
		$this->_sendemail($token);
	}

	private function _sendemail($token) {
		$cekmail = $this->db->get_where('tb_email',['email_id' => 1])->row_array();
		$cekprof = $this->db->get_where('tb_profil',['id' => 1])->row_array();

		$this->load->library('email');
		$config['charset'] = 'utf-8';
		$config['useragent'] = 'AKTIVASI AKUN '.$cekprof['nama'];
		$config['protocol'] = 'smtp';
		$config['mailtype'] = 'html';
		$config['smtp_host'] = $cekmail['email_ssl'];
		$config['smtp_port'] = '465';
		$config['smtp_timeout'] = '5';
		$config['smtp_user'] = $cekmail['email']; //email anda di sini
		$config['smtp_pass'] = $cekmail['email_password']; // password email anda di sini
		$config['crlf'] = "\r\n";
		$config['newline'] = "\r\n";
		$config['wordwrap'] = TRUE;

		$this->email->initialize($config);

		$this->email->from($cekmail['email'], 'AKTIVASI AKUN '.$cekprof['nama']);  //email anda di sini
		$this->email->to($this->input->post('email'));
        $this->email->subject('AKTIVASI AKUN '.$cekprof['nama']);
		$this->email->message('<h4>Hi, ' .ucwords($this->input->post('nama')) . '</h4>Klik tombol di bawah ini untuk memverifikasi email anda. <p><a href="' . base_url() . 'verify?email=' . $this->input->post('email') . '&token=' . urlencode($token) . '" style="background-color:#44c767;border-radius:28px;border:1px solid #18ab29;display:inline-block;cursor:pointer;color:#ffffff;font-family:Times New Roman;font-size:17px;font-weight:bold;padding:9px 17px;text-decoration:none;text-shadow:0px 1px 0px #2f6627;" target="_blank">Verifikasi</a></p>');

		$this->email->send();
	}

	public function data_galang_dana() {
		$this->db->order_by('gd_tgl', 'DESC');
		return $this->db->get('tb_galang_dana')->result_array();
	}

	public function data_galang_dana_by($url) {
		$cek = $this->db->get_where('tb_kategori_campaign',['kacam_url' => $url])->row_array();
		$this->db->where('gd_kategori', $cek['kacam_id']);
		$this->db->where('gd_tgl_selesai >', date('Y-m-d', strtotime('+5 days')));
		$this->db->order_by('gd_tgl', 'DESC');
		return $this->db->get('tb_galang_dana')->result_array();
	}

	public function get_campaigns_near_end($url) {
		$cek = $this->db->get_where('tb_kategori_campaign',['kacam_url' => $url])->row_array();
		$this->db->where('gd_kategori', $cek['kacam_id']);
        $this->db->where('gd_tgl_selesai >=', date('Y-m-d'));
        $this->db->where('gd_tgl_selesai <=', date('Y-m-d', strtotime('+5 days')));
		$this->db->order_by('gd_tgl_selesai', 'ASC');
        return $this->db->get('tb_galang_dana')->result_array();
    }

	public function data_galang_dana_index() {
		$this->db->order_by('gd_tgl', 'DESC');
		$this->db->limit(7);
		return $this->db->get('tb_galang_dana')->result_array();
	}

	public function data_galang_by($url) {
		$this->db->where('gd_url', $url);
		return $this->db->get('tb_galang_dana')->row_array();
	}

	public function list_dona($url) {
		$cekc = $this->db->get_where('tb_galang_dana',['gd_url' => $url])->row_array();
		$id = $cekc['gd_id'];
		$this->db->select('*');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->order_by('donasi_tgl', 'DESC');
		$this->db->where('donasi_gdid', $id);
		$this->db->where('donasi_status', 2);
		$this->db->limit(7);
		return $this->db->get()->result_array();
	}

	public function data_volunteer() {
		$this->db->select('SUM(donasi_jml) as terkumpul, user_foto as foto, user_nama as nama');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->group_by('user_id');
		$this->db->order_by('donasi_jml', 'DESC');
		$this->db->where('donasi_status', 2);
		$this->db->limit(3);
		return $this->db->get()->result_array();
	}

	public function data_events_index() {
		$this->db->order_by('created', 'DESC');
		$this->db->limit(4);
		return $this->db->get('tb_events')->result_array();
	}

	public function search($keyword, $limit, $offset) {
        $this->db->like('gd_judul', $keyword);
        $this->db->or_like('gd_isi', $keyword);
        $this->db->limit($limit, $offset);
        $query = $this->db->get('tb_galang_dana');
        return $query->result();
    }

    public function count_search($keyword) {
        $this->db->like('gd_judul', $keyword);
        $this->db->or_like('gd_isi', $keyword);
        return $this->db->count_all_results('tb_galang_dana');
    }

    public function get_campaigns_near_end_pilihan_terbaik() {
        $this->db->where('gd_tgl_selesai >=', date('Y-m-d'));
        $this->db->where('gd_tgl_selesai <=', date('Y-m-d', strtotime('+5 days')));
		$this->db->order_by('gd_tgl_selesai', 'ASC');
        return $this->db->get('tb_galang_dana')->result_array();
    }
}