<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_model extends CI_Model {
	public function data_donasi_index() {
		$this->db->select('*');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->order_by('donasi_tgl', 'DESC');
		$this->db->limit(5);
		return $this->db->get()->result_array();
	}

	public function data_donasi() {
		$this->db->select('*');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->order_by('donasi_tgl', 'DESC');
		return $this->db->get()->result_array();
	}

	public function simpan_ka_campaign() {
	    $url = url_title(strtolower($this->input->post('nama')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = './assets/home/categories/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
	                'kacam_url'		=>	$url,
	                'kacam_nama'	=>	ucwords($this->input->post('nama')),
					'kacam_icon'	=>	$gambar['file_name']
	            );
	        	$this->db->insert('tb_kategori_campaign', $data);
	       }
	    }else {
	    	$this->session->set_flashdata('error', 'Kolom icon tidak boleh kosong');
			redirect('admin/kategori-campaign');
	    }
	
	}
	
	public function edit_ka_campaign($id) {
	    $url = url_title(strtolower($this->input->post('nama')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = './assets/home/categories/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
	                'kacam_url'		=>	$url,
	                'kacam_nama'	=>	ucwords($this->input->post('nama')),
					'kacam_icon'	=>	$gambar['file_name']
	            );
	        	$this->db->where('kacam_id', $id);
	        	$this->db->update('tb_kategori_campaign', $data);
	       }
	    }else {
	    	$data = array(
	            'kacam_url'		=>	$url,
                'kacam_nama'	=>	ucwords($this->input->post('nama')),
				'kacam_icon'	=>	$this->input->post('gambar_old')
	        );
	        $this->db->where('kacam_id', $id);
	        $this->db->update('tb_kategori_campaign', $data);
	    }
	
	}

	public function data_galdan() {
		$this->db->select('*');
		$this->db->from('tb_galang_dana');
		$this->db->join('tb_kategori_campaign', 'tb_kategori_campaign.kacam_id = tb_galang_dana.gd_kategori','left');
		$this->db->order_by('gd_tgl', 'DESC');
		return $this->db->get()->result_array();
	}

	public function simpan_galang_dana() {
	    $url = url_title(strtolower($this->input->post('judul')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = './assets/home/img/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array (
					'gd_id'				=>   md5(rand()),
					'gd_url'			=>   $url,
					'gd_tgl_selesai'	=>   $this->input->post('tgl'),
					'gd_judul'			=>   ucwords($this->input->post('judul')),
					'gd_isi'			=>   $this->input->post('isi', false),
					'gd_dana'			=>   $this->input->post('jml'),
					'gd_time'			=>   date('Y-m-d'),
					'gd_foto'			=>   $gambar['file_name'],
					'gd_kategori'		=>   $this->input->post('kategori'),
				);
           }
	    }else {
	    	$this->session->set_flashdata('error', 'Kolom foto tidak boleh kosong');
			redirect('admin/galang-dana/new');
	    }
	
		$this->db->insert('tb_galang_dana', $data);
	}

	public function edit_galang_dana($id) {
	    $url = url_title(strtolower($this->input->post('judul')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = './assets/home/img/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
                    'gd_url'			=>   $url,
					'gd_tgl_selesai'	=>   $this->input->post('tgl'),
					'gd_judul'			=>   ucwords($this->input->post('judul')),
					'gd_isi'			=>   $this->input->post('isi', false),
					'gd_dana'			=>   $this->input->post('jml'),
					'gd_foto'			=>   $gambar['file_name'],
					'gd_kategori'		=>   $this->input->post('kategori'),
                );
           }
	    }else {
	    	$data = array(
	            'gd_url'			=>   $url,
				'gd_tgl_selesai'	=>   $this->input->post('tgl'),
				'gd_judul'			=>   ucwords($this->input->post('judul')),
				'gd_isi'			=>   $this->input->post('isi', false),
				'gd_dana'			=>   $this->input->post('jml'),
				'gd_foto'			=>	 $this->input->post('gambar_old'),
				'gd_kategori'		=>   $this->input->post('kategori'),
	        );
	    }
	
		$this->db->where('gd_id', $id);
		$this->db->update('tb_galang_dana', $data);
	}

	public function data_pengguna() {
		$this->db->order_by('user_nama', 'ASC');
		return $this->db->get('tb_users')->result_array();
	}

	public function simpan_akses() {
	
	    // get foto
	    $config['upload_path'] = './assets/admin/img/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
	                'admin_id'			=>	md5(rand()),
	                'admin_nama'		=>	ucwords($this->input->post('nama')),
	                'admin_email'		=>	strtolower($this->input->post('email')),
					'admin_foto'		=>	$gambar['file_name'],
					'admin_password'	=>	password_hash('12345', PASSWORD_DEFAULT),
	            );
	        	$this->db->insert('tb_admin', $data);
	       }
	    }else {
	    	$data = array(
                'admin_id'			=>	md5(rand()),
                'admin_nama'		=>	ucwords($this->input->post('nama')),
                'admin_email'		=>	strtolower($this->input->post('email')),
				'admin_foto'		=>	'default_avatar.jpg',
				'admin_password'	=>	password_hash('12345', PASSWORD_DEFAULT),
            );
        	$this->db->insert('tb_admin', $data);
	    }
	
	}
	
	public function edit_akses($id) {
		if($this->input->post('password')) {
			// get foto
		    $config['upload_path'] = './assets/admin/img/';
		    $config['allowed_types'] = 'jpg|png|jpeg|gif';
		    $config['encrypt_name'] = TRUE;
		
		    $this->upload->initialize($config);
		    if (!empty($_FILES['gambar']['name'])) {
		        if ( $this->upload->do_upload('gambar') ) {
		            $gambar = $this->upload->data();
		                
		            $data = array(
		                'admin_nama'		=>	ucwords($this->input->post('nama')),
		                'admin_email'		=>	strtolower($this->input->post('email')),
						'admin_foto'		=>	$gambar['file_name'],
						'admin_password'	=>	password_hash($this->input->post('password'), PASSWORD_DEFAULT),
		            );
		        	$this->db->where('admin_id', $id);
		        	$this->db->update('tb_admin', $data);
		       }
		    }else {
		    	$data = array(
		            'admin_nama'		=>	ucwords($this->input->post('nama')),
	                'admin_email'		=>	strtolower($this->input->post('email')),
					'admin_foto'		=>	$this->input->post('gambar_old'),
					'admin_password'	=>	password_hash($this->input->post('password'), PASSWORD_DEFAULT),
		        );
		        $this->db->where('admin_id', $id);
	        	$this->db->update('tb_admin', $data);
		    }
		}else {
			// get foto
		    $config['upload_path'] = './assets/admin/img/';
		    $config['allowed_types'] = 'jpg|png|jpeg|gif';
		    $config['encrypt_name'] = TRUE;
		
		    $this->upload->initialize($config);
		    if (!empty($_FILES['gambar']['name'])) {
		        if ( $this->upload->do_upload('gambar') ) {
		            $gambar = $this->upload->data();
		                
		            $data = array(
		                'admin_nama'		=>	ucwords($this->input->post('nama')),
		                'admin_email'		=>	strtolower($this->input->post('email')),
						'admin_foto'		=>	$gambar['file_name']
		            );
		        	$this->db->where('admin_id', $id);
		        	$this->db->update('tb_admin', $data);
		       }
		    }else {
		    	$data = array(
		            'admin_nama'		=>	ucwords($this->input->post('nama')),
	                'admin_email'		=>	strtolower($this->input->post('email')),
					'admin_foto'		=>	$this->input->post('gambar_old')
		        );
		        $this->db->where('admin_id', $id);
	        	$this->db->update('tb_admin', $data);
		    }
		}
	
	}

	public function simpan_midtrans() {
		$data = array (
			'client'			=>   $this->input->post('client'),
			'server'			=>   $this->input->post('server'),
		);
	
		$this->db->where('id', 1);
		$this->db->update('tb_api', $data);
	}

	public function profit() {
		$this->db->select('SUM(donasi_jml) as profitus');
		$this->db->where('donasi_status', 2);
		$this->db->from('tb_donasi');
		return $this->db->get()->row()->profitus;
	}

	public function data_volunteer_index() {
		$this->db->select('SUM(donasi_jml) as terkumpul, user_foto as foto, user_nama as nama');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->group_by('user_id');
		$this->db->order_by('donasi_jml', 'DESC');
		$this->db->where('donasi_status', 2);
		$this->db->limit(5);
		return $this->db->get()->result_array();
	}

	public function data_volunteer() {
		$this->db->select('SUM(donasi_jml) as terkumpul, user_foto as foto, user_nama as nama, user_telp as telp');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->group_by('user_id');
		$this->db->order_by('terkumpul', 'DESC');
		$this->db->where('donasi_status', 2);
		return $this->db->get()->result_array();
	}

	public function laporan_donasi_sortir($daterange) {
		$this->db->select('*');
		$this->db->from('tb_donasi');
		$this->db->join('tb_users', 'tb_users.user_id = tb_donasi.donasi_userid');
		$this->db->where('donasi_time >=', $daterange[0]);
		$this->db->where('donasi_time <=', $daterange[1]);
		$this->db->order_by('donasi_tgl', 'DESC');
		return $this->db->get()->result_array();
	}

	public function data_galdan_sortir($status) {
		$this->db->from('tb_galang_dana');
		$this->db->join('tb_users', 'tb_users.user_id = tb_galang_dana.gd_userid');
		$this->db->where('gd_status', $status);
		$this->db->order_by('gd_tgl', 'DESC');
		return $this->db->get()->result_array();
	}

	public function data_pengguna_sortir($status) {
		$this->db->where('user_status', $status);
		$this->db->order_by('user_nama', 'ASC');
		return $this->db->get('tb_users')->result_array();
	}

	public function simpan_about() {
		$data = array (
			'nama'			=>   $this->input->post('nama'),
			'email'			=>   strtolower($this->input->post('email')),
			'telp'			=>   $this->input->post('telp'),
			'facebook'		=>   $this->input->post('fb'),
			'instagram'		=>   $this->input->post('ig'),
			'twitter'		=>   $this->input->post('tw'),
			'alamat'		=>   $this->input->post('alamat'),
		);
	
		$this->db->where('id', 1);
		$this->db->update('tb_profil', $data);
	}

	public function data_inbox() {
		$this->db->order_by('tgl', 'DESC');
		return $this->db->get('tb_inbox')->result_array();
	}

	public function data_kategori() {
		return $this->db->get('tb_kategori')->result_array();
	}

	public function simpan_kategori() {
		$url = url_title(strtolower($this->input->post('kategori')), 'dash', TRUE);
		$data = array (
			'kat_id'		=>   md5(time()),
			'kat_nama'		=>   ucwords($this->input->post('kategori')),
			'kat_url'		=>   $url,
		);
	
		$this->db->insert('tb_kategori', $data);
	}

	public function edit_kategori($id) {
		$url = url_title(strtolower($this->input->post('kategori')), 'dash', TRUE);
		$data = array (
			'kat_nama'		=>   ucwords($this->input->post('kategori')),
			'kat_url'		=>   $url,
		);
	
		$this->db->where('kat_id', $id);
		$this->db->update('tb_kategori', $data);
	}

	public function data_blog() {
		$this->db->select('*');
		$this->db->from('tb_blog');
		$this->db->join('tb_kategori', 'tb_kategori.kat_id = tb_blog.post_kategori');
		$this->db->order_by('post_tgl', 'DESC');
		return $this->db->get()->result_array();
	}

	public function simpan_artikel() {
	    $url = url_title(strtolower($this->input->post('judul')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = './assets/home/img/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
                    'post_id'			=>	md5(rand()),
                    'post_kategori'		=>	$this->input->post('kategori'),
                    'post_judul'		=>	ucwords($this->input->post('judul')),
                    'post_isi'			=>	$this->input->post('isi', false),
					'post_foto'			=>	$gambar['file_name'],
                    'post_url'			=>	$url,
                );
           }
	    }else {
	    	$this->session->set_flashdata('error', 'Kolom gambar masih kosong');
			redirect('admin/postingan/artikel/new');
	    }
	
		$this->db->insert('tb_blog', $data);
	}
	
	public function edit_artikel($id) {
	    $url = url_title(strtolower($this->input->post('judul')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = './assets/home/img/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
                    'post_kategori'		=>	$this->input->post('kategori'),
                    'post_judul'		=>	ucwords($this->input->post('judul')),
                    'post_isi'			=>	$this->input->post('isi', false),
					'post_foto'			=>	$gambar['file_name'],
                    'post_url'			=>	$url,
                );
           }
	    }else {
	    	$data = array(
	            'post_kategori'		=>	$this->input->post('kategori'),
                'post_judul'		=>	ucwords($this->input->post('judul')),
                'post_isi'			=>	$this->input->post('isi', false),
				'post_foto'			=>	$this->input->post('gambar_old'),
                'post_url'			=>	$url,
	        );
	    }
	
		$this->db->where('post_id', $id);
		$this->db->update('tb_blog', $data);
	}

	public function update_password() {
		$sandi = $this->input->post('password');
		$sandi2 = password_hash($this->input->post('password2'), PASSWORD_DEFAULT);
		$cek = $this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array();

		if(password_verify($sandi, $cek['admin_password'])) {
			$this->db->set('admin_password', $sandi2);
			$this->db->where('admin_id', $this->session->userdata('id'));
			$this->db->update('tb_admin');
			$this->session->set_flashdata('flash', 'Password anda berhasil diperbaharui');
			redirect('admin/atur/password');
		}else {
			$this->session->set_flashdata('error', 'Konfirmasi password lama salah');
			redirect('admin/atur/password');
		}
	}

	public function update_profil() {
		$sandi = $this->input->post('password');
		$cek = $this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array();

		if(password_verify($sandi, $cek['admin_password'])) {

			// get foto
		    $config['upload_path'] = 'assets/admin/img/';
		    $config['allowed_types'] = 'jpg|png|jpeg|gif';
		    $config['encrypt_name'] = TRUE;
		
		    $this->upload->initialize($config);
		    if (!empty($_FILES['gambar']['name'])) {
		        if ( $this->upload->do_upload('gambar') ) {
		            $gambar = $this->upload->data();
		                
		            $data = array(
	                    'admin_nama'			=>	ucwords($this->input->post('nama')),
	                    'admin_email'			=>	strtolower($this->input->post('email')),
						'admin_foto'			=>	$gambar['file_name'],
	                );
	           }
		    }else {
		    	$data = array(
	                'admin_nama'			=>	ucwords($this->input->post('nama')),
                    'admin_email'			=>	strtolower($this->input->post('email')),
					'admin_foto'			=>	$this->input->post('gambar_old'),
		        );
		    }

			$this->db->where('admin_id', $this->session->userdata('id'));
			$this->db->update('tb_admin', $data);
			$this->session->set_flashdata('flash', 'Profil anda berhasil diperbaharui');
			redirect('admin/atur/profil');
		}else {
			$this->session->set_flashdata('error', 'Konfirmasi password salah');
			redirect('admin/atur/profil');
		}
	}

	public function simpan_email() {
		$data = array (
			'email'					=>   strtolower($this->input->post('email')),
			'email_password'		=>   $this->input->post('password'),
			'email_ssl'				=>   $this->input->post('ssl'),
		);
	
		$this->db->where('email_id', 1);
		$this->db->update('tb_email', $data);
	}

	public function data_events() {
		$this->db->order_by('created', 'DESC');
		return $this->db->get('tb_events')->result_array();
	}

	public function simpan_events() {
		$url = url_title(strtolower($this->input->post('tema')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = 'assets/home/img/event/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
                    'event_id'			=>	md5(time()),
                    'event_tema'		=>	ucwords($this->input->post('tema')),
                    'event_waktu'		=>	$this->input->post('waktu'),
                    'event_lokasi'		=>	ucwords($this->input->post('lokasi')),
                    'event_tgl'			=>	$this->input->post('tgl'),
					'event_foto'		=>	$gambar['file_name'],
                    'event_url'			=>	$url,
                    'event_isi'			=>	$this->input->post('isi', false),
                );
           }
	    }else {
	    	$this->session->set_flashdata('error', 'Kolom foto tidak boleh kosong');
			redirect('admin/events/new');
	    }
	
		$this->db->insert('tb_events', $data);
	}
	
	public function edit_events($id) {
		$url = url_title(strtolower($this->input->post('tema')), 'dash', TRUE);
	
	    // get foto
	    $config['upload_path'] = 'assets/home/img/event/';
	    $config['allowed_types'] = 'jpg|png|jpeg|gif';
	    $config['encrypt_name'] = TRUE;
	
	    $this->upload->initialize($config);
	    if (!empty($_FILES['gambar']['name'])) {
	        if ( $this->upload->do_upload('gambar') ) {
	            $gambar = $this->upload->data();
	                
	            $data = array(
                    'event_tema'		=>	ucwords($this->input->post('tema')),
                    'event_waktu'		=>	$this->input->post('waktu'),
                    'event_lokasi'		=>	ucwords($this->input->post('lokasi')),
                    'event_tgl'			=>	$this->input->post('tgl'),
					'event_foto'		=>	$gambar['file_name'],
					'event_url'			=>	$url,
                    'event_isi'			=>	$this->input->post('isi', false),
                );
           }
	    }else {
	    	$data = array(
	            'event_tema'		=>	ucwords($this->input->post('tema')),
                'event_waktu'		=>	$this->input->post('waktu'),
                'event_lokasi'		=>	ucwords($this->input->post('lokasi')),
                'event_tgl'			=>	$this->input->post('tgl'),
				'event_foto'		=>	$this->input->post('gambar_old'),
				'event_url'			=>	$url,
                'event_isi'			=>	$this->input->post('isi', false),
	        );
	    }
	
		$this->db->where('event_id', $id);
		$this->db->update('tb_events', $data);
	}

	public function simpan_atribut() {
	    $data = array(
	        'slogan' => $this->input->post('slogan'),
	        'logo_teks' => $this->input->post('logo_teks'),
	        'footer' => $this->input->post('footer'),
	    );
	    $this->db->where('id', 1);
	    $this->db->update('tb_profil', $data);
	
	    // Simpan Favicon
	    if (!empty($_FILES['favicon']['name'])) {
	        $config['upload_path'] = './assets/admin/img/';
	        $config['allowed_types'] = 'jpg|jpeg|png|gif';
	        $config['encrypt_name'] = TRUE; // Nama file bisa disesuaikan
	        $this->load->library('upload', $config);
		    $this->upload->initialize($config);
	
	        if ($this->upload->do_upload('favicon')) {
	            $favicon_data = $this->upload->data();
	            $favicon_path = $favicon_data['full_path'];
	
	            // Simpan path favicon ke dalam database
	            $this->db->where('id', 1);
	            $this->db->update('tb_profil', array('favicon' => $favicon_data['file_name']));
	        } else {
	            // Handle jika upload gagal
	            $error = $this->upload->display_errors();
	            // Tambahkan logika sesuai kebutuhan Anda
	        }
	    }else {
	    	$this->db->where('id', 1);
	        $this->db->update('tb_profil', array('favicon' => $this->input->post('favicon_old')));
	    }

	    // Simpan Logo Depan
	    if (!empty($_FILES['logo_depan']['name'])) {
	        $config['upload_path'] = './assets/home/img/home/';
	        $config['allowed_types'] = 'jpg|jpeg|png|gif';
	        $config['encrypt_name'] = TRUE; // Nama file bisa disesuaikan
	        $this->load->library('upload', $config);
		    $this->upload->initialize($config);
	
	        if ($this->upload->do_upload('logo_depan')) {
	            $lodep_data = $this->upload->data();
	            $lodep_path = $lodep_data['full_path'];
	
	            // Simpan path logo depan ke dalam database
	            $this->db->where('id', 1);
	            $this->db->update('tb_profil', array('logo_depan' => $lodep_data['file_name']));
	        } else {
	            // Handle jika upload gagal
	            $error = $this->upload->display_errors();
	            // Tambahkan logika sesuai kebutuhan Anda
	        }
	    }else {
	    	$this->db->where('id', 1);
	        $this->db->update('tb_profil', array('logo_depan' => $this->input->post('lodep_old')));
	    }
	
	}
}