<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('Welcome_model');
		$cepi = $this->db->get_where('tb_api',['id' => 1])->row_array();
		$params = array('server_key' => $cepi['server'], 'production' => true);
		$this->load->library('midtrans');
		$this->midtrans->config($params);
		$this->load->helper('url');
	}

	public function index() {
		$data = array (
			'title'			=>	'Beranda',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'bloglist'		=>	$this->Welcome_model->data_artikel(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'volunteer'		=>	$this->Welcome_model->data_volunteer(),
			'events'		=>	$this->Welcome_model->data_events_index(),
			'galang'		=>	$this->Welcome_model->data_galang_dana_index(),
			'indonasi'		=>	$this->db->get('tb_donasi')->num_rows(),
			'donatur'		=>	$this->db->get('tb_users')->num_rows(),
			'inggal'		=>	$this->db->get_where('tb_galang_dana',['gd_status' => 1])->num_rows(),
			'kategori'		=>	$this->db->limit(3)->get('tb_kategori_campaign')->result_array(),
			'campaigns'		=>	$this->Welcome_model->data_galang_dana(),
		);
		$this->load->view('home/header', $data);
		$this->load->view('home/index', $data);
		$this->load->view('home/footer');
	}

	public function about_me() {
		$data = array (
			'title'			=>	'Tentang Kami',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
		);
		$this->load->view('home/tentang', $data);
	}

	public function contact_me() {
		$data = array (
			'title'			=>	'Hubungi Kami',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
		);
		$this->form_validation->set_rules('pesan', 'pesan', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('email', 'email', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('subjek', 'subjek', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('home/kontak', $data);
		}else {
			$isipes = array (
				'id'				=>	md5(time()),
				'nama'				=>	ucwords($this->input->post('nama')),
				'email'				=>	strtolower($this->input->post('email')),
				'subjek'			=>	$this->input->post('subjek'),
				'isi'				=>	$this->input->post('pesan'),
				'tgl'				=>	date('Y-m-d'),
			);
			$this->db->insert('tb_inbox', $isipes);
			$this->session->set_flashdata('flash', 'Pesan anda berhasil dikirim');
			redirect('hubungi-kami');
		}
	}

	public function donate() {
		$data = array (
			'title'			=>	'Donasi',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'galang'		=>	$this->Welcome_model->data_galang_dana(),
		);
		$this->load->view('home/header', $data);
		$this->load->view('home/donasi', $data);
		$this->load->view('home/footer');
	}

	public function donate_show($url) {
		$cek = $this->db->get_where('tb_galang_dana',['gd_url' => $url])->row_array();
		$data = array (
			'title'			=>	$cek['gd_judul'],
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'galang'		=>	$this->Welcome_model->data_galang_by($url),
			'sidegalang'	=>	$this->Welcome_model->data_galang_dana_index(),
			'listdonasi'	=>	$this->Welcome_model->list_dona($url),
		);
		$this->load->view('home/header', $data);
		$this->load->view('home/detail', $data);
		$this->load->view('home/footer');
	}

	public function donate_konfirm($url) {
		if(!$this->session->userdata('uid')) {
			$cek = $this->db->get_where('tb_galang_dana',['gd_url' => $url])->row_array();
			$data = array (
				'title'			=>	'Konfirmasi Jumlah',
				'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
				'galang'		=>	$this->Welcome_model->data_galang_by($url),
			);
			$this->form_validation->set_rules('amount', 'amount', 'required', [
						'required'	=>	'Kolom ini tidak boleh kosong']);
			$this->form_validation->set_rules('url', 'url', 'required', [
						'required'	=>	'Kolom ini tidak boleh kosong']);
			if($this->form_validation->run() == FALSE) {
				$this->load->view('home/show_bank', $data);
				$this->load->view('home/footer');
			}else {
				$id = md5(rand());

				$sesiin = array (
					'jumlah'		=>	$this->input->post('amount'),
					'url'			=>	$this->input->post('url'),
					'doa'			=>	$this->input->post('doa'),
					'iddo'			=>	$id,
				);

				$this->session->set_userdata($sesiin);
				redirect('konfirmasi-identitas');
			}
		}else {
			$cek = $this->db->get_where('tb_galang_dana',['gd_url' => $url])->row_array();
			$cekprop = $this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array();
			$data = array (
				'title'			=>	'Konfirmasi Jumlah',
				'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
				'galang'		=>	$this->Welcome_model->data_galang_by($url),
			);
			$this->form_validation->set_rules('amount', 'amount', 'required', [
						'required'	=>	'Kolom ini tidak boleh kosong']);
			$this->form_validation->set_rules('url', 'url', 'required', [
						'required'	=>	'Kolom ini tidak boleh kosong']);
			if($this->form_validation->run() == FALSE) {
				$this->load->view('home/show_bank', $data);
				$this->load->view('home/footer');
			}else {
				$userid = md5(rand());
				$id = md5(rand());
				$simpdon = array (
					'donasi_id'					=>	$id,
					'donasi_userid'				=>	$this->session->userdata('uid'),
					'donasi_gdid'				=>	$this->input->post('url'),
					'donasi_jml'				=>	$this->input->post('amount'),
					'donasi_time'				=>	date('Y-m-d'),
					'donasi_status'				=>	1,
					'donasi_doa'				=>	$this->input->post('doa'),
				);

				$sesiin = array (
					'jumlah'		=>	$this->input->post('amount'),
					'url'			=>	$this->input->post('url'),
					'doa'			=>	$this->input->post('doa'),
					'iddo'			=>	$id,
					'nama'			=>  $cekprop['user_nama'],
					'telp'			=>  $cekprop['user_telp'],
					'email'			=>  $cekprop['user_email'],
				);

				$this->db->insert('tb_donasi', $simpdon);
				$this->session->set_userdata($sesiin);
				redirect('metode');
			}
		}
	}

	public function konfirmasi_identitas() {
		$cekc = $this->db->get_where('tb_galang_dana',['gd_id' => $this->session->userdata('url')])->row_array();
		if(!$this->session->userdata('jumlah')) {
			redirect('konfirmasi-donasi/'.$cekc['gd_url']);
		}
		$data = array (
			'title'			=>	'Konfirmasi Identitas',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('email', 'email', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('telp', 'telp', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('home/konfirmasi_identitas', $data);
			$this->load->view('home/footer');
		}else {
			$cek = $this->db->get_where('tb_users',['user_email' => $this->input->post('email')])->row_array();
			if($cek) {
				$this->session->set_userdata('uid', $cek['user_id']);
				$this->session->set_userdata('ustatus', 'sudahlogin');
				$cekprop = $this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array();
				$userid = md5(rand());
				$id = md5(rand());
				$simpdon = array (
					'donasi_id'					=>	$id,
					'donasi_userid'				=>	$this->session->userdata('uid'),
					'donasi_gdid'				=>	$this->session->userdata('url'),
					'donasi_jml'				=>	$this->session->userdata('jumlah'),
					'donasi_time'				=>	date('Y-m-d'),
					'donasi_status'				=>	1,
					'donasi_doa'				=>	$this->session->userdata('doa'),
				);

				$sesiin = array (
					'iddo'			=>	$id,
					'nama'			=>  $cekprop['user_nama'],
					'telp'			=>  $cekprop['user_telp'],
					'email'			=>  $cekprop['user_email'],
				);

				$this->db->insert('tb_donasi', $simpdon);
				$this->session->set_userdata($sesiin);
				redirect('metode');
			}else {
				$userid = md5(rand());
				$regisbaru = array (
					'user_id'			=>   $userid,
					'user_nama'			=>   ucwords($this->input->post('nama')),
					'user_telp'			=>   $this->input->post('telp'),
					'user_email'		=>   strtolower($this->input->post('email')),
					'user_password'		=>   password_hash('12345', PASSWORD_DEFAULT),
					'user_foto'			=>   'icon-user.svg',
					'user_status'		=>   1,
				);
			
				if($this->db->insert('tb_users', $regisbaru)) {
					$id = md5(rand());
					$this->session->set_userdata('uid', $userid);
					$this->session->set_userdata('ustatus', 'sudahlogin');
					$cekprop = $this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array();
					$simpdon = array (
						'donasi_id'					=>	$id,
						'donasi_userid'				=>	$this->session->userdata('uid'),
						'donasi_gdid'				=>	$this->session->userdata('url'),
						'donasi_jml'				=>	$this->session->userdata('jumlah'),
						'donasi_time'				=>	date('Y-m-d'),
						'donasi_status'				=>	1,
						'donasi_doa'				=>	$this->session->userdata('doa'),
					);

					$sesiin = array (
						'iddo'			=>	$id,
						'nama'			=>  $cekprop['user_nama'],
						'telp'			=>  $cekprop['user_telp'],
						'email'			=>  $cekprop['user_email'],
					);

					$this->db->insert('tb_donasi', $simpdon);
					$this->session->set_userdata($sesiin);
					redirect('metode');
				}
			}
		}
	}

	public function meth() {
		if(!$this->session->userdata('uid')) {
			redirect('login');
		}
		if(!$this->session->userdata('jumlah')) {
			redirect('konfirmasi-donasi/'.$cekc['gd_url']);
		}
		$cekc = $this->db->get_where('tb_galang_dana',['gd_id' => $this->session->userdata('url')])->row_array();
		$url = $cekc['gd_url'];
		if(!$this->session->userdata('telp')) {
			redirect('donasi/'.$cekc['gd_url']);
		}
		$data = array (
			'title'			=>	'Metode Pembayaran',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'galang'		=>	$this->Welcome_model->data_galang_by($url),
		);
		$this->load->view('home/metode', $data);
		$this->load->view('home/footer');
	}

	public function token() {
		$cek = $this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array();
		// Required
		$transaction_details = array(
		  'order_id' => rand(),
		  'gross_amount' => $this->session->userdata('jumlah'), // no decimal allowed for creditcard
		);

		// Optional
		$customer_details = array(
		  'first_name'    => $this->session->userdata('nama'),
		  'email'         => $this->session->userdata('email'),
		  'phone'         => $this->session->userdata('telp')
		);

		// Data yang akan dikirim untuk request redirect_url.
        $credit_card['secure'] = true;
        //ser save_card true to enable oneclick or 2click
        //$credit_card['save_card'] = true;

        $time = time();
        $custom_expiry = array(
            'start_time' => date("Y-m-d H:i:s O",$time),
            'unit' => 'hour', 
            'duration'  => 4
        );
        
        $transaction_data = array(
            'transaction_details'=> $transaction_details,
            // 'item_details'       => $item_details,
            'customer_details'   => $customer_details,
            'credit_card'        => $credit_card,
            'expiry'             => $custom_expiry
        );

		error_log(json_encode($transaction_data));
		$snapToken = $this->midtrans->getSnapToken($transaction_data);
		error_log($snapToken);
		echo $snapToken;
    }

    public function send() {
    	$id = $this->session->userdata('iddo');
    	if($this->input->post('result_data') == '') {
    		redirect('');
    	}else {
    		$result = json_decode($this->input->post('result_data'),true);
    		$jenispay = $result['payment_type'];
    		$howtopay = $result['pdf_url'];
    		if($result['va_numbers']) { // virtual account yg tersedia hanya bank bca, bni, bri
		    	$valist = json_encode($result['va_numbers']);
		    	$valisti = json_decode($valist, true);
		    	$bank = $valisti[0]['bank'];
		    	$nova = $valisti[0]['va_number'];
    		}else if($result['bill_key']) {
    			$bank = 'Mandiri';
		    	$nova = $result['bill_key'];
    		}else {
    			$bank = 'Permata';
		    	$nova = $result['permata_va_number'];
    		}

    		$updatedon = array (
    			'donasi_bank'			=>	$bank,
    			'donasi_va'				=>	$nova,
				'donasi_htp'			=>	$howtopay,
				'donasi_type'			=>	$jenispay,
    		);
    		$this->db->where('donasi_id', $id);
    		$this->db->update('tb_donasi', $updatedon);
    		redirect('tagihan-donasi/'.$id);
    	}

    }

	public function donate_invoice($id) {
		$data = array (
			'title'			=>	'Invoice',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'donasi'		=>	$this->db->get_where('tb_donasi',['donasi_id' => $id])->row_array(),
		);
		$this->load->view('home/tagihan', $data);
		$this->load->view('home/footer');
	}

	public function ka_campaign() {
		$data = array (
			'title'			=>	'Kategori Campaign',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'kategori'		=>	$this->db->get('tb_kategori_campaign')->result_array(),
		);
		$this->load->view('home/header', $data);
		$this->load->view('home/ka_campaign', $data);
		$this->load->view('home/footer');
	}

	public function ka_campaign_single($url) {
		$cek = $this->db->get_where('tb_kategori_campaign',['kacam_url' => $url])->row_array();
		$data = array (
			'title'			=>	'Kategori Campaign '.$cek['kacam_nama'],
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'galang'		=>	$this->Welcome_model->data_galang_dana_by($url),
			'panggilan'		=>	$this->Welcome_model->get_campaigns_near_end($url),
			'vkategori'		=>	$cek['kacam_nama'],
		);
		$this->load->view('home/header', $data);
		$this->load->view('home/kategori_galang_dana', $data);
		$this->load->view('home/footer');
	}

	public function artikel() {
		$data = array (
			'title'			=>	'Blog',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'bloglist'		=>	$this->Welcome_model->data_artikel(),
			'blogside'		=>	$this->Welcome_model->data_artikel(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
		);
		$this->load->view('home2/header', $data);
		$this->load->view('home2/blog', $data);
		$this->load->view('home2/footer');
	}

	public function artikel_single($url) {
		$cek = $this->db->get_where('tb_blog',['post_url' => $url])->row_array();
		$data = array (
			'title'			=>	$cek['post_judul'],
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'blogid'		=>	$this->Welcome_model->data_artikelby($url),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'blogside'		=>	$this->Welcome_model->data_artikel(),
			'disqus'		=>	$this->disqus->get_html(),
		);
		$this->load->view('home/single_blog', $data);
	}

	public function kategori($kategori) {
		$cek = $this->db->get_where('tb_kategori',['kat_url' => $kategori])->row_array();
		$ini = $cek['kat_id'];
		$data = array (
			'title'			=>	$cek['kat_nama'],
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'bloglist'		=>	$this->Welcome_model->blog_by($ini),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'blogside'		=>	$this->Welcome_model->data_artikel(),
		);
		$this->load->view('home2/header', $data);
		$this->load->view('home2/blog', $data);
		$this->load->view('home2/footer');
	}

	public function pencarian() {
		$key = $this->input->post('cari');
		$data = array (
			'title'			=>	$key,
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'bloglist'		=>	$this->Welcome_model->blog_cari($key),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'blogside'		=>	$this->Welcome_model->data_artikel(),
		);
		$this->load->view('home2/header', $data);
		$this->load->view('home2/blog', $data);
		$this->load->view('home2/footer');
	}

	public function pencarian_galang_dana() {
		$data = array (
			'title'			=>	'Pencarian',
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'pilihanli'		=>	$this->Welcome_model->get_campaigns_near_end_pilihan_terbaik(),
			'kategori'		=>	$this->db->limit(3)->get('tb_kategori_campaign')->result_array(),
		);
		$this->load->view('home/header', $data);
		$this->load->view('home/galang_dana_search', $data);
		$this->load->view('home/footer');
	}

	public function search_x() {
        $keyword = $this->input->get('key');
        $page = $this->input->get('page');
        $limit = 10; // jumlah data per halaman
        $offset = ($page - 1) * $limit;

        $data['results'] = $this->Welcome_model->search($keyword, $limit, $offset);
        echo $this->load->view('home/search_results', $data, true);
    }

    public function event_single($url) {
		$cek = $this->db->get_where('tb_events',['event_url' => $url])->row_array();
		$data = array (
			'title'			=>	$cek['event_tema'],
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'evid'			=>	$this->db->get_where('tb_events',['event_url' => $url])->row_array(),
			'meu'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
		);
		$this->load->view('home/single_event', $data);
	}
}
