<?php 
        function waktu_lalu($timestamp) {
    $selisih = time() - strtotime($timestamp) ;
    $detik = $selisih ;
    $menit = round($selisih / 60 );
    $jam = round($selisih / 3600 );
    $hari = round($selisih / 86400 );
    $minggu = round($selisih / 604800 );
    $bulan = round($selisih / 2419200 );
    $tahun = round($selisih / 29030400 );
    if ($detik <= 60) {
        $waktu = $detik.' detik yang lalu';
    } else if ($menit <= 60) {
        $waktu = $menit.' menit yang lalu';
    } else if ($jam <= 24) {
        $waktu = $jam.' jam yang lalu';
    } else if ($hari <= 7) {
        $waktu = $hari.' hari yang lalu';
    } else if ($minggu <= 4) {
        $waktu = $minggu.' minggu yang lalu';
    } else if ($bulan <= 12) {
        $waktu = $bulan.' bulan yang lalu';
    } else {
        $waktu = $tahun.' tahun yang lalu';
    }
    return $waktu;
}
         ?>


<div class="content-header">
        <div>
          <h4 class="content-title"><?php echo $title; ?></h4>
        </div>
      </div><!-- content-header -->
      <div class="content-body">
      	<?php if($this->session->flashdata('flash')): ?>
		<div class="alert alert-success m-2"><i class="fa fa-check"></i> <?php echo $this->session->flashdata('flash'); ?></div>
		<?php endif; ?>
      	<table id="example1" class="table">
	        <thead>
	          <tr>
	          	<th>No</th>
				<th>Nama</th>
				<th>Email</th>
				<th>Status</th>
				<th>Foto</th>
				<th>Alamat</th>
				<th>User Sejak</th>
				<th>Opsi</th>
	          </tr>
	        </thead>
	        <tbody>
	        	<?php $i = 1; ?>
				<?php foreach($users as $us): ?>
				<tr>
					<td><?php echo $i; ?>.</td>
					<td><?php echo $us['user_nama']; ?> <br><?php echo $us['user_telp']; ?></td>
					<td><?php echo $us['user_email']; ?></td>
					<td>
						<?php if($us['user_status'] == 1) { ?>
							<span class="badge badge-success">Aktif</span>
						<?php }else if($us['user_status'] == 0) { ?>
							<span class="badge badge-warning">Belum Aktif</span>
						<?php }else { ?>
							<span class="badge badge-danger">Diblokir</span>
						<?php } ?>
					</td>
					<td><img src="assets/home/img/image_sementara/<?php echo $us['user_foto']; ?>" width="50"></td>
					<td><?php echo $us['user_alamat']; ?></td>
					<td><?php echo waktu_lalu($us['user_since']); ?></td>
					<td class="text-right">
						<a href="admin/pengguna/aktifkan/<?php echo $us['user_id']; ?>" class="btn btn-sm btn-success"><i class="fa fa-check me-1"></i> Aktifkan</a>
						<a href="admin/pengguna/blokir/<?php echo $us['user_id']; ?>" class="btn btn-sm btn-danger"><i class="fa fa-ban me-1"></i>Blokir</a>
					</td>
				</tr>
				<?php $i++; ?>
				<?php endforeach; ?>
	        </tbody>
	      </table>
      </div><!-- content-body -->