<?php 
        function waktu_lalu($timestamp) {
    $selisih = time() - strtotime($timestamp) ;
    $detik = $selisih ;
    $menit = round($selisih / 60 );
    $jam = round($selisih / 3600 );
    $hari = round($selisih / 86400 );
    $minggu = round($selisih / 604800 );
    $bulan = round($selisih / 2419200 );
    $tahun = round($selisih / 29030400 );
    if ($detik <= 60) {
        $waktu = $detik.' detik yang lalu';
    } else if ($menit <= 60) {
        $waktu = $menit.' menit yang lalu';
    } else if ($jam <= 24) {
        $waktu = $jam.' jam yang lalu';
    } else if ($hari <= 7) {
        $waktu = $hari.' hari yang lalu';
    } else if ($minggu <= 4) {
        $waktu = $minggu.' minggu yang lalu';
    } else if ($bulan <= 12) {
        $waktu = $bulan.' bulan yang lalu';
    } else {
        $waktu = $tahun.' tahun yang lalu';
    }
    return $waktu;
}
         ?>
<div class="content-header">
        <div>
          <h4 class="content-title"><?php echo $title; ?></h4>
        </div>
      </div><!-- content-header -->
      <div class="content-body">
      	<div class="mb-2">
			<?php if($status == '') { ?>
			<a href="admin/laporan/pengguna/excel" class="btn btn-primary">
				<i class="fas fa-file-excel"></i>
			</a>
			<a href="admin/laporan/pengguna/print" class="btn btn-primary" target="_blank">
				<i class="fas fa-print"></i>
			</a>
			<?php }else { ?>
				<a href="admin/laporan/pengguna/excel/<?php echo $status; ?>" class="btn btn-primary">
					<i class="fas fa-file-excel"></i>
				</a>
				<a href="admin/laporan/pengguna/print/<?php echo $status; ?>" class="btn btn-primary" target="_blank">
					<i class="fas fa-print"></i>
				</a>
			<?php } ?>
			<a class="btn btn-primary" data-toggle="collapse" href="#collapseExample" role="button" aria-expanded="false" aria-controls="collapseExample">
				<i class="fas fa-filter"></i>
			</a>
		</div>
		<div class="collapse mg-t-5" id="collapseExample">
		  <div class="card card-body">
		  	<form action="" method="post">
		  		<input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
		  		<div class="row">
		  			<div class="form-group col-md-3">
		  				<label>Status</label>
		  				<select name="status" class="form-control form-control-sm" required="">
		  					<option value="">-Pilih-</option>
		  					<option value="1">Aktif</option>
		  					<option value="0">Belum Aktif</option>
		  					<option value="2">Diblokir</option>
		  				</select>
		  			</div>
		  			<div class="form-group col-md-3">
		  				<button style="margin-top: 29px;" type="submit" class="btn btn-success btn-sm">Lihat</button>
		  			</div>
		  		</div>
		  	</form>
		  </div>
		</div>
      	<table id="myTable" class="table">
	        <thead>
	          <tr>
	          	<th class="wd-5p">No</th>
				<th>Nama</th>
				<th>Email</th>
				<th>Status</th>
				<th>Alamat</th>
				<th>User Sejak</th>
	          </tr>
	        </thead>
	        <tbody>
	        	<?php $i = 1; ?>
				<?php foreach($users as $us): ?>
				<tr>
					<td><?php echo $i; ?>.</td>
					<td><?php echo $us['user_nama']; ?> <br><?php echo $us['user_telp']; ?></td>
					<td><?php echo $us['user_email']; ?></td>
					<td>
						<?php if($us['user_status'] == 1) { ?>
							<span class="badge badge-success">Aktif</span>
						<?php }else if($us['user_status'] == 0) { ?>
							<span class="badge badge-warning">Belum Aktif</span>
						<?php }else { ?>
							<span class="badge badge-danger">Diblokir</span>
						<?php } ?>
					</td>
					<td><?php echo $us['user_alamat']; ?></td>
					<td><?php echo waktu_lalu($us['user_since']); ?></td>
				</tr>
				<?php $i++; ?>
				<?php endforeach; ?>
	        </tbody>
	      </table>
      </div><!-- content-body -->