<div class="content-header">
<div>
  <h4 class="content-title"><?php echo $title; ?></h4>
</div>
</div><!-- content-header -->
<div class="content-body">
	<?php if($this->session->flashdata('error')): ?>
	<div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
	<?php endif; ?>
	<form action="" method="post" enctype="multipart/form-data">
		<input type="hidden" name="<?php echo $this->security->get_csrf_token_name(); ?>" value="<?php echo $this->security->get_csrf_hash(); ?>">
		<div class="form-group">
			<label>Tema</label>
			<input type="text" class="form-control" name="tema" value="<?php echo set_value('tema'); ?>" autofocus>
			<small class="text-danger"><?php echo form_error('tema'); ?></small>
		</div>
		<div class="row">
			<div class="form-group col-md-6">
				<label>Tanggal</label>
				<input type="date" class="form-control" min="<?php echo date('Y-m-d'); ?>" name="tgl" value="<?php echo set_value('tgl'); ?>">
				<small class="text-danger"><?php echo form_error('tgl'); ?></small>
			</div>
			<div class="form-group col-md-6">
				<label>Waktu</label>
				<input type="text" class="form-control" name="waktu" value="<?php echo set_value('waktu'); ?>" placeholder="09:00 AM - 11:00 AM">
				<small class="text-danger"><?php echo form_error('waktu'); ?></small>
			</div>
		</div>
		<div class="row">
			<div class="form-group col-md-6">
				<label>Lokasi</label>
				<input type="text" class="form-control" name="lokasi" value="<?php echo set_value('lokasi'); ?>">
				<small class="text-danger"><?php echo form_error('lokasi'); ?></small>
			</div>
			<div class="form-group col-md-6">
				<label>Foto</label>
				<input type="file" class="form-control" name="gambar" required>
			</div>
		</div>
		<div class="form-group">
			<label>Deskripsi</label>
			<textarea name="isi" class="form-control" cols="30" rows="17" id="summernote"><?php echo set_value('isi'); ?></textarea>
			<small class="text-danger"><?php echo form_error('isi'); ?></small>
		</div>
		<div class="form-group">
			<button type="button" onclick="goBack();" class="btn btn-warning">Batal</button>
			<button type="submit" class="btn btn-success">Simpan</button>
		</div>
	</form>
</div><!-- content-body -->