<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('User_model');
		if($this->session->userdata('ustatus') != 'sudahlogin') {
			redirect('login');
		}
	}

	public function index() {
		$data = array (
			'title'			=>	'Profil',
			'me'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'donasiku'		=>	$this->User_model->donasisaya(),
			'donasix'		=>	$this->db->get_where('tb_donasi',['donasi_userid' => $this->session->userdata('uid')])->num_rows(),
			'galangdana'	=>	$this->db->get_where('tb_galang_dana',['gd_userid' => $this->session->userdata('uid')])->num_rows(),
		);
		$this->load->view('user/landing', $data);
		$this->load->view('home/footer');
	}

	public function donasi() {
		$data = array (
			'title'			=>	'Donasi Saya',
			'me'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'donasi'		=>	$this->User_model->data_donasi(),
		);
		$this->load->view('user/donasi', $data);
		$this->load->view('home/footer');
	}

	public function set_password() {
		$data = array (
			'title'			=>	'Atur Password',
			'me'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
		);
		$this->form_validation->set_rules('password1', 'password1', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('password2', 'password2', 'required|matches[password1]', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'matches'	=>	'Konfirmasi password baru salah']);
		$this->form_validation->set_rules('password', 'password', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('user/password', $data);
		}else {
			$this->User_model->simpan_password();
		}
	}

	public function set_profil() {
		$data = array (
			'title'			=>	'Atur Profil',
			'me'			=>	$this->db->get_where('tb_users',['user_id' => $this->session->userdata('uid')])->row_array(),
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('email', 'email', 'required|valid_email', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'valid_email'=>	'Email harus valid']);
		$this->form_validation->set_rules('telp', 'telp', 'required|numeric', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'numeric'	=>	'Harus angka']);
		$this->form_validation->set_rules('alamat', 'alamat', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('password', 'password', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('user/profil', $data);
		}else {
			$this->User_model->simpan_profil();
		}
	}
}