<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('Admin_model');
		if($this->session->userdata('status') != 'oklog') {
			redirect('auth');
		}
	}

	public function index() {
		$data = array (
			'title'			=>	'Dashboard',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'trx'			=>	$this->db->get('tb_donasi')->num_rows(),
			'profit'		=>	$this->Admin_model->profit(),
			'pengguna'		=>	$this->db->get('tb_users')->num_rows(),
			'galang'		=>	$this->db->get('tb_galang_dana')->num_rows(),
			'listdonasi'	=>	$this->Admin_model->data_donasi_index(),
			'topdonatur'	=>	$this->Admin_model->data_volunteer_index(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/index', $data);
		$this->load->view('admin/footer');
	}

	public function donasi() {
		$data = array (
			'title'			=>	'Donasi',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donasi'		=>	$this->Admin_model->data_donasi(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/donasi', $data);
		$this->load->view('admin/footer');
	}

	public function donasi_masuk($id) {
		$this->db->set('donasi_status', 2);
		$this->db->where('donasi_id', $id);
		$this->db->update('tb_donasi');
		redirect('admin/donasi');
	}

	public function donasi_tolak($id) {
		$this->db->set('donasi_status', 3);
		$this->db->where('donasi_id', $id);
		$this->db->update('tb_donasi');
		redirect('admin/donasi');
	}

	public function ka_campaign() {
		$data = array (
			'title'			=>	'Kategori Campaign',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kategori'		=>	$this->db->get('tb_kategori_campaign')->result_array(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/ka_campaign', $data);
		$this->load->view('admin/footer');
	}

	public function ka_campaign_add() {
		$data = array (
			'title'			=>	'Input Kategori Campaign',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required|is_unique[tb_kategori_campaign.kacam_nama]', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'is_unique'	=>	'Kategori ini sudah digunakan']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/ka_campaign_add', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_ka_campaign();
			$this->session->set_flashdata('flash', 'Data baru berhasil ditambahkan');
			redirect('admin/kategori-campaign');
		}
	}

	public function ka_campaign_edit($id) {
		$data = array (
			'title'			=>	'Edit Kategori Campaign',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kacaid'		=>	$this->db->get_where('tb_kategori_campaign',['kacam_id' => $id])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/ka_campaign_edit', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->edit_ka_campaign($id);
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/kategori-campaign');
		}
	}

	public function ka_campaign_del($id) {
		$this->db->where('kacam_id', $id);
		$this->db->delete('tb_kategori_campaign');
		$this->session->set_flashdata('flash', 'Data berhasil dihapus');
		redirect('admin/kategori-campaign');
	}

	public function galdan() {
		$data = array (
			'title'			=>	'Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galangdana'	=>	$this->Admin_model->data_galdan(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/galang_dana', $data);
		$this->load->view('admin/footer');
	}

	function upload_image(){
        if(isset($_FILES["image"]["name"])){
            $config['upload_path'] = './assets/home/img/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('image')){
                $this->upload->display_errors();
                return FALSE;
            }else{
                $data = $this->upload->data();
                echo base_url().'assets/home/img/'.$data['file_name'];
            }
        }
    }

    //Delete image summernote
    function delete_image(){
        $src = $this->input->post('src');
        $file_name = str_replace(base_url(), '', $src);
        if(unlink($file_name))
        {
            echo 'File Delete Successfully';
        }
    }

	public function galdan_add() {
		$data = array (
			'title'			=>	'Mulai Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kategori'		=>	$this->db->get('tb_kategori_campaign')->result_array(),
		);
		$this->form_validation->set_rules('judul', 'judul', 'required|is_unique[tb_galang_dana.gd_judul]', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'is_unique'	=>	'Judul ini sudah digunakan']);
		$this->form_validation->set_rules('isi', 'isi', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('jml', 'jml', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('tgl', 'tgl', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('kategori', 'kategori', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/galang_dana_add', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_galang_dana();
			$this->session->set_flashdata('flash', 'Data baru berhasil ditambahkan');
			redirect('admin/galang-dana');
		}
	}

	public function galdan_edit($id) {
		$data = array (
			'title'			=>	'Edit Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kategori'		=>	$this->db->get('tb_kategori_campaign')->result_array(),
			'galang'		=>	$this->db->get_where('tb_galang_dana',['gd_id' => $id])->row_array(),
		);
		$this->form_validation->set_rules('judul', 'judul', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('isi', 'isi', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('jml', 'jml', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('tgl', 'tgl', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('kategori', 'kategori', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/galang_dana_edit', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->edit_galang_dana($id);
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/galang-dana');
		}
	}

	public function galdan_del($id) {
		$this->db->where('gd_id', $id);
		$this->db->delete('tb_galang_dana');
		$this->session->set_flashdata('flash', 'Data berhasil dihapus');
		redirect('admin/galang-dana');
	}

	public function pengguna() {
		$data = array (
			'title'			=>	'Pengguna',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'users'			=>	$this->Admin_model->data_pengguna(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/users', $data);
		$this->load->view('admin/footer');
	}

	public function user_aktif($id) {
		$this->db->set('user_status', 1);
		$this->db->where('user_id', $id);
		$this->db->update('tb_users');
		$this->session->set_flashdata('flash','Pengguna berhasil di aktifkan');
		redirect('admin/pengguna');
	}

	public function user_blok($id) {
		$this->db->set('user_status', 2);
		$this->db->where('user_id', $id);
		$this->db->update('tb_users');
		$this->session->set_flashdata('flash','Pengguna berhasil di blokir');
		redirect('admin/pengguna');
	}

	public function akses() {
		$data = array (
			'title'			=>	'Akses',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'akses'			=>	$this->db->get('tb_admin')->result_array(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/akses', $data);
		$this->load->view('admin/footer');
	}

	public function akses_add() {
		$data = array (
			'title'			=>	'Input Akses',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('email', 'email', 'required|is_unique[tb_admin.admin_email]', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'is_unique'	=>	'Email ini sudah digunakan']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/akses_add', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_akses();
			$this->session->set_flashdata('flash', 'Data baru berhasil ditambahkan');
			redirect('admin/akses');
		}
	}

	public function akses_edit($id) {
		$data = array (
			'title'			=>	'Edit Akses',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'aksid'			=>	$this->db->get_where('tb_admin',['admin_id' => $id])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('email', 'email', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/akses_edit', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->edit_akses($id);
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/akses');
		}
	}

	public function akses_del($id) {
		$this->db->where('admin_id', $id);
		$this->db->delete('tb_admin');
		$this->session->set_flashdata('flash', 'Data berhasil dihapus');
		redirect('admin/akses');
	}

	public function events() {
		$data = array (
			'title'			=>	'Events',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'events'		=>	$this->Admin_model->data_events(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/events', $data);
		$this->load->view('admin/footer');
	}

	public function events_add() {
		$data = array (
			'title'			=>	'Buat Events',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
		);
		$this->form_validation->set_rules('tema', 'tema', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('tgl', 'tgl', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('waktu', 'waktu', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('lokasi', 'lokasi', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/events_add', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_events();
			$this->session->set_flashdata('flash', 'Data baru berhasil ditambahkan');
			redirect('admin/events');
		}
	}

	public function events_edit($id) {
		$data = array (
			'title'			=>	'Edit Events',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'evid'			=>	$this->db->get_where('tb_events',['event_id' => $id])->row_array(),
		);
		$this->form_validation->set_rules('tema', 'tema', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('tgl', 'tgl', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('waktu', 'waktu', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('lokasi', 'lokasi', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/events_edit', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->edit_events($id);
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/events');
		}
	}

	public function events_del($id) {
		$this->db->where('event_id', $id);
		$this->db->delete('tb_events');
		$this->session->set_flashdata('flash', 'Data berhasil dihapus');
		redirect('admin/events');
	}

	public function laporan_top_donatur() {
		$data = array (
			'title'			=>	'Laporan Top Donatur',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donatur'		=>	$this->Admin_model->data_volunteer(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/donatur', $data);
		$this->load->view('admin/footer');
	}

	public function laporan_top_donatur_excel() {
		$data = array (
			'title'			=>	'Laporan Top Donatur',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donatur'		=>	$this->Admin_model->data_volunteer(),
		);
		$this->load->view('admin/topdon_excel', $data);
	}

	public function laporan_top_donatur_print() {
		$data = array (
			'title'			=>	'Laporan Top Donatur',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donatur'		=>	$this->Admin_model->data_volunteer(),
		);
		$this->load->view('admin/topdon_print', $data);
	}

	public function laporan_donasi_masuk() {
		$mulai = $this->input->post('start');
		$sampai = $this->input->post('end');
		if($mulai == '' AND $sampai == '') {
			$data = array (
				'title'			=>	'Laporan Donasi Masuk',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'donasi'		=>	$this->Admin_model->data_donasi(),
				'mulai'			=>	$mulai,
				'sampai'		=>	$sampai,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_donasi_masuk', $data);
			$this->load->view('admin/footer');
		}else {
			$data = array (
				'title'			=>	'Laporan Donasi Masuk',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'donasi'		=>	$this->Admin_model->laporan_donasi_sortir(array($mulai,$sampai)),
				'mulai'			=>	$mulai,
				'sampai'		=>	$sampai,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_donasi_masuk', $data);
			$this->load->view('admin/footer');
		}
	}

	public function laporan_donasi_excel() {
		$data = array (
			'title'			=>	'Laporan Donasi Masuk',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donasi'		=>	$this->Admin_model->data_donasi(),
		);
		$this->load->view('admin/donasi_masuk_excel', $data);
	}

	public function laporan_donasi_print() {
		$data = array (
			'title'			=>	'Laporan Donasi Masuk',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donasi'		=>	$this->Admin_model->data_donasi(),
		);
		$this->load->view('admin/donasi_masuk_print', $data);
	}

	public function laporan_donasi_excel_by($mulai,$sampai) {
		$data = array (
			'title'			=>	'Laporan Donasi Masuk',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donasi'		=>	$this->Admin_model->laporan_donasi_sortir(array($mulai,$sampai)),
		);
		$this->load->view('admin/donasi_masuk_excel', $data);
	}

	public function laporan_donasi_print_by($mulai,$sampai) {
		$data = array (
			'title'			=>	'Laporan Donasi Masuk',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'donasi'		=>	$this->Admin_model->laporan_donasi_sortir(array($mulai,$sampai)),
		);
		$this->load->view('admin/donasi_masuk_print', $data);
	}

	public function laporan_galang_dana() {
		$status = $this->input->post('status');
		if($status == '') {
			$data = array (
				'title'			=>	'Laporan Galang Dana',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'galang'		=>	$this->Admin_model->data_galdan(),
				'status'		=>	$status,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_galang_dana', $data);
			$this->load->view('admin/footer');
		}else {
			$data = array (
				'title'			=>	'Laporan Galang Dana',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'galang'		=>	$this->Admin_model->data_galdan_sortir($status),
				'status'		=>	$status,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_galang_dana', $data);
			$this->load->view('admin/footer');
		}
	}

	public function laporan_galang_dana_print() {
		$data = array (
			'title'			=>	'Laporan Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan(),
		);
		$this->load->view('admin/galang_dana_print', $data);
	}

	public function laporan_galang_dana_excel() {
		$data = array (
			'title'			=>	'Laporan Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan(),
		);
		$this->load->view('admin/galang_dana_excel', $data);
	}

	public function laporan_galang_dana_print_by($status) {
		$data = array (
			'title'			=>	'Laporan Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan_sortir($status),
		);
		$this->load->view('admin/galang_dana_print', $data);
	}

	public function laporan_galang_dana_excel_by($status) {
		$data = array (
			'title'			=>	'Laporan Galang Dana',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan_sortir($status),
		);
		$this->load->view('admin/galang_dana_excel', $data);
	}

	public function laporan_pengguna() {
		$status = $this->input->post('status');
		if($status == '') {
			$data = array (
				'title'			=>	'Laporan Pengguna',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'users'			=>	$this->Admin_model->data_pengguna(),
				'status'		=>	$status,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_pengguna', $data);
			$this->load->view('admin/footer');
		}else {
			$data = array (
				'title'			=>	'Laporan Pengguna',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'users'			=>	$this->Admin_model->data_pengguna_sortir($status),
				'status'		=>	$status,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_pengguna', $data);
			$this->load->view('admin/footer');
		}
	}

	public function laporan_pengguna_print() {
		$data = array (
			'title'			=>	'Laporan Pengguna',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'users'			=>	$this->Admin_model->data_pengguna(),
		);
		$this->load->view('admin/pengguna_print', $data);
	}

	public function laporan_pengguna_excel() {
		$data = array (
			'title'			=>	'Laporan Pengguna',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'users'			=>	$this->Admin_model->data_pengguna(),
		);
		$this->load->view('admin/pengguna_excel', $data);
	}

	public function laporan_pengguna_print_by($status) {
		$data = array (
			'title'			=>	'Laporan Pengguna',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'users'			=>	$this->Admin_model->data_pengguna_sortir($status),
		);
		$this->load->view('admin/pengguna_print', $data);
	}

	public function laporan_pengguna_excel_by($status) {
		$data = array (
			'title'			=>	'Laporan Pengguna',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'users'			=>	$this->Admin_model->data_pengguna_sortir($status),
		);
		$this->load->view('admin/pengguna_excel', $data);
	}

	public function laporan_laba() {
		$status = $this->input->post('status');
		if($status == '') {
			$data = array (
				'title'			=>	'Laporan Keuntungan',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'galang'		=>	$this->Admin_model->data_galdan(),
				'status'		=>	$status,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_keuntungan', $data);
			$this->load->view('admin/footer');
		}else {
			$data = array (
				'title'			=>	'Laporan Keuntungan',
				'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
				'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
				'galang'		=>	$this->Admin_model->data_galdan_sortir($status),
				'status'		=>	$status,
			);
			$this->load->view('admin/header', $data);
			$this->load->view('admin/laporan_keuntungan', $data);
			$this->load->view('admin/footer');
		}
	}

	public function laporan_keuntungan_print() {
		$data = array (
			'title'			=>	'Laporan Keuntungan',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan(),
		);
		$this->load->view('admin/keuntungan_print', $data);
	}

	public function laporan_keuntungan_excel() {
		$data = array (
			'title'			=>	'Laporan Keuntungan',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan(),
		);
		$this->load->view('admin/keuntungan_excel', $data);
	}

	public function laporan_keuntungan_print_by($status) {
		$data = array (
			'title'			=>	'Laporan Keuntungan',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan_sortir($status),
		);
		$this->load->view('admin/keuntungan_print', $data);
	}

	public function laporan_keuntungan_excel_by($status) {
		$data = array (
			'title'			=>	'Laporan Keuntungan',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'galang'		=>	$this->Admin_model->data_galdan_sortir($status),
		);
		$this->load->view('admin/keuntungan_excel', $data);
	}

	public function set_about() {
		$data = array (
			'title'			=>	'Pengaturan Profil Perusahaan',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/about', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_about();
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/pengaturan/profil');
		}
	}

	public function set_atribut() {
		$data = array (
			'title'			=>	'Pengaturan Atribut',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'profil'		=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
		);
		$this->form_validation->set_rules('logo_teks', 'logo_teks', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/atribut', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_atribut();
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/pengaturan/atribut');
		}
	}

	public function set_midtrans() {
		$data = array (
			'title'			=>	'Konfigurasi API Midtrans',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'apiid'			=>	$this->db->get_where('tb_api',['id' => 1])->row_array(),
		);
		$this->form_validation->set_rules('client', 'client', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('server', 'server', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/midtrans', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_midtrans();
			$this->session->set_flashdata('flash', 'Konfigurasi berhasil');
			redirect('admin/pengaturan/midtrans');
		}
	}

	public function set_email() {
		$data = array (
			'title'			=>	'Pengaturan Email Aktivasi',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'email'			=>	$this->db->get_where('tb_email',['email_id' => 1])->row_array(),
		);
		$this->form_validation->set_rules('email', 'email', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('password', 'password', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('ssl', 'ssl', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/email', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_email();
			$this->session->set_flashdata('flash', 'Email berhasil diperbaharui');
			redirect('admin/pengaturan/email');
		}
	}

	public function inbox() {
		$data = array (
			'title'			=>	'Pesan Masuk',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'inbox'			=>	$this->Admin_model->data_inbox(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/inbox', $data);
		$this->load->view('admin/footer');
	}

	public function pos_kategori() {
		$data = array (
			'title'			=>	'Kategori',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kategori'		=>	$this->Admin_model->data_kategori(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/kategori', $data);
		$this->load->view('admin/footer');
	}

	public function pos_kategori_add() {
		$data = array (
			'title'			=>	'Input Kategori',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
		);
		$this->form_validation->set_rules('kategori', 'kategori', 'required|is_unique[tb_kategori.kat_nama]', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'is_unique'	=>	'Kategori ini sudah ada']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/kategori_add', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_kategori();
			$this->session->set_flashdata('flash', 'Data baru berhasil ditambahkan');
			redirect('admin/postingan/kategori');
		}
	}

	public function pos_kategori_edit($id) {
		$data = array (
			'title'			=>	'Edit Kategori',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'katid'			=>	$this->db->get_where('tb_kategori',['kat_id' => $id])->row_array(),
		);
		$this->form_validation->set_rules('kategori', 'kategori', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/kategori_edit', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->edit_kategori($id);
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/postingan/kategori');
		}
	}

	public function pos_kategori_del($id) {
		$this->db->where('kat_id', $id);
		$this->db->delete('tb_kategori');
		$this->session->set_flashdata('flash', 'Data berhasil dihapus');
		redirect('admin/postingan/kategori');
	}

	public function pos_artikel() {
		$data = array (
			'title'			=>	'Artikel',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'artikel'		=>	$this->Admin_model->data_blog(),
		);
		$this->load->view('admin/header', $data);
		$this->load->view('admin/artikel', $data);
		$this->load->view('admin/footer');
	}

	public function pos_artikel_add() {
		$data = array (
			'title'			=>	'Buat Artikel',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kategori'		=>	$this->Admin_model->data_kategori(),
		);
		$this->form_validation->set_rules('judul', 'judul', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('kategori', 'kategori', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('isi', 'isi', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/artikel_add', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->simpan_artikel();
			$this->session->set_flashdata('flash', 'Data baru berhasil ditambahkan');
			redirect('admin/postingan/artikel');
		}
	}

	public function pos_artikel_edit($id) {
		$data = array (
			'title'			=>	'Edit Artikel',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
			'kategori'		=>	$this->Admin_model->data_kategori(),
			'blog'			=>	$this->db->get_where('tb_blog',['post_id' => $id])->row_array(),
		);
		$this->form_validation->set_rules('judul', 'judul', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('kategori', 'kategori', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('isi', 'isi', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/artikel_edit', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->edit_artikel($id);
			$this->session->set_flashdata('flash', 'Data berhasil diperbaharui');
			redirect('admin/postingan/artikel');
		}
	}

	public function pos_artikel_del($id) {
		$this->db->where('post_id', $id);
		$this->db->delete('tb_blog');
		$this->session->set_flashdata('flash', 'Data berhasil dihapus');
		redirect('admin/postingan/artikel');
	}

	public function atur_profil() {
		$data = array (
			'title'			=>	'Atur Profil',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
		);
		$this->form_validation->set_rules('nama', 'nama', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('email', 'email', 'required|valid_email', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'valid_email'=>	'Email harus valid']);
		$this->form_validation->set_rules('password', 'password', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/profil', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->update_profil();
		}
	}

	public function atur_pass() {
		$data = array (
			'title'			=>	'Atur Password',
			'atr'			=>	$this->db->get_where('tb_profil',['id' => 1])->row_array(),
			'me'			=>	$this->db->get_where('tb_admin',['admin_id' => $this->session->userdata('id')])->row_array(),
		);
		$this->form_validation->set_rules('password1', 'password1', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		$this->form_validation->set_rules('password2', 'password2', 'required|matches[password1]', [
					'required'	=>	'Kolom ini tidak boleh kosong',
					'matches'	=>	'Konfirmasi password baru salah']);
		$this->form_validation->set_rules('password', 'password', 'required', [
					'required'	=>	'Kolom ini tidak boleh kosong']);
		if($this->form_validation->run() == FALSE) {
			$this->load->view('admin/header', $data);
			$this->load->view('admin/password', $data);
			$this->load->view('admin/footer');
		}else {
			$this->Admin_model->update_password();
		}
	}
}