<?php
/*
Plugin Name: DonasiAja
Description: DonasiAja adalah plugin donasi yang mudah & simple. Cocok digunakan untuk Penggalangan Dana, Lembaga Amal, Yayasan, Pesantren, Masjid, dan lain-lain.
Version: 1.7.0.2
Author: Sinkronus Co
Author URI: https://donasiaja.id
*/

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

function dja_options_install() {
    global $wpdb;

    $table_name = $wpdb->prefix . "dja_settings";
    $table_name2 = $wpdb->prefix . "dja_campaign";
    $table_name3 = $wpdb->prefix . "dja_campaign_update";

    $table_name4 = $wpdb->prefix . "dja_category";
    $table_name5 = $wpdb->prefix . "dja_donate";

    $table_name6 = $wpdb->prefix . "dja_aff_code";
    $table_name7 = $wpdb->prefix . "dja_love";

    $table_name8 = $wpdb->prefix . "dja_payment_list";
    $table_name9 = $wpdb->prefix . "dja_register";

    $table_name10 = $wpdb->prefix . "dja_shortcode";
    $table_name11 = $wpdb->prefix . "dja_users";

    $table_name12 = $wpdb->prefix . "dja_user_logs";
    $table_name13 = $wpdb->prefix . "dja_user_type";

    $table_name14 = $wpdb->prefix . "dja_verification_details";
    $table_name15 = $wpdb->prefix . "dja_verification_status";

    $table_name16 = $wpdb->prefix . "dja_payment_log";
    $table_name17 = $wpdb->prefix . "dja_password_reset";
    $table_name18 = $wpdb->prefix . "dja_password_reset_log";

    $table_name19 = $wpdb->prefix . "dja_aff_click";
    $table_name20 = $wpdb->prefix . "dja_aff_submit";
    $table_name21 = $wpdb->prefix . "dja_aff_payout";


    $charset_collate = $wpdb->get_charset_collate();
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

    $sql = "CREATE TABLE $table_name (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  type varchar(32) DEFAULT NULL,
		  data text DEFAULT NULL,
		  created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name2 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  campaign_id varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  title text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  slug text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  target decimal(21,0) DEFAULT NULL,
		  image_url text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  information longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  location_name varchar(240) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  location_gmaps text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  publish_status int(1) DEFAULT NULL,
		  reached_status int(1) DEFAULT NULL,
		  end_date datetime DEFAULT NULL,
		  form_base int(1) DEFAULT NULL,
		  form_type varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  packaged int(12) DEFAULT NULL,
		  packaged_title varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  currency varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  category_id int(2) DEFAULT NULL,
		  user_id bigint(20) DEFAULT NULL,
		  fundraiser_id bigint(20) DEFAULT NULL,
		  payment_status int(1) DEFAULT NULL,
		  method_status text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  bank_account text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  form_status int(1) DEFAULT NULL,
		  form_text text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  unique_number_setting int(1) DEFAULT NULL,
		  unique_number_value text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  notification_status int(1) DEFAULT NULL,
		  wanotif_message text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  pixel_status int(1) DEFAULT NULL,
		  fb_pixel varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  fb_event text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  pengeluaran_setting int(1) DEFAULT NULL,
		  pengeluaran_title text,
		  gtm_status int(1) DEFAULT NULL,
		  gtm_id varchar(30) DEFAULT NULL,
		  tiktok_status int(1) DEFAULT NULL,
		  tiktok_pixel varchar(30) DEFAULT NULL,
		  socialproof int(1) DEFAULT NULL,
		  socialproof_text varchar(250) DEFAULT NULL,
		  socialproof_position varchar(20) DEFAULT NULL,
		  zakat_setting int(1) DEFAULT NULL,
  		  zakat_percent decimal(10,2) DEFAULT NULL,
  		  fundraiser_setting int(1) DEFAULT NULL,
		  fundraiser_on int(1) DEFAULT NULL,
		  fundraiser_text text,
		  fundraiser_button text,
		  fundraiser_commission_on int(1) DEFAULT NULL,
		  fundraiser_commission_type int(1) DEFAULT NULL,
		  fundraiser_commission_percent decimal(10,2) DEFAULT NULL,
		  fundraiser_commission_fixed int(10) DEFAULT NULL,
		  additional_info text,
		  additional_formula text,
		  additional_field text,
		  custom_field_setting text,
		  general_status int(1) DEFAULT NULL,
		  allocation_title varchar(60) DEFAULT NULL,
		  allocation_others_title varchar(60) DEFAULT NULL,
		  donatur_name int(1) DEFAULT NULL,
		  donatur_others_name varchar(60) DEFAULT NULL,
		  home_icon_url text,
		  back_icon_url text,
		  minimum_donate int(10) DEFAULT NULL,
		  opt_nominal text,
		  opt_qurban text,
		  opt_package2 text,
		  opt_zfitrah text,
		  cs_rotator text,
		  wanotif_device int(1) DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name3 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  campaign_id varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  title text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  information longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_id bigint(20) DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name4 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  category varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  private_category int(1) DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);

    $sql = "CREATE TABLE $table_name5 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  campaign_id varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  invoice_id varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_id bigint(20) DEFAULT NULL,
		  name varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  whatsapp varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  email varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  comment text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  anonim int(1) DEFAULT NULL,
		  payment_method varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  payment_code varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  payment_number text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  payment_qrcode text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  payment_account varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  unique_number decimal(5,0) DEFAULT NULL,
		  nominal decimal(21,0) DEFAULT NULL,
		  main_donate decimal(21,0) DEFAULT NULL,
		  info_donate text,
		  info_qurban text,
		  info_package2 text,
		  info_zfitrah text,
		  info_addformula text,
		  status int(1) DEFAULT NULL,
		  cs_id int(14) DEFAULT NULL,
		  f0 int(1) DEFAULT NULL,
		  f1 int(1) DEFAULT NULL,
		  f2 int(1) DEFAULT NULL,
		  f3 int(1) DEFAULT NULL,
		  f4 int(1) DEFAULT NULL,
		  f5 int(1) DEFAULT NULL,
		  payment_trx_id varchar(64) DEFAULT NULL,
		  payment_at datetime DEFAULT NULL,
		  process_by varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  deeplink_url text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  payment_gateway varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  img_confirmation_url text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  img_confirmation_status int(1) DEFAULT NULL,
		  img_confirmation_date datetime DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);

	// Aff Fundraiser
    $sql = "CREATE TABLE $table_name6 (
		  id int(15) NOT NULL AUTO_INCREMENT,
		  campaign_id varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_id int(15) DEFAULT NULL,
		  aff_code varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);

    $sql = "CREATE TABLE $table_name7 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  campaign_id varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  donate_id int(11) DEFAULT NULL,
		  user_id bigint(20) DEFAULT NULL,
		  love int(3) DEFAULT NULL,
		  ip varchar(21) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  os varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  browser varchar(21) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  mobdesktop varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name8 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  code varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  name varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name9 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  r_nama_lengkap varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  r_email varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  r_whatsapp varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  r_password varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  r_code text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  r_status int(1) DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);

	

    $sql = "CREATE TABLE $table_name10 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  s_id varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  s_name text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  s_category varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  s_style varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  s_show int(3) DEFAULT NULL,
		  s_loadmore int(3) DEFAULT NULL,
		  s_button_on int(1) DEFAULT NULL,
		  s_button_text varchar(30) DEFAULT NULL,
		  s_data_load int(2) DEFAULT NULL,
		  s_campaign text,
		  s_grid_on int(1) DEFAULT NULL,
		  s_grid_mobile int(1) DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  updated_at timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name11 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  user_id bigint(20) DEFAULT NULL,
		  user_randid varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_type varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'org,personal',
		  user_verification int(1) DEFAULT NULL,
		  user_bio text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_wa varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_provinsi varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_kabkota varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_kecamatan varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_provinsi_id int(4) DEFAULT NULL,
		  user_kabkota_id int(4) DEFAULT NULL,
		  user_kecamatan_id int(4) DEFAULT NULL,
		  user_alamat text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_bank_name varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_bank_no varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_bank_an varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_pp_img text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_cover_img text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_anonim_f int(1) DEFAULT NULL,
		  user_commission_f int(3) DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name12 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  del_by int(12) DEFAULT NULL,
		  user_login varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_email varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_id bigint(20) DEFAULT NULL,
		  user_fullname varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_randid varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_type varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_verification int(1) DEFAULT NULL,
		  user_bio text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_wa varchar(18) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_provinsi varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_kabkota varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_kecamatan varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_provinsi_id int(4) DEFAULT NULL,
		  user_kabkota_id int(4) DEFAULT NULL,
		  user_kecamatan_id int(4) DEFAULT NULL,
		  user_alamat text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_bank_name varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_bank_no varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_bank_an varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_pp_img text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  user_cover_img text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name13 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  type varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  name varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name14 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  u_id int(12) DEFAULT NULL,
		  u_nama_lengkap varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  u_email varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  u_whatsapp varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  u_ktp text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  u_ktp_selfie text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  u_jabatan text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  u_nama_ketua varchar(160) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  u_alamat_lengkap text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  u_program_unggulan text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  u_profile text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  u_legalitas text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    $sql = "CREATE TABLE $table_name15 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  status int(1) DEFAULT NULL,
		  name varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name16 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  id_donate int(11) DEFAULT NULL,
		  hit text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  status varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  message text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  log text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name17 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  reset_email varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  reset_code varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  reset_status int(1) DEFAULT NULL,
	  	  ip varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  os varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  browser varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name18 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  reset_email varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  ip varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  os varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
	  	  browser varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name19 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  campaign_id varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  affcode_id varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  ip varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  os varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  browser varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name20 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  donate_id int(15) DEFAULT NULL,
		  campaign_id varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  affcode_id int(15) DEFAULT NULL,
		  payout_status int(1) DEFAULT NULL,
		  nominal_commission decimal(21,0) DEFAULT NULL,
		  created_at datetime DEFAULT NULL,
		  updated_at datetime DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


	$sql = "CREATE TABLE $table_name21 (
		  id int(11) NOT NULL AUTO_INCREMENT,
		  payout_number varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
		  user_id bigint(20) DEFAULT NULL,
		  aff_submit_id text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  nominal_payout decimal(21,0) DEFAULT NULL,
		  status int(1) DEFAULT NULL,
		  image text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  bank_name text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  bank_no text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  bank_an text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
		  created_at datetime DEFAULT NULL,
		  updated_at timestamp NULL DEFAULT NULL,
		  PRIMARY KEY  (id)
		) $charset_collate; ";
	dbDelta($sql);


    // ADD ROLE Donatur
    $check_donatur = wp_roles()->is_role( 'donatur' );
    if($check_donatur!=1){
    	$role = add_role( 'donatur', 'Donatur', array(
		    'read' => true,
		    'upload_files' => true, // True allows that capability
		));

    }

    // ADD ROLE Donatur
    $check_donatur2 = wp_roles()->is_role( 'cs' );
    if($check_donatur2!=1){
    	$role2 = add_role( 'cs', 'Customer Support', array(
		    'read' => true, // True allows that capability
		    'upload_files' => true, // True allows that capability
		));
    }

	$role = get_role( 'donatur' );
	$role->add_cap( 'upload_files' );
    $role->add_cap( 'read' );

	$role2 = get_role( 'cs' );
	$role2->add_cap( 'upload_files' );
    $role2->add_cap( 'read' );

}
// run the install scripts upon plugin activation
register_activation_hook(__FILE__, 'dja_options_install');





function dja_options_install_data() {
	global $wpdb;
	$table_name 	= $wpdb->prefix . 'dja_settings';
	$table_name2 	= $wpdb->prefix . 'dja_category';
	$table_name3 	= $wpdb->prefix . "dja_payment_list";
	$table_name4 	= $wpdb->prefix . "dja_user_type";
	$table_name5 	= $wpdb->prefix . "dja_verification_status";
	
	// table dja_settings
	$data_array = array(
				'label_tab',
				'max_love',
				'opt_nominal',
				'max_package',
				'form_setting',
				'del_campaign_setting',
				'btn_followup',
				'text_f1',
				'text_f2',
				'text_f3',
				'text_f4',
				'text_f5',
				'text_received',
				'text_received_status',
				'campaign_setting',
				'main_menu_name',
				'logo_url',
				'app_name',
				'login_setting',
				'login_text',
				'register_setting',
				'register_text',
				'page_login',
				'page_register',
				'anonim_text',
				'page_donate',
				'page_typ',
				'apikey_local',
				'apikey_server',
				'theme_color',
				'form_text',
				'unique_number_setting',
				'unique_number_value',
				'currency',
				'payment_setting',
				'bank_account',
				'ipaymu_mode',
				'ipaymu_va',
				'ipaymu_apikey',
				'moota_secret_token',
				'moota_range',
				'wanotif_url',
				'wanotif_apikey',
				'wanotif_message',
				'wanotif_message2',
				'wanotif_on_dashboard',
				'powered_by_setting',
				'form_email_setting',
				'form_comment_setting',
				'fb_pixel',
				'fb_event',
				'telegram_bot_token',
				'telegram_send_to',
				'telegram_on',
				'wanotif_on',
				'wanotif_followup1_on',
				'jquery_on',
				'gtm_id',
				'limitted_donation_button',
				'tripay_mode',
				'tripay_apikey',
				'tripay_privatekey',
				'tripay_merchant',
				'tripay_apikey_sandbox',
				'tripay_privatekey_sandbox',
				'tripay_merchant_sandbox',
				'midtrans_mode',
				'midtrans_serverkey',
				'midtrans_clientkey',
				'midtrans_merchant',
				'midtrans_serverkey_sandbox',
				'midtrans_clientkey_sandbox',
				'midtrans_merchant_sandbox',
				'socialproof_text',
				'socialproof_settings',
				'email_send_to',
				'email_on',
				'changepass_setting',
				'tiktok_pixel',
				'fundraiser_on',
				'fundraiser_text',
				'fundraiser_button',
				'fundraiser_commission_on',
				'fundraiser_commission_type',
				'fundraiser_commission_percent',
				'fundraiser_commission_fixed',
				'fundraiser_wa_on',
				'fundraiser_email_on',
				'fundraiser_wa_text',
				'fundraiser_email_text',
				'payment_error_handling',
				'email_success_message',
				'tripay_qris',
				'register_checkbox_setting',
				'register_checkbox_info',
				'form_confirmation_setting',
				'telegram_manual_confirmation',
				'jquery_custom',
				'minimum_donate',
				'wanotif_apikey_cs',
				'min_payout_setting',
				'min_payout',
				'donasiaja',
				'flip_mode',
				'flip_apikey',
				'flip_validation_token',
				'flip_apikey_sandbox',
				'flip_validation_token_sandbox',
				'flip_redirect'
			);


	foreach ($data_array as $key => $value) {
		
		// cek apakah di table ada sesuai "type" ?
		$query = $wpdb->get_results('SELECT data from '.$table_name.' where type="'.$value.'"');
		if($query==null){

			// -> klo gak ada, insert
			if($value=='label_tab'){
				$isi = 'tab';
			}elseif($value=='max_love'){
				$isi = '0';
			}elseif($value=='opt_nominal'){
				$isi = '{"opt1":["10000","Rp 10rb","0"],"opt2":["25000","Rp 25rb","0"],"opt3":["50000","Rp 50rb","1"],"opt4":["100000","Rp 100rb","0"]}';
			}elseif($value=='max_package'){
				$isi = '10';
			}elseif($value=='form_setting'){
				$isi = '1';
			}elseif($value=='del_campaign_setting'){
				$isi = '0';
			}elseif($value=='btn_followup'){
				$isi = '3';
			}elseif($value=='text_f1'){
				$isi = 'Terimakasih *Bpk/Ibu {name}* atas Donasi yang akan Anda berikan. Semoga Rahmat dan Lindungan Allah selalu senantiasa bersama Anda.

Untuk Donasinya sejumlah *{total}* mohon ditransfer *{payment_account}* dengan No Rek *{payment_number}*. 
Terimakasih 😊🙏';
			}elseif($value=='text_f2'){
				$isi = 'Followup 2';
			}elseif($value=='text_f3'){
				$isi = 'Followup 3';
			}elseif($value=='text_f4'){
				$isi = 'Followup 4';
			}elseif($value=='text_f5'){
				$isi = 'Followup 5';
			}elseif($value=='text_received'){
				$isi = 'Terimakasih *Bpk/Ibu {name}* , donasi anda sudah kami terima. Semoga Rahmat dan Lindungan Allah selalu senantiasa bersama Anda.
Terimakasih 😊🙏';
			}elseif($value=='text_received_status'){
				$isi = '0';
			}elseif($value=='campaign_setting'){
				$isi = '1';
			}elseif($value=='main_menu_name'){
				$isi = 'DonasiAja';
			}elseif($value=='logo_url'){
				$isi = '';
			}elseif($value=='app_name'){
				$isi = '';
			}elseif($value=='login_setting'){
				$isi = '1';
			}elseif($value=='login_text'){
				$isi = 'Silahkan login jika sudah memiliki akun.';
			}elseif($value=='register_setting'){
				$isi = '0';
			}elseif($value=='register_text'){
				$isi = 'Mari bergabung bersama orang baik lainnya.';
			}elseif($value=='page_login'){
				$isi = 'login';
			}elseif($value=='page_register'){
				$isi = 'register';
			}elseif($value=='anonim_text'){
				$isi = 'Orang Baik';
			}elseif($value=='page_donate'){
				$isi = 'donate-now';
			}elseif($value=='page_typ'){
				$isi = 'invoice';
			}elseif($value=='apikey_local'){
				$isi = '{"donasiaja": [""]}';
			}elseif($value=='apikey_server'){
				$isi = '{"donasiaja": ["", "0", "", ""]}';
			}elseif($value=='theme_color'){
				$isi = '{"color":["","",""]}';
			}elseif($value=='form_text'){
				$isi = '{"text":["Donasi Sekarang!","Donasi","Anda akan berdonasi dalam program:","Donasi Terbaik Anda"]}';
			}elseif($value=='unique_number_setting'){
				$isi = '2';
			}elseif($value=='unique_number_value'){
				$isi = '{"unique_number":["1","1","999"]}';
			}elseif($value=='currency'){
				$isi = 'IDR';
			}elseif($value=='payment_setting'){
				$isi = '{"method1":["instant","Pembayaran Instan (Cepat & Mudah)","0"],"method2":["va","Virtual Account (Verifikasi Otomatis)","0"],"method3":["transfer","Transfer Bank (Verifikasi Manual 1x24jam)","1"]}';
			}elseif($value=='bank_account'){
				$isi = '{"bca":"__0"}';
			}elseif($value=='ipaymu_mode'){
				$isi = '0';
			}elseif($value=='moota_range'){
				$isi = '2';
			}elseif($value=='wanotif_url'){
				$isi = 'https://api.wanotif.id/v1';
			}elseif($value=='wanotif_message'){
				$isi = 'Terimakasih *Bpk/Ibu {name}* atas Donasi yang akan Anda berikan. Semoga Rahmat dan Lindungan Allah selalu senantiasa bersama Anda.

Untuk Donasinya sejumlah *{total}* mohon ditransfer ke *{payment_account}* dengan No Rek *{payment_number}*. 
Terimakasih 😊🙏';
			}elseif($value=='wanotif_message2'){
				$isi = 'Terimakasih *Bpk/Ibu {name}* , Donasi anda sudah kami terima. Semoga Rahmat dan Lindungan Allah selalu senantiasa bersama Anda.
Terimakasih 😊🙏';
			}elseif($value=='wanotif_on_dashboard'){
				$isi = '0';
			}elseif($value=='powered_by_setting'){
				$isi = '1';
			}elseif($value=='form_email_setting'){
				$isi = '1';
			}elseif($value=='form_comment_setting'){
				$isi = '1';
			}elseif($value=='fb_event'){
				$isi = '{"event":["","",""]}';
			}elseif($value=='telegram_send_to'){
				$isi = '[{"channel":"","message":""}]';
			}elseif($value=='telegram_on'){
				$isi = '1';
			}elseif($value=='wanotif_on'){
				$isi = '1';
			}elseif($value=='jquery_on'){
				$isi = '1';
			}elseif($value=='limitted_donation_button'){
				$isi = '0';
			}elseif($value=='socialproof_text'){
				$isi = 'Baru saja Donasi di {campaign_title}';
			}elseif($value=='telegram_send_to'){
				$isi = '{"settings":["flying_rounded","bottom_left","show","8","15"]}';
			}elseif($value=='email_send_to'){
				$isi = '[{"email":"","message":""}]';
			}elseif($value=='email_on'){
				$isi = '0';
			}elseif($value=='changepass_setting'){
				$isi = '1';
			}elseif($value=='fundraiser_on'){
				$isi = '0';
			}elseif($value=='fundraiser_text'){
				$isi = 'Mari jadi Fundraiser dan berikan manfaat bagi program ini.';
			}elseif($value=='fundraiser_button'){
				$isi = 'Jadi Fundraiser';
			}elseif($value=='fundraiser_commission_on'){
				$isi = '1';
			}elseif($value=='fundraiser_commission_type'){
				$isi = '0';
			}elseif($value=='fundraiser_commission_percent'){
				$isi = '10';
			}elseif($value=='fundraiser_commission_fixed'){
				$isi = '2000';
			}elseif($value=='fundraiser_wa_on'){
				$isi = '0';
			}elseif($value=='fundraiser_email_on'){
				$isi = '0';
			}elseif($value=='fundraiser_wa_text'){
				$isi = 'Selamat {name}

Komisi anda berhasil kami transfer ke rekening Anda.
Payout Number : {payout_number}
Total Komisi : {nominal}

Terimakasih atas kerjasamanya dan jangan berhenti untuk memasarkan produk dari kami untuk mendapatkan Komisi yang lebih Banyak Lagi.

Salam, DonasiAja Team 😊🙏';
			}elseif($value=='fundraiser_email_text'){
				$isi = '[{"email":"{email}","emailcc":"","emailbcc":"","subject":"Komisi {payout_number} - {nominal} sudah ditransfer","message":"<p>Selamat <strong>{name}</strong></p>linebreak<p>Komisi anda berhasil kami transfer ke rekening Anda.<br />Payout Number : <strong>{payout_number}</strong><br />Total Komisi : <strong>{nominal}</strong></p>linebreak<p>Terimakasih atas kerjasamanya dan jangan berhenti untuk memasarkan produk dari kami untuk mendapatkan Komisi yang lebih Banyak Lagi.</p>linebreak<p>Salam, <strong>DonasiAja Team</strong> 😊🙏</p>"}]';
			}elseif($value=='payment_error_handling'){
				$isi = '0';
			}elseif($value=='email_success_message'){
				$isi = '[{"email":"{email}","emailcc":"","emailbcc":"","subject":"Donasi sebesar {total} berhasil kami terima untuk Program {campaign_title}","message":"<p><strong>Terimakasih {name}</strong> atas Donasi yang sudah anda berikan pada program <strong>{campaign_title}</strong> sebesar <strong>{total}</strong>.</p>linebreak<p>Semoga Rahmat dan Lindungan Allah selalu senantiasa bersama Anda, dimudahkan segala urusannya dan dilancarkan rejekinya. Aaminnn</p>linebreak<p><br />Terimakasih, <strong>DonasiAja Team</strong> 😊🙏</p>"}]';
			}elseif($value=='tripay_qris'){
				$isi = 'QRISC';
			}elseif($value=='register_checkbox_setting'){
				$isi = '1';
			}elseif($value=='register_checkbox_info'){
				$isi = 'Dengan ini saya menyetujui dan mematuhi semua peraturan yang ada di website ini.';
			}elseif($value=='form_confirmation_setting'){
				$isi = '1';
			}elseif($value=='telegram_manual_confirmation'){
				$isi = '[{"channel":"","message":""}]';
			}elseif($value=='jquery_custom'){
				$isi = '3.6.1';
			}elseif($value=='minimum_donate'){
				$isi = '1000';
			}elseif($value=='wanotif_apikey_cs'){
				$isi = '{"jumlah":0,"data":{}}';
			}elseif($value=='min_payout_setting'){
				$isi = '1';
			}elseif($value=='min_payout'){
				$isi = '50000';
			}elseif($value=='flip_mode'){
				$isi = '0';
			}elseif($value=='flip_redirect'){
				$isi = '0';
			}else{
				$isi = '';
			}

	    	$wpdb->insert( 
				$table_name, 
				array(
					'type' => $value,
					'data' => $isi
				) 
			);

		}
    }



    // table dja_category
	$data_array2 = array(
				'Pendidikan',
				'Kesehatan',
				'Kemanusiaan',
				'Bencana Alam',
				'Rumah Ibadah',
			);

	foreach ($data_array2 as $key => $value) {
    	$query = $wpdb->get_results('SELECT category from '.$table_name2.' where category="'.$value.'"');

    	if($query==null){

    		$wpdb->insert( 
				$table_name2, 
				array(
					'category' => $value
				) 
			);
    	}
    }

    // table dja_payment_list
	$data_array3 = array(
				"bca" => "Bank BCA",
				"mandiri" => "Bank Mandiri",
				"bni" => "Bank BNI",
				"bri" => "Bank BRI",
				"bank_btn" => "Bank BTN",
				"btpn" => "Bank BTPN",
				"bukopin" => "Bank Bukopin",
				"cimb_niaga" => "Bank CIMB Niaga",
				"mega" => "Bank Mega",
				"danamon" => "Bank Danamon",
				"bag" => "Bank Artha Graha Internasional",
				"permata" => "Permata Bank",
				"citi_bank" => "Citi Bank",
				"sinarmas" => "Bank Sinarmas",
				"sampoerna" => "Bank Sahabat Sampoerna",
				"maybank" => "Maybank",
				"hongleong" => "HongLeong Bank",
				"uob" => "United Overseas Bank",
				"bsi" => "Bank Syariah Indonesia",
				"bca_syariah" => "Bank BCA Syariah",
				"cimb_niaga_syariah" => "Bank CIMB Niaga Syariah",
				"mega_syariah" => "Bank Mega Syariah",
				"bank_bjb_syariah" => "Bank BJB Syariah",
				"bank_jateng_syariah" => "Bank Jateng Syariah",
				"bank_jatim_syariah" => "Bank Jatim Syariah",
				"bank_nagari_syariah" => "Bank Nagari Syariah",
				"bank_sulselbar_syariah" => "Bank Sulselbar Syariah",
				"bank_panin_dubai_syariah" => "Bank Panin Dubai Syariah",
				"muamalat" => "Bank Muamalat",
				"bank_bjb" => "Bank BJB",
				"bank_dki" => "Bank DKI",
				"bank_jateng" => "Bank Jateng",
				"bank_jatim" => "Bank Jatim",
				"bank_nagari" => "Bank Nagari",
				"bank_sulselbar" => "Bank Sulselbar",
				"qris" => "QRIS",
				"jenius" => "Jenius",
				"gopay" => "Gopay",
				"ovo" => "OVO",
				"dana" => "DANA",
				"shopeepay" => "ShopeePay",
				"linkaja" => "LinkAja",
				"jemput_donasi" => "Jemput Donasi",
				"alfamart" => "Alfamart",
				"alfamidi" => "Alfamidi",
				"indomaret" => "Indomaret",
				"flip" => "Flip Transfer",
				"tunai" => "Tunai"
			);

	foreach ($data_array3 as $key => $value) {
    	$query = $wpdb->get_results('SELECT code from '.$table_name3.' where code="'.$key.'"');

    	if($query==null){

    		$wpdb->insert( 
				$table_name3, 
				array(
					'code' => $key,
					'name' => $value,
				) 
			);
    	}
    }



    // table dja_user_type
	$data_array4 = array(
				"personal" => "Personal",
				"org" => "Organization",
			);

	foreach ($data_array4 as $key => $value) {
    	$query = $wpdb->get_results('SELECT type from '.$table_name4.' where type="'.$key.'"');

    	if($query==null){

    		$wpdb->insert( 
				$table_name4, 
				array(
					'type' => $key,
					'name' => $value,
				) 
			);
    	}
    }


    // table dja_verification_status
	$data_array5 = array(
				"0" => "No Status",
				"1" => "Verified",
				"2" => "On Review",
				"3" => "Rejected",
				"4" => "Banned",
			);

	foreach ($data_array5 as $key => $value) {
    	$query = $wpdb->get_results('SELECT status from '.$table_name5.' where status="'.$key.'"');

    	if($query==null){

    		$wpdb->insert( 
				$table_name5, 
				array(
					'status' => $key,
					'name' => $value,
				) 
			);
    	}
    }


}
register_activation_hook(__FILE__, 'dja_options_install_data');



function deactivate_plugin_dna() {
 	
 	// REMOVE ROLE
    $role = get_role( 'donatur' );
    $role->remove_cap( 'upload_files' );
    $role->remove_cap( 'edit_posts' );
    $role->remove_cap( 'edit_published_posts' );
    $role->remove_cap( 'publish_posts' );
    $role->remove_cap( 'read' );
    $role->remove_cap( 'level_2' );
    $role->remove_cap( 'level_1' );
    $role->remove_cap( 'level_0' );
    $role->remove_cap( 'manage_options' );


 	// REMOVE ROLE
    $role = get_role( 'cs' );
    $role->remove_cap( 'upload_files' );
    $role->remove_cap( 'edit_posts' );
    $role->remove_cap( 'edit_published_posts' );
    $role->remove_cap( 'publish_posts' );
    $role->remove_cap( 'read' );
    $role->remove_cap( 'level_2' );
    $role->remove_cap( 'level_1' );
    $role->remove_cap( 'level_0' );
    $role->remove_cap( 'manage_options' );

}
register_deactivation_hook( __FILE__, 'deactivate_plugin_dna' );


function load_custom_dja_admin_style() {

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $id_login = wp_get_current_user()->ID;
	$rows = $wpdb->get_results('SELECT * from '.$table_name.' where user_id="'.$id_login.'"');

	$cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

	if(isset($rows[0])){
	    if($rows[0]->user_pp_img=='') {
	        $pp_url = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
	    }else{
	        $pp_url = $rows[0]->user_pp_img;
	    }
	}else{
		$pp_url = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
	}

    donasiaja_global_vars();
    wp_register_style( 'dja_style_admin', plugin_dir_url( __FILE__ ) . 'admin/css/style-admin.css', false, null );
    wp_enqueue_style( 'dja_style_admin' );

    wp_register_script( 'donasiaja_script_admin', plugin_dir_url( __FILE__ ) . 'admin/js/donasiaja-admin.js', false, true );
    wp_enqueue_script('donasiaja_script_admin');

    $a = array( 'admin_url' => admin_url() );
    wp_localize_script( 'donasiaja_script_admin', 'donasiaja_admin', $a );

    $b = array( 'pp_url' => $pp_url );
    wp_localize_script( 'donasiaja_script_admin', 'donasiaja_admin2', $b );

    $c = array( 'logout_url' => wp_logout_url() );
    wp_localize_script( 'donasiaja_script_admin', 'donasiaja_admin3', $c );

    $d = array( 'role_user' => $role );
    wp_localize_script( 'donasiaja_script_admin', 'donasiaja_admin4', $d );


}
add_action( 'admin_enqueue_scripts', 'load_custom_dja_admin_style' );


function enqueue_donasiaja_admin_style(){
   wp_enqueue_script('donasiaja_script_admin');
}
add_action('admin_enqueue_scripts', 'enqueue_donasiaja_admin_style');




// register jquery and style on initialization
function register_donasiaja_script() {
    global $wpdb;
    donasiaja_global_vars();
    $table_name = $wpdb->prefix . "dja_settings";
    $plugin_version = $GLOBALS['donasiaja_vars']['plugin_version'];
    $query_settings=$wpdb->get_results('SELECT data from '.$table_name.' where type="main_menu_name" or type="apikey_local" or type="apikey_server" or type="donasiaja" ORDER BY id ASC');
    $x=$query_settings[0]->data;
    $a=$query_settings[1]->data;
    $b=json_decode($a,true);
    $c=$b['donasiaja'][0];
    $e=json_decode($query_settings[2]->data, true);
    if($e['donasiaja'][2]!=''){
    	$f=date("dMY",$e['donasiaja'][2]);
    }else{
    	$f=null;
    }
    if(empty($query_settings[3]->data)){$d = '';}else{$d=$query_settings[3]->data;}

	// Register the script
	// wp_register_script( 'dja_script_1', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.min.js', array(), $plugin_version, true );
	wp_register_script( 'dja_script_1', plugin_dir_url( __FILE__ ) . 'assets/js/hello.donasiaja.js', array(), $plugin_version, true );

	// Localize the script with new data
	$translation_array = array(
	    'varSiteUrl' => get_site_url(),
		'varPluginUrl' => plugin_dir_url( __FILE__ ),
		'apiKey' => substr($c, 0, 11),
	    'm' => $x,
	    'n' => '.id',
	    'r' => 'https://',
	    'd' => $d,
	    'dt'=> $f
	);
	wp_localize_script( 'dja_script_1', 'donasiajaObjName', $translation_array );
	 
	// Enqueued script with localized data.
	wp_enqueue_script( 'dja_script_1' );
	
}
add_action('init', 'register_donasiaja_script');


function load_custom_dja_style_carousel() {
	
	wp_enqueue_script('dja_script_1');
	// wp_enqueue_script('dja_script_2');
}
add_action( 'wp_enqueue_scripts', 'load_custom_dja_style_carousel' );

/*
function register_donasiaja_footer_script() {
    global $wpdb;
    donasiaja_global_vars();
    $plugin_version = $GLOBALS['donasiaja_vars']['plugin_version'];
    $table_name = $wpdb->prefix . "dja_settings";

    // Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="jquery_on" or type="jquery_custom" ORDER BY id ASC');
    $jquery_on = $query_settings[0]->data;
    $jquery_custom = $query_settings[1]->data;

    if($jquery_on=='0' || $jquery_on==null){
    	// no JQuery
    }elseif($jquery_on=='2'){
    	if($jquery_custom=='0' || $jquery_custom==null){
    		// no JQuery
    	}else{
    		echo '<script src="https://code.jquery.com/jquery-'.$jquery_custom.'.min.js"></script>';
    	}
    }else{
    	echo '<script src="'.plugin_dir_url( __FILE__ ) . 'assets/js/jquery.min.js?ver='.$plugin_version.'"></script>';
    }

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="theme_color" ORDER BY id ASC');
    $general_theme_color    = json_decode($query_settings[0]->data, true);
    $theme_color 			= $general_theme_color['color'][0];
	$progressbar_color  	= $general_theme_color['color'][1];
	$button_color 			= $general_theme_color['color'][2];
	$button_color2 			= $general_theme_color['color'][3];

    if($theme_color!=''){
    	echo '<style>.donasiaja_search_box .control .btn-material{background: '.$theme_color.';}</style>';
    }
	
}
// add_action('init', 'register_donasiaja_script');
add_action( 'wp_footer', 'register_donasiaja_footer_script');
*/

function custom_style_donasiaja() {
	donasiaja_global_vars();
    $plugin_version = $GLOBALS['donasiaja_vars']['plugin_version'];
    wp_register_style( 'donasiaja-style', plugin_dir_url( __FILE__ ) . 'assets/css/donasiaja-style.css', false, $plugin_version );
    wp_enqueue_style( 'donasiaja-style' );
}
add_action( 'wp_enqueue_scripts', 'custom_style_donasiaja' );


function custom_donasiaja_js() {
    global $wpdb;
    donasiaja_global_vars();
    $plugin_version = $GLOBALS['donasiaja_vars']['plugin_version'];
    $table_name = $wpdb->prefix . "dja_settings";

    // Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="jquery_on" or type="jquery_custom" ORDER BY id ASC');
    $jquery_on = $query_settings[0]->data;
    $jquery_custom = $query_settings[1]->data;

    if($jquery_on=='0' || $jquery_on==null){
    	// no JQuery
    }elseif($jquery_on=='2'){
    	if($jquery_custom=='0' || $jquery_custom==null){
    		// no JQuery
    	}else{
    		echo '<script src="https://code.jquery.com/jquery-'.$jquery_custom.'.min.js"></script>';
    	}
    }else{
    	echo '<script src="'.plugin_dir_url( __FILE__ ) . 'assets/js/jquery.min.js?ver='.$plugin_version.'"></script>';
    }

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="theme_color" ORDER BY id ASC');
    $general_theme_color    = json_decode($query_settings[0]->data, true);
    $theme_color 			= $general_theme_color['color'][0];
	$progressbar_color  	= $general_theme_color['color'][1];
	$button_color 			= $general_theme_color['color'][2];
	$button_color2 			= $general_theme_color['color'][3];

    if($theme_color!=''){
    	echo '<style>.donasiaja_search_box .control .btn-material{background: '.$theme_color.';}</style>';
    }
}
// Add hook for front-end <head></head>
add_action( 'wp_head', 'custom_donasiaja_js' );


function parent_theme_setup() {
	add_theme_support( 'post-thumbnails' );
    add_image_size( 'campaign_cover', 650, 350, true );
    add_image_size( 'qurban_cover', 500, 350, true );
    add_image_size( 'donasiaja_profile_picture', 150, 150, true );
}
add_action( 'after_setup_theme', 'parent_theme_setup' );



// GENERAL SHORTCODE FUNCTION TO LOAD MUCH CAMPAIGN
function donasiaja_shortcode_func( $atts, $content = "" ) {
	
	global $wpdb;
	$table_name = $wpdb->prefix . "dja_campaign";
	$table_name2 = $wpdb->prefix . "dja_donate";
	$table_name3 = $wpdb->prefix . "dja_users";
	$table_name4 = $wpdb->prefix . "dja_shortcode";
	$table_name5 = $wpdb->prefix . "dja_settings";
	$table_name6 = $wpdb->prefix . "dja_love";

	// $table_name = $wpdb->prefix . "dja_campaign";
	// $table_name2 = $wpdb->prefix . "dja_donate";
	// $table_name3 = $wpdb->prefix . "dja_users";
	// $table_name4 = $wpdb->prefix . "dja_shortcode";
	// $table_name5 = $wpdb->prefix . "dja_campaign_update";
	// $table_name6 = $wpdb->prefix . "dja_settings";

	$atts = shortcode_atts( array(
		'id' => null,
		'show' => null
	), $atts, 'donasiaja' );

	$query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="max_love" or type="anonim_text" ORDER BY id ASC');
    $max_love 		= $query_settings[0]->data;
    $anonim_text   	= $query_settings[1]->data;

	$show = '';
	if($atts['show']!==null){
  		$show = $atts['show'];

  		ob_start();

  		if($show=='total_terkumpul'){
  			$total_donasi = $wpdb->get_results("SELECT SUM(nominal) as total, COUNT(id) as jumlah FROM $table_name2 where status='1' ")[0];

	        if($total_donasi==null){
	            $total_terkumpul = 0;
	            $jumlah_donasi = 0;
	        }else{
	            $total_terkumpul = $total_donasi->total;
	            $jumlah_donasi = $total_donasi->jumlah;
	        }

  			echo 'Rp '.number_format($total_terkumpul,0,",",".");
  		}
  		if($show=='jumlah_donasi'){

  			$total_donasi = $wpdb->get_results("SELECT SUM(nominal) as total, COUNT(id) as jumlah FROM $table_name2 where status='1' ")[0];

	        if($total_donasi==null){
	            $total_terkumpul = 0;
	            $jumlah_donasi = 0;
	        }else{
	            $total_terkumpul = $total_donasi->total;
	            $jumlah_donasi = $total_donasi->jumlah;
	        }

  			echo $jumlah_donasi;
  		}
  		if($show=='jumlah_donatur'){
  			$jumlah_donatur = count( get_users( array( 'fields' => array( 'ID' ), 'role' => 'donatur' ) ) );
  			echo number_format($jumlah_donatur,0,",",".");
  		}
  		if($show=='jumlah_user'){
  			$jumlah_user = count( get_users( array( 'fields' => array( 'ID' ) ) ) );
  			echo number_format($jumlah_user,0,",",".");
  		}
  		if($show=='jumlah_all_campaign'){
  			$jumlah_all_campaign = count($wpdb->get_results("SELECT id from $table_name ORDER BY id DESC"));
  			echo number_format($jumlah_all_campaign,0,",",".");
  		}
  		if($show=='jumlah_active_campaign'){

  			$rows = $wpdb->get_results("SELECT id, end_date, publish_status from $table_name ORDER BY id DESC");

  			$active_campaign = 0;
            foreach ($rows as $row) {
                                                
                $date_now = date('Y-m-d');
                $datetime1 = new DateTime($date_now);
                $datetime2 = new DateTime($row->end_date);
                $hasil = $datetime1->diff($datetime2);

                if($hasil->invert==true && $row->publish_status==1){
                    
                }else{
                    if($row->publish_status==1){
                        // $act_status = '<span class="active-status">Active</span>';
                        $active_campaign++;
                    }
                }
            }   
  			
  			echo number_format($active_campaign,0,",",".");
  		}
  		if($show=='list_donatur'){

			$donasi = $wpdb->get_results("SELECT * FROM $table_name2 where status='1' ORDER BY id DESC limit 0,25 ");
			$rand_id = d_randomString(5);

			$max_lovenya = '';
			if($max_love!="0"){
				$max_lovenya = '
		    	if(response=="cukup"){
		    		alert("Maaf, hanya boleh "'.$max_love.'" kali");
				}
				';
			}
			$home_url = home_url();

			echo '
				<script>
				function getNum(val) {
				   if (isNaN(val)) {
				     return 0;
				   }
				   return val;
				}
				function set_hide(id){
					$("#"+id+" .plus1").removeClass("show").removeAttr("style");
				}
				$(document).on("click", ".donation_love", function(e) {
					var id = $(this).attr("id");
					var campaign_id = $(this).attr("data-campaignid");
					var donate_id = $(this).attr("data-donateid");
					var count_love = $(this).find(".total_love").text();
					
					var thenum = parseInt(getNum(count_love.replace(/\D/g, "")));
					if(isNaN(thenum)){
						$(this).find(".total_love").html("<span>1 Aaminn</span>");
					}else{
						thenum = thenum+1;
						$(this).find(".total_love").html("<span>"+thenum+" Aaminn</span>");
					}

					$("#"+id+" img").attr("src","'.plugin_dir_url( __FILE__ ).'assets/icons/praying-color3.png");

					$(this).find(".plus1").addClass("show").animate({
						top: "-27px",
						opacity: "0",
					}, {
						duration : 400, 
						complete : function(){
		    				set_hide(id);
		    			}
		    		});
					var data_nya = [campaign_id, donate_id];
				    var data = {
				        "action": "djafunction_set_love",
				        "datanya": data_nya
				    };

				    jQuery.post("'.$home_url.'/wp-admin/admin-ajax.php", data, function(response) {

				    	'.$max_lovenya.'

				    });
					
				});
				</script>
				<style>.donation_box {width:520px;}@media only screen and (max-width:480px) {.donation_box {width:100%;}}</style>
				<div class="donation_box black" style="background:#F4F8FD;">

				    <div id="box_'.$rand_id.'">';

					foreach ($donasi as $data) {

						$value = $wpdb->get_results("SELECT * FROM $table_name where campaign_id='$data->campaign_id' ")[0];
			        	$readtime = new donasiaja_readtime();
						$donation_time = $readtime->time_donation($data->created_at);

						$general_status = $value->general_status;
					    $allocation_title = $value->allocation_title;
					    $allocation_others_title = $value->allocation_others_title;

					    if($general_status=='1'){
					        if($allocation_title=='1'){
					            $allocation_title = 'Donasi';
					        }elseif($allocation_title=='2'){
					            $allocation_title = 'Zakat';
					        }elseif($allocation_title=='3'){
					            $allocation_title = 'Qurban';
					        }else{
					            $allocation_title = $allocation_others_title;
					        }
					    }else{
					        $allocation_title = 'Donasi';
					    }

					    $donatur_name = $data->name;
						$anonim = 'Orang Baik';
						if($data->anonim=='1'){
							$donatur_name = $anonim_text;
						}

						/*
						$id_login = wp_get_current_user()->ID;

						$a = donasiaja_getIP();
					    $b = donasiaja_getOS();
					    $c = donasiaja_getBrowser();
					    $d = donasiaja_getMobDesktop();
						if($id_login!='0'){
							// cek berdasarkan user_agent
							$row = $wpdb->get_results('SELECT * from '.$table_name6.' where ip="'.$a.'" and os="'.$b.'" and browser="'.$c.'" and mobdesktop="'.$d.'" and donate_id="'.$value->id.'"');
					    	if($row!=null){
					    		$left_span = '<span>';
					    		$right_span = '</span>';
					    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-color3.png';
					    	}else{
					    		$left_span = '';
					    		$right_span = '';
					    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-gray.png';
					    	}
						}else{
							// cek berdasarkan user_id
							$row = $wpdb->get_results('SELECT * from '.$table_name2.' where user_id="'.$id_login.'" ');
					    	if($row!=null){
					    		$left_span = '<span>';
					    		$right_span = '</span>';
					    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-color3.png';
					    	}else{
					    		$left_span = '';
					    		$right_span = '';
					    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-gray.png';
					    	}
						}

						$total_love = $wpdb->get_results("SELECT SUM(love) as jumlah FROM $table_name6 where donate_id='$value->id' ")[0];
						$love = $total_love->jumlah;
						if($love==0){
							$love = 'Aaminn-kan doa ini';
						}else{
							if($love>=2){
								$love = $left_span.$love.' Aaminn'.$right_span;
							}else{
								$love = $left_span.$love.' Aaminn'.$right_span;
							}
						}

						// $hide_love = '';
						// if($data->comment==''){
						// 	$hide_love = 'style="display:none;"';
						// }

						

						echo '

						        <div class="donation_inner_box" style="background:#ffffff;">
						            <div class="donation_name">'.$donatur_name.'<span class="donation_time"><span class="dashicons dashicons-clock"></span>'.$donation_time.'</span>
						            </div>
						            <div class="donation_total" style="color: #23374d;font-weight:normal;">'.$allocation_title.' <b>Rp '.number_format($data->nominal,0,",",".").'</b></div>
						            <div class="donation_comment">'.str_replace('\\', '', $data->comment).'</div>
						            <div class="donation_love" id="love_'.$value->id.'" data-donateid="'.$value->id.'" data-campaignid="'.$value->campaign_id.'" '.$hide_love.'>
							            
							            <div class="fancy-button">
										  <div class="left-frills frills"></div>
										  <div class="box_love">
										  	<img alt="Image" src="'.$icon_love.'">
										  	<div class="total_love">'.$love.'</div>
										  	<div class="plus1">+1</div>
										  </div>
										  <div class="right-frills frills"></div>
										</div>

									</div>

						        </div>
							        
							
						';
						*/

						echo '

						        <div class="donation_inner_box" style="background:#ffffff;">
						            <div class="donation_name">'.$donatur_name.'<span class="donation_time"><span class="dashicons dashicons-clock"></span>'.$donation_time.'</span>
						            </div>
						            <div class="donation_total" style="color: #23374d;font-weight:normal;">'.$allocation_title.' <b>Rp '.number_format($data->nominal,0,",",".").'</b></div>
						            <div class="donation_comment">'.str_replace('\\', '', $data->comment).'</div>
						        </div>
							        
							
						';

					}

				echo '
					</div>

				    <div id="box_btn_'.$rand_id.'" class="donation_button">
				        <div class="loadmore_info"></div>
				        <button id="'.$rand_id.'" class="load_list_donatur" data-id="all" data-count="2" data-fullanonim="true" data-anonim="Hamba Allah" style="height: 45px !important;border-radius:45px;margin-top:10px;">Loadmore</button>
					</div>
				</div>';

		}


		$output = ob_get_clean();
		return $output;


  	}else{

  		$id = '';
		if($atts['id']!==null){
	  		$id = $atts['id'];
	  	}

	  	$check_shortcode = $wpdb->get_results('SELECT * from '.$table_name4.' where s_id="'.$id.'"');
		if($check_shortcode==null){
			// wp_die();
			return false;
		}else{
			$style = $check_shortcode[0]->s_style;
			$show  = $check_shortcode[0]->s_show;
			$category_id  	= $check_shortcode[0]->s_category;
			$loadmore  		= $check_shortcode[0]->s_loadmore;
			$button_on  	= $check_shortcode[0]->s_button_on;
			$button_text  	= $check_shortcode[0]->s_button_text;
			$s_data_load  	= $check_shortcode[0]->s_data_load;
			$s_campaign  	= $check_shortcode[0]->s_campaign;
			$grid_on  		= $check_shortcode[0]->s_grid_on;
			$grid_mobile  	= $check_shortcode[0]->s_grid_mobile;
		}

        if($grid_on=='1'){
        	$style_cardnya 	= ' campaign_grid set_to_grid';
        	$show_grid 		= ' show_grid'.$grid_mobile;
        }else{
        	$style_cardnya 	= ' set_to_list';
        	$show_grid 		= '';
        }

		if($s_data_load == '1'){
			$s_campaign = json_decode($s_campaign, true);
			if($s_campaign!=null){
				$count = count($s_campaign['campaign']);
	            $i = 1;
	            $wherenya = '';
	            $campaign = [];
	            foreach ($s_campaign['campaign'] as $value) {

	                $idnya = $value;
	                $new_campaign = $wpdb->get_results("SELECT * FROM $table_name where id='$idnya' ");
	            	$campaign=array_merge($campaign,$new_campaign);

	            }

        	}

		}else{
			if($category_id==null || $category_id=='0'){
				// ALL Category show
				$campaign = $wpdb->get_results("SELECT * FROM $table_name where publish_status='1' ORDER BY id DESC LIMIT 0,$show ");
			}else{

				// example OR : WHERE (category_id='1' and publish_status='1') or (category_id='4' and publish_status='1')
				if( strpos($category_id, ',') !== false ) {

	                // ada koma, maka loop. berarti banyak category
	                $variable = $category_id;
	                $var=explode(',',$variable);
	                $count_categoty = count($var);
	                $no_category = 1;
	                $wherenya = '';
	                foreach($var as $value_idnya)
	                {
	                    $wherenya .= "(category_id='$value_idnya' and publish_status='1')";
	                    if($no_category<$count_categoty){
	                        $wherenya .= ' or ';
	                    }
	                    $no_category++;
	                }

	                $campaign = $wpdb->get_results("SELECT * FROM $table_name where $wherenya ORDER BY id DESC LIMIT 0,$show ");

	            }else{

	                // gak ada koma, berarti single
	                $campaign = $wpdb->get_results("SELECT * FROM $table_name where publish_status='1' and category_id='$category_id' ORDER BY id DESC LIMIT 0,$show ");
	            }

			}
		}

		// Settings
	    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="theme_color" ORDER BY id ASC');
	    $general_theme_color    = json_decode($query_settings[0]->data, true);
	    $theme_color 			= $general_theme_color['color'][0];
		$progressbar_color  	= $general_theme_color['color'][1];
		$button_color 			= $general_theme_color['color'][2];
		$button_color2 			= $general_theme_color['color'][3];

	    if($theme_color==''){
	    	$theme_color = '#009F61';
	    }
	    if($progressbar_color==''){
	    	$progressbar_color = '#009F61';
	    }
		
		// $campaign2 = $wpdb->get_results("SELECT * FROM $table_name where publish_status='1' ORDER BY id ASC LIMIT 0,6 ");

	  	$hasil_list = '';	
	  	$hasil_slider = '';
	  	$hasil_grid = '';


		if($style=='list' || $style=='slider' || $style=='grid'){

			foreach ($campaign as $value) {

				date_default_timezone_set('Asia/jakarta');
				// Waktu Berakhir
			    $date_now = date('Y-m-d');
			    $datetime1 = new DateTime($date_now);
			    $datetime2 = new DateTime($value->end_date);
			    $hasil = $datetime1->diff($datetime2);
			    
			    $year = $hasil->y;
			    $month = $hasil->m;
			    $day = $hasil->d;

			    // Date
			    $date_end = false;
			    if($year!=0){
			        if($day>7){
			    		$sisa_waktu = $year.'&nbsp;tahun,&nbsp;' .($month+1).'&nbsp;bulan&nbsp;lagi';
			    	}else{
			    		$sisa_waktu = $year.'&nbsp;tahun,&nbsp;' .$month.'&nbsp;bulan&nbsp;lagi';
			    	}
			    }else{
			        if($month!=0){
			            $sisa_waktu = $month.'&nbsp;bulan,&nbsp;' .$day.'&nbsp;hari&nbsp;lagi';
			        }else{
			            if($day==0 && $hasil->days==0){
			                $sisa_waktu = 'hari&nbsp;ini';
			            }else{
			                if($hasil->invert==true){
			                    $sisa_waktu = '<span style="color:#ff6b24;font-style:italic;">sudah&nbsp;berakhir</span>';
			                    $date_end = true;
			                }else{
			                    $sisa_waktu = $day.'&nbsp;hari&nbsp;lagi';
			                }
			                
			            }
			        }
			    }

			    if($value->end_date==null){
			    	$sisa_waktu = '∞';
			    }

			    if($hasil->invert==true){
			    	$sisa_waktu = '<span style="color:#ff6b24;font-style:italic;">sudah&nbsp;berakhir</span>';
			    }


				$total_donasi = $wpdb->get_results("SELECT SUM(nominal) as total, COUNT(id) as jumlah FROM $table_name2 where campaign_id='$value->campaign_id' and status='1' ")[0];

				if($value->target==0){
					// $persen = 100;
					$persen_width = 100;
				}else{
					// $persen = ($total_donasi->total/$row->target)*100;
					$persen_width = ($total_donasi->total/$value->target)*100;
					if($persen_width>100){
						$persen_width = 100;
					}
				}

				$data_donasinya = '';
	            if($total_donasi==null){
	                $total_terkumpul = 0;
	                $jumlah_donasi = 0;
	                $data_donasi = 0;
	            }else{
	                $total_terkumpul = $total_donasi->total;
	                $jumlah_donasi = $total_donasi->jumlah;

	                $data_donasi = $wpdb->get_results("SELECT user_id, name FROM $table_name2 where campaign_id='$value->campaign_id' and status='1' ORDER BY id ASC LIMIT 0,3 ");

	                // GET INISAL DONATUR / PP URL
	                foreach ($data_donasi as $data) {
	                	if($data->user_id==null || $data->user_id==0){
	                		$first_char = strtoupper(mb_substr($data->name, 0, 1));
	                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
	                	}else{
	                		$first_char = strtoupper(mb_substr($data->name, 0, 1));
	                		$user_profile = $wpdb->get_results('SELECT user_pp_img as photo from '.$table_name3.' where user_id="'.$data->user_id.'"');
							if(isset($user_profile[0])){
								if($user_profile==null){
									$first_char = strtoupper(mb_substr($data->name, 0, 1));
			                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
								}else{
									$url_photo = $user_profile[0]->photo;
									if($url_photo==''){
										$first_char = strtoupper(mb_substr($data->name, 0, 1));
				                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
									}else{
										$data_donasinya .= '<img src="'.$url_photo.'" alt="User Image" class="u_image">';
									}
								}
							}else{
								$first_char = strtoupper(mb_substr($data->name, 0, 1));
		                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
							}
	                	}
	                }
	            }

				if($value->image_url==null){
	                $image_url = plugin_dir_url( __FILE__ ).'assets/images/cover_donasiaja.jpg';
	            }else{
	                $image_url = $value->image_url;
	                // $image_url = str_replace('localhost', '192.168.0.102', $image_url);
	            }

	            if($jumlah_donasi==0){
	            	$icon_donasi = '
	            	<div class="u_campaign u_icon">
					  <div class="campaign_days no_donation" style="padding-top:5px;">'.$sisa_waktu.'</div>
					</div>
					';
	            }else{
	            	$donasi_plusmore = '';
	            	if($jumlah_donasi>=4){
		            	
	            		$total_min_three = $jumlah_donasi-3;
	            		$donasi_totalnya = shortDisplayNumber($total_min_three).'+';

		            	if(strlen($donasi_totalnya)>=4){
		            		$donasi_totalnya = '<span style="font-size:7px;">'.$donasi_totalnya.'</span>';
		            	}elseif(strlen($donasi_totalnya)==3){
		            		$donasi_totalnya = '<span style="font-size:8px;">'.$donasi_totalnya.'</span>';
		            	}else{
		            		$donasi_totalnya = $donasi_totalnya;
		            	}

		            	// >= 4 char = 7px
		            	// 3 char = 8px
		            	// 2 char = 9px

		            	$donasi_plusmore = '<span class="u_image u_inisial" style="background:'.$theme_color.'">'.$donasi_totalnya.'</span>';
	            	}


					$icon_donasi = '
	            	<div class="u_campaign u_donasi">
					  <div class="u_photo">
					  	'.$data_donasinya.'
					  	'.$donasi_plusmore.'
					  </div>
					  <div class="campaign_days" style="margin-top:5px;font-size:11px;">'.$sisa_waktu.'</div>
					</div>
					';
	            }

	            if($value->publish_status=='1'){
	                $campaign_url = get_site_url().'/campaign/'.$value->slug;
	            }else{
	                $campaign_url = get_site_url().'/preview/'.$value->slug;
	            }


	            // GET PROFILE PICTURE CAMPAIGNER
				$profile = $wpdb->get_results('SELECT user_pp_img as photo, user_verification from '.$table_name3.' where user_id="'.$value->user_id.'"');
				if(isset($profile[0])){
					if($profile==null){
						$profile_photo = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
					}else{
						$profile_photo = $profile[0]->photo;
					}
				}else{
					$profile_photo = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
				}

				// GET USER NAME
				$args2 = array( 'blog_id' => 0, 'search' => $value->user_id, 'search_columns' => array( 'ID' ) );
	            $get_name = get_users( $args2 );

	            if($get_name==null){
	                $campaigner_name = '-';
	            }else{
	                $nama_user = str_replace("'", "&#39;", $get_name[0]->user_firstname.' '.$get_name[0]->user_lastname);
	                $campaigner_name = str_replace('\\', '', $nama_user); // nama asli
	            }
	            // user_firstname

	            if($profile[0]->user_verification=='1'){
	            	$verified_user = '<div class="verified_checklist"><img alt="Image" src="'.plugin_dir_url( __FILE__ ).'assets/images/check.png"></div>';
	            }else{
	            	$verified_user = '';
	            }

	            $button_donasi = '';
	            if($button_on=='1'){

	            	$text_button = 'Donate Now';
	            	if($button_text!=''){
	            		$text_button = $button_text;
	            	}

	            	if($style=='list'){
	            		$button_donasi = '
	            		<div class="btn_donasi_box">
				        	<div class="btn_donasi">
					       	<button style="background-color:'.$button_color2.';">'.$text_button.'</button>
					       	</div>
					    </div>
					    ';
	            	}
	            	if($style=='slider'){
	            		$button_donasi = '
	            		<div class="btn_donasi_box btn_slider">
				        	<div class="btn_donasi">
					       	<button style="background-color:'.$button_color2.';">'.$text_button.'</button>
					       	</div>
					    </div>
					    ';
	            	}

	            	if($style=='grid'){
	            		$button_donasi = '
	            		<div class="btn_donasi_box btn_grid">
				        	<div class="btn_donasi">
					       	<button style="background-color:'.$button_color2.';">'.$text_button.'</button>
					       	</div>
					    </div>
					    ';
	            	}

	            }


	            if($style=='list'){
		            $hasil_list .= '
		            <li class="cards__item">
					  <a href="'.$campaign_url.'">
				      <div class="card__">
				        <div class="card__image"><img src="'.$image_url.'"></div>
				        <div class="card__content content_1">
				          <div class="card__title">'.$value->title.'</div>
				        </div>
				        <div class="card__content content_2">
				          <div class="card__text campaigner_name">'.$campaigner_name.$verified_user.'</div>
				          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
				          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
				          '.$icon_donasi.'
				        </div>
				        '.$button_donasi.'
					    </div>
				        
				      </a>
				    </li>
				    ';
				}

				if($style=='slider'){
				    $hasil_slider .= '
					<div class="cards__item">
					  <a href="'.$campaign_url.'">
				      <div class="card__">
				        <div class="card__image"><img src="'.$image_url.'"></div>
				        <div class="card__content content_1">
				          <div class="card__title">'.$value->title.'</div>
				        </div>
				        <div class="card__content content_2">
				          <div class="card__text campaigner_name">'.$campaigner_name.$verified_user.'</div>
				          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
				          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
				          '.$icon_donasi.'
				        </div>
				        '.$button_donasi.'
				      </div>
				      </a>
				    </div>
					';
				}

				if($style=='grid'){
					$hasil_grid .= '
					<li class="cards__item">
					  <a href="'.$campaign_url.'">
				      <div class="card__">
				        <div class="card__image"><img src="'.$image_url.'"></div>
				        <div class="card__content content_1">
				          <div class="card__title">'.$value->title.'</div>
				        </div>
				        <div class="card__content content_2">
				          <div class="card__text campaigner_name">'.$campaigner_name.$verified_user.'</div>
				          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
				          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
				          '.$icon_donasi.'
				        </div>
				        '.$button_donasi.'
				      </div>
				      </a>
				    </li>
					';
				}

			}

		}


		ob_start();

		if($style=='slider'){
			
			echo '<div id="section_'.$id.'" class="my-slider-'.$id.'">'.$hasil_slider.'</div>';
			echo '
				<script src="'.plugin_dir_url( __FILE__ ) . 'assets/js/tiny-slider.min.js"></script>
					
					<script type="module">
					var widthnya = $("#section_'.$id.'").width();
					var itemnya = 2;
					if(widthnya>=540){
						itemnya = 3;
					}
					/* if(widthnya<=350){ itemnya = 1; } */
					  var slider = tns({
					    container: ".my-slider-'.$id.'",
					    "items": itemnya,
						"slideBy": "page",
						"loop": true,
						"swipeAngle": false,
						"speed": 400,
						"controls": false,
						"controlsPosition" : "bottom",
						"navPosition" : "bottom",
						"touch" : true,
						"autoplay": true,
						"controlsText" : ["<span class='."'".'dashicons dashicons-arrow-left-alt2'."'".'></span>", "<span class='."'".'dashicons dashicons-arrow-right-alt2'."'".'></span>"]
					  });
				</script>
			';
		}

		if($style=='list'){
			echo '<ul id="section_'.$id.'" class="cards__campaign cards__list">'.$hasil_list.'</ul>';
			if($loadmore>=1){
				echo '<div id="box_button_'.$id.'" class="btn_loadmore_list"><div class="donasiaja_loadmore_info"></div><button class="load_campaign" data-id="'.$id.'" data-count="2" style="color:'.$button_color2.';border:1px solid '.$button_color2.';">Load more</button></div>';
			}
			
		}
		if($style=='grid'){
			echo '<ul id="section_'.$id.'" class="cards__campaign'.$style_cardnya.$show_grid.'">'.$hasil_grid.'</ul>';
			if($loadmore>=1){
				echo '<div id="box_button_'.$id.'" class="btn_loadmore_grid"><div class="donasiaja_loadmore_info"></div><button class="load_campaign" data-id="'.$id.'" data-count="2" style="color:'.$button_color2.';border:1px solid '.$button_color2.';">Load more</button></div>';
			}
		}

		$output = ob_get_clean();
		return $output;


  	}

  	

}
add_shortcode( 'donasiaja', 'donasiaja_shortcode_func' );



// shortcode per campaign
function donasiaja_campaign_shortcode_func( $atts, $content = "" ) {
	
	global $wpdb;
	$table_name = $wpdb->prefix . "dja_campaign";
	$table_name2 = $wpdb->prefix . "dja_donate";
	$table_name3 = $wpdb->prefix . "dja_users";
	$table_name4 = $wpdb->prefix . "dja_shortcode";
	$table_name5 = $wpdb->prefix . "dja_campaign_update";
	$table_name6 = $wpdb->prefix . "dja_settings";

	$atts = shortcode_atts( array(
		'id' => null,
		'show' => null,
		'icon_donatur' => null
	), $atts, 'donasiaja_campaign' );


	$id = '';
	if($atts['id']!==null){
  		$id = $atts['id'];
  	}

	$show = '';
	if($atts['show']!==null){
  		$show = $atts['show'];
  	}

	$icon_donatur = '';
	if($atts['icon_donatur']!==null){
  		$icon_donatur = $atts['icon_donatur'];
  	}

  	$check_campaign = $wpdb->get_results('SELECT id from '.$table_name.' where campaign_id="'.$id.'"');
	if($check_campaign==null){
		return false;
	}

	// Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name6.' where type="anonim_text" or type="theme_color" ORDER BY id ASC');
    $anonim_text 			= $query_settings[0]->data;
    $general_theme_color    = json_decode($query_settings[1]->data, true);
    $theme_color 			= $general_theme_color['color'][0];
	$progressbar_color  	= $general_theme_color['color'][1];
	$button_color 			= $general_theme_color['color'][2];

    if($theme_color==''){
    	$theme_color = '#009F61';
    }
    if($progressbar_color==''){
    	$progressbar_color = '#009F61';
    }


		$value = $wpdb->get_results("SELECT * FROM $table_name where campaign_id='$id' ")[0];

		$date_now = date('Y-m-d');
	    $datetime1 = new DateTime($date_now);
	    $datetime2 = new DateTime($value->end_date);
	    $hasil = $datetime1->diff($datetime2);
	    
	    $year = $hasil->y;
	    $month = $hasil->m;
	    $day = $hasil->d;

	    // Date
	    $date_end = false;
	    if($year!=0){
	        if($day>7){
	    		$sisa_waktu = $year.'&nbsp;tahun,&nbsp;' .($month+1).'&nbsp;bulan&nbsp;lagi';
	    	}else{
	    		$sisa_waktu = $year.'&nbsp;tahun,&nbsp;' .$month.'&nbsp;bulan&nbsp;lagi';
	    	}
	    }else{
	        if($month!=0){
	            $sisa_waktu = $month.'&nbsp;bulan,&nbsp;' .$day.'&nbsp;hari&nbsp;lagi';
	        }else{
	            if($day==0 && $hasil->days==0){
	                $sisa_waktu = 'hari&nbsp;ini';
	            }else{
	                if($hasil->invert==true){
	                    $sisa_waktu = '<span style="color:#ff6b24;font-style:italic;">sudah&nbsp;berakhir</span>';
	                    $date_end = true;
	                }else{
	                    $sisa_waktu = $day.'&nbsp;hari&nbsp;lagi';
	                }
	                
	            }
	        }
	    }

	    if($value->end_date==null){
	    	$sisa_waktu = '∞';
	    }
	    if($hasil->invert==true){
	    	$sisa_waktu = '<span style="color:#ff6b24;font-style:italic;">sudah&nbsp;berakhir</span>';
	    }


		$total_donasi = $wpdb->get_results("SELECT SUM(nominal) as total, COUNT(id) as jumlah FROM $table_name2 where campaign_id='$value->campaign_id' and status='1' ")[0];

		if($value->target==0){
			// $persen = 100;
			$persen_width = 100;
		}else{
			// $persen = ($total_donasi->total/$row->target)*100;
			$persen_width = ($total_donasi->total/$value->target)*100;
			if($persen_width>100){
				$persen_width = 100;
			}
		}

		$data_donasinya = '';
        if($total_donasi==null){
            $total_terkumpul = 0;
            $jumlah_donasi = 0;
            $data_donasi = 0;
        }else{
            $total_terkumpul = $total_donasi->total;
            $jumlah_donasi = $total_donasi->jumlah;

            $data_donasi = $wpdb->get_results("SELECT user_id, name FROM $table_name2 where campaign_id='$value->campaign_id' and status='1' ORDER BY id ASC LIMIT 0,3 ");

            // GET INISAL DONATUR / PP URL
            foreach ($data_donasi as $data) {
            	if($data->user_id==null || $data->user_id==0){
            		$first_char = strtoupper(mb_substr($data->name, 0, 1));
            		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
            	}else{
            		$first_char = strtoupper(mb_substr($data->name, 0, 1));
            		$user_profile = $wpdb->get_results('SELECT user_pp_img as photo from '.$table_name3.' where user_id="'.$data->user_id.'"');
					if(isset($user_profile[0])){
						if($user_profile==null){
							$first_char = strtoupper(mb_substr($data->name, 0, 1));
	                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
						}else{
							$url_photo = $user_profile[0]->photo;
							if($url_photo==''){
								$first_char = strtoupper(mb_substr($data->name, 0, 1));
		                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
							}else{
								$data_donasinya .= '<img src="'.$url_photo.'" alt="User Image" class="u_image">';
							}
						}
					}else{
						$first_char = strtoupper(mb_substr($data->name, 0, 1));
                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
					}
            	}
            }
        }

		if($value->image_url==null){
            $image_url = plugin_dir_url( __FILE__ ).'assets/images/cover_donasiaja.jpg';
        }else{
            $image_url = $value->image_url;
            // $image_url = str_replace('localhost', '192.168.0.102', $image_url);
        }

        if($jumlah_donasi==0){
        	$icon_donasi = '
        	<div class="u_campaign u_icon">
			  <div class="campaign_days no_donation" style="padding-top:5px;">'.$sisa_waktu.'</div>
			</div>
			';
        }else{
        	$donasi_plusmore = '';
        	if($jumlah_donasi>=4){
            	
        		$total_min_three = $jumlah_donasi-3;
        		$donasi_totalnya = shortDisplayNumber($total_min_three).'+';

            	if(strlen($donasi_totalnya)>=4){
            		$donasi_totalnya = '<span style="font-size:7px;">'.$donasi_totalnya.'</span>';
            	}elseif(strlen($donasi_totalnya)==3){
            		$donasi_totalnya = '<span style="font-size:8px;">'.$donasi_totalnya.'</span>';
            	}else{
            		$donasi_totalnya = $donasi_totalnya;
            	}

            	// >= 4 char = 7px
            	// 3 char = 8px
            	// 2 char = 9px

            	$donasi_plusmore = '<span class="u_image u_inisial" style="background:'.$theme_color.'">'.$donasi_totalnya.'</span>';
        	}

        	if($icon_donatur=='hide'){
        		$icon_donasi = '
	        	<div class="u_campaign u_donasi">
				  <div class="campaign_days" style="margin-top:5px;font-size:11px;">'.$sisa_waktu.'</div>
				</div>
				';
        	}else{
        		$icon_donasi = '
	        	<div class="u_campaign u_donasi">
				  <div class="u_photo">
				  	'.$data_donasinya.'
				  	'.$donasi_plusmore.'
				  </div>
				  <div class="campaign_days" style="margin-top:5px;font-size:11px;">'.$sisa_waktu.'</div>
				</div>
				';
        	}

			
        }

        if($value->publish_status=='1'){
            $campaign_url = get_site_url().'/campaign/'.$value->slug;
        }else{
            $campaign_url = get_site_url().'/preview/'.$value->slug;
        }


        // GET PROFILE PICTURE CAMPAIGNER
		$profile = $wpdb->get_results('SELECT user_pp_img as photo from '.$table_name3.' where user_id="'.$value->user_id.'"');
		if(isset($profile[0])){
			if($profile==null){
				$profile_photo = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
			}else{
				$profile_photo = $profile[0]->photo;
			}
		}else{
			$profile_photo = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
		}

		// GET USER NAME
		$args2 = array( 'blog_id' => 0, 'search' => $value->user_id, 'search_columns' => array( 'ID' ) );
        $get_name = get_users( $args2 );

        if($get_name==null){
            $campaigner_name = '-';
        }else{
            $nama_user = str_replace("'", "&#39;", $get_name[0]->user_firstname.' '.$get_name[0]->user_lastname);
	        $campaigner_name = str_replace('\\', '', $nama_user); // nama asli
        }
	

	


	ob_start();

	if($show=='info'){
		echo html_entity_decode($value->information);
	}

	if($show=='info_update'){
		
		$campaign_update = $wpdb->get_results("SELECT * FROM $table_name5 where campaign_id='$id' ORDER BY id DESC");

		$dt = new DateTime($value->created_at);
	    $m = $dt->format('F');

	    if (strpos($m, 'January') !== false ) { $m = 'Januari'; }
	    elseif(strpos($m, 'February') !== false ) { $m = 'Februari'; }

	    $dt = $m.', '.$dt->format('j Y');
	    

		if($campaign_update==null){ 
			echo '
	    	<div id="kabar-terbaru-donasi">
				  <ul class="timeline" style="margin-top: 50px;">
					<li class="timeline-milestone is-start" style="height: 50px;">
				      <div class="timeline-action">
				      	<span class="date">'.$dt.'</span>
				        <h3 class="title">Campaign is published</h3>
				      </div>
				    </li>
				  </ul>
	    	</div>
	    	';

    	}else{

    		$data_info_update = '';
    		foreach ($campaign_update as $value) { 

			  	$readtime = new donasiaja_readtime();
				$time_update = $readtime->time_donation($value->created_at);

		  		$data_info_update .= '

				    <li class="timeline-milestone is-current">
				      <div class="timeline-action is-expandable expanded">
					        <span class="date">'.$dt.'</span>
					        <h3 class="title">'.$value->title.'</h3>
					        <div class="content">
					        	'.$value->information.'
					        </div>
				      </div>
				    </li>
			    ';

			}

    		$info_update = '
	    	<div id="kabar-terbaru-donasi">
				  <ul class="timeline" style="margin-top: 50px;">
				  	'.$data_info_update.'
				  	<li class="timeline-milestone is-start" style="height: 50px;">
				      <div class="timeline-action">
				      	<span class="date">'.$dt.'</span>
				        <h3 class="title">Campaign is published</h3>
				      </div>
				    </li>
				  </ul>
	    	</div>';

	    	echo $info_update;

    	}
	}

	if($show=='list_donatur'){

		$donasi = $wpdb->get_results("SELECT * FROM $table_name2 where campaign_id='$id' and status='1' ORDER BY id DESC limit 0,5 ");
		$rand_id = d_randomString(5);

		echo '
			<style>.donation_box {width:520px;}@media only screen and (max-width:480px) {.donation_box {width:100%;}}</style>
			<div class="donation_box black" style="background:#F4F8FD;">

			    <div id="box_'.$rand_id.'">';

				foreach ($donasi as $data) {

		        	$readtime = new donasiaja_readtime();
					$donation_time = $readtime->time_donation($data->created_at);

					$general_status = $value->general_status;
				    $allocation_title = $value->allocation_title;
				    $allocation_others_title = $value->allocation_others_title;

				    if($general_status=='1'){
				        if($allocation_title=='1'){
				            $allocation_title = 'Donasi';
				        }elseif($allocation_title=='2'){
				            $allocation_title = 'Zakat';
				        }elseif($allocation_title=='3'){
				            $allocation_title = 'Qurban';
				        }else{
				            $allocation_title = $allocation_others_title;
				        }
				    }else{
				        $allocation_title = 'Donasi';
				    }

				    $donatur_name = $data->name;
					$anonim = 'Orang Baik';
					if($data->anonim=='1'){
						$donatur_name = $anonim_text;
					}

					echo '

					        <div class="donation_inner_box" style="background:#ffffff;">
					            <div class="donation_name">'.$donatur_name.'<span class="donation_time"><span class="dashicons dashicons-clock"></span>'.$donation_time.'</span>
					            </div>
					            <div class="donation_total" style="color: #23374d;font-weight:normal;">'.$allocation_title.' <b>Rp '.number_format($data->nominal,0,",",".").'</b></div>
					            <div class="donation_comment">'.str_replace('\\', '', $data->comment).'</div>

					        </div>
						        
						
					';

				}

			echo '
				</div>

			    <div id="box_btn_'.$rand_id.'" class="donation_button">
			        <div class="loadmore_info"></div>
			        <button id="'.$rand_id.'" class="load_list_donatur" data-id="'.$id.'" data-count="2" data-fullanonim="true" data-anonim="Hamba Allah" style="height: 45px !important;border-radius:45px;margin-top:10px;">Loadmore</button>
				</div>
			</div>';

	}

	if($show=='total_terkumpul'){
		echo 'Rp '.number_format($total_terkumpul,0,",",".");
	}

	if($show=='jumlah_donasi'){
		echo $jumlah_donasi .' Donasi';
	}

	if($show=='full_list'){

	    $view = '
		<ul id="section_'.$id.'" class="cards__campaign cards__list">
		  <li class="cards__item" style="margin:0;margin-top:10px;margin-bottom:10px;padding-bottom:5px;">
		  <a href="'.$campaign_url.'">
	      <div class="card__">
	        <div class="card__image"><img src="'.$image_url.'"></div>
	        <div class="card__content content_1">
	          <div class="card__title">'.$value->title.'</div>
	        </div>
	        <div class="card__content content_2">
	          <div class="card__text campaigner_name">'.$campaigner_name.'<div class="verified_checklist"><img alt="Image" src="'.plugin_dir_url( __FILE__ ).'assets/images/check.png"></div></div>
	          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
	          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
	          '.$icon_donasi.'
	        </div>
	      </div>
	      </a>
	      </li>
	    </ul>
		';

		echo $view;
			
	}

	if($show=='full_card'){

	    $view = '
		<div class="cards__item" style="padding:0;width:100%;margin-top:10px;margin-bottom:10px;">
		  <a href="'.$campaign_url.'">
	      <div class="card__">
	        <div class="card__image"><img src="'.$image_url.'"></div>
	        <div class="card__content content_1">
	          <div class="card__title">'.$value->title.'</div>
	        </div>
	        <div class="card__content content_2">
	          <div class="card__text campaigner_name">'.$campaigner_name.'<div class="verified_checklist"><img alt="Image" src="'.plugin_dir_url( __FILE__ ).'assets/images/check.png"></div></div>
	          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
	          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
	          '.$icon_donasi.'
	        </div>
	      </div>
	      </a>
	    </div>
		';

		echo $view;
			
	}

	if($show=='cta_form'){

		// print_r($value);
			
	}

	if($show=='progress'){

	    $progress = '
	        <div class="card__content content_2" style="padding:20px 10px 40px 10px;height:auto;border-radius: 4px;">
	          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
	          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
	          '.$icon_donasi.'
	        </div>
		';

		echo $progress;
			
	}

	$output = ob_get_clean();
	return $output;

}
add_shortcode( 'donasiaja_campaign', 'donasiaja_campaign_shortcode_func' );



// shortcode per campaign
function donasiaja_socialproof_shortcode_func( $atts, $content = "" ) {
	
	global $wpdb;
	$table_name   = $wpdb->prefix . "dja_settings";
	$table_name2  = $wpdb->prefix . "dja_donate";
	$table_name3  = $wpdb->prefix . "dja_campaign";
	$table_name4  = $wpdb->prefix . "dja_users";

	$atts = shortcode_atts( array(
		'campaign' => null,
		'close' => null,
	), $atts, 'donasiaja_socialproof' );


	$campaign = '';
	if($atts['campaign']!==null){
  		$campaign = $atts['campaign'];
  	}

  	$close = 'hide';
	if($atts['close']!==null){
  		$close = $atts['close'];
  	}
  	if($close=='show'){
  		$close = 'true';
  	}else{
  		$close = 'false';
  	}


	// Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="anonim_text" or type="socialproof_text" or type="socialproof_settings" ORDER BY id ASC');
    $anonim_text    	  = $query_settings[0]->data;
    $socialproof_text     = $query_settings[1]->data;
    $socialproof_settings = $query_settings[2]->data;

    $socialproof_setting  = json_decode($socialproof_settings, true);
    $popup_style    = $socialproof_setting['settings'][0];
    $position       = $socialproof_setting['settings'][1];
    $time_set       = $socialproof_setting['settings'][2];
    $delay          = $socialproof_setting['settings'][3];
    $data_load      = $socialproof_setting['settings'][4];

    // popup_style
    if($popup_style=='rounded'){
        $set_style = ' s-rounded';
    }elseif($popup_style=='flying_boxed'){
        $set_style = ' s-flying';
    }elseif($popup_style=='flying_rounded'){
        $set_style = ' s-rounded s-flying';
    }else{
        $set_style = '';
    }

    // delay
    $delay = $delay*1000;

    // data_load
    $total = $data_load;

    // time
    $time = $time_set;

    // title
    $title = $socialproof_text;

    // position
    $position_data = explode('_', $position);
	$p_gravity  = $position_data[0];
	$p_position = $position_data[1];

	// campaign
	if($campaign!=''){
    	$data_donasi = $wpdb->get_results("SELECT a.id, a.campaign_id, a.user_id, a.invoice_id, a.name, a.anonim, a.created_at, b.title, c.user_pp_img FROM $table_name2 a
		left JOIN $table_name3 b ON b.campaign_id = a.campaign_id
		left JOIN $table_name4 c ON c.user_id = a.user_id
		where a.status='1' and a.campaign_id='$campaign' ORDER BY id DESC LIMIT 0,$total ");
    }else{
    	$data_donasi = $wpdb->get_results("SELECT a.id, a.campaign_id, a.user_id, a.invoice_id, a.name, a.anonim, a.created_at, b.title, c.user_pp_img FROM $table_name2 a
		left JOIN $table_name3 b ON b.campaign_id = a.campaign_id
		left JOIN $table_name4 c ON c.user_id = a.user_id
		where a.status='1' ORDER BY id DESC LIMIT 0,$total ");
    }
	

	$data_donasinya = '';
	foreach ($data_donasi as $value) {
		
		$donatur_name = $value->name;
		if($value->anonim=='1'){
			$donatur_name = $anonim_text;
		}

		$data_field = array();
	    $data_field[ '{campaign_title}' ] = $value->title;
	   
		$titlenya = strtr($title, $data_field);
		
		$pp = '';
		if($value->user_pp_img!=''){
			$pp = $value->user_pp_img;
		}

		$the_time = donasiaja_readtime($value->created_at);

		$donatur_name = str_replace("'",'',$donatur_name);
		$donatur_name = str_replace('"','',$donatur_name);

		$title_campaign = str_replace("'",'',$titlenya);
		$title_campaign = str_replace('"','',$title_campaign);
		
		$data_donasinya .= '{"content": ["'.$donatur_name.'", "'.$the_time.'", "'.$title_campaign.'", "'.$pp.'", "'.$value->campaign_id.'"]},';
	}

	ob_start();
	$decoding = "decoding='async'";
	echo '<script src="'.plugin_dir_url( __FILE__ ).'assets/js/toastify.js"></script>';
	echo '
		<script>
		Array.prototype.getRandomColor= function(cut){
		    var i= Math.floor(Math.random()*this.length);
		    if(cut && i in this){
		        return this.splice(i, 1)[0];
		    }
		    return this[i];
		}
		var avatar_colors= ["#D94452", "#FA6C51", "#F5B945", "#9ED26A", "#35BA9B", "#4FC0E8", 
		"#9579DA", "#E3B692", "#E5C3C1", "#E7CDAC"];
		splittedContent = [ '.$data_donasinya.' ];
		function loopSplit(splittedContent) {
		    for (var i = 0; i < splittedContent.length; i++) {
		        (function (i) {
		        })(i);
		    };
		}
		loopSplit(splittedContent);
		var d = 0, howManyTimes = splittedContent.length;

		function f_socialproof() {
		  	var name 	= splittedContent[d].content[0];
		    var time 	= " - "+splittedContent[d].content[1];
		    var title 	= splittedContent[d].content[2];
		    var pp_url 	= splittedContent[d].content[3];
		    var c_id 	= splittedContent[d].content[4];
		    show_color_avatar = "";
		    if(pp_url!=""){
		    	show_color_avatar = "display:none;";
		    }
		    show_img_avatar = "";
		    if(pp_url==""){
		    	show_img_avatar = "display:none;";
		    }
		    var show_time = "'.$time.'";
		    if(show_time=="hide"){
		    	time = "";
		    }
		    setTimeout(function() {
		       Toastify({
				  text: "<div class=dsproof-container id="+c_id+"><div class=dsproof-avatar style=background:"+avatar_colors.getRandomColor()+";"+show_color_avatar+">"+name.substring(0, 1)+"</div><div class=dsproof-avatar style="+show_img_avatar+"><img '.$decoding.' src="+pp_url+"></div><div class=dsproof-content><div class=dsproof-name>"+name+"</div><div class=dsproof-title>"+title+"</div><div class=dsproof-verified><img src='.plugin_dir_url( __FILE__ ).'assets/images/check.png'.'><span>Verified"+time+"</span></div><div></div>",
				  className: "donasiaja-socialproof'.$set_style.'",
				  escapeMarkup : false,
				  gravity: "'.$p_gravity.'",
				  position: "'.$p_position.'",
				  close: '.$close.',
				  duration: 5000,
				  style: {
				    background: "linear-gradient(to right, #ffffff, #ffffff)",
				  }
				}).showToast();
			}, 1000)
		  d++;
		  if (d < howManyTimes) {
		    setTimeout(f_socialproof, '.$delay.');
		  }
		}
		if(splittedContent.length>=1){
			f_socialproof();  
		} 
		</script>

	';

	echo '<style>
		.donasiaja-socialproof{line-height: 1.5;border-radius:6px;max-width:360px;height:auto;padding-right:30px!important;z-index:9999;background:#fff!important;box-shadow: 0 3px 6px -1px rgba(0, 0, 0, 0.06),0 10px 36px -4px rgba(77, 96, 232, 0.09) !important;}.donasiaja-socialproof .toast-close{position:absolute;right:0;color:#fff;margin-top:-16px!important;background:#0000004f;width:25px!important;height:25px!important;font-size:13px!important;text-align:center!important;padding:2px!important;opacity:1;top:10px}.dsproof-avatar{border-radius:4px;width:50px;height:50px;text-align:center;position:absolute;margin-left:-7px;margin-top:0px;font-size:32px;font-weight:700;color:#fffc;font-family:Lato,FontAwesome,lato,sans-serif!important}.dsproof-avatar img{width:50px;height:50px;border-radius:4px;}.dsproof-content{margin-left:54px;color:#888;font-size:11px;font-family:Lato,FontAwesome,lato,sans-serif!important}.dsproof-name{font-size:13px;font-weight:700;color:#35363c;position:absolute;margin-top:-3px}.dsproof-title{color:#656577;padding-top:16px;padding-bottom:2px}.dsproof-verified{font-size:10px;color:#b0b0c6;margin-bottom:2px;}.dsproof-verified span{padding-left:15px}.dsproof-verified img{width:12px;position:absolute;margin-top:2px}.toastify{padding:12px 20px;padding-top:12px!important;color:#fff;display:inline-block;box-shadow:0 3px 6px -1px rgba(0,0,0,.12),0 10px 36px -4px rgba(77,96,232,.3);background:-webkit-linear-gradient(315deg,#73a5ff,#5477f5);background:linear-gradient(135deg,#73a5ff,#5477f5);position:fixed;opacity:0;transition:all .4s cubic-bezier(.215,.61,.355,1);cursor:pointer;text-decoration:none;z-index:2147483647}.toastify.on{opacity:1}.toast-close{opacity:.4;padding:0 5px}.toastify-right{right:15px}.toastify-left{left:15px}.toastify-top{top:-150px}.toastify-bottom{bottom:-150px}.toastify-rounded{}.toastify-avatar{width:1.5em;height:1.5em;margin:-7px 5px;border-radius:2px}.toastify-center{margin-left:auto;margin-right:auto;left:0;right:0;max-width:fit-content;max-width:-moz-fit-content}@media only screen and (max-width:360px){.toastify-left,.toastify-right{margin-left:auto;margin-right:auto;left:0;right:0;max-width:fit-content}} .donasiaja-socialproof.s-rounded .dsproof-avatar{border-radius: 50px;} .donasiaja-socialproof.s-rounded .dsproof-avatar img{border-radius: 50px;}
		.donasiaja-socialproof.s-rounded {min-height:77px !important;height:auto !important;}
		.donasiaja-socialproof.s-rounded .dsproof-avatar {margin-top:0px;}
		.donasiaja-socialproof.s-flying { background: transparent !important;box-shadow:none !important;}
		.donasiaja-socialproof.s-flying .dsproof-avatar { box-shadow: 0 3px 6px -1px rgba(0, 0, 0, 0.06),0 10px 36px -4px rgba(77, 96, 232, 0.04) !important;}
		.donasiaja-socialproof.s-flying .dsproof-content { background: #fff;padding: 10px 20px 10px 16px;border-radius: 4px;box-shadow: 0 3px 6px -1px rgba(0, 0, 0, 0.06),0 10px 36px -4px rgba(77, 96, 232, 0.04)}
	</style>';
	$output = ob_get_clean();
	return $output;

}
add_shortcode( 'donasiaja_socialproof', 'donasiaja_socialproof_shortcode_func' );





function donasiaja_readtime($time) { 

	$timestamp = strtotime($time);	
   
    $strTime = array("detik", "menit", "jam", "hari", "bulan", "tahun");
    $length = array("60","60","24","30","12","10");

    $currentTime = time();
    if($currentTime >= $timestamp) {
    	
    	$diff     = time()- $timestamp + (60*60);
		
		for($i = 0; $diff >= $length[$i] && $i < count($length)-1; $i++) {
		$diff = $diff / $length[$i];
		}

		$diff = round($diff);
		return $diff . " " . $strTime[$i] . " yang lalu";
    }

}

function donasiaja_load_campaign() {
	
    global $wpdb;
	$table_name = $wpdb->prefix . "dja_campaign";
	$table_name2 = $wpdb->prefix . "dja_donate";
	$table_name3 = $wpdb->prefix . "dja_users";
	$table_name4 = $wpdb->prefix . "dja_shortcode";
	$table_name5 = $wpdb->prefix . "dja_settings";
    
    $id = $_POST['datanya'][0];
    $load_count = $_POST['datanya'][1];
    $uid = $_POST['datanya'][2];

    $firstTwoCharacters = substr($id, 0, 2);

  	$check_campaign = $wpdb->get_results('SELECT * from '.$table_name4.' where s_id="'.$id.'"');

	if($firstTwoCharacters=='u_'){
		$style = 'list';
		$show  = 3;
		$category_id  = 0;
		$loadmore  = 3;
	}elseif($check_campaign==null){
		wp_die();
	}else{
		$style = $check_campaign[0]->s_style;
		$show  = $check_campaign[0]->s_show;
		$category_id  = $check_campaign[0]->s_category;
		$loadmore  = $check_campaign[0]->s_loadmore;
		$button_on  = $check_campaign[0]->s_button_on;
		$button_text  = $check_campaign[0]->s_button_text;
	}

	$start = ($load_count*$show)-$show;
    $limit = $loadmore;

	if($category_id==null || $category_id=='0'){
		if($uid!=''){
			$campaign = $wpdb->get_results("SELECT * FROM $table_name where publish_status='1' and user_id='$uid' ORDER BY id DESC LIMIT $start,$limit ");
		}else{
			$campaign = $wpdb->get_results("SELECT * FROM $table_name where publish_status='1' ORDER BY id DESC LIMIT $start,$limit ");
		}
	}else{
		// example OR : WHERE (category_id='1' and publish_status='1') or (category_id='4' and publish_status='1')
		if( strpos($category_id, ',') !== false ) {

            // ada koma, maka loop. berarti banyak category
            $variable = $category_id;
            $var=explode(',',$variable);
            $count_categoty = count($var);
            $no_category = 1;
            $wherenya = '';
            foreach($var as $value_idnya)
            {
                $wherenya .= "(category_id='$value_idnya' and publish_status='1')";
                if($no_category<$count_categoty){
                    $wherenya .= ' or ';
                }
                $no_category++;
            }

            $campaign = $wpdb->get_results("SELECT * FROM $table_name where $wherenya ORDER BY id DESC LIMIT $start,$limit ");

        }else{

            // gak ada koma, berarti single
            $campaign = $wpdb->get_results("SELECT * FROM $table_name where publish_status='1' and category_id='$category_id' ORDER BY id DESC LIMIT $start,$limit ");
        }
	}

	// Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="theme_color" ORDER BY id ASC');
    $general_theme_color    = json_decode($query_settings[0]->data, true);
    $theme_color 			= $general_theme_color['color'][0];
	$progressbar_color  	= $general_theme_color['color'][1];
	$button_color 			= $general_theme_color['color'][2];
	$button_color2 			= $general_theme_color['color'][3];

    if($theme_color==''){
    	$theme_color = '#009F61';
    }
    if($progressbar_color==''){
    	$progressbar_color = '#009F61';
    }



  	$hasil_list = '';	
  	$hasil_slider = '';
  	$hasil_grid = '';


	if($style=='list' || $style=='slider' || $style=='grid'){

		foreach ($campaign as $value) {

			// Waktu Berakhir
		    $date_now = date('Y-m-d');
		    $datetime1 = new DateTime($date_now);
		    $datetime2 = new DateTime($value->end_date);
		    $hasil = $datetime1->diff($datetime2);
		    
		    $year = $hasil->y;
		    $month = $hasil->m;
		    $day = $hasil->d;

		    // Date
		    $date_end = false;
		    if($year!=0){
		        if($day>7){
		    		$sisa_waktu = $year.'&nbsp;tahun,&nbsp;' .($month+1).'&nbsp;bulan&nbsp;lagi';
		    	}else{
		    		$sisa_waktu = $year.'&nbsp;tahun,&nbsp;' .$month.'&nbsp;bulan&nbsp;lagi';
		    	}
		    }else{
		        if($month!=0){
		            $sisa_waktu = $month.'&nbsp;bulan,&nbsp;' .$day.'&nbsp;hari&nbsp;lagi';
		        }else{
		            if($day==0 && $hasil->days==0){
		                $sisa_waktu = 'hari&nbsp;ini';
		            }else{
		                if($hasil->invert==true){
		                    $sisa_waktu = '<span style="color:#ff6b24;font-style:italic;">sudah&nbsp;berakhir</span>';
		                    $date_end = true;
		                }else{
		                    $sisa_waktu = $day.'&nbsp;hari&nbsp;lagi';
		                }
		                
		            }
		        }
		    }

		    if($value->end_date==null){
		    	$sisa_waktu = '∞';
		    }
		    if($hasil->invert==true){
		    	$sisa_waktu = '<span style="color:#ff6b24;font-style:italic;">sudah&nbsp;berakhir</span>';
		    }


			$total_donasi = $wpdb->get_results("SELECT SUM(nominal) as total, COUNT(id) as jumlah FROM $table_name2 where campaign_id='$value->campaign_id' and status='1' ")[0];

			if($value->target==0){
				// $persen = 100;
				$persen_width = 100;
			}else{
				// $persen = ($total_donasi->total/$row->target)*100;
				$persen_width = ($total_donasi->total/$value->target)*100;
				if($persen_width>100){
					$persen_width = 100;
				}
			}

			$data_donasinya = '';
            if($total_donasi==null){
                $total_terkumpul = 0;
                $jumlah_donasi = 0;
                $data_donasi = 0;
            }else{
                $total_terkumpul = $total_donasi->total;
                $jumlah_donasi = $total_donasi->jumlah;

                $data_donasi = $wpdb->get_results("SELECT user_id, name FROM $table_name2 where campaign_id='$value->campaign_id' and status='1' ORDER BY id ASC LIMIT 0,3 ");

                // GET INISAL DONATUR / PP URL
                foreach ($data_donasi as $data) {
                	if($data->user_id==null || $data->user_id==0){
                		$first_char = strtoupper(mb_substr($data->name, 0, 1));
                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
                	}else{
                		$first_char = strtoupper(mb_substr($data->name, 0, 1));
                		$user_profile = $wpdb->get_results('SELECT user_pp_img as photo from '.$table_name3.' where user_id="'.$data->user_id.'"');
						if(isset($user_profile[0])){
							if($user_profile==null){
								$first_char = strtoupper(mb_substr($data->name, 0, 1));
		                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
							}else{
								$url_photo = $user_profile[0]->photo;
								if($url_photo==''){
									$first_char = strtoupper(mb_substr($data->name, 0, 1));
			                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
								}else{
									$data_donasinya .= '<img src="'.$url_photo.'" alt="User Image" class="u_image">';
								}
							}
						}else{
							$first_char = strtoupper(mb_substr($data->name, 0, 1));
	                		$data_donasinya .= '<span class="u_image u_inisial" style="background:'.$theme_color.'"> '.$first_char.' </span>';
						}
                	}
                }
            }

			if($value->image_url==null){
                $image_url = plugin_dir_url( __FILE__ ).'assets/images/cover_donasiaja.jpg';
            }else{
                $image_url = $value->image_url;
                // $image_url = str_replace('localhost', '192.168.0.102', $image_url);
            }

            if($jumlah_donasi==0){
            	$icon_donasi = '
            	<div class="u_campaign u_icon">
				  <div class="campaign_days no_donation" style="padding-top:5px;">'.$sisa_waktu.'</div>
				</div>
				';
            }else{
            	$donasi_plusmore = '';
            	if($jumlah_donasi>=4){
	            	
            		$total_min_three = $jumlah_donasi-3;
            		$donasi_totalnya = shortDisplayNumber($total_min_three).'+';

	            	if(strlen($donasi_totalnya)>=4){
	            		$donasi_totalnya = '<span style="font-size:7px;">'.$donasi_totalnya.'</span>';
	            	}elseif(strlen($donasi_totalnya)==3){
	            		$donasi_totalnya = '<span style="font-size:8px;">'.$donasi_totalnya.'</span>';
	            	}else{
	            		$donasi_totalnya = $donasi_totalnya;
	            	}

	            	// >= 4 char = 7px
	            	// 3 char = 8px
	            	// 2 char = 9px

	            	$donasi_plusmore = '<span class="u_image u_inisial" style="background:'.$theme_color.'">'.$donasi_totalnya.'</span>';
            	}


				$icon_donasi = '
            	<div class="u_campaign u_donasi">
				  <div class="u_photo">
				  	'.$data_donasinya.'
				  	'.$donasi_plusmore.'
				  </div>
				  <div class="campaign_days" style="margin-top:5px;font-size:11px;">'.$sisa_waktu.'</div>
				</div>
				';
            }

            if($value->publish_status=='1'){
                $campaign_url = get_site_url().'/campaign/'.$value->slug;
            }else{
                $campaign_url = get_site_url().'/preview/'.$value->slug;
            }


            // GET PROFILE PICTURE CAMPAIGNER
			$profile = $wpdb->get_results('SELECT user_pp_img as photo, user_verification from '.$table_name3.' where user_id="'.$value->user_id.'"');
			if(isset($profile[0])){
				if($profile==null){
					$profile_photo = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
				}else{
					$profile_photo = $profile[0]->photo;
				}
			}else{
				$profile_photo = plugin_dir_url( __FILE__ ) . "assets/images/pp.jpg";
			}

			// GET USER NAME
			$args2 = array( 'blog_id' => 0, 'search' => $value->user_id, 'search_columns' => array( 'ID' ) );
            $get_name = get_users( $args2 );

            if($get_name==null){
                $campaigner_name = '-';
            }else{
                $nama_user = str_replace("'", "&#39;", $get_name[0]->user_firstname.' '.$get_name[0]->user_lastname);
                $campaigner_name = str_replace('\\', '', $nama_user); // nama asli
            }
            // user_firstname

            if($profile[0]->user_verification=='1'){
            	$verified_user = '<div class="verified_checklist"><img alt="Image" src="'.plugin_dir_url( __FILE__ ).'assets/images/check.png"></div>';
            }else{
            	$verified_user = '';
            }

            $button_donasi = '';
            if($button_on=='1'){

            	$text_button = 'Donate Now';
            	if($button_text!=''){
            		$text_button = $button_text;
            	}

            	if($style=='list'){
            		$button_donasi = '
            		<div class="btn_donasi_box">
			        	<div class="btn_donasi">
				       	<button style="background-color:'.$button_color2.';">'.$text_button.'</button>
				       	</div>
				    </div>
				    ';
            	}
            	if($style=='slider'){
            		$button_donasi = '
            		<div class="btn_donasi_box btn_slider">
			        	<div class="btn_donasi">
				       	<button style="background-color:'.$button_color2.';">'.$text_button.'</button>
				       	</div>
				    </div>
				    ';
            	}

            	if($style=='grid'){
            		$button_donasi = '
            		<div class="btn_donasi_box btn_grid">
			        	<div class="btn_donasi">
				       	<button style="background-color:'.$button_color2.';">'.$text_button.'</button>
				       	</div>
				    </div>
				    ';
            	}

            }

            if($style=='list'){
	            $hasil_list .= '
	            <li class="cards__item">
				  <a href="'.$campaign_url.'">
			      <div class="card__">
			        <div class="card__image"><img src="'.$image_url.'"></div>
			        <div class="card__content content_1">
			          <div class="card__title">'.$value->title.'</div>
			        </div>
			        <div class="card__content content_2">
			          <div class="card__text campaigner_name">'.$campaigner_name.$verified_user.'</div>
			          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
			          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
			          '.$icon_donasi.'
			        </div>
			        '.$button_donasi.'
			      </div>
			      </a>
			    </li>
			    ';
			}

			if($style=='slider'){
			    $hasil_slider .= '
				<div class="cards__item">
				  <a href="'.$campaign_url.'">
			      <div class="card__">
			        <div class="card__image"><img src="'.$image_url.'"></div>
			        <div class="card__content content_1">
			          <div class="card__title">'.$value->title.'</div>
			        </div>
			        <div class="card__content content_2">
			          <div class="card__text campaigner_name">'.$campaigner_name.$verified_user.'</div>
			          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
			          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
			          '.$icon_donasi.'
			        </div>
			        '.$button_donasi.'
			      </div>
			      </a>
			    </div>
				';
			}

			if($style=='grid'){
				$hasil_grid .= '
				<li class="cards__item">
				  <a href="'.$campaign_url.'">
			      <div class="card__">
			        <div class="card__image"><img src="'.$image_url.'"></div>
			        <div class="card__content content_1">
			          <div class="card__title">'.$value->title.'</div>
			        </div>
			        <div class="card__content content_2">
			          <div class="card__text campaigner_name">'.$campaigner_name.$verified_user.'</div>
			          <div class="card__text donation_collected" style="color:'.$theme_color.'">Rp '.number_format($total_terkumpul,0,",",".").'<span class="donation_collected_text">terkumpul</span></div>
			          <div style="height:4px; width:100%;background:#eaeaea;border-radius:4px;"><div style="height:4px; width:'.$persen_width.'%;background:'.$progressbar_color.';border-radius:4px;" title="'.$persen_width.'%"></div></div>
			          '.$icon_donasi.'
			        </div>
			        '.$button_donasi.'
			      </div>
			      </a>
			    </li>
				';
			}

		}

	}

	if($style=='list'){
		echo $hasil_list;
	}
	if($style=='slider'){
		echo $hasil_slider;
	}
	if($style=='grid'){
		echo $hasil_grid;
	}


    wp_die();

} 
add_action( 'wp_ajax_donasiaja_load_campaign', 'donasiaja_load_campaign' );
add_action( 'wp_ajax_nopriv_donasiaja_load_campaign', 'donasiaja_load_campaign' );




function donasiaja_load_campaign_search() {
	
    global $wpdb;
	$table_name = $wpdb->prefix . "dja_campaign";
	$table_name2 = $wpdb->prefix . "dja_donate";
	$table_name3 = $wpdb->prefix . "dja_users";
	$table_name4 = $wpdb->prefix . "dja_shortcode";
	$table_name5 = $wpdb->prefix . "dja_settings";
    
    $s = $_POST['datanya'][0];
    $load_count = $_POST['datanya'][1];

    $show  = 5;
    $start = ($load_count*$show)-$show;
    $limit = 5;
    $campaign = $wpdb->get_results("SELECT * FROM $table_name where title like '%$s%' or information like '%$s%' ORDER BY id ASC LIMIT $start,$limit ");

	// Settings
 //    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="theme_color" ORDER BY id ASC');
 //    $general_theme_color    = json_decode($query_settings[0]->data, true);
 //    $theme_color 			= $general_theme_color['color'][0];
	// $progressbar_color  	= $general_theme_color['color'][1];
	// $button_color 			= $general_theme_color['color'][2];


	$hasil_list = '';
	foreach ($campaign as $value) {

            if($value->publish_status=='1'){
                $campaign_url = get_site_url().'/campaign/'.$value->slug;
            }else{
                $campaign_url = get_site_url().'/preview/'.$value->slug;
            }

            if($value->image_url==null){
                $image_url = plugin_dir_url( __FILE__ ).'assets/images/cover_donasiaja.jpg';
            }else{
                $image_url = $value->image_url;
            }

            // GET PROFILE PICTURE CAMPAIGNER
			$profile = $wpdb->get_results('SELECT user_pp_img as photo, user_verification from '.$table_name3.' where user_id="'.$value->user_id.'"');
            if($profile[0]->user_verification=='1'){
            	$verified_user = '<span class="verified_checklist"><img alt="Image" src="'.plugin_dir_url( __FILE__ ).'assets/images/check.png" style="height: 10px;margin-left: 5px;"></span>';
            }else{
            	$verified_user = '';
            }

            // GET USER NAME
			$args2 = array( 'blog_id' => 0, 'search' => $value->user_id, 'search_columns' => array( 'ID' ) );
            $get_name = get_users( $args2 );

            if($get_name==null){
                $campaigner_name = '-';
            }else{
                $nama_user = str_replace("'", "&#39;", $get_name[0]->user_firstname.' '.$get_name[0]->user_lastname);
                $campaigner_name = str_replace('\\', '', $nama_user); // nama asli
            }

            $hasil_list .= '
            <li class="cards__item">
			  <a href="'.$campaign_url.'">
		      <div class="card__">
		        <div class="card__image"><img src="'.$image_url.'"></div>
		        <div class="card__content content_1">
		          <div class="card__title"><span style="font-size:13px;">'.$value->title.'<br><span style="font-size: 12px;font-weight: normal;">'.$campaigner_name.$verified_user.'</span></span></div>
		          <br>
		        </div>
		      </div>
		      </a>
		    </li>
		    ';
			
		}

	echo $hasil_list;


    wp_die();

} 
add_action( 'wp_ajax_donasiaja_load_campaign_search', 'donasiaja_load_campaign_search' );
add_action( 'wp_ajax_nopriv_donasiaja_load_campaign_search', 'donasiaja_load_campaign_search' );





function action_get_the_user_attachments( $query ) {

    // If we are not seeing the backend we quit.
    if ( !is_admin() ) {
        return;
    }

    /**
     * If it's not a main query type we quit.
     *
     * @link    https://codex.wordpress.org/Function_Reference/is_main_query
     */
    if ( !$query->is_main_query() ) {
        return;
    }

    $current_screen = get_current_screen();

    $current_screen_id = $current_screen->id;

    // If it's not the upload page we quit.
    if ( $current_screen_id != 'upload' ) {
        return;
    }

    $current_user = wp_get_current_user();

    $current_user_id = $current_user->ID;

    $author__in = array(
        $current_user_id
    );

    $query->set( 'author__in', $author__in );

}

add_action( 'pre_get_posts', 'action_get_the_user_attachments', 10 );



// ajax media file
function filter_get_the_user_attachments( $query ) {

    $current_user = wp_get_current_user();

    if ( !$current_user ) {
        return;
    }

    $current_user_id = $current_user->ID;

    $query['author__in'] = array(
        $current_user_id
    );

    return $query;

};

add_filter( 'ajax_query_attachments_args', 'filter_get_the_user_attachments', 10 );



function djafunction_publish_campaign() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";

    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];
    
    // FROM INPUT
    $title 			= $_POST['datanya'][0];
    $image_url 		= $_POST['datanya'][1];
    $information 	= $_POST['datanya'][2];
    $target 		= $_POST['datanya'][3];
    $end_date 		= $_POST['datanya'][4];
    $location_name 	= $_POST['datanya'][5];
    $location_gmaps = $_POST['datanya'][6];
    $category_id	= $_POST['datanya'][7];
    $form_base		= $_POST['datanya'][8];
    $form_type		= $_POST['datanya'][9];
    $packaged		= $_POST['datanya'][10];
    $packaged_title	= $_POST['datanya'][11];
    $act			= $_POST['datanya'][12];
    $pengeluaran_setting = $_POST['datanya'][13];
    $pengeluaran_title	 = $_POST['datanya'][14];
    $zakat_setting	 = $_POST['datanya'][15];
    $zakat_percent	 = $_POST['datanya'][16];

    $title = str_replace("'", "&#39;", $title); // petik 1
    $title = str_replace('"', "&#34;", $title); // petik 2
    $title = str_replace('\\', '', $title); // backslash

    // $information = str_replace("'", "&#39;", $information); // petik 1
    // $information = str_replace('"', "&#34;", $information); // petik 2
    $information = str_replace('\\', '', $information); // backslash

    // DEFAULT
    $campaign_id = 'dja'.d_randomString(8);
    $slug = d_formatUri($title);
    $publish_status = 1;
    $reached_status = 0;
    $currency = 'IDR';
    $user_id = wp_get_current_user()->ID;
    $fundraiser_id = null;
    $method_status = '{"instant":"0","va":"0","transfer":"0"}';


    if($end_date==''){
    	$end_date = null;
    }else{
    	$end_date = date($_POST['datanya'][4].' 23:59:00');
    }

    // cek slug
    $slug = str_replace('?', '', $slug); // delete ? on slug
    $jumlah_slug = count($wpdb->get_results('SELECT id from '.$table_name.' where slug="'.$slug.'"'));
    if($jumlah_slug>1){
    	$count = $jumlah_slug+1;
    	$slug = $slug.'-'.d_randomString(3);
    }

    // publish status
    if($role=='donatur'){
    	$publish_status = 2; // pending review
    	$form_type = 1; // form type : card
    	$form_base = 0;
    	$pengeluaran_setting = 0;
    	$pengeluaran_title = null;
    }

    if($act=='draft'){
    	$publish_status = 0;
    }

    if(strpos($image_url, 'donasiaja-cover.jpg') !== false) {
	    $image_url = null;
	}

	if($zakat_setting=='0'){
		$zakat_percent = null;
	}

    // ACTION INSERT TO DB
    $wpdb->insert(
            $table_name, //table
            array(
	            'campaign_id' 	=> $campaign_id,
	            'title' 		=> $title,
	            'slug' 			=> $slug,
	            'target' 		=> $target,
	            'image_url' 	=> $image_url,
	            'information' 	=> $information,
	            'location_name' => $location_name,
	            'location_gmaps'=> $location_gmaps,
	            'publish_status'=> $publish_status,
	            'reached_status'=> $reached_status,
	            'end_date' 		=> $end_date,
	            'form_base'		=> $form_base,
	            'form_type'		=> $form_type,
	            'packaged'		=> $packaged,
	            'packaged_title'=> $packaged_title,
	            'currency' 		=> $currency,
	            'category_id'	=> $category_id,
	            'user_id' 		=> $user_id,
	            'fundraiser_id' => $fundraiser_id,
	            'payment_status'=> 0,
	            'method_status' => $method_status,
	            'bank_account'  => null,
	            'form_status'	=> 0,
	            'form_text'  	=> null,
	            'pengeluaran_setting' => $pengeluaran_setting,
	            'pengeluaran_title'   => $pengeluaran_title,
	            'zakat_setting'   => $zakat_setting,
	            'zakat_percent'   => $zakat_percent,
	            'created_at' 	=> date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );
	
	echo $campaign_id;

    wp_die();

} 
add_action( 'wp_ajax_djafunction_publish_campaign', 'djafunction_publish_campaign' );
add_action( 'wp_ajax_nopriv_djafunction_publish_campaign', 'djafunction_publish_campaign' );


function donasiaja_getIP(){
	if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
		//check ip from share internet
		$ip = $_SERVER['HTTP_CLIENT_IP'];

	} elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
		//to check ip is pass from proxy
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}

	return $ip;
}


function donasiaja_getOS() { 

    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $os_platform  = "Unknown OS Platform";
    $os_array     = array(
                          '/windows nt 10/i'      =>  'Windows 10',
                          '/windows nt 6.3/i'     =>  'Windows 8.1',
                          '/windows nt 6.2/i'     =>  'Windows 8',
                          '/windows nt 6.1/i'     =>  'Windows 7',
                          '/windows nt 6.0/i'     =>  'Windows Vista',
                          '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
                          '/windows nt 5.1/i'     =>  'Windows XP',
                          '/windows xp/i'         =>  'Windows XP',
                          '/windows nt 5.0/i'     =>  'Windows 2000',
                          '/windows me/i'         =>  'Windows ME',
                          '/win98/i'              =>  'Windows 98',
                          '/win95/i'              =>  'Windows 95',
                          '/win16/i'              =>  'Windows 3.11',
                          '/macintosh|mac os x/i' =>  'Mac OS X',
                          '/mac_powerpc/i'        =>  'Mac OS 9',
                          '/linux/i'              =>  'Linux',
                          '/ubuntu/i'             =>  'Ubuntu',
                          '/iphone/i'             =>  'iPhone',
                          '/ipod/i'               =>  'iPod',
                          '/ipad/i'               =>  'iPad',
                          '/android/i'            =>  'Android',
                          '/blackberry/i'         =>  'BlackBerry',
                          '/webos/i'              =>  'Mobile'
                    );

    foreach ($os_array as $regex => $value)
        if (preg_match($regex, $user_agent))
            $os_platform = $value;

    return $os_platform;
}

function donasiaja_getBrowser() {

    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $browser        = "Unknown Browser";
    $browser_array = array(
                            '/msie/i'      => 'Internet Explorer',
                            '/firefox/i'   => 'Firefox',
                            '/safari/i'    => 'Safari',
                            '/chrome/i'    => 'Chrome',
                            '/edge/i'      => 'Edge',
                            '/opera/i'     => 'Opera',
                            '/netscape/i'  => 'Netscape',
                            '/maxthon/i'   => 'Maxthon',
                            '/konqueror/i' => 'Konqueror',
                            '/mobile/i'    => 'Handheld Browser'
                     );

    foreach ($browser_array as $regex => $value)
        if (preg_match($regex, $user_agent))
            $browser = $value;

    return $browser;
}



function donasiaja_getMobDesktop() {

	$useragent = $_SERVER['HTTP_USER_AGENT'];

    if(preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4))){ 
        return "mobile";
    }else{
        return "desktop";
    }
}

function shortDisplayNumber($num) 
{
    $units = ['', 'K', 'M', 'B', 'T'];
    for ($i = 0; $num >= 1000; $i++) {
        $num /= 1000;
    }
    return round($num, 1) . $units[$i];
}



function djafunction_set_love(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_love";
    $table_name2 = $wpdb->prefix . "dja_settings";

    // FROM INPUT
    $campaign_id 	= $_POST['datanya'][0];
    $donate_id 		= $_POST['datanya'][1];

    $a = donasiaja_getIP();
    $b = donasiaja_getOS();
    $c = donasiaja_getBrowser();
    $d = donasiaja_getMobDesktop();

    $id_login = wp_get_current_user()->ID;

    // Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="max_love" ORDER BY id ASC');
    $max_love = $query_settings[0]->data;

    $row = $wpdb->get_results('SELECT * from '.$table_name.' where ip="'.$a.'" and os="'.$b.'" and browser="'.$c.'" and mobdesktop="'.$d.'" and donate_id="'.$donate_id.'"');
    if($row==null){
    	// create
    	$wpdb->insert(
            $table_name, //table
            array(
	            'campaign_id' 	=> $campaign_id,
	            'donate_id' 	=> $donate_id,
	            'user_id' 		=> $id_login,
	            'love' 			=> 1,
	            'ip' 			=> $a,
	            'os' 			=> $b,
	            'browser' 		=> $c,
	            'mobdesktop' 	=> $d,
	            'created_at' 	=> date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

    	echo '+1';

    }else{

    	$total_love = $wpdb->get_results('SELECT love from '.$table_name.' where ip="'.$a.'" and os="'.$b.'" and browser="'.$c.'" and mobdesktop="'.$d.'" and donate_id="'.$donate_id.'"')[0];
		$love = $total_love->love;

		if($max_love=='0'){
			// update
			$love = $love+1;
	    	$wpdb->update(
		            $table_name, //table
		            array(
			            'love' 	=> $love
			        ),
		            array('campaign_id' => $campaign_id, 'donate_id' => $donate_id, 'ip' => $a, 'os' => $b, 'browser' => $c, 'mobdesktop' => $d), //where
		            array('%s'), //data format
		            array('%s') //where format    
		        );

	    	echo "+$love";

		}else{
			if($love<=$max_love){

				$love = $love+1;
		    	$wpdb->update(
			            $table_name, //table
			            array(
				            'love' 	=> $love
				        ),
			            array('campaign_id' => $campaign_id, 'donate_id' => $donate_id, 'ip' => $a, 'os' => $b, 'browser' => $c, 'mobdesktop' => $d), //where
			            array('%s'), //data format
			            array('%s') //where format    
			        );

		    	echo "+$love";

			}else{
				echo "cukup";
			}
		}
    	

    }

    wp_die();
}
add_action( 'wp_ajax_djafunction_set_love', 'djafunction_set_love' );
add_action( 'wp_ajax_nopriv_djafunction_set_love', 'djafunction_set_love' );


function getBaseUrl() 
{
    // output: /myproject/index.php
    $currentPath = $_SERVER['PHP_SELF']; 

    // output: Array ( [dirname] => /myproject [basename] => index.php [extension] => php [filename] => index ) 
    $pathInfo = pathinfo($currentPath); 

    // output: localhost
    $hostName = $_SERVER['HTTP_HOST']; 

    // output: http://
    $protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,5))=='https'?'https':'http';

    // return: http://localhost/myproject/
    return $protocol.'://'.$hostName.$pathInfo['dirname']."/";
}


function paymentCode($code) 
{
    global $wpdb;
    $table_name 	= $wpdb->prefix . "dja_payment_list";

    $get_payment_name = $wpdb->get_results('SELECT name from '.$table_name.' where code="'.$code.'" ');
    if($get_payment_name!=null){
    	return $get_payment_name[0]->name;
    }
}


function djafunction_submit_donasi(){
	global $wpdb;
    $table_name 	= $wpdb->prefix . "dja_donate";
    $table_name2 	= $wpdb->prefix . "dja_settings";
    $table_name3 	= $wpdb->prefix . "dja_campaign";
    $table_name4 	= $wpdb->prefix . "dja_payment_log";
    $table_name5 	= $wpdb->prefix . "dja_aff_submit";
    $table_name6 	= $wpdb->prefix . "dja_aff_code";

    // FROM INPUT
    $campaign_id 	= $_POST['datanya'][0];
    $name 			= $_POST['datanya'][1];
    $whatsapp 		= $_POST['datanya'][2];
    $email 			= $_POST['datanya'][3];
    $anonim 		= $_POST['datanya'][4];
    $comment 		= str_replace('\\', '', $_POST['datanya'][5]);
    $nominal 		= $_POST['datanya'][6];
    $payment_method = $_POST['datanya'][7];
    $payment_code 	= $_POST['datanya'][8];
    $payment_number = $_POST['datanya'][9];
    $payment_account = $_POST['datanya'][10];
    $unique_number   = $_POST['datanya'][11];
    $title_campaign  = $_POST['datanya'][12];
    $affcode_id 	 = $_POST['datanya'][13];
    $main_donate 	 = $_POST['datanya'][14];
    $info_donate 	 = str_replace('\\', '', $_POST['datanya'][15]);
    $cs_id 	 		 = $_POST['datanya'][16];
    $info_qurban 	 = str_replace('\\', '', $_POST['datanya'][17]);
    $info_package2 	 = str_replace('\\', '', $_POST['datanya'][18]);
    $info_zfitrah 	 = str_replace('\\', '', $_POST['datanya'][19]);
    $info_addformula = str_replace('\\', '', $_POST['datanya'][20]);

    // handling char
    $name = substr($name, 0, 120);
    $whatsapp = substr($whatsapp, 0, 15);
    $email = substr($email, 0, 60);

    // General Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="text_f1" or type="app_name" or type="currency" or type="ipaymu_mode" or type="ipaymu_va" or type="ipaymu_apikey" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message" or type="telegram_bot_token" or type="telegram_send_to" or type="telegram_on" or type="wanotif_on" or type="wanotif_followup1_on" or type="tripay_mode" or type="tripay_apikey" or type="tripay_privatekey" or type="tripay_merchant" or type="tripay_apikey_sandbox" or type="tripay_privatekey_sandbox" or type="tripay_merchant_sandbox" or type="midtrans_mode" or type="midtrans_serverkey" or type="midtrans_clientkey" or type="midtrans_merchant" or type="midtrans_serverkey_sandbox" or type="midtrans_clientkey_sandbox" or type="midtrans_merchant_sandbox" or type="email_send_to" or type="email_on" or type="fundraiser_on" or type="fundraiser_commission_on" or type="fundraiser_commission_type" or type="fundraiser_commission_percent" or type="fundraiser_commission_fixed" or type="tripay_qris" or type="wanotif_apikey_cs" or type="flip_mode" or type="flip_apikey" or type="flip_validation_token" or type="flip_apikey_sandbox" or type="flip_validation_token_sandbox" ORDER BY id ASC');
    $text_f1 			= $query_settings[0]->data;
    $app_name 			= $query_settings[1]->data;

    $currency 			= $query_settings[2]->data;
    $ipaymu_mode 		= $query_settings[3]->data;
    $ipaymu_va 			= $query_settings[4]->data;
    $ipaymu_apikey 		= $query_settings[5]->data;
    
    $wanotif_url 		= $query_settings[6]->data;
    $wanotif_apikey 	= $query_settings[7]->data;
    $wanotif_message 	= $query_settings[8]->data;
    $telegram_bot_token	= $query_settings[9]->data;
    $telegram_send_to	= $query_settings[10]->data;
    $telegram_on 		= $query_settings[11]->data;
    $wanotif_on			= $query_settings[12]->data;
    $wanotif_followup1_on	= $query_settings[13]->data;

    $tripay_mode 		= $query_settings[14]->data;
    $tripay_apikey 		= $query_settings[15]->data;
    $tripay_privatekey 	= $query_settings[16]->data;
    $tripay_merchant 	= $query_settings[17]->data;
    $tripay_apikey_sandbox 		= $query_settings[18]->data;
    $tripay_privatekey_sandbox 	= $query_settings[19]->data;
    $tripay_merchant_sandbox 	= $query_settings[20]->data;

    $midtrans_mode 		= $query_settings[21]->data;
    $midtrans_serverkey = $query_settings[22]->data;
    $midtrans_clientkey = $query_settings[23]->data;
    $midtrans_merchant 	= $query_settings[24]->data;
    $midtrans_serverkey_sandbox = $query_settings[25]->data;
    $midtrans_clientkey_sandbox = $query_settings[26]->data;
    $midtrans_merchant_sandbox 	= $query_settings[27]->data;

    $email_send_to	= $query_settings[28]->data;
    $email_on 		= $query_settings[29]->data;

    $fundraiser_on 	= $query_settings[30]->data;
    $fundraiser_commission_on 	= $query_settings[31]->data;
    $fundraiser_commission_type = $query_settings[32]->data;
    $fundraiser_commission_percent = $query_settings[33]->data;
    $fundraiser_commission_fixed = $query_settings[34]->data;

    $tripay_qris = $query_settings[35]->data;
    $wanotif_apikey_cs = $query_settings[36]->data;

    $flip_mode 		= $query_settings[37]->data;
    $flip_apikey 	= $query_settings[38]->data;
    $flip_validation_token = $query_settings[39]->data;
    $flip_apikey_sandbox 	= $query_settings[40]->data;
    $flip_validation_token_sandbox = $query_settings[41]->data;

    // Campaign Settings
    $campaign_setting = $wpdb->get_results('SELECT notification_status, wanotif_message, fundraiser_setting, fundraiser_on,  fundraiser_commission_on, fundraiser_commission_type, fundraiser_commission_percent, fundraiser_commission_fixed, general_status, allocation_title, allocation_others_title, cs_rotator, wanotif_device from '.$table_name3.' where campaign_id="'.$campaign_id.'" ')[0];
    $notification_status 		= $campaign_setting->notification_status;
    $wanotif_message_on_form 	= $campaign_setting->wanotif_message;
    $c_fundraiser_setting 		= $campaign_setting->fundraiser_setting;
    $c_fundraiser_on 				 = $campaign_setting->fundraiser_on;
    $c_fundraiser_commission_on 	 = $campaign_setting->fundraiser_commission_on;
    $c_fundraiser_commission_type    = $campaign_setting->fundraiser_commission_type;
    $c_fundraiser_commission_percent = $campaign_setting->fundraiser_commission_percent;
    $c_fundraiser_commission_fixed   = $campaign_setting->fundraiser_commission_fixed;
    $c_general_status 				 = $campaign_setting->general_status;
    $allocation_title 				 = $campaign_setting->allocation_title;
    $allocation_others_title 		 = $campaign_setting->allocation_others_title;
    $cs_rotator   					 = $campaign_setting->cs_rotator;
    $wanotif_device   				 = $campaign_setting->wanotif_device;
    
    if($c_general_status=='1'){
        if($allocation_title=='1' || $allocation_title=='0'){
            $allocation_title = 'Donasi';
        }elseif($allocation_title=='2'){
            $allocation_title = 'Zakat';
        }elseif($allocation_title=='3'){
            $allocation_title = 'Qurban';
        }else{
            $allocation_title = $allocation_others_title;
        }
    }else{
        $allocation_title = 'Donasi';
    }


    // Normalize cs rotator di campaign
    $today_cs = date('Y-m-d');
    $filternya_cs = "and a.created_at BETWEEN '$today_cs 00:00' AND '$today_cs 23:59'";
    $donasi_normalize = $wpdb->get_results("SELECT a.cs_id FROM $table_name a
    WHERE a.campaign_id='$campaign_id' and a.whatsapp='$whatsapp' and a.cs_id != '' $filternya_cs ");
    if($donasi_normalize!=null){
    	
    	$cs_id_normalize = $donasi_normalize[0]->cs_id;
    	if($cs_rotator!=''){
            $data_cs = json_decode($cs_rotator, true);
            $jumlah_cs = $data_cs['jumlah'];
        }else{
            $jumlah_cs = 0;
        }
        if($jumlah_cs>=1){
        	foreach ($data_cs['data'] as $key => $value) {
            	if($cs_id_normalize==$value[0]){
            		$cs_id = $value[0];
            		break;
            	}
            }
        }
    }

    // set cs_name
    $cs_name = '';
    if($cs_id>=1){
    	$user_info_cs = get_userdata($cs_id);
	    if($user_info_cs!=null){
	    	if($user_info_cs->last_name==''){
		    	$cs_name = $user_info_cs->first_name;
		    }else{
		    	$cs_name = $user_info_cs->first_name.' '.$user_info_cs->last_name;
		    }
	    }
    }


    $ddate = date('y').date('m').date('d');
    $rand_char = $ddate.d_randomBigString(5);
    $invoice_id = 'INV-'.$rand_char;
    $url_wp = home_url($wp->request);
    $link_notify = $url_wp.'/notify-ipaymu';
    
    $TransactionId = null;
    $payment_qrcode = null;

    $protocols = array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
	$base_url = str_replace($protocols, '', $url_wp);
	// if($email==''){
	// 	$email = 'nomail_'.$rand_char.'@'.$base_url;
	// }

    $HasQRLink = strpos($payment_number, 'http') !== false || strpos($payment_number, 'www.') !== false;
	if($HasQRLink){
		$payment_qrcode = $payment_number;
	}

	// Set PG
	$pg_code = $payment_account;
	// ipaymu
    if($pg_code=='ipaymu'){
    	
    	// langsung eksekusi pakai ipaymu payment gateway
    	// CHECK METHOD AND CHANNEL

    	// ****************************
		// Payment channel of the payment method
		// ****************************

		// Virtual Account (va) : method
		// -------------------
		// BAG => 'bag'
		// BNI => 'bni'
		// Cimb Niaga => 'cimb'
		// Mandiri => 'mandiri'
		// Muamalat => 'bmi'
		// BRI => 'bri'

		// Bank Transfer (banktransfer) : method
		// -------------------
		// BCA => 'bca'

		// QRIS (qris) : method
		// -------------------
		// linkaja => 'linkaja' : channel

    	$payment_gateway = false;
    	$payment_number = strtolower($payment_number);

    	if($payment_method=='instant'){
    		if($payment_number=='qris' || $payment_number=='gopay' || $payment_number=='ovo' || $payment_number=='dana' || $payment_number=='linkaja' || $payment_number=='shopeepay'){
	    		$p_method = 'qris';
	    		$p_channel = 'linkaja';
	    		$payment_gateway = true;
	    	}
    	}

    	if($payment_method=='va'){
    		if($payment_number=='mandiri' || $payment_number=='bni' || $payment_number=='cimb' || $payment_number=='bag' || $payment_number=='bmi' || $payment_number=='bri' || $payment_number=='bsi' || $payment_number=='bca' || $payment_number=='permata'){
    			$p_method = 'va';
	    		if($payment_number=='mandiri'){ $p_channel = 'mandiri';$payment_gateway = true;}
	    		if($payment_number=='bni'){ $p_channel = 'bni';$payment_gateway = true;}
	    		if($payment_number=='cimb'){ $p_channel = 'cimb';$payment_gateway = true;}
	    		if($payment_number=='bag'){ $p_channel = 'bag';$payment_gateway = true;}
	    		if($payment_number=='bmi'){ $p_channel = 'bmi';$payment_gateway = true;}
	    		if($payment_number=='bri'){ $p_channel = 'bri';$payment_gateway = true;}
	    		if($payment_number=='bsi'){ $p_channel = 'bsi';$payment_gateway = true;}
	    		if($payment_number=='bca'){ $p_channel = 'bca';$payment_gateway = true;}
	    		if($payment_number=='permata'){ $p_channel = 'permata';$payment_gateway = true;}
	    	}
    	}

    	if($payment_method=='transfer'){
    		if($payment_number=='bca'){
	    		$p_method = 'banktransfer';
	    		$p_channel = 'bca';
	    		$payment_gateway = true;
	    	}
	    	if($payment_number=='alfamart' || $payment_number=='indomaret'){
	    		if($payment_number=='alfamart'){ $p_channel = 'alfamart';$payment_gateway = true;}
	    		if($payment_number=='indomaret'){ $p_channel = 'indomaret';$payment_gateway = true;}
	    		$p_method = 'cstore';
	    	}
    	}


    	// LAST VALIDATION
    	if($payment_gateway == true){
    		
    		$va      = $ipaymu_va;
		    $secret  = $ipaymu_apikey;

		    if($ipaymu_mode=='1'){
		    	$url = 'https://my.ipaymu.com/api/v2/payment/direct';
		    }else{
		    	$url = 'https://sandbox.ipaymu.com/api/v2/payment/direct';
		    }
		    
		    if($email==''){
				$emailnya = 'nomail_'.$ddate.date('His').'@gmail.com';
			}else{
				$emailnya = $email;
			}

			$check_title = substr("$title_campaign", -1);
			if($check_title==' '){
			    $title_campaign = $title_campaign.'.'; // add last char with .
			}

			$check_name = substr("$name", -1);
			if($check_name==' '){
			    $name = substr_replace($name ,"",-1); // remove last char
			}

			$method = 'POST'; //method

		    // Request Body
		    $body['name']   = $name;
		    $body['phone']  = $whatsapp;
		    $body['email']  = $emailnya;
		    $body['amount'] = $nominal;
		    $body['notifyUrl']  = $link_notify;
		    $body['expired']    = '24';
		    $body['expiredType']    = 'hours';
		    $body['referenceId']    = $invoice_id;
		    $body['paymentMethod']  = $p_method;
		    $body['paymentChannel'] = $p_channel;
		    $body['comments']    	= $title_campaign;
		    // End Request Body

		    // Generate Signature
		    // Don't change this
		    $jsonBody     = json_encode($body, JSON_UNESCAPED_SLASHES);
		    $requestBody  = strtolower(hash('sha256', $jsonBody));
		    $stringToSign = strtoupper($method) . ':' . $va . ':' . $requestBody . ':' . $secret;
		    $signature    = hash_hmac('sha256', $stringToSign, $secret);
		    $timestamp    = Date('YmdHis');
		    // End Generate Signature

		    $ch = curl_init($url);
		    $headers = array(
		        'Accept: application/json',
		        'Content-Type: application/json',
		        'va: ' . $va,
		        'signature: ' . $signature,
		        'timestamp: ' . $timestamp
		    );

		    curl_setopt($ch, CURLOPT_HEADER, false);
		    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		    curl_setopt($ch, CURLOPT_POST, count($body));
		    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonBody);
		    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		    $err = curl_error($ch);
		    $response = curl_exec($ch);
		    curl_close($ch);
		    if($err) {
		        // print_r($err);
		        $response = json_decode( $err, true );
		        $response_payment = $response;

		    } else {
		    	// print_r($response);
		    	$response = json_decode( $response, true );
		    	$response_payment = $response;
		    }

			if(strtolower($response['Message'])=='success'){

				$TransactionId = $response['Data']['TransactionId'];
				$PaymentNo = $response['Data']['PaymentNo'];
				$PaymentName = $response['Data']['PaymentName'];
				$QrImage = $response['Data']['QrImage'];

				// QrValue
				// set payment_number and payment_account
				if(isset($response['Data']['QrImage'])){
					// INSTANT PAYMENT
					$payment_number = $QrImage;
					$payment_account = strtoupper($payment_code).' - '.$PaymentName;
				}else{
					$payment_number = $PaymentNo;
					$payment_account = $PaymentName;

					if($p_method=='va'){
						$payment_account = 'VA '.strtoupper($payment_code).' - '.$PaymentName;
					}
				}
			}
    	}

    	// Handling ipaymu have qrcode or not
	    $paymentHasLink = strpos($payment_number, 'http') !== false || strpos($payment_number, 'www.') !== false;
		if($paymentHasLink){
			$payment_qrcode = $payment_number;
			$payment_number = $payment_number;
		}

    }

   
	// TRIPAY
	$deeplink_urlnya = '';
	if($pg_code=='tripay'){

		$payment_number = strtolower($payment_number);

		if($payment_number=='mandiri' || $payment_number=='bni' || $payment_number=='bri' || $payment_number=='cimb' || $payment_number=='maybank' || $payment_number=='bmi' || $payment_number=='sampoerna' || $payment_number=='sinarmas' || $payment_number=='permata' || $payment_number=='bca' || $payment_number=='bsi' || $payment_number=='danamon'){
			
			if($payment_number=='bmi'){
				$payment_number = 'muamalat';
			}
			if($payment_number=='sinarmas'){
				$payment_number = 'sms';
			}
			if($payment_number=='maybank'){
				$payment_number = 'myb';
			}

			$tripay_method = strtoupper($payment_number).'VA'; // BCAVA, BNIVA, dll

		}

		if($payment_number=='alfamart' || $payment_number=='alfamidi' || $payment_number=='indomaret'){
			$tripay_method = strtoupper($payment_number); // ALFAMART, ALFAMIDI, INDOMARET
		}

		if($tripay_qris==''){$tripay_qris='QRISC';}

		if($payment_number=='qris' || $payment_number=='gopay' || $payment_number=='linkaja'){
    		$tripay_method = $tripay_qris; // QRISC - QRIS Customizable
    	}

		if($payment_number=='shopeepay'){
    		$tripay_method = 'SHOPEEPAY'; // QRIS Shopeepay - jump apps
    	}

		if($payment_number=='ovo'){
    		$tripay_method = 'OVO'; // OVO
    	}

		if($payment_number=='dana'){
    		$tripay_method = 'QRIS2'; //  QRIS2 - QRIS Dana
    	}

    	if($payment_number=='cc'){
    		$tripay_method = strtoupper($payment_number); // CC
    	}

	    if($tripay_mode=='1'){
	    	$tripay_api_url = 'api';
	    	$apiKey = $tripay_apikey;
			$privateKey = $tripay_privatekey;
			$merchantCode = $tripay_merchant;
			$link_callback_tripay = $url_wp.'/callback_tripay';
	    }else{
	    	$tripay_api_url = 'api-sandbox';
	    	$apiKey = $tripay_apikey_sandbox;
			$privateKey = $tripay_privatekey_sandbox;
			$merchantCode = $tripay_merchant_sandbox;
			$link_callback_tripay = $url_wp.'/callback_tripay_sandbox';
	    }


		if($email==''){
			$emailnya = 'nomail_'.$ddate.date('His').'@gmail.com';
		}else{
			$emailnya = $email;
		}

		$merchantRef = $invoice_id;
		$amount = $nominal;
		$method = $tripay_method; //$payment_list['bcava']['code'];

		$dataPayment = [
		  'method'            => $method,
		  'merchant_ref'      => $merchantRef,
		  'amount'            => $amount,
		  'customer_name'     => $name,
		  'customer_email'    => $emailnya,
		  'customer_phone'    => $whatsapp,
		  'order_items'       => [
		    [
		      'sku'       => home_url(),
		      'name'      => $title_campaign,
		      'price'     => $amount,
		      'quantity'  => 1
		    ]
		  ],
		  'callback_url'      => $link_callback_tripay,
		  'return_url'        => null,
		  'expired_time'      => (time()+(24*60*60)), // 24 jam
		  'signature'         => hash_hmac('sha256', $merchantCode.$merchantRef.$amount, $privateKey)
		];

		$curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_FRESH_CONNECT     => true,
		  CURLOPT_URL               => "https://tripay.co.id/$tripay_api_url/transaction/create",
		  CURLOPT_RETURNTRANSFER    => true,
		  CURLOPT_HEADER            => false,
		  CURLOPT_HTTPHEADER        => array(
		    "Authorization: Bearer ".$apiKey
		  ),
		  CURLOPT_FAILONERROR       => false,
		  CURLOPT_POST              => true,
		  CURLOPT_POSTFIELDS        => http_build_query($dataPayment)
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		// print_r($response);
		// wp_die();

		$response = json_decode( $response, true );		

		if($response['success']==true){
			$TransactionId = $response['data']['reference'];
			$payment_number = $response['data']['pay_code'];
			$payment_account = $response['data']['payment_name'];

			$nominal = $response['data']['amount'];

			// Handling TRIPAY have qrcode or not
			if($response['data']['qr_url']!=null){
				$payment_qrcode = $response['data']['qr_url'];
				$payment_number = $response['data']['qr_url'];
			}

			// Handling OVO redirect URL
			if($response['data']['payment_method']=='OVO'){
				$deeplink_urlnya = $response['data']['checkout_url'];
			}

			// Handling SHOPEEPAY redirect URL
			if($response['data']['payment_method']=='SHOPEEPAY'){
				$deeplink_urlnya = $response['data']['checkout_url'];
			}
		}

	}

	$deeplink_url = '';
	if($deeplink_urlnya!=''){
		$deeplink_url = $deeplink_urlnya;
	}


	if($pg_code=='ipaymu' || $pg_code=='tripay' || $pg_code=='midtrans' || $pg_code=='xendit' || $pg_code=='flip'){
		// nothing
	}else{
		$pg_code = null;
	}

	// MIDTRANS
	if($pg_code=='midtrans'){

		// Configurations
		require_once dirname(__FILE__) . '/library/Midtrans/Config.php';

		// Midtrans API Resources
		require_once dirname(__FILE__) . '/library/Midtrans/Transaction.php';

		// Plumbing
		require_once dirname(__FILE__) . '/library/Midtrans/ApiRequestor.php';
		require_once dirname(__FILE__) . '/library/Midtrans/Notification.php';
		require_once dirname(__FILE__) . '/library/Midtrans/CoreApi.php';
		require_once dirname(__FILE__) . '/library/Midtrans/Snap.php';

		// Sanitization
		require_once dirname(__FILE__) . '/library/Midtrans/Sanitizer.php';

		if($midtrans_mode=='1'){
	    	Midtrans\Config::$isProduction = true;
	    	Midtrans\Config::$serverKey = $midtrans_serverkey;
	    	Midtrans\Config::$isSanitized = true;
	    }else{
	    	Midtrans\Config::$isProduction = false;
	    	Midtrans\Config::$serverKey = $midtrans_serverkey_sandbox;
	    	Midtrans\Config::$isSanitized = true;
	    }

	    // Midtrans\Config::$isSanitized = true;

		$amount = $nominal;
		$nominal_fix = $amount-$unique_number;
		    
		$transaction_details = array(
		    'order_id'    	=> $invoice_id,
		    'gross_amount'  => $amount
		);

		// Populate items
		$items = array(
		    array(
		        'id'       => 'item1',
		        'price'    => $nominal_fix,
		        'quantity' => 1,
		        'name'     => 'Jumlah '.$allocation_title.''
		    ),
		    array(
		        'id'       => 'item2',
		        'price'    => (int)$unique_number,
		        'quantity' => 1,
		        'name'     => 'Kode Unik'
		    ));


		// Populate customer's info
		$customer_details = array(
		    'first_name'       => $name,
		    'last_name'        => "",
		    'email'            => $emailnya,
		    'phone'            => $whatsapp
		);

		$any_error = false;
		$payment_number = strtolower($payment_number);

		if($payment_number=='bri'){

			$payment_account = strtoupper($payment_number). ' VA';
			$payment_type = 'bank_transfer';
			$payment_code = $payment_number;

			// Transaction data to be sent
			$transaction_data = array(
			    'payment_type' => $payment_type,
			    'transaction_details' => $transaction_details,
			    'item_details'        => $items,
			    'customer_details'    => $customer_details,
			    'bank_transfer' => array(
			         'bank' => $payment_code
			    )
			);

			try {
				$response = Midtrans\CoreApi::charge($transaction_data);
				
				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;

					$reponse_json = json_encode($response);
				    $reponse_array = json_decode($reponse_json, TRUE);
					$payment_number = $reponse_array['va_numbers'][0]['va_number'];

				}
			} catch (Exception $e) {
				// echo 'Caught exception: ',  $e->getMessage(), "\n";
				$any_error = true;
				$message_error = $e->getMessage();
			}

		}

		if($payment_number=='bca' || $payment_number=='bni'){

			$payment_account = strtoupper($payment_number). ' VA';
			$payment_type = 'bank_transfer';
			$payment_code = $payment_number;

			// Transaction data to be sent
			$transaction_data = array(
			    'payment_type' => $payment_type,
			    'transaction_details' => $transaction_details,
			    'item_details'        => $items,
			    'customer_details'    => $customer_details,
			    'bank_transfer' => array(
			         'bank' => $payment_code
			    )
			);

			try { 
				$response = Midtrans\CoreApi::charge($transaction_data);
				
				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;

					$reponse_json = json_encode($response);
				    $reponse_array = json_decode($reponse_json, TRUE);
					$payment_number = $reponse_array['va_numbers'][0]['va_number'];

				}
			} catch (Exception $e) {
				$any_error = true;
				$message_error = $e->getMessage();
			}

		}

		if($payment_number=='permata'){

			$payment_account = strtoupper($payment_number). ' VA';
			$payment_type = 'permata';
			
			// Transaction data to be sent
			$transaction_data = array(
			    'payment_type' => $payment_type,
			    'transaction_details' => $transaction_details,
			    'item_details'        => $items,
			    'customer_details'    => $customer_details
			);

			try {
				$response = Midtrans\CoreApi::charge($transaction_data);

				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;
					$payment_number = $response->permata_va_number;
				}

			} catch (Exception $e) {
				$any_error = true;
				$message_error = $e->getMessage();
			}


		}

		if($payment_number=='mandiri'){

			$payment_account = strtoupper($payment_number). ' VA';
			$payment_type = 'echannel';
			
			// Transaction data to be sent
			$transaction_data = array(
			    'payment_type' => $payment_type,
			    'transaction_details' => $transaction_details,
			    'item_details'        => $items,
			    'customer_details'    => $customer_details,
			    'echannel' => array(
			        'bill_info1' => 'Online payment',
				    'bill_info2' => $title_campaign,
			    )
			);

			try {
				$response = Midtrans\CoreApi::charge($transaction_data);

				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;
					$payment_number = $response->bill_key;
				}

			} catch (Exception $e) {
				$any_error = true;
				$message_error = $e->getMessage();
			}


		}

		if($payment_number=='gopay' || $payment_number=='qris' || $payment_number=='ovo' || $payment_number=='dana' || $payment_number=='linkaja' || $payment_number=='shopeepay'){

			$payment_account = strtoupper($payment_number);
			$payment_type = 'gopay';

			$transaction_data = array(
			    'payment_type' => $payment_type,
			    'transaction_details' => $transaction_details,
			    'item_details'        => $items,
			    'customer_details'    => $customer_details,
			    'gopay' => array(
			        'enable_callback' => true,
			        'callback_url' => 'someapps://callback'
			    )
			);

			try {
				$response = Midtrans\CoreApi::charge($transaction_data);

				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;

					$reponse_json = json_encode($response);
				    $reponse_array = json_decode($reponse_json, TRUE);
					$qr_code_url = $reponse_array['actions'][0]['url'];
					
					if($payment_number=='gopay'){
						$deeplink_url = $reponse_array['actions'][1]['url'];
					}
					// set value qrcode link
					$payment_qrcode = $qr_code_url;
					$payment_number = $qr_code_url;

				}
			} catch (Exception $e) {
				$any_error = true;
				$message_error = $e->getMessage();
			}
			
		}

		/*
		if($payment_number=='shopeepay'){

			$payment_account = strtoupper($payment_number);
			$payment_type = 'shopeepay';

			$transaction_data = array(
			    'payment_type' => $payment_type,
			    'transaction_details' => $transaction_details,
			    'item_details'        => $items,
			    'customer_details'    => $customer_details,
			    'shopeepay' => array(
			        'callback_url' => 'someapps://callback'
			    )
			);

			try {
				$response = Midtrans\CoreApi::charge($transaction_data);

				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;

					$reponse_json = json_encode($response);
				    $reponse_array = json_decode($reponse_json, TRUE);
					$qr_code_url = $reponse_array['actions'][0]['url'];
					
					if($payment_number=='shopeepay'){
						$deeplink_url = $reponse_array['actions'][1]['url'];
					}
					// set value qrcode link
					$payment_qrcode = $qr_code_url;
					$payment_number = $qr_code_url;

				}
			} catch (Exception $e) {
				$any_error = true;
				$message_error = $e->getMessage();
			}
			
		}
		*/

		if($payment_number=='alfamart' || $payment_number=='indomaret' ){

			$payment_account = strtoupper($payment_number);
			$payment_type = 'cstore';

			if($payment_number=='alfamart'){
				$transaction_data = array(
				    'payment_type' => $payment_type,
				    'transaction_details' => $transaction_details,
				    'item_details'        => $items,
				    'customer_details'    => $customer_details,
				    'cstore' => array(
				        'store' => 'alfamart',
				        'message' => 'Alfamart - '.$title_campaign,
					    'alfamart_free_text_1' => '',
					    'alfamart_free_text_2' => '',
					    'alfamart_free_text_3' => ''
				    )
				);
			}

			if($payment_number=='indomaret'){
				$transaction_data = array(
				    'payment_type' => $payment_type,
				    'transaction_details' => $transaction_details,
				    'item_details'        => $items,
				    'customer_details'    => $customer_details,
				    'cstore' => array(
				        'store' => 'indomaret',
					    'message' => 'Indomaret - '.$title_campaign
				    )
				);
			}
			
			try {
				$response = Midtrans\CoreApi::charge($transaction_data);

				if($response->status_code=='201'){
					$TransactionId = $response->transaction_id;
					$payment_number = $response->payment_code;
				}
			} catch (Exception $e) {
				$any_error = true;
				$message_error = $e->getMessage();
			}
			
		}

		$transaction_datanya = json_encode($transaction_data);
		$responsenya = json_encode($response);

	}

	// FLIP
	if($pg_code=='flip'){

		if($flip_mode=='1'){
			$secret_keynya = $flip_apikey;
			$url_flip = 'https://bigflip.id/api/v2/pwf/bill';
		}else{
			$secret_keynya = $flip_apikey_sandbox;
			$url_flip = 'https://bigflip.id/big_sandbox_api/v2/pwf/bill';
		}

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "$url_flip");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_HEADER, FALSE);

		curl_setopt($ch, CURLOPT_POST, TRUE);

		$payment_number = strtolower($payment_number); 
		$payment_numbernya = $payment_number; 

		if($payment_number=='bsi'){
			$payment_numbernya = 'bsm';
		}
		if($payment_number=='shopeepay'){
			$payment_numbernya = 'shopeepay_app';
		}
		if($payment_number=='gopay'){
			$payment_numbernya = 'qris';
		}
		// if($payment_number=='linkaja'){
		// 	$payment_number = 'linkaja_app';
		// }
		if($payment_number=='btpn'){
			$payment_numbernya = 'tabungan_pensiunan_nasional';
		}

		// Mandiri, BNI, BRI, Permata, BSI, CIMB, dan Danamon. BCA agak ribet harus ngurus berkas : VA

		$step = 3;
		if($payment_method=='instant'){
			$payment_methodnya = 'wallet_account';
			$step = 3;
			$payment_account = strtoupper($payment_number);
		}
		if($payment_method=='va'){
			$payment_methodnya = 'virtual_account';
			$step = 3;
			$payment_account = strtoupper(str_replace('_', ' ', $payment_code)). ' VA';
		}
		if($payment_method=='transfer'){
			$payment_methodnya = 'bank_account';
			$step = 2;
			$payment_account = strtoupper($payment_number);
			$payment_numbernya = 'bca'; // transfer di set all to bca transfer
		}

		if($email==''){
			$emailnya = 'nomail_'.$ddate.date('His').'@gmail.com';
		}else{
			$emailnya = $email;
		}

		$payloads = [
		    "title" => $invoice_id.' '.$title_campaign,
		    "amount" => $nominal,
		    "type" => "SINGLE",
		    "is_address_required" => 0,
		    "is_phone_number_required" => 1,
		    "step" => $step, // step 2 = bank_transfer, step 3 = wallet_account and virtual_account
		    "sender_name" => $name,
		    "sender_email" => $emailnya,
		    "sender_phone_number" => $whatsapp,
		    "sender_bank" => $payment_numbernya,
		    "sender_bank_type" => $payment_methodnya
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payloads));

		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		  "Content-Type: application/x-www-form-urlencoded"
		));

		curl_setopt($ch, CURLOPT_USERPWD, $secret_keynya.":");

		$response = curl_exec($ch);
		curl_close($ch);
		$response = json_decode( $response );

		if(isset($response->link_id)){

			if($payment_method=='transfer'){
				$amount = $response->amount;
				$TransactionId = $response->link_id;
				$deeplink_url = $response->link_url;
				if(strpos($deeplink_url, 'http') !== false){}else{
					$deeplink_url = 'https://'.$deeplink_url;
				}
				$payment_number = $deeplink_url;
			}elseif($payment_method=='instant'){
				// if($payment_number=='qris' || $payment_number=='gopay' || $payment_number=='shopeepay' || $payment_number=='ovo' || $payment_number=='linkaja'){
					$amount = $response->amount;
					$TransactionId = $response->link_id;
					$deeplink_url = $response->payment_url;
					if(strpos($deeplink_url, 'http') !== false){}else{
						$deeplink_url = 'https://'.$deeplink_url;
					}
					$payment_number = $deeplink_url;
				// }
			}else{
				// VA
				$account_number = $response->bill_payment->receiver_bank_account->account_number;
				$amount = $response->bill_payment->amount;
				$payment_id = $response->bill_payment->id;

				$payment_number = $account_number;
				$nominal = $amount;
				$TransactionId = $payment_id;
			}

			// payment_url => to get QR Code
			// if($payment_code=='qris'){
			// 	$payment_qrcode = $response->payment_url;
			// 	$payment_number = $response->payment_url;
			// }

		}else{
			$payment_account = 'flip';
		}

	}

	// ==================
	// info qurban - default
    // ==================
    $info_qurbannya = json_decode($info_qurban, true);
    $count_arr = count($info_qurbannya);
    $data_qurban = '';
    $count_qurban = 0;
    if($count_arr>=1){
    	foreach ( $info_qurbannya as $key => $value ) {
	    	if($count_qurban==$count_arr-1){
	    		$data_qurban .= '- '.$value['qurban'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*';
	    	}else{
	    		$data_qurban .= '- '.$value['qurban'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*
';
	    	}
	    	$count_qurban++;
	    }
    }

    // ==================
    // info qurban - detail
    // =================
    $info_qurbannya2 = json_decode($info_qurban, true);
    $count_arr2 = count($info_qurbannya2);
    $data_qurban2 = '';
    $count_qurban2 = 0;
    if($count_arr2>=1){
    	foreach ( $info_qurbannya2 as $key => $value ) {
	    	if($count_qurban2==$count_arr2-1){
	    		$data_qurban2 .= '- '.$value['qurban'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*';
			}else{
				$data_qurban2 .= '- '.$value['qurban'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*
';
			}
	    	$count_qurban2++;
	    }
    }
    
    // ==================
    // info package2 - default
    // ==================
    $info_packagenya = json_decode($info_package2, true);
    $count_arr_packagenya = count($info_packagenya);
    $data_packagenya = '';
    $count_packagenya = 0;
    if($count_arr_packagenya>=1){
    	foreach ( $info_packagenya as $key => $value ) {
	    	if($count_packagenya==$count_arr_packagenya-1){
	    		$data_packagenya .= '- '.$value['package'] .' = '.$value['jumlah'].'';
	    	}else{
	    		$data_packagenya .= '- '.$value['package'] .' = '.$value['jumlah'].'
';
	    	}
	    	$count_packagenya++;
	    }
    }

    // ==================
    // info package2 - detail
    // ==================
    $info_packagenya2 = json_decode($info_package2, true);
    $count_arr_packagenya2 = count($info_packagenya2);
    $data_packagenya2 = '';
    $count_packagenya2 = 0;
    if($count_arr_packagenya2>=1){
    	foreach ( $info_packagenya2 as $key => $value ) {
	    	if($count_packagenya2==$count_arr_packagenya2-1){
	    		$data_packagenya2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].'';
	    	}else{
	    		$data_packagenya2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].'
';
	    	}
	    	$count_packagenya2++;
	    }
    }

    // ==================
    // info zfitrah - default
    // ==================
    $info_zfitrahnya = json_decode($info_zfitrah, true);
    $count_arr_zfitrah = count($info_zfitrahnya);
    $data_zfitrah = '';
    $count_zfitrah = 0;
    if($count_arr_zfitrah>=1){
        foreach ( $info_zfitrahnya as $key => $value ) {
            if($count_zfitrah==$count_arr_zfitrah-1){
                $data_zfitrah .= '- '.$value['package'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*';
            }else{
                $data_zfitrah .= '- '.$value['package'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*
';
            }
            $count_zfitrah++;
        }
    }

    // ==================
    // info zfitrah - detail
    // =================
    $info_zfitrahnya2 = json_decode($info_zfitrah, true);
    $count_arr_zfitrah2 = count($info_zfitrahnya2);
    $data_zfitrah2 = '';
    $count_zfitrah2 = 0;
    if($count_arr_zfitrah2>=1){
        foreach ( $info_zfitrahnya2 as $key => $value ) {
            if($count_zfitrah2==$count_arr_zfitrah2-1){
                $data_zfitrah2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*';
            }else{
                $data_zfitrah2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*
';
            }
            $count_zfitrah2++;
        }
    } 


    // ==================
    // info additional formula data
    // =================
    $info_addformulanya = json_decode($info_addformula, true);
    $count_arr_addformula = count($info_addformulanya);
    $data_addformula = '';
    $count_addformula = 0;
    if($count_arr_addformula>=1){
        foreach ( $info_addformulanya as $key => $value ) {
            if($count_addformula==$count_arr_addformula-1){
                $data_addformula .= '
- '.$value['label'] .' : '.$value['nominal'];
            }else{
                $data_addformula .= '
- '.$value['label'] .' : '.$value['nominal'];
            }
            $count_addformula++;
        }
    }

    // set data list
    if($data_qurban!=''){
    	$data_list = $data_qurban.$data_addformula;
    }elseif($data_zfitrah!=''){
    	$data_list = $data_zfitrah.$data_addformula;
    }else{
    	$data_list = $data_packagenya.$data_addformula;
    }
    // set data list detail
    if($data_qurban2!=''){
    	$data_list_detail = $data_qurban2.$data_addformula;
    }elseif($data_zfitrah2!=''){
    	$data_list_detail = $data_zfitrah2.$data_addformula;
    }else{
    	$data_list_detail = $data_packagenya2.$data_addformula;
    }

    $payment_method 	= get_payment_method($invoice_id);
    $payment_method 	= str_replace('(*', '*', $payment_method);
    $payment_method 	= str_replace('*)', '*', $payment_method);
    $payment_expired 	= get_payment_expired($invoice_id);

	// SET TEXT FORMAT
	$date_created = date("Y-m-d H:i:s");

	$data_field = array();
    $data_field[ '{name}' ] 	= $name;
    $data_field[ '{cs_name}' ] 	= $cs_name;
    $data_field[ '{whatsapp}' ] = $whatsapp;
    $data_field[ '{email}' ] 	= $email;
    $data_field[ '{comment}' ] 	= $comment;
    $data_field[ '{payment_number}' ] 	= $payment_number;
    $data_field[ '{payment_code}' ] 	= paymentCode($payment_code);
    $data_field[ '{payment_account}' ] 	= $payment_account;
    $data_field[ '{campaign_title}' ] 	= $title_campaign;
    $data_field[ '{invoice_id}' ] 		= $invoice_id;
    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($date_created));
    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$invoice_id;
    $data_field[ '{data_list}' ] 		= $data_list;
    $data_field[ '{data_list_detail}' ] = $data_list_detail;
    $data_field[ '{payment_method}' ] 	= $payment_method;
    $data_field[ '{payment_expired}' ] 	= $payment_expired;
    

    if($currency=='IDR'){
    	$data_field[ '{total}' ] 	= 'Rp '.number_format($nominal,0,",",".");
    }else{
    	$data_field[ '{total}' ] 	= $nominal;
    }

    $fundraiser_name = '-';
    if($affcode_id!='0'){
		$query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name5 a
	    LEFT JOIN $table_name6 b ON b.id = a.affcode_id 
	    where a.affcode_id='$affcode_id' ORDER BY a.id DESC ")[0];

	    if($query_donation->fundraiser_id!=''){
	        $user_info = get_userdata($query_donation->fundraiser_id);
	        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
	    }
	    $data_field[ '{fundraiser}' ] = $fundraiser_name;
	}else{
		$data_field[ '{fundraiser}' ] = '-';
	}


    // CREATE DONASI
    $id_login = wp_get_current_user()->ID;
	$wpdb->insert(
        $table_name, //table
        array(
            'campaign_id' 	 => $campaign_id,
            'invoice_id' 	 => $invoice_id,
            'user_id' 		 => $id_login,
            'name' 			 => $name,
            'whatsapp' 		 => $whatsapp,
            'email' 		 => $email,
            'comment' 		 => $comment,
            'anonim' 		 => $anonim,
            'payment_method' => $payment_method,
            'payment_code'	 => $payment_code,
            'payment_number' => $payment_number,
            'payment_qrcode' => $payment_qrcode,
            'payment_account'=> $payment_account,
            'unique_number'  => $unique_number,
            'nominal' 		 => $nominal,
            'main_donate' 	 => $main_donate,
            'info_donate' 	 => $info_donate,
            'info_qurban' 	 => $info_qurban,
            'info_package2'  => $info_package2,
            'info_zfitrah' 	 => $info_zfitrah,
            'info_addformula'=> $info_addformula,
            'status' 		 => 0,
            'cs_id' 		 => $cs_id,
            'f0' 			 => null,
            'f1' 			 => null,
            'f2' 			 => null,
            'f3' 			 => null,
            'f4' 			 => null,
            'f5' 			 => null,
            'payment_trx_id' => $TransactionId,
            'payment_at'	 => null,
            'deeplink_url'	 => $deeplink_url,
            'payment_gateway'=> $pg_code,
            'created_at' 	 => $date_created),
        array('%s', '%s') //data format         
    );

    $donasi_id = $wpdb->insert_id;

    if($affcode_id!='0'){
    	// check mode fundraising
    	if($fundraiser_on=='1'){
			if($c_fundraiser_setting=='0' || $c_fundraiser_setting==null){
				
				$add_commission = true;
				// ikut default settingan utama
				if($fundraiser_commission_on=='1'){
		    		if($fundraiser_commission_type=='0'){
		    			if($fundraiser_commission_percent=='' || $fundraiser_commission_percent==null){
		    				$fundraiser_commission_percent = 0;
		    			}
		    			$nominal_commission = round($nominal*($fundraiser_commission_percent/100));
		    		}else{
		    			if($fundraiser_commission_fixed=='' || $fundraiser_commission_fixed==null){
		    				$fundraiser_commission_fixed = 0;
		    			}
		    			$nominal_commission = round($fundraiser_commission_fixed);
		    		}
		    	}else{
		    		$nominal_commission = 0;
		    	}

			}else if($c_fundraiser_setting=='1'){

				if($c_fundraiser_on=='1'){

					$add_commission = true;
					if($c_fundraiser_commission_on=='1'){

						// ikut settingan di campaign
						if($c_fundraiser_commission_on=='1'){
				    		if($c_fundraiser_commission_type=='0'){
				    			$nominal_commission = round($nominal*($c_fundraiser_commission_percent/100));
				    		}else{
				    			$nominal_commission = round($c_fundraiser_commission_fixed);
				    		}
				    	}else{
				    		$nominal_commission = 0;
				    	}

					}else{
						$nominal_commission = 0;
					}
					
				}else{
					$add_commission = false;
				}
			}else{
				$add_commission = false;
			}
		}else{
			$add_commission = false;
		}
		
		if($add_commission==true){

	    	$wpdb->insert( $table_name5,
		        array(
		            'donate_id' 	=> $donasi_id,
		            'campaign_id' 	=> $campaign_id,
		            'affcode_id' 	=> $affcode_id,
		            'payout_status' => 0,
		            'nominal_commission' => $nominal_commission,
		            'created_at' 	=> date("Y-m-d H:i:s"),
		            'updated_at' 	=> date("Y-m-d H:i:s")),
		        array('%s', '%s') //data format         
		    );

		}
    	
    }


    // CREATE LOG Payment
    if($pg_code=='flip'){

    	if(isset($response->link_id)){
    		$data_status  = 1;
    		$data_message = 'success';
    	}else{
    		if(isset($response->errors[0]->message)){
    			$data_status  = 0;
    			$data_message = $response->errors[0]->message;
    		}else{
    			$data_status  = 0;
	    		$data_message = $response->message;
    		}
    		
    	}

    	$transaction_datanya = json_encode($payloads);
		$responsenya = json_encode($response);
		$responsenya = str_replace('\/', '/', $responsenya);
		
	    $wpdb->insert(
	        $table_name4, //table
	        array(
	            'id_donate' 	=> $donasi_id,
	            'hit'			=> $transaction_datanya,
	            'status' 		=> $data_status,
	            'message' 		=> $data_message,
	            'log' 			=> $responsenya,
	            'created_at' 	=> date("Y-m-d H:i:s")
	        ),
	        array('%s', '%s') //data format         
	    );
    }

    
    if($pg_code=='midtrans'){
		
		$data_log = $responsenya;
		
    	if($response->status_code=='201'){
			$data_status = 1;
			$data_message = 'success';
		}else{
			if($any_error==false){
				$data_status = 0;
				$data_message = $response->status_message;
			}else{
				$data_status = 0;
				$data_message = 'failed';
				$data_log = $message_error;
			}
		}

	    $wpdb->insert(
	        $table_name4, //table
	        array(
	            'id_donate' 	=> $donasi_id,
	            'hit'			=> $transaction_datanya,
	            'status' 		=> $data_status,
	            'message' 		=> $data_message,
	            'log' 			=> $data_log,
	            'created_at' 	=> date("Y-m-d H:i:s")
	        ),
	        array('%s', '%s') //data format         
	    );
    }

    if($pg_code=='ipaymu'){

		$data_status  = $response_payment['Status'];
    	$data_message = $response_payment['Message'];
    	$data_log = json_encode($response_payment);
    	$data_log = str_replace('\/', '/', $data_log);

	    $wpdb->insert(
	        $table_name4, //table
	        array(
	            'id_donate' 	=> $donasi_id,
	            'hit'			=> $jsonBody,
	            'status' 		=> $data_status,
	            'message' 		=> $data_message,
	            'log' 			=> $data_log,
	            'created_at' 	=> date("Y-m-d H:i:s")
	        ),
	        array('%s', '%s') //data format         
	    );
    }

    if($pg_code=='tripay'){

    	if($response['success']==true){
			$data_status = 1;
			$data_message = 'success';
		}else{
			$data_status = 0;
			$data_message = $response['message'];
		}

		$dataPayment = json_encode($dataPayment);
		$dataPayment = str_replace('\/', '/', $dataPayment);
		$data_log = json_encode($response);
		$data_log = str_replace('\/', '/', $data_log);

    	$wpdb->insert(
	        $table_name4, //table
	        array(
	            'id_donate' 	=> $donasi_id,
	            'hit'			=> $dataPayment,
	            'status' 		=> $data_status,
	            'message' 		=> $data_message,
	            'log' 			=> $data_log,
	            'created_at' 	=> date("Y-m-d H:i:s")
	        ),
	        array('%s', '%s') //data format         
	    );
    }
    
    
    // WANOTIF
	if($wanotif_apikey!='' && $wanotif_on=='1'){
		// SET PHONE
		if($whatsapp!=''){

			$phone = djaPhoneFormat($whatsapp);
		
			if($notification_status=='1'){
				// message diambil dari settingan campaign
				$messagenya = $wanotif_message_on_form;

				// device diambil dari settingan campaign
				if($wanotif_device=='1'){
					if($wanotif_apikey_cs!=''){
                        $data_cs = json_decode($wanotif_apikey_cs, true);
                        $jumlah_cs = $data_cs['jumlah'];
                    }else{
                        $jumlah_cs = 0;
                    }
                    
                    if($jumlah_cs>=1){
                    	foreach ($data_cs['data'] as $key => $value) {
	                    	if($cs_id==$value[0]){
	                    		$wanotif_apikey = $value[1];
	                    		break;
	                    	}
	                    }
                    }
				}

			}else{
				if($wanotif_followup1_on=='1'){
					
					// UPDATE FOLLOWUP 1 STATUS = 1
				    $wpdb->update( $table_name, array( 'f1' => 1 ), array('id' => $donasi_id), array('%s'), array('%s'));

				    // pakai message followup 1
					$messagenya = $text_f1;
				}else{
					// pakai settingan default wanotif
					$messagenya = $wanotif_message;
				}
			}


			// Update data message dari data sumbit donasi
			$messagenya = strtr($messagenya, $data_field);
			$messagenya = str_replace('*'.$payment_qrcode.'*', '', $messagenya);
			$messagenya = str_replace($payment_qrcode, '', $messagenya);

			$bHasLink = strpos($payment_qrcode, 'http') !== false || strpos($payment_qrcode, 'www.') !== false;
			$bHasIPaymu = strpos($payment_qrcode, 'ipaymu.com') !== false;

			if($bHasLink){

				$content = file_get_contents($payment_qrcode);

				if (preg_match('@"([^"]+)"@', $content, $matches) && $bHasIPaymu) {
					$image_base64_qrcode = $matches[0];
					$body = $image_base64_qrcode;
					$body = str_replace('"', '', $body);
				}else{	
					$imagedata = 'data:image/png;base64,'.base64_encode(file_get_contents($payment_qrcode));
					$body = $imagedata;
				}

				// Nama file beserta jenis ekstensinya
				$filename = 'QRcode.jpg';

				$url = $wanotif_url.'/sendfile';

				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, $url);
				curl_setopt($curl, CURLOPT_HEADER, 0);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
				curl_setopt($curl, CURLOPT_TIMEOUT,30);
				curl_setopt($curl, CURLOPT_POST, 1);
				curl_setopt($curl, CURLOPT_POSTFIELDS, array(
				    'Apikey'    => $wanotif_apikey,
				    'Phone'     => $phone,
				    'Body'      => $body,
				    'Caption'   => $messagenya,
				    'Filename'  => $filename
				));
				$response = curl_exec($curl);
				curl_close($curl); 

			}else{

				$url = $wanotif_url.'/send';

				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, $url);
				curl_setopt($curl, CURLOPT_HEADER, 0);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
				curl_setopt($curl, CURLOPT_TIMEOUT,30);
				curl_setopt($curl, CURLOPT_POST, 1);
				curl_setopt($curl, CURLOPT_POSTFIELDS, array(
				    'Apikey'    => $wanotif_apikey,
				    'Phone'     => $phone,
				    'Message'   => $messagenya,
				));
				$response = curl_exec($curl);
				curl_close($curl);
			}

		}

	}
	
	
	// TELEGRAM
	if($telegram_on=='1'){
		$token = $telegram_bot_token;
		$telegram_send_to = json_decode($telegram_send_to);

		foreach($telegram_send_to as $key => $value) {

            $message_tele = $value->message;
            $message_tele = strtr($message_tele, $data_field);
            $channel = $value->channel;
			
			if (strpos($channel, ',') !== false ) {
				$array_channel  = (explode(",", $channel));
				foreach ($array_channel as $values){
					$channel_id = $values;
					$send = donasiaja_send2tg($token, $channel_id, $message_tele);
					// echo $send;
				}
			}else{
				$channel_id = $channel;
				donasiaja_send2tg($token, $channel_id, $message_tele);
			}

		}
	}

	// EMAIL
	if($email_on=='1'){
		$email_send_to = json_decode($email_send_to);

		foreach($email_send_to as $key => $value) {

            $message = $value->message;
            $message = strtr($message, $data_field);
			$message = str_replace('<p>linebreak</p>', '', $message);
			$message = str_replace('linebreak', '', $message);
			$message = str_replace('*', '', $message);
			
            $subject = $value->subject;
            $subject = strtr($subject, $data_field);
			$subject = str_replace("'","",$subject);
			
            $emailnya = $value->email;
			
            $emailnyacc = $value->emailcc;
            $emailnyabcc = $value->emailbcc;

            $headers[] = 'Content-Type: text/html; charset=UTF-8';

            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

			if (strpos($emailnyacc, ',') !== false ) {
				$array_emailcc  = (explode(",", $emailnyacc));
				foreach ($array_emailcc as $values){
					$email_cc = strtr($values, $data_field);
					$headers[] = 'Cc: '.$email_cc;
				}
			}else{
				$emailnyacc = strtr($emailnyacc, $data_field);
				$headers[] = 'Cc: '.$emailnyacc;
			}

			if (strpos($emailnyabcc, ',') !== false ) {
				$array_emailbcc  = (explode(",", $emailnyabcc));
				foreach ($array_emailbcc as $values){
					$email_bcc = strtr($values, $data_field);
					$headers[] = 'Bcc: '.$email_bcc;
				}
			}else{
				$emailnyabcc = strtr($emailnyabcc, $data_field);
				$headers[] = 'Bcc: '.$emailnyabcc;
			}
			
 			
			if($emailnya!=''){
				$emailnya = strtr($emailnya, $data_field);
				wp_mail( $emailnya, $subject, $body, $headers );
			}
				
			

		}
	}	

	echo $invoice_id;

    wp_die();
}
add_action( 'wp_ajax_djafunction_submit_donasi', 'djafunction_submit_donasi' );
add_action( 'wp_ajax_nopriv_djafunction_submit_donasi', 'djafunction_submit_donasi' );




function djafunction_regaff_fundraiser(){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_aff_code";
    $table_name2 = $wpdb->prefix . "dja_campaign";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $campaign_id 	= $_POST['datanya'][0];
    $aff_code = d_randomString(5);


    if($id_login==null){
    	echo 'loginfirst_0';
    	wp_die();
    }

    $check = $wpdb->get_results('SELECT * from '.$table_name.' where campaign_id="'.$campaign_id.'" and user_id="'.$id_login.'" ');
	if($check==null){
		// create aff_code
		// check dl aff_code sudah ada belum
		$check2 = $wpdb->get_results('SELECT * from '.$table_name.' where aff_code="'.$aff_code.'" ');
		if($check2==null){
			$wpdb->insert(
	            $table_name, //table
	            array(
		            'campaign_id' 	=> $campaign_id,
		            'user_id' 		=> $id_login,
		            'aff_code' 		=> $aff_code,
		            'created_at' 	=> date("Y-m-d H:i:s")
		        ),
	            array('%s', '%s') //data format         
	        );
	        $the_code = 'success_'.$aff_code;
		}else{
			$aff_code2 = d_randomString(6);
			$check3 = $wpdb->get_results('SELECT * from '.$table_name.' where aff_code="'.$aff_code2.'" ');
			if($check3==null){
				$wpdb->insert(
		            $table_name, //table
		            array(
			            'campaign_id' 	=> $campaign_id,
			            'user_id' 		=> $id_login,
			            'aff_code' 		=> $aff_code2,
			            'created_at' 	=> date("Y-m-d H:i:s")
			        ),
		            array('%s', '%s') //data format         
		        );
		        $the_code = 'success_'.$aff_code2;
			}else{
				$aff_code3 = d_randomString(7);
				$check4 = $wpdb->get_results('SELECT * from '.$table_name.' where aff_code="'.$aff_code3.'" ');
				if($check4==null){
					$wpdb->insert(
			            $table_name, //table
			            array(
				            'campaign_id' 	=> $campaign_id,
				            'user_id' 		=> $id_login,
				            'aff_code' 		=> $aff_code3,
				            'created_at' 	=> date("Y-m-d H:i:s")
				        ),
			            array('%s', '%s') //data format         
			        );
			        $the_code = 'success_'.$aff_code3;
				}
			}
		}
		
	}else{
		// tampilkan saja
		$the_code = 'show_'.$check[0]->aff_code;
	}

	echo $the_code;

    wp_die();

}
add_action( 'wp_ajax_djafunction_regaff_fundraiser', 'djafunction_regaff_fundraiser' );
add_action( 'wp_ajax_nopriv_djafunction_regaff_fundraiser', 'djafunction_regaff_fundraiser' );



function donasiaja_send2tg($token, $chatID, $message_tele) {
	
	$urlweb = 'https://api.telegram.org/bot'.$token.'/sendMessage?text='.rawurlencode($message_tele).'&chat_id='.$chatID.'&parse_mode=Markdown';

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $urlweb);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_TIMEOUT, 30);

	$siteData = curl_exec($ch);
	curl_close($ch);

	return $siteData;

} 



function djafunction_send_test_telegram(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    // FROM INPUT
    $channel_tele 	= $_POST['datanya'][0];
    $message_tele 	= $_POST['datanya'][1];

    // General Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="telegram_bot_token" or type="telegram_send_to" ORDER BY id ASC');
    $telegram_bot_token	= $query_settings[0]->data;
    $telegram_send_to	= $query_settings[1]->data;

	$token = $telegram_bot_token;
	$send = donasiaja_send2tg($token, $channel_tele, $message_tele);

	$array = json_decode( $send, true );
    $data = $array['ok'];

	if($data==true){
		echo 'success';
	}else{
		echo 'failed';
	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_send_test_telegram', 'djafunction_send_test_telegram' );
add_action( 'wp_ajax_nopriv_djafunction_send_test_telegram', 'djafunction_send_test_telegram' );


function djafunction_send_test_email(){
	global $wpdb;

    // FROM INPUT
    $to 		= $_POST['datanya'][0];
    $subject 	= $_POST['datanya'][1];
    $message 	= $_POST['datanya'][2];
    $headers = array('Content-Type: text/html; charset=UTF-8');

    $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;">'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

    wp_mail( $to, $subject, $body, $headers );
	
	echo 'success';

    wp_die();

} 
add_action( 'wp_ajax_djafunction_send_test_email', 'djafunction_send_test_email' );
add_action( 'wp_ajax_nopriv_djafunction_send_test_email', 'djafunction_send_test_email' );






function djafunction_send_test_wanotif(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    // FROM INPUT
    $apikey 		= $_POST['datanya'][0];
    $no_wa 			= $_POST['datanya'][1];
    $message_wa 	= $_POST['datanya'][2];

    // General Settings
    // GET SETTINGS
	$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="wanotif_url" or type="wanotif_apikey" ORDER BY id ASC');
    $wanotif_url 		  = $query_settings[0]->data;
    $wanotif_apikey 	  = $query_settings[1]->data;   

	$phone = djaPhoneFormat($no_wa);
	$url = $wanotif_url.'/send';

	$messagenya = $message_wa;

	$curl = curl_init();
	curl_setopt($curl, CURLOPT_URL, $url);
	curl_setopt($curl, CURLOPT_HEADER, 0);
	curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
	curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($curl, CURLOPT_TIMEOUT,30);
	curl_setopt($curl, CURLOPT_POST, 1);
	curl_setopt($curl, CURLOPT_POSTFIELDS, array(
	    'Apikey'    => $apikey,
	    'Phone'     => $phone,
	    'Message'   => $messagenya,
	));
	$response = curl_exec($curl);
	curl_close($curl);

	$array = json_decode( $response, true );
	$data = $array['wanotif']['status'];

	if($data=='sent'){
		echo 'success';
	}else{
		echo 'failed';
	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_send_test_wanotif', 'djafunction_send_test_wanotif' );
add_action( 'wp_ajax_nopriv_djafunction_send_test_wanotif', 'djafunction_send_test_wanotif' );


function djafunction_status_wanotif(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $check_status 			= $_POST['datanya'][0];

    if($check_status==true){
    	// GET SETTINGS
		$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="wanotif_url" or type="wanotif_apikey" ORDER BY id ASC');
	    $wanotif_url 		  = $query_settings[0]->data;
	    $wanotif_apikey 	  = $query_settings[1]->data;   

		$url = $wanotif_url.'/auth';

		$curl = curl_init();
		curl_setopt_array($curl, [
		    CURLOPT_URL => $url,
		    CURLOPT_RETURNTRANSFER => true,
		    CURLOPT_ENCODING => "",
		    CURLOPT_MAXREDIRS => 10,
		    CURLOPT_TIMEOUT => 30,
		    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		    CURLOPT_CUSTOMREQUEST => "GET",
		    CURLOPT_SSL_VERIFYHOST => 0,
		    CURLOPT_SSL_VERIFYPEER => 0,
		    CURLOPT_HTTPHEADER => [
		      "Accept: application/json",
		      "Apikey: $wanotif_apikey",
		    ],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

	    curl_close($curl);

	    if ($err) {
	      echo "cURL Error #:" . $err;
	    }else{
	    	$array = json_decode( $response, true );
			$data_wanotif_status = $array['wanotif']['status'];

			if($data_wanotif_status=='connected'){
			    $status_wanotif = '<span style="color:#36BD47;">Connected</span>';
			}elseif($data_wanotif_status=='scan'){
			    $status_wanotif =  '<a href="https://app.wanotif.id/device" class="link_href" target="_blank">Sqan QR-Code</a>';
			}else{
				if($wanotif_apikey==''){
					$status_wanotif = '-';
				}else{
					$status_wanotif = '<a href="https://app.wanotif.id/device" class="link_href" target="_blank">Check your connection on Wanotif</a>';
				}
			}
			echo $status_wanotif;
	    }
		wp_die();
    }

} 
add_action( 'wp_ajax_djafunction_status_wanotif', 'djafunction_status_wanotif' );
add_action( 'wp_ajax_nopriv_djafunction_status_wanotif', 'djafunction_status_wanotif' );



function djafunction_get_donasi(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_campaign";
    $table_name3 = $wpdb->prefix . "users";
    $table_name4 = $wpdb->prefix . "dja_users";
    $table_name5 = $wpdb->prefix . "dja_payment_log";
    $table_name6 = $wpdb->prefix . "dja_settings";
    $table_name7 = $wpdb->prefix . "dja_aff_submit";
    $table_name8 = $wpdb->prefix . "dja_aff_code";
    

    // FROM INPUT
    $donasi_id 	= $_POST['datanya'][0];

    $row = $wpdb->get_results("SELECT a.*, b.user_randid FROM $table_name a 
    left JOIN $table_name4 b ON b.user_id = a.user_id where a.id='$donasi_id' ")[0];

    $row2 = $wpdb->get_results("SELECT title, slug, general_status, allocation_title, allocation_others_title FROM $table_name2 where campaign_id='$row->campaign_id' ")[0];

    $row3 = $wpdb->get_results("SELECT b.user_id as aff_userid from $table_name7 a 
    left JOIN $table_name8 b ON b.id = a.affcode_id where a.donate_id='$donasi_id' ");

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name6.' where type="page_typ" ORDER BY id ASC');
    $page_typ = $query_settings[0]->data;

    if($row->status=='1'){
        $status = '<span class="active-status p_received" style="padding: 5px 12px;font-size: 10px;">Success</span>';
    }else{
        $status = '<span class="active-status p_waiting" style="padding: 5px 12px;font-size: 10px;">Waiting</span>';
    }

    if($row->anonim=='1'){
    	$anonim = 'Ya';
    	$anonim_text = 'Ya';
    	$anonim_status = 'anonim_yes';
    	$anonim_checked = 'checked';
    }else{
    	$anonim = 'Tidak';
    	$anonim_text = 'Tidak';
    	$anonim_status = 'anonim_no';
    	$anonim_checked = '';
    }

    if($row->comment==''){
    	$comment = '-';
    }else{
    	$comment = $row->comment;
    }

    // cek ada id user gak, klo ada, ambil data member
    if($row->user_id!='0'){
    	$select_active = 'opt_active';
    	$input_active = 'opt_hide';
    }else{
    	$select_active = 'opt_hide';
    	$input_active = 'opt_active';
    }
    	
    // $data_userwp = get_users( array( 'fields' => array( 'ID', 'display_name', 'user_email' ) ) );
    $data_userwp = $wpdb->get_results('SELECT a.ID, a.display_name, a.user_email, b.user_wa, b.user_pp_img, b.user_randid from '.$table_name3.' a 
    left JOIN '.$table_name4.' b ON b.user_id = a.ID ');

	$data_user = '';
	foreach ( $data_userwp as $user ) {
		$selected = '';
		if($row->user_id==$user->ID){
			$selected = 'selected';
		}

	    $data_user .= '<option value="'.$user->display_name.'" data-userid="'.$user->ID.'" data-name="'.$user->display_name.'" data-wa="'.$user->user_wa.'" data-email="'.$user->user_email.'" data-userrandid="'.$user->user_randid.'" data-pp="'.$user->user_pp_img.'" '.$selected.'>'.$user->display_name.' ('.$user->user_email.')</span></option>';
	}


	$data_cs = '';
	foreach ( $data_userwp as $user ) {
        $cap_user = get_user_meta( $user->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
        $roles_user = array_keys((array)$cap_user);
        if(isset($roles_user[0])){
            $rolenya_user = $roles_user[0];
        }else{
            $rolenya_user = null;
        }

        if($rolenya_user=='cs'){
            $selected = '';
            if($row->cs_id==$user->ID){
                $selected = 'selected';
            }
            $data_cs .= '<option value="'.$user->display_name.'" data-userid="'.$user->ID.'" data-name="'.$user->display_name.'" data-wa="'.$user->user_wa.'" data-email="'.$user->user_email.'" data-userrandid="'.$user->user_randid.'" data-pp="'.$user->user_pp_img.'" '.$selected.'>'.$user->display_name.'</span></option>';
        }
    }



	$user_data_select = '<select class="select2 form-control mb-3 custom-select usernya_select '.$select_active.'" style="width: 100%; height:36px;" >
        <option value="">Select User</option>
        '.$data_user.'
    </select>';

    $user_data_select2 = '<select class="select2 form-control mb-3 custom-select csnya_select '.$select_active.'" style="width: 100%; height:36px;" >
        <option value="">Select CS</option>
        '.$data_cs.'
    </select>';

	$user_option_select = '<span class="input-group-append icon_pencil '.$select_active.'" title="Edit Manual tanpa Korelasi User">
                            <button type="button" class="btn btn-sm btn-primary" style="border-top-right-radius: 4px; border-bottom-right-radius: 4px;"><i class="fas fa-pen" style="margin-left:3px;margin-right:3px;"></i></button>
                        </span>';


	$user_data_input = '<input type="text" class="form-control usernya_input '.$input_active.'" id="inp1" placeholder="Nama Donatur" value="'.$row->name.'" style="border-radius: 4px;">
	';
	$user_option_input = '<span class="input-group-append icon_user '.$input_active.'" title="Edit From Data User">
                            <button type="button" class="btn btn-sm btn-primary" style="height:45px;"><i class="fas fa-user" style="margin-left:4px;margin-right:4px;"></i></button>
                        </span>';
    
    // payment log
    $get_log = $wpdb->get_results("SELECT * FROM $table_name5 where id_donate='$donasi_id' ");
    if($get_log==null){
    	$log_messagenya = '';
    	$height = 'height:340px';
    }else{
    	$log_messagenya = '
    	<tr><td>Request</td><td>:</td><td><textarea readonly="readonly" rows="2" style="width: 100%;font-size: 11px;padding: 10px 10px;background: #ecf0fb;border: 1px solid #ecf0fb;color: #7484bb;">'.$get_log[0]->hit.'</textarea></td></tr>
		<tr><td>Response</td><td>:</td><td><textarea readonly="readonly" rows="2" style="width: 100%;font-size: 11px;padding: 10px 10px;background: #ecf0fb;border: 1px solid #ecf0fb;color: #7484bb;">'.$get_log[0]->log.'</textarea></td></tr>
		<tr><td>Message</td><td>:</td><td>'.$get_log[0]->message.'</td></tr>
		<tr><td colspan="3"><hr></td></tr>
    	';
    	$height = 'height:450px';
    }

    // set kosong log_messagenya for donatur
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];
    // if($role=='donatur'){
    // 	$log_messagenya = '';
    // }
    $show_data_cs = '';
    $show_edit_icon = '';
    $margin_printer = '';
    if($role=='cs'){
    	$show_data_cs = 'display:none;';
    	$show_edit_icon = 'display:none;';
    	$margin_printer = 'margin-right:5px !important;';
    }
    
    

    $general_status = $row2->general_status;
    $allocation_title = $row2->allocation_title;
    $allocation_others_title = $row2->allocation_others_title;

    if($general_status=='1'){
        if($allocation_title=='1' || $allocation_title=='0'){
            $allocation_title = 'Donasi';
        }elseif($allocation_title=='2'){
            $allocation_title = 'Zakat';
        }elseif($allocation_title=='3'){
            $allocation_title = 'Qurban';
        }else{
            $allocation_title = $allocation_others_title;
        }
    }else{
        $allocation_title = 'Donasi';
    }


    $info_donate = json_decode($row->info_donate);
    $datane = '';
    foreach ( $info_donate as $key => $value ) {
    	$datane .= '<li>'.$key . ': ' . $value .'</li>';
    }

    $info_qurban = json_decode($row->info_qurban, true);
    $datane2 = '';
    $show_qurban = 'display:none';
    foreach ( $info_qurban as $key => $value ) {
    	$show_qurban = '';
    	$datane2 .= '<li>'.$value['qurban'] .' ('.$value['per@'].') x '.$value['jumlah'].'</li><ul><li>Total : '.$value['nominal'].'</li><li>Atas nama : '.$value['an'].'</li></ul></li>';
    }

    $info_package2 = json_decode($row->info_package2, true);
    $datane3 = '';
    $show_package2 = 'display:none';
    foreach ( $info_package2 as $key => $value ) {
    	$show_package2 = '';
    	$datane3 .= '<li>'.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].'</li><ul><li>Total : '.$value['nominal'].'</li></ul></li>';
    }

    $info_zfitrah = json_decode($row->info_zfitrah, true);
    $datane4 = '';
    $show_zfitrah = 'display:none';
    foreach ( $info_zfitrah as $key => $value ) {
    	$show_zfitrah = '';
    	$datane4 .= '<li>'.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].'</li><ul><li>Total : '.$value['nominal'].'</li><li>Atas nama : '.$value['an'].'</li></ul></li>';
    }

    $info_addformula = json_decode($row->info_addformula, true);
    $datane_addformula = '';
    $show_addformula = 'display:none';
    foreach ( $info_addformula as $key => $value ) {
    	$show_addformula = '';
    	$datane_addformula .= '<li>'.$value['label'] .': '.$value['nominal'].'</li>';
    }
    
    if($row->info_donate==''){
    	$show_detail_donasi = 'style="display:none;"';
    }else{
    	$show_detail_donasi = '';
    }

    
    if($row3!=null){
    	$user_info_cs = get_userdata($row3[0]->aff_userid);
    	if($user_info_cs->last_name==''){
	    	$refferal_name = $user_info_cs->first_name;
	    }else{
	    	$refferal_name = $user_info_cs->first_name.'&nbsp;'.$user_info_cs->last_name;
	    }
    }else{
    	$refferal_name = '-';
    }

    $user_info_cs = get_userdata($row->cs_id);
    if($user_info_cs!=null){
    	if($user_info_cs->last_name==''){
	    	$cs_name = $user_info_cs->first_name;
	    }else{
	    	$cs_name = $user_info_cs->first_name.'&nbsp;'.$user_info_cs->last_name;
	    }
    }else{
    	$cs_name = '-';
    }


	$data_donasi = '
	<p class="title_donasi" style="color:#50608e;"><b>'.$row2->title.'</b></p>
	<hr>
	<p class="inv"><a href="'.home_url().'/campaign/'.$row2->slug.'/'.$page_typ.'/'.$row->invoice_id.'" target="_blank" style="color:#7680ff;">'.$row->invoice_id.'</a> / '.date("M",strtotime($row->created_at)).'&nbsp;'.date("j",strtotime($row->created_at)).',&nbsp;'.date("Y",strtotime($row->created_at)).'&nbsp;-&nbsp;'.date("H:i ",strtotime($row->created_at)).'</p>
	<a href="'.home_url().'/wp-admin/?donasiaja=print_kuitansi&inv='.$row->invoice_id.'" target="_blank"><p class="inv print_invoice" title="Print Kuitansi" data-id="'.$row->id.'"><i class="mdi mdi-printer mr-2" style="color:#7081B9;margin: 0 4px !important;margin-right:45px !important;'.$margin_printer.'"></i></p></a>
	<p class="inv edit_detail" title="Edit Data Donasi" data-id="'.$row->id.'" style="'.$show_edit_icon.'"><i class="mdi mdi-pencil mr-2" style="margin: 0 4px !important;"></i></p>
	<hr>
	<div class="box_table" style="'.$height.';overflow-y: scroll;">
		<table id="table_donasi" style="margin-bottom:-25px;">
			<tr><td style="width:140px;">Nama</td><td>:</td><td><span id="d_name">'.$row->name.'</span></td></tr>
			<tr><td>Anonim</td><td>:</td><td>'.$anonim.'</td></tr>
			<tr><td>Whatsapp</td><td>:</td><td><span id="d_whatsapp">'.$row->whatsapp.'</span></td></tr>
			<tr><td>Email</td><td>:</td><td><span id="d_email">'.$row->email.'</span></td></tr>
			<tr><td>Pesan</td><td>:</td><td><span id="d_comment">'.$comment.'</span></td></tr>
			<tr><td>Payment Method</td><td>:</td><td>'.strtoupper($row->payment_method).'</td></tr>
			<tr><td>Payment Number</td><td>:</td><td>'.ucwords($row->payment_number).'</td></tr>
			<tr><td>Payment Account</td><td>:</td><td>'.$row->payment_account.'</td></tr>
			<tr><td>Payment Trx-ID</td><td>:</td><td>'.$row->payment_trx_id.'</td></tr>
			<tr><td>Payment Status</td><td>:</td><td><a href="'.home_url().'/campaign/'.$row2->slug.'/'.$page_typ.'/'.$row->invoice_id.'" target="_blank">'.$status.'</a></td></tr>
			<tr><td style="padding-top: 8px;">Refferal</td><td style="padding-top: 8px;">:</td><td style="padding-top: 8px;"><span id="d_csname">'.$refferal_name.'</span></td></tr>
			<tr><td style="padding-top: 5px;">CS</td><td style="padding-top: 5px;">:</td><td style="padding-top: 5px;"><span id="d_csname">'.$cs_name.'</span></td></tr>
			<tr><td style="padding-bottom: 8px;">Total</td><td style="padding-bottom: 8px;">:</td><td style="padding-bottom: 8px;font-size:15px;"><span id="d_nominal">'.'<b>Rp '.number_format($row->nominal,0,",",".").'</b></span></td></tr>

			<tr '.$show_detail_donasi.'><td style="vertical-align:top">Detail '.$allocation_title.'</td><td style="vertical-align:top">:</td><td style="vertical-align:top;font-size: 11px;"><ol style="margin-top:5px;margin-bottom:padding-top: 2px;font-style: italic;background: #f1f5ff;padding: 10px 15px;border-radius: 4px;margin: 0; padding-left: 25px;line-height: 1;'.$show_qurban.'">'.$datane2.'</ol><ol style="margin-top:5px;margin-bottom:padding-top: 2px;font-style: italic;background: #f1f5ff;padding: 10px 15px;border-radius: 4px;margin: 0; padding-left: 25px;line-height: 1;'.$show_package2.'">'.$datane3.'</ol><ol style="margin-top:5px;margin-bottom:padding-top: 2px;font-style: italic;background: #f1f5ff;padding: 10px 15px;border-radius: 4px;margin: 0; padding-left: 25px;line-height: 1;'.$show_zfitrah.'">'.$datane4.'</ol><ul style="margin-top:5px;margin-bottom:5px;margin-left: px;padding-top: 2px;font-style: italic;background: #f1f5ff;padding: 10px 15px;border-radius: 4px;line-height:1;'.$show_addformula.'">'.$datane_addformula.'</ul><ul style="margin-top:5px;margin-bottom:5px;margin-left: px;padding-top: 2px;font-style: italic;background: #f1f5ff;padding: 10px 15px;border-radius: 4px;line-height:1;">'.$datane.'</ul></td></tr>
    		<tr><td colspan="3"><hr></td></tr>
			'.$log_messagenya.'

		</table>

		<div class="card-body" id="edit_data_donasi">
            
            <div class="general-label">
                <form>
                	<div role="alert" class="alert alert-success border-0 update_donasi_success" style="font-size: 13px;margin-top: -20px;margin-bottom: 30px;display:none;">Update Success.
                    </div>
                    <div role="alert" class="alert alert-danger border-0 update_donasi_failed" style="font-size: 13px;margin-top: -20px;margin-bottom: 30px;display:none;">Update failed.
                    </div>
                    <div class="form-group row data_usernya">
                        <label for="inp1" class="col-sm-3 col-form-label" style="font-size:14px;">Nama</label>
                        <div class="input-group col-sm-9" id="select-user">
                            <input type="text" class="form-control" id="inp0" placeholder="ID Donasi" value="'.$row->id.'" style="display:none;">
                            '.$user_data_select.'
                            '.$user_option_select.'
                            '.$user_data_input.'
                            '.$user_option_input.'
                        </div>
                    </div>
                    <div class="form-group row" id="anonim_status">
                        <label for="inp2" class="col-sm-3 col-form-label" style="font-size:14px;">Anonim</label>

                        <div class="custom-control custom-switch set_anonim '.$anonim_status.'" style="margin-left: 10px;margin-top: 10px;">
	                        <input type="checkbox" class="custom-control-input set_anonim_status" id="customSwitchAnonim" '.$anonim_checked.'>
	                        <label class="custom-control-label" for="customSwitchAnonim"><span>'.$anonim_text.'</span></label>
	                    </div>

                    </div>
                    <div class="form-group row">
                        <label for="inp2" class="col-sm-3 col-form-label" style="font-size:14px;">Whatsapp</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control wa_donatur" id="inp2" placeholder="08xxxx" value="'.$row->whatsapp.'">
                            <span id="errmsg2"></span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="inp3" class="col-sm-3 col-form-label" style="font-size:14px;">Email</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control email_donatur" id="inp3" placeholder="Email" value="'.$row->email.'">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="inp4" class="col-sm-3 col-form-label" style="font-size:14px;">Pesan</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" rows="3" id="inp4">'.$row->comment.'</textarea>
                        </div>
                    </div>
                    <div class="form-group row data_csnya" style="'.$show_data_cs.'">
                        <label for="inp5" class="col-sm-3 col-form-label" style="font-size:14px;">CS</label>
                        <div class="col-sm-9">
                            '.$user_data_select2.'
                        </div>
                    </div>
                    <div class="form-group row" style="margin-bottom:30px;">
                        <label for="inp5" class="col-sm-3 col-form-label" style="font-size:14px;">Donasi</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control nominal_donasi" id="inp5" placeholder="Nominal Donasi" value="'.number_format($row->nominal,0,",",".").'">
                            <span id="errmsg"></span>
                            <input type="text" class="form-control user_randid" id="inp6" placeholder="user_randid" value="'.$row->user_randid.'" style="display:none;">
                        </div>
                    </div>
                    
                        
                    <div class="row">
                        <div class="col-sm-9 ml-auto" style="text-align:left;">
                        	<button type="button" class="btn btn-outline-primary back_me" style="padding:6px 15px 6px 12px;"><i class="mdi mdi-chevron-left"></i>Back</button>
                            <button type="button" class="btn btn-primary update_donasi" style="padding:6px 15px;">Update Donasi <div class="spinner-border spinner-border-sm text-white update_donasi_loading" style="margin-left: 3px;display: none;"></div></button>
                        	
                        </div>
                    </div> 
                </form>           
            </div>
        </div>

	</div>

	<script src="'.plugin_dir_url( __FILE__ ).'admin/plugins/select2/select2.min.js"></script>
	<script>

    jQuery(document).ready(function($){
        $(".usernya_select").select2({
		    tags: true,
		    tokenSeparators: [",", "joss"]
		});

		$(".csnya_select").select2({
		    tags: true,
		    tokenSeparators: [",", "joss"]
		});

		var status_user = "'.$row->user_id.'";
		if(status_user!="0"){
        	$(".wa_donatur, .email_donatur").prop( "disabled", true );
        }

        if(status_user=="0"){
        	$("#select-user .select2.select2-container").hide();
    	}

        $(".select2.usernya_select").on("change", function() {
	    	var userid = $(this).find("option:selected").attr("data-userid");
	    	var name = $(this).find("option:selected").attr("data-name");
	    	var wa = $(this).find("option:selected").attr("data-wa");
	    	var email = $(this).find("option:selected").attr("data-email");
	    	var user_randid = $(this).find("option:selected").attr("data-userrandid");

	    	$(".wa_donatur").val(wa);
	    	$(".email_donatur").val(email);
	    	$(".user_randid").val(user_randid);
	    })
    });

    </script>
	';

	echo $data_donasi;


    wp_die();
}
add_action( 'wp_ajax_djafunction_get_donasi', 'djafunction_get_donasi' );
add_action( 'wp_ajax_nopriv_djafunction_get_donasi', 'djafunction_get_donasi' );




function djafunction_get_donasi_confirmation(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

    // FROM INPUT
    $donasi_id 	= $_POST['datanya'][0];

    $row = $wpdb->get_results("SELECT * FROM $table_name where id='$donasi_id' ")[0];

    if($row!=null){
    	$a = $wpdb->update(
	        $table_name, //table
	        array(
	            'img_confirmation_status' 	=> 1,
	        ),
	        array('id' => $donasi_id), //where
	        array('%s'), //data format
	        array('%s') //where format
	    );

    	$time_upload = date('Y-m-d H:i:s',strtotime('+0 hour',strtotime($row->img_confirmation_date)));
	    $readtime = new humanReadtime();
        $a = $readtime->dja_human_time($time_upload);

	    $datenya = new DateTime($row->img_confirmation_date);
        $date_upload = $datenya->format('d').'&nbsp;'.$datenya->format('M').',&nbsp;'.$datenya->format('Y').'&nbsp;-&nbsp;'.$datenya->format('H').':'.$datenya->format('i').'<br><span style='."'".'font-size:10px;color:#91a2b0;'."'".'>'.$a.'<span>';

	    $data_image =  '
		<p class="title_donasi" style="color:#50608e;"><button data-inv="'.$row->invoice_id.'" data-id="'.$donasi_id.'" data-img="'.$row->img_confirmation_url.'" type="button" class="swal2-close del_conf" style="top: auto;right: auto;background: #ea0940;font-size: 20px;border-radius: 4px;margin-left: 180px;margin-top: 25px;" title="Delete Confirmation"><span class="mdi mdi-trash-can" style="font-size: 15px;"></span></button><img src="'.$row->img_confirmation_url.'" style="width:210px;border-radius:4px;margin-top:20px;margin-bottom:10px;"></p>';

		$data_date = '';
		if($row->img_confirmation_date!=''){
			$data_date = '<p><i>Date upload: '.$date_upload.'</i></p>';
		}

		echo $data_image.$data_date;
    }

	
    wp_die();
}
add_action( 'wp_ajax_djafunction_get_donasi_confirmation', 'djafunction_get_donasi_confirmation' );
add_action( 'wp_ajax_nopriv_djafunction_get_donasi_confirmation', 'djafunction_get_donasi_confirmation' );




function donasiaja_upload_confirmation() {
	if ( $_FILES ) {
		require_once(ABSPATH . "wp-admin" . '/includes/image.php');
		require_once(ABSPATH . "wp-admin" . '/includes/file.php');
		require_once(ABSPATH . "wp-admin" . '/includes/media.php');
		
		foreach ($_FILES as $file => $array) {

	        if($_FILES[$file]['error'] !== UPLOAD_ERR_OK){
	        	echo "failed";
	        }else{
	        	$file_handler = 'updoc';
	        	$attach_id = media_handle_upload($file_handler,$pid);
		        echo wp_get_attachment_url($attach_id); //upload file URL
	        }
	    }
	}

	// echo "success_".$attach_id;
	// echo wp_get_attachment_url($attach_id); // file url upload

	wp_die();
}
add_action( 'wp_ajax_donasiaja_upload_confirmation', 'donasiaja_upload_confirmation' );
add_action( 'wp_ajax_nopriv_donasiaja_upload_confirmation', 'donasiaja_upload_confirmation' );



function djafunction_update_confirmation(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_settings";
    $table_name3 = $wpdb->prefix . "dja_campaign";
    $table_name5 	= $wpdb->prefix . "dja_aff_submit";
    $table_name6 	= $wpdb->prefix . "dja_aff_code";

    // FROM INPUT
    $link_image 	= $_POST['datanya'][0];
    $invoice_id 	= $_POST['datanya'][1];

    // General Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="currency" or type="telegram_bot_token" or type="telegram_send_to" or type="telegram_on" or type="telegram_manual_confirmation" ORDER BY id ASC');
    $currency 				= $query_settings[0]->data;
    $telegram_bot_token 	= $query_settings[1]->data;
    $telegram_send_to 		= $query_settings[2]->data;
    $telegram_on 			= $query_settings[3]->data;
    $telegram_manual_confirmation 	= $query_settings[4]->data;


    // GET DATA DONATE
    $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name.' a 
    left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.invoice_id="'.$invoice_id.'" ')[0];

    $row2 = $wpdb->get_results("SELECT * FROM $table_name5 where donate_id='$row->id' ")[0];

	// Data FORMAT
    $date_created = date("Y-m-d H:i:s");

	$data_field = array();
    $data_field[ '{name}' ] 	= $row->name;
    $data_field[ '{whatsapp}' ] = $row->whatsapp;
    $data_field[ '{email}' ] 	= $row->email;
    $data_field[ '{comment}' ] 	= $row->comment;
    $data_field[ '{payment_number}' ] 	= $row->payment_number;
    $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
    $data_field[ '{payment_account}' ] 	= $row->payment_account;
    $data_field[ '{campaign_title}' ] 	= $row->title;
    $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
    $data_field[ '{date}' ] 			= date("j F Y - h:i",strtotime($row->date_created));
    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;

    if($currency=='IDR'){
    	$data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
    }else{
    	$data_field[ '{total}' ] 	= $row->nominal;
    }

    $fundraiser_name = '-';
    if($row2!=null){
		$query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name5 a
	    LEFT JOIN $table_name6 b ON b.id = a.affcode_id 
	    where a.affcode_id='$row->affcode_id' ORDER BY a.id DESC ")[0];

	    if($query_donation->fundraiser_id!=''){
	        $user_info = get_userdata($query_donation->fundraiser_id);
	        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
	    }
	    $data_field[ '{fundraiser}' ] = $fundraiser_name;
	}else{
		$data_field[ '{fundraiser}' ] = '-';
	}

	
	// TELEGRAM
	if($telegram_on=='1'){
		$token = $telegram_bot_token;
		$telegram_manual_confirmation = json_decode($telegram_manual_confirmation);

		foreach($telegram_manual_confirmation as $key => $value) {

            $message_tele = $value->message;
            $message_tele = strtr($message_tele, $data_field);
            $channel = $value->channel;
			
			if (strpos($channel, ',') !== false ) {
				$array_channel  = (explode(",", $channel));
				foreach ($array_channel as $values){
					$channel_id = $values;
					$send = donasiaja_send2tg($token, $channel_id, $message_tele);
				}
			}else{
				$channel_id = $channel;
				$send = donasiaja_send2tg($token, $channel_id, $message_tele);
			}

		}
	}

	// ACTION Update TO DB tanpa form_type dan packaged
 	$a = $wpdb->update(
        $table_name, //table
        array(
            'img_confirmation_url' 	=> $link_image,
            'img_confirmation_date' => date("Y-m-d H:i:s"),
        ),
        array('invoice_id' => $invoice_id), //where
        array('%s'), //data format
        array('%s') //where format
    );

	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_update_confirmation', 'djafunction_update_confirmation' );
add_action( 'wp_ajax_nopriv_djafunction_update_confirmation', 'djafunction_update_confirmation' );



function djafunction_get_mydonasi(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_campaign";
    $table_name3 = $wpdb->prefix . "users";
    $table_name4 = $wpdb->prefix . "dja_users";

    // FROM INPUT
    $donasi_id 	= $_POST['datanya'][0];

    $row = $wpdb->get_results("SELECT * FROM $table_name where id='$donasi_id' ")[0];
    $row2 = $wpdb->get_results("SELECT title FROM $table_name2 where campaign_id='$row->campaign_id' ")[0];

    if($row->status=='1'){
        $status = '<span class="active-status p_received" style="padding: 5px 12px;font-size: 10px;">Success</span>';
    }else{
        $status = '<span class="active-status p_waiting" style="padding: 5px 12px;font-size: 10px;">Waiting</span>';
    }

    if($row->anonim=='1'){
    	$anonim = 'Ya';
    	$anonim_text = 'Ya';
    	$anonim_status = 'anonim_yes';
    	$anonim_checked = 'checked';
    }else{
    	$anonim = 'Tidak';
    	$anonim_text = 'Tidak';
    	$anonim_status = 'anonim_no';
    	$anonim_checked = '';
    }

    if($row->comment==''){
    	$comment = '-';
    }else{
    	$comment = $row->comment;
    }

    // cek ada id user gak, klo ada, ambil data member
    if($row->user_id!='0'){
    	$select_active = 'opt_active';
    	$input_active = 'opt_hide';
    }else{
    	$select_active = 'opt_hide';
    	$input_active = 'opt_active';
    }
    	
    // $data_userwp = get_users( array( 'fields' => array( 'ID', 'display_name', 'user_email' ) ) );
    $data_userwp = $wpdb->get_results('SELECT a.ID, a.display_name, a.user_email, b.user_wa, b.user_pp_img, b.user_randid from '.$table_name3.' a 
    left JOIN '.$table_name4.' b ON b.user_id = a.ID ');

	$data_user = '';
	foreach ( $data_userwp as $user ) {
		$selected = '';
		if($row->user_id==$user->ID){
			$selected = 'selected';
		}

	    $data_user .= '<option value="'.$user->display_name.'" data-userid="'.$user->ID.'" data-name="'.$user->display_name.'" data-wa="'.$user->user_wa.'" data-email="'.$user->user_email.'" data-userrandid="'.$user->user_randid.'" data-pp="'.$user->user_pp_img.'" '.$selected.'>'.$user->display_name.' ('.$user->user_email.')</span></option>';
	}



	$user_data_select = '<select class="select2 form-control mb-3 custom-select usernya_select '.$select_active.'" style="width: 100%; height:36px;" >
        <option value="">Select User</option>
        '.$data_user.'
    </select>';

	$user_option_select = '<span class="input-group-append icon_pencil '.$select_active.'" title="Edit Manual tanpa Korelasi User">
                            <button type="button" class="btn btn-sm btn-primary" style="border-top-right-radius: 4px; border-bottom-right-radius: 4px;"><i class="fas fa-pen" style="margin-left:3px;margin-right:3px;"></i></button>
                        </span>';


	$user_data_input = '<input type="text" class="form-control usernya_input '.$input_active.'" id="inp1" placeholder="Nama Donatur" value="'.$row->name.'" style="border-radius: 4px;">
	';
	$user_option_input = '<span class="input-group-append icon_user '.$input_active.'" title="Edit From Data User">
                            <button type="button" class="btn btn-sm btn-primary" style="height:45px;"><i class="fas fa-user" style="margin-left:4px;margin-right:4px;"></i></button>
                        </span>';
    
    

	$data_donasi = '
	<p class="title_donasi" style="color:#50608e;"><b>'.$row2->title.'</b></p>
	<hr>
	<p class="inv">'.$row->invoice_id.' / '.date("M",strtotime($row->created_at)).'&nbsp;'.date("j",strtotime($row->created_at)).',&nbsp;'.date("Y",strtotime($row->created_at)).'&nbsp;-&nbsp;'.date("H:i ",strtotime($row->created_at)).'</p>
	<hr>
	<div class="box_table">
		<table id="table_donasi">
			<tr><td>Nama</td><td>:</td><td><span id="d_name">'.$row->name.'</span></td></tr>
			<tr><td>Anonim</td><td>:</td><td>'.$anonim.'</td></tr>
			<tr><td>Whatsapp</td><td>:</td><td><span id="d_whatsapp">'.$row->whatsapp.'</span></td></tr>
			<tr><td>Email</td><td>:</td><td><span id="d_email">'.$row->email.'</span></td></tr>
			<tr><td>Pesan</td><td>:</td><td><span id="d_comment">'.$comment.'</span></td></tr>
			<tr><td>Donasi</td><td>:</td><td><span id="d_nominal">'.'Rp '.number_format($row->nominal,0,",",".").'</span></td></tr>
			<tr><td>Payment Method</td><td>:</td><td>'.$row->payment_method.'</td></tr>
			<tr><td>Payment Number</td><td>:</td><td>'.$row->payment_number.'</td></tr>
			<tr><td>Payment Account</td><td>:</td><td>'.$row->payment_account.'</td></tr>
			<tr><td>Payment Status</td><td>:</td><td>'.$status.'</td></tr>
		</table>


	</div>

	<script src="'.plugin_dir_url( __FILE__ ).'admin/plugins/select2/select2.min.js"></script>
	<script>

    </script>
	';

	echo $data_donasi;


    wp_die();
}
add_action( 'wp_ajax_djafunction_get_mydonasi', 'djafunction_get_mydonasi' );
add_action( 'wp_ajax_nopriv_djafunction_get_mydonasi', 'djafunction_get_mydonasi' );



function djafunction_update_donasi(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

    // FROM INPUT
    $id 		 = $_POST['datanya'][0];
    $user_id 	 = $_POST['datanya'][1];
    $name 		 = $_POST['datanya'][2];
    $whatsapp 	 = $_POST['datanya'][3];
    $email 		 = $_POST['datanya'][4];
    $comment 	 = $_POST['datanya'][5];
    $nominal 	 = $_POST['datanya'][6];
    $anonim 	 = $_POST['datanya'][7];
    $user_randid = $_POST['datanya'][8];
    $cs_id 		 = $_POST['datanya'][9];

    if($anonim==''){
    	$anonim = 0;
    }else{
    	$anonim = 1;
    }

    if($cs_id==''){
    	$cs_id = null;
    }

	// ACTION Update TO DB tanpa form_type dan packaged
 	$a = $wpdb->update(
        $table_name, //table
        array(
            'user_id' 	=> $user_id,
            'name' 		=> $name,
            'whatsapp' 	=> $whatsapp,
            'email' 	=> $email,
            'comment' 	=> $comment,
            'nominal' 	=> $nominal,
            'anonim' 	=> $anonim,
            'cs_id' 	=> $cs_id,
        ),
        array('id' => $id), //where
        array('%s'), //data format
        array('%s') //where format
    );

	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_update_donasi', 'djafunction_update_donasi' );
add_action( 'wp_ajax_nopriv_djafunction_update_donasi', 'djafunction_update_donasi' );



function djafunction_upload_ss()
{

    global $wpdb;
    $table_name = $wpdb->prefix . "dja_aff_payout";

    $id = $_POST['datanya'][0];
    $image = $_POST['datanya'][1];

    $a = $wpdb->update(
        $table_name, //table
        array(
            'image' 	=> $image,
        ),
        array('id' => $id), //where
        array('%s'), //data format
        array('%s') //where format
    );
   	
   	if($a){
   		echo 'success';
   	}else{
   		echo 'failed';
   	}

   	wp_die();

}
add_action( 'wp_ajax_djafunction_upload_ss', 'djafunction_upload_ss' );
add_action( 'wp_ajax_nopriv_djafunction_upload_ss', 'djafunction_upload_ss' );


function djafunction_cairkan_sekarang()
{

    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";
    $table_name2 = $wpdb->prefix . "dja_category";
    $table_name3 = $wpdb->prefix . "dja_campaign_update";
    $table_name4 = $wpdb->prefix . "dja_donate";
    $table_name5 = $wpdb->prefix . "dja_settings";
    $table_name6 = $wpdb->prefix . "dja_users";
    $table_name7 = $wpdb->prefix . "dja_payment_list";
    $table_name8 = $wpdb->prefix . "dja_aff_code";
    $table_name9 = $wpdb->prefix . "dja_aff_submit";
    $table_name10 = $wpdb->prefix . "dja_aff_click";
    $table_name11 = $wpdb->prefix . "dja_aff_payout";
    
    $action = $_POST['datanya'][0];
    $id_login = wp_get_current_user()->ID;

    $check_user = $wpdb->get_results('SELECT user_bank_name, user_bank_no, user_bank_an from '.$table_name6.' where user_id="'.$id_login.'"');

	if($check_user!=null){
		$bank_name = $check_user[0]->user_bank_name;
		$bank_no = $check_user[0]->user_bank_no;
		$bank_an = $check_user[0]->user_bank_an;

		if($bank_name=='' || $bank_no=='' || $bank_an==''){
			echo 'bank_not_valid';
   			wp_die();
		}

	}

   	$rows_aff = $wpdb->get_results("SELECT a.id, a.campaign_id, a.aff_code, a.user_id as fundraiser_id, c.user_randid, c.user_pp_img from $table_name8 a 
                left JOIN $table_name6 c ON a.user_id = c.user_id
                where a.user_id=$id_login
                ORDER BY a.id DESC");

    $no = 1;
    $belum_dicairkan = 0;
    $data_id = '';
    foreach ($rows_aff as $row) { 
        // 0 = not payout
        // 1 = paid
        // 2 = on process

        $count_submit3 = $wpdb->get_results("SELECT a.id, a.donate_id, a.nominal_commission  FROM $table_name9 a 
            left JOIN $table_name4 b ON b.id = a.donate_id
            where a.affcode_id='$row->id' and a.payout_status='0' and b.status='1' ");

        // print_r($count_submit3);

        if($count_submit3==null){
            $total_belum_dicairkan = 0;
        }else{
        	foreach ($count_submit3 as $row2) {
        		// echo $row2->donate_id.' | ';
        		$total_belum_dicairkan = $row2->nominal_commission;
            
	            // Update table dja_aff_submit > payout_status : 2
	            $wpdb->update(
			        $table_name9, //table
			        array(
			            'payout_status' => 2,
			        ),
			        array('id' => $row2->id), //where
			        array('%s'), //data format
			        array('%s') //where format
			    );

			    $data_id .= $row2->id.',';
				
				$belum_dicairkan = $belum_dicairkan+$total_belum_dicairkan;

        	}
        }

        $no++; 
    }

    $payout_number = 'INVP-'.strtoupper(d_randomString(5));

    // insert table dja_aff_payout
    $wpdb->insert(
        $table_name11, //table
        array(
            'payout_number' => $payout_number,
            'user_id' 		=> $id_login,
            'aff_submit_id' => $data_id,
            'nominal_payout' => $belum_dicairkan,
            'bank_name' 	=> $bank_name,
            'bank_no' 		=> $bank_no,
            'bank_an' 		=> $bank_an,
            'status' 		=> 0,
            'created_at' 	=> date("Y-m-d H:i:s"),
            'updated_at' 	=> date("Y-m-d H:i:s"),
        ),
        array('%s', '%s') //data format         
    );

   	echo 'success';
   	
   	wp_die();

}
add_action( 'wp_ajax_djafunction_cairkan_sekarang', 'djafunction_cairkan_sekarang' );
add_action( 'wp_ajax_nopriv_djafunction_cairkan_sekarang', 'djafunction_cairkan_sekarang' );




function djafunction_update_fundraising_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
	$fundraiser_on = $_POST['datanya'][0];
    $fundraiser_text = $_POST['datanya'][1];
    $fundraiser_button = $_POST['datanya'][2];

    $fundraiser_commission_on = $_POST['datanya'][3];
    $fundraiser_commission_type = $_POST['datanya'][4];
    $fundraiser_commission_percent = $_POST['datanya'][5];
    $fundraiser_commission_fixed = $_POST['datanya'][6];

    $fundraiser_wa_on = $_POST['datanya'][7];
    $fundraiser_email_on = $_POST['datanya'][8];
    $fundraiser_wa_text = str_replace('\\', '', $_POST['datanya'][9]);
    $fundraiser_email_text = str_replace('\\', '', $_POST['datanya'][10]);

    $min_payout_setting = $_POST['datanya'][11];
    $min_payout = $_POST['datanya'][12];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_on ), array('type' => 'fundraiser_on'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_text ), array('type' => 'fundraiser_text'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_button ), array('type' => 'fundraiser_button'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_commission_on ), array('type' => 'fundraiser_commission_on'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_commission_type ), array('type' => 'fundraiser_commission_type'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_commission_percent ), array('type' => 'fundraiser_commission_percent'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_commission_fixed ), array('type' => 'fundraiser_commission_fixed'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_wa_on ), array('type' => 'fundraiser_wa_on'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_email_on ), array('type' => 'fundraiser_email_on'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_wa_text ), array('type' => 'fundraiser_wa_text'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fundraiser_email_text ), array('type' => 'fundraiser_email_text'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $min_payout_setting ), array('type' => 'min_payout_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $min_payout ), array('type' => 'min_payout'), array('%s'), array('%s') );
	
        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_fundraising_settings', 'djafunction_update_fundraising_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_fundraising_settings', 'djafunction_update_fundraising_settings' );


function djafunction_delete_pencairan(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_aff_payout";
    $table_name2 = $wpdb->prefix . "dja_aff_submit";

    // FROM INPUT
    $id 	= $_POST['datanya'][0];

    // payout_status :
    // 0 = not payout
    // 1 = paid
    // 2 = on process

    $set_payout_status = 0;

    $check_data = $wpdb->get_results('SELECT * from '.$table_name.' where id="'.$id.'" ')[0];
    $data_aff_submit = $check_data->aff_submit_id;

    if(strpos($data_aff_submit, ',') !== false) {
	    $var=explode(',',$data_aff_submit);

	   	foreach($var as $idnya_aff_submit)
	    {
	       $wpdb->update(
		        $table_name2, //table
		        array(
		            'payout_status' => $set_payout_status,
		        ),
		        array('id' => $idnya_aff_submit), //where
		        array('%s'), //data format
		        array('%s') //where format
		    );
	    }

	}else{
		$idnya_aff_submit = $data_aff_submit;
		$wpdb->update(
	        $table_name2, //table
	        array(
	            'payout_status' => $set_payout_status,
	        ),
	        array('id' => $idnya_aff_submit), //where
	        array('%s'), //data format
	        array('%s') //where format
	    );
	}

    // table dja_aff_payout : 
    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {
		// then delete
        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );
    }

	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_delete_pencairan', 'djafunction_delete_pencairan' );
add_action( 'wp_ajax_nopriv_djafunction_delete_pencairan', 'djafunction_delete_pencairan' );



function djafunction_update_status_payment()
{

    global $wpdb;
    $table_name = $wpdb->prefix . "dja_aff_payout";
    $table_name2 = $wpdb->prefix . "dja_aff_submit";
    $table_name3 = $wpdb->prefix . "dja_settings";
    $table_name4 = $wpdb->prefix . "dja_users";
    $table_name5 = $wpdb->prefix . "users";
    
    $id = $_POST['datanya'][0];
    $status_payment = $_POST['datanya'][1];

    $check_data = $wpdb->get_results('SELECT a.*, b.user_wa, c.user_email from '.$table_name.' a
    left JOIN '.$table_name4.' b ON b.user_id = a.user_id
    left JOIN '.$table_name5.' c ON c.ID = a.user_id
    where a.id="'.$id.'" ');

    if($check_data!=null){
	    $data_aff_submit = $check_data[0]->aff_submit_id;
	    $user_wa = $check_data[0]->user_wa;
	    $user_email = $check_data[0]->user_email;
    }else{
    	echo 'failed_0';
    	wp_die();
    }
   

    // GET SETTINGS
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name3.' where type="currency" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_on" or type="email_on" or type="fundraiser_wa_on" or type="fundraiser_email_on" or type="fundraiser_wa_text" or type="fundraiser_email_text" ORDER BY id ASC');
    $currency 		= $query_settings[0]->data;
    $wanotif_url 	= $query_settings[1]->data;
    $wanotif_apikey	= $query_settings[2]->data;
    $wanotif_on 	= $query_settings[3]->data;
    $email_on 		= $query_settings[4]->data;
    $fundraiser_wa_on		= $query_settings[5]->data;
    $fundraiser_email_on	= $query_settings[6]->data;
    $fundraiser_wa_text		= $query_settings[7]->data;
    $fundraiser_email_text	= $query_settings[8]->data;

    $send_notif = false;
    if($status_payment=='2'){
    	$status_payment = '1';
    	$send_notif = true;
    }

    // print_r($send_notif);
    // wp_die();

    if($send_notif==true){

	    $row = $wpdb->get_results('SELECT nominal_payout as nominal, payout_number, user_id from '.$table_name.'
		    where id="'.$id.'" ')[0];

	    $user_info = get_userdata($row->user_id);
	    if($user_info->last_name==''){
	    	$fullname = $user_info->first_name;
	    	$email = $user_info->user_email;
	    }else{
	    	$fullname = $user_info->first_name.' '.$user_info->last_name;
	    	$email = $user_info->user_email;
	    }
	    
	    $data_field = array();
	    $data_field[ '{email}' ] 			= $email;
	    $data_field[ '{name}' ] 			= $fullname;
	    $data_field[ '{payout_number}' ] 	= $row->payout_number;
	    
	    if($currency=='IDR'){
	    	$data_field[ '{nominal}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
	    	$nominalnya = 'Rp '.number_format($row->nominal,0,",",".");
	    }else{
	    	$data_field[ '{nominal}' ] 	= $row->nominal;
	    	$nominalnya = $row->nominal;
	    }
	   
	    $messagenya = strtr($fundraiser_wa_text, $data_field);
		$phone = djaPhoneFormat($user_wa);

    	if($wanotif_on=='1' and $fundraiser_wa_on=='1'){

    		// send wa_notif
			$url = $wanotif_url.'/send';
			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl, CURLOPT_HEADER, 0);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_TIMEOUT,30);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, array(
			    'Apikey'    => $wanotif_apikey,
			    'Phone'     => $phone,
			    'Message'   => $messagenya,
			));
			$response = curl_exec($curl);
			curl_close($curl);
    	}

    	if($email_on=='1' and $fundraiser_email_on=='1'){

    		$fundraiser_email_text = json_decode($fundraiser_email_text);

			foreach($fundraiser_email_text as $key => $value) {

	            $message = $value->message;
	            $message = strtr($message, $data_field);
				$message = str_replace('<p>linebreak</p>', '', $message);
				$message = str_replace('linebreak', '', $message);
				
	            $subject = $value->subject;
	            $subject = strtr($subject, $data_field);
				$subject = str_replace("'","",$subject);
				
	            $emailnya = $value->email;
				
	            $emailnyacc = $value->emailcc;
	            $emailnyabcc = $value->emailbcc;

	            $headers[] = 'Content-Type: text/html; charset=UTF-8';

	            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

				if (strpos($emailnyacc, ',') !== false ) {
					$array_emailcc  = (explode(",", $emailnyacc));
					foreach ($array_emailcc as $values){
						$email_cc = strtr($values, $data_field);
						$headers[] = 'Cc: '.$email_cc;
					}
				}else{
					$emailnyacc = strtr($emailnyacc, $data_field);
					$headers[] = 'Cc: '.$emailnyacc;
				}

				if (strpos($emailnyabcc, ',') !== false ) {
					$array_emailbcc  = (explode(",", $emailnyabcc));
					foreach ($array_emailbcc as $values){
						$email_bcc = strtr($values, $data_field);
						$headers[] = 'Bcc: '.$email_bcc;
					}
				}else{
					$emailnyabcc = strtr($emailnyabcc, $data_field);
					$headers[] = 'Bcc: '.$emailnyabcc;
				}
				
	 			
				if($emailnya!=''){
					$emailnya = strtr($emailnya, $data_field);
					wp_mail( $emailnya, $subject, $body, $headers );
				}
					
				

			}

    	}

    }


    // table dja_aff_submit 
    // 0 => On Process =====> t_dja_aff_submit : set payout_status = 2
    // 1 dan 2 => PAID =====> t_dja_aff_submit : set payout_status = 1

    if($status_payment=='1'){
    	$set_payout_status = 1;
    }else{
    	$set_payout_status = 2;
    }

    if(strpos($data_aff_submit, ',') !== false) {
	    $var=explode(',',$data_aff_submit);

	   	foreach($var as $idnya_aff_submit)
	    {
	       $wpdb->update(
		        $table_name2, //table
		        array(
		            'payout_status' => $set_payout_status,
		        ),
		        array('id' => $idnya_aff_submit), //where
		        array('%s'), //data format
		        array('%s') //where format
		    );
	    }

	}else{
		$idnya_aff_submit = $data_aff_submit;
		$wpdb->update(
	        $table_name2, //table
	        array(
	            'payout_status' => $set_payout_status,
	        ),
	        array('id' => $idnya_aff_submit), //where
	        array('%s'), //data format
	        array('%s') //where format
	    );
	}

    // table dja_aff_payout : 
    $a = $wpdb->update(
        $table_name, //table
        array(
            'status' 	=> $status_payment,
        ),
        array('id' => $id), //where
        array('%s'), //data format
        array('%s') //where format
    );

   	
   	// if($a){
   		echo 'success_'.$status_payment;
   	// }else{
   	// 	echo 'failed_0';
   	// }

   	wp_die();

}
add_action( 'wp_ajax_djafunction_update_status_payment', 'djafunction_update_status_payment' );
add_action( 'wp_ajax_nopriv_djafunction_update_status_payment', 'djafunction_update_status_payment' );



function djafunction_download_donasi(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

    // FROM INPUT
    $id_campaign 		= $_POST['datanya'][0];

	$DB_TBLName = "your_table_name"; 
	$filename = "excelfilename";  //your_file_name
	$file_ending = "xls";   //file_extention

	header("Content-Type: application/xls");    
	header("Content-Disposition: attachment; filename=$filename.'.'.$file_ending");  
	header("Pragma: no-cache"); 
	header("Expires: 0");

	$sep = "\t";

	// $sql="SELECT * FROM $DB_TBLName"; 

	$sql = $wpdb->get_results('SELECT * from '.$table_name.' ORDER BY id ASC');

	// $resultt = $con->query($sql);
	while ($property = mysqli_fetch_field($sql)) { //fetch table field name
	    echo $property->name."\t";
	}

	print("\n");    

	while($row = mysqli_fetch_row($resultt))  //fetch_table_data
	{
	    $schema_insert = "";
	    for($j=0; $j< mysqli_num_fields($resultt);$j++)
	    {
	        if(!isset($row[$j]))
	            $schema_insert .= "NULL".$sep;
	        elseif ($row[$j] != "")
	            $schema_insert .= "$row[$j]".$sep;
	        else
	            $schema_insert .= "".$sep;
	    }
	    $schema_insert = str_replace($sep."$", "", $schema_insert);
	    $schema_insert = preg_replace("/\r\n|\n\r|\n|\r/", " ", $schema_insert);
	    $schema_insert .= "\t";
	    print(trim($schema_insert));
	    print "\n";
	}


	// echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_download_donasi', 'djafunction_download_donasi' );
add_action( 'wp_ajax_nopriv_djafunction_download_donasi', 'djafunction_download_donasi' );



function download_donasi()
{
    if ( ! current_user_can( 'manage_options' ) )
        return;

    global $wpdb;
   
    $table_name = $wpdb->prefix . "dja_donate";
    $c_id = $_GET['c_id'];
    $date_filter = $_GET['c_date'];
    $date_range = $_GET['c_range'];

    $filternya = "";
    if($date_filter=='today' || $date_filter=='yesterday' || $date_filter=='7lastdays' || $date_filter=='30lastdays' || $date_filter=='thismonth' || $date_filter=='lastmonth' || $date_filter=='daterange' || $date_filter=='all'){
    
        // Date
        $today = date('Y-m-d');
        $yesterday = date("Y-m-d", strtotime("-1 day"));
        $one_week_ago = date("Y-m-d", strtotime("-7 day"));
        $one_month_ago = date("Y-m-d", strtotime("-30 day"));
        $three_months_ago = date("Y-m-d", strtotime("-90 day"));
        $thismonth = date("Y-m-01");
        
        $month = date('m');
        $year = date('Y');
        if($month==1){
        	$monthnya = 12;
        	$yearnya = $year-1;
        }else{
        	$monthnya = $month-1;
        	$yearnya = $year;
        }
		$lastmonth_firstrange = date($yearnya."-".$monthnya."-01");
		$lastmonth_lastrange = date($yearnya."-".$monthnya."-31");

		if($date_range!=''){
			$date_range = explode('_',$date_range);
			$date_range_first = date($date_range[0]);
			$date_range_last = date($date_range[1]);
		}else{
			$date_range_first = $today;
			$date_range_last = $today;
		}
		

        if($date_filter=='today'){
            $filternya = "and a.created_at BETWEEN '$today 00:00' AND '$today 23:59'";
        }elseif($date_filter=='yesterday'){
            $filternya = "and a.created_at BETWEEN '$yesterday 00:00' AND '$yesterday 23:59'";
        }elseif($date_filter=='7lastdays'){
            $filternya = "and a.created_at BETWEEN '$one_week_ago 00:00' AND '$today 23:59'";
        }elseif($date_filter=='30lastdays'){
            $filternya = "and a.created_at BETWEEN '$one_month_ago 00:00' AND '$today 23:59'";
        }elseif($date_filter=='3months'){
            $filternya = "and a.created_at BETWEEN '$three_months_ago 00:00' AND '$today 23:59'";
        }elseif($date_filter=='thismonth'){
            $filternya = "and a.created_at BETWEEN '$thismonth 00:00' AND '$today 23:59'";
        }elseif($date_filter=='lastmonth'){
            $filternya = "and a.created_at BETWEEN '$lastmonth_firstrange 00:00' AND '$lastmonth_lastrange 23:59'";
        }elseif($date_filter=='daterange'){
            $filternya = "and a.created_at BETWEEN '$date_range_first 00:00' AND '$date_range_last 23:59'";
        }else{
            $filternya = "";
        }

        // and a.created_at BETWEEN '2022-03-28 00:00' AND '2022-04-27 23:59'
    }

    require_once(ROOTDIR_DNA . 'admin/f_download_excel.php');

	wp_die();
	
}
add_action( 'admin_post_download_data_donasi', 'download_donasi' );
add_action( 'admin_post_nopriv_download_data_donasi', 'download_donasi' );


function upload_donasi()
{
    if ( ! current_user_can( 'manage_options' ) )
        return;

    global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

    // $uploadedfile 	= $_POST['info'][0];
    $c_id = $_POST['cid'];

    if ( ! function_exists( 'wp_handle_upload' ) ) require_once( ABSPATH . 'wp-admin/includes/file.php' );
	$uploadedfile = $_FILES['file'];
	$upload_overrides = array( 'test_form' => false );
	$movefile = wp_handle_upload( $uploadedfile, $upload_overrides );
	if ( $movefile ) {
	    
	    // echo "File is valid, and was successfully uploaded.\n";
	    // var_dump( $movefile);
	    require_once(ROOTDIR_DNA . 'admin/f_upload_excel.php');

	    // echo 'success';

	} else {
	    echo "failed";
	}
   
    exit();

}
add_action( 'admin_post_upload_donasi', 'upload_donasi' );
add_action( 'admin_post_nopriv_upload_donasi', 'upload_donasi' );




function download_template_excel()
{
    if ( ! current_user_can( 'manage_options' ) )
        return;

    $fileurl = plugin_dir_path(__FILE__).'admin/assets/files/template_upload_donasi.xls';

	header("Content-type:application/xls");
	header('Content-Disposition: attachment; filename=template_upload_donasi.xls');
	readfile( $fileurl );

	exit;
	
}
add_action( 'admin_post_download_template_excel', 'download_template_excel' );
add_action( 'admin_post_nopriv_download_template_excel', 'download_template_excel' );


function djafunction_del_donasi(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_love";

    // FROM INPUT
    $donasi_id 	= $_POST['datanya'][0];

    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $donasi_id ) ) ) {
		// then delete
        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$donasi_id.'" ' ) );
    }
    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name2.' WHERE donate_id = %d', $donasi_id ) ) ) {
		// then delete campaign update
        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name2.' WHERE donate_id = "'.$donasi_id.'" ' ) );
    }

	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_del_donasi', 'djafunction_del_donasi' );
add_action( 'wp_ajax_nopriv_djafunction_del_donasi', 'djafunction_del_donasi' );


function djafunction_del_confirmation(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

    // FROM INPUT
    $donasi_id 		= $_POST['datanya'][0];
    $img_url 		= $_POST['datanya'][1];
    $invoice_id 	= $_POST['datanya'][2];

    $attachment_id = attachment_url_to_postid( $img_url );

    if ( false === wp_delete_attachment( $attachment_id, true ) ) {
	    $file = get_attached_file( $attachment_id );
	    $file = str_replace( "uploads", "upload-assets", $file);
	    wp_delete_file( $file );
    }

    $a = $wpdb->update(
        $table_name, //table
        array(
            'img_confirmation_url' 	=> null,
            'img_confirmation_status' => null,
            'img_confirmation_date' => null,
        ),
        array('invoice_id' => $invoice_id), //where
        array('%s'), //data format
        array('%s') //where format
    );

	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_del_confirmation', 'djafunction_del_confirmation' );
add_action( 'wp_ajax_nopriv_djafunction_del_confirmation', 'djafunction_del_confirmation' );


function djafunction_update_csrotator() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";
    $table_name2 = $wpdb->prefix . "dja_settings";
    
    // FROM INPUT
    $campaign_id 	= $_POST['datanya'][0];
    $cs_rotator  = str_replace('\\', '', $_POST['datanya'][1]);

    $a = $wpdb->update(
	            $table_name, //table
	            array(
		            'cs_rotator' => $cs_rotator
		        ),
	            array('campaign_id' => $campaign_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

	if($a === FALSE){
		echo 'failed_'.$campaign_id;
	}else{
		echo 'success_'.$campaign_id;
	}

	// }else{
	// 	echo 'failed_0';
	// }

    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_csrotator', 'djafunction_update_csrotator' );
add_action( 'wp_ajax_nopriv_djafunction_update_csrotator', 'djafunction_update_csrotator' );




function djafunction_update_campaign() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";
    $table_name2 = $wpdb->prefix . "dja_settings";
    
    // FROM INPUT
    $campaign_id 	= $_POST['datanya'][0];
    $title 			= $_POST['datanya'][1];
    $slug 			= $_POST['datanya'][2];
    $image_url 		= $_POST['datanya'][3];
    $information 	= $_POST['datanya'][4];
    $target 		= $_POST['datanya'][5];
    $end_date 		= $_POST['datanya'][6];
    $location_name 	= $_POST['datanya'][7];
    $location_gmaps = $_POST['datanya'][8];
    $category_id 	= $_POST['datanya'][9];
    $publish_status = $_POST['datanya'][10];
    $id 			= $_POST['datanya'][11];
    $form_base 		= $_POST['datanya'][12];
    $form_type 		= $_POST['datanya'][13];
    $packaged 		= $_POST['datanya'][14];
    $packaged_title = $_POST['datanya'][15];
    $act 			= $_POST['datanya'][16];
    $payment_status = $_POST['datanya'][17];
    $bank_account 	= str_replace('\\', '', $_POST['datanya'][18]);
    $form_status 	= $_POST['datanya'][19];
    $form_text 		= str_replace('\\', '', $_POST['datanya'][20]);
    $unique_number_setting  = $_POST['datanya'][21];
    $unique_number_value  	= str_replace('\\', '', $_POST['datanya'][22]);
    $method_status  		= str_replace('\\', '', $_POST['datanya'][23]);
    $notification_status 	= $_POST['datanya'][24];
    $wanotif_message 		= str_replace('\\', '', $_POST['datanya'][25]);
    $pixel_status			= $_POST['datanya'][26];
    $fb_pixel				= $_POST['datanya'][27];
    $fb_event				= str_replace('\\', '', $_POST['datanya'][28]);
    $pengeluaran_setting 	= $_POST['datanya'][29];
    $pengeluaran_title 		= $_POST['datanya'][30];
    $gtm_status 			= $_POST['datanya'][31];
    $gtm_id 				= $_POST['datanya'][32];
    $socialproof 			= $_POST['datanya'][33];
    $socialproof_text 		= $_POST['datanya'][34];
    $socialproof_position 	= $_POST['datanya'][35];
    $tiktok_status 			= $_POST['datanya'][36];
    $tiktok_pixel 			= $_POST['datanya'][37];
    $zakat_setting 			= $_POST['datanya'][38];
    $zakat_percent 			= $_POST['datanya'][39];
    $fundraiser_setting 	= $_POST['datanya'][40];
    $fundraiser_on 			= $_POST['datanya'][41];
    $fundraiser_text 		= $_POST['datanya'][42];
    $fundraiser_button 		= $_POST['datanya'][43];
    $fundraiser_commission_on 		= $_POST['datanya'][44];
    $fundraiser_commission_type 	= $_POST['datanya'][45];
    $fundraiser_commission_percent 	= $_POST['datanya'][46];
    $fundraiser_commission_fixed   	= $_POST['datanya'][47];
    $additional_info				= str_replace('\\', '', $_POST['datanya'][48]);
    $additional_formula				= str_replace('\\', '', $_POST['datanya'][49]);
    $additional_field				= str_replace('\\', '', $_POST['datanya'][50]);
    $custom_field_setting			= str_replace('\\', '', $_POST['datanya'][51]);
    $general_status					= str_replace('\\', '', $_POST['datanya'][52]);
    $allocation_title				= str_replace('\\', '', $_POST['datanya'][53]);
    $allocation_others_title		= str_replace('\\', '', $_POST['datanya'][54]);
    $donatur_name					= str_replace('\\', '', $_POST['datanya'][55]);
    $donatur_others_name			= str_replace('\\', '', $_POST['datanya'][56]);
    $home_icon_url   		= $_POST['datanya'][57];
    $back_icon_url   		= $_POST['datanya'][58];
    $opt_nominal   			= str_replace('\\', '', $_POST['datanya'][59]);
    $minimum_donate   		= $_POST['datanya'][60];
    $cs_rotator   			= str_replace('\\', '', $_POST['datanya'][61]);
    $wanotif_device   		= $_POST['datanya'][62];
    $opt_qurban   			= str_replace('\\', '', $_POST['datanya'][63]);
    $opt_package2   		= str_replace('\\', '', $_POST['datanya'][64]);
    $opt_zfitrah	   		= str_replace('\\', '', $_POST['datanya'][65]);


    $title = str_replace("'", "&#39;", $title); // petik 1
    $title = str_replace('"', "&#34;", $title); // petik 2
    $title = str_replace('\\', '', $title); // backslash

    $slug = str_replace('?', '', $slug); // backslash

    // $information = str_replace("'", "&#39;", $information); // petik 1
    // $information = str_replace('"', "&#34;", $information); // petik 2
    $information = str_replace('\\', '', $information); // backslash
    // $information = str_replace('../wp-content', home_url().'/wp-content', $information); // backslash 
    // $information = 'oke';

    // Settingsdjafunction_update_info
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="form_setting" ORDER BY id ASC');
    $form_setting = $query_settings[0]->data;

    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

    // get data campaign to check user cannot modify the campaign id
    $row = $wpdb->get_results('SELECT * from '.$table_name.' where campaign_id="'.$campaign_id.'" and id="'.$id.'"');

    if($row!=null){

    	// publish status form donatur, status can not change from page editor. set default from data campaign
	    if($role=='donatur'){
	    	$publish_status = $row[0]->publish_status;
	    }

	    // DEFAULT
	    $slug = d_formatUri($slug);

	    if($slug==''){
	    	$slug = d_formatUri($title);
	    }

	    if(strpos($image_url, 'donasiaja-cover.jpg') !== false) {
		    $image_url = null;
		}
		if($end_date==''){
			$end_date = null;
		}

	    // cek slug
    	$jumlah_slug = $wpdb->get_results("SELECT id from $table_name where slug='$slug' ");
    	if($jumlah_slug==null){
	    	$slug = $slug;
    	}else{

    		if(count($jumlah_slug)==1){
    			$jumlah_slug_bawaan = $wpdb->get_results("SELECT id from $table_name where slug='$slug' and campaign_id='$campaign_id' ");
    			if($jumlah_slug_bawaan!=null){
    				$slug = $slug;
    			}else{
    				$slug = $slug.'-'.d_randomString(3);
    			}
    		}else{
    			$count = count($jumlah_slug)+1;
		    	$slug = $slug.'-'.d_randomString(3);
    		}
    	}

    	// action status
    	if($act=='draft'){
    		$publish_status = 0;
    	}

		
		if($role=='donatur'){
    		
    		// tidak boleh setting form
    		if($form_setting!='1'){
    			$form_type = '1';
    			$packaged = '0';
    			$packaged_title = '';
    		}
    		if($act=='publish'){
	    		$publish_status = 2;
	    	}

	    	// ACTION Update TO DB tanpa form_type dan packaged
		 	$a = $wpdb->update(
	            $table_name, //table
	            array(
		            'campaign_id' 	=> $campaign_id,
		            'title' 		=> $title,
		            'slug' 			=> $slug,
		            'target' 		=> $target,
		            'image_url' 	=> $image_url,
		            'information' 	=> $information,
		            'location_name' => $location_name,
		            'location_gmaps'=> $location_gmaps,
		            'publish_status'=> $publish_status,
		            'category_id'	=> $category_id,
		            'end_date' 		=> $end_date,
		            'form_base' 	=> $form_base,
		            'form_type' 	=> $form_type,
		            'packaged' 		=> $packaged,
		            'packaged_title'=> $packaged_title,
		        ),
	            array('campaign_id' => $campaign_id), //where
	            array('%s'), //data format
	            array('%s') //where format
	        );
			
    	}else{
		
		    // ACTION Update TO DB
			$a = $wpdb->update(
	            $table_name, //table
	            array(
		            'campaign_id' 	=> $campaign_id,
		            'title' 		=> $title,
		            'slug' 			=> $slug,
		            'target' 		=> $target,
		            'image_url' 	=> $image_url,
		            'information' 	=> $information,
		            'location_name' => $location_name,
		            'location_gmaps'=> $location_gmaps,
		            'publish_status'=> $publish_status,
		            'category_id'	=> $category_id,
		            'end_date' 		=> $end_date,
		            'form_base' 	=> $form_base,
		            'form_type' 	=> $form_type,
		            'packaged' 		=> $packaged,
		            'packaged_title'=> $packaged_title,
		            'payment_status'=> $payment_status,
		            'method_status' => $method_status,
		            'bank_account'	=> $bank_account,
		            'form_status'	=> $form_status,
		            'form_text'		=> $form_text,
		            'unique_number_setting'	=> $unique_number_setting,
		            'unique_number_value'	=> $unique_number_value,
		            'notification_status'	=> $notification_status,
		            'wanotif_message'		=> $wanotif_message,
		            'pixel_status'			=> $pixel_status,
		            'fb_pixel'				=> $fb_pixel,
		            'fb_event'				=> $fb_event,
		            'pengeluaran_setting'	=> $pengeluaran_setting,
		            'pengeluaran_title'		=> $pengeluaran_title,
		            'gtm_status'			=> $gtm_status,
		            'gtm_id'				=> $gtm_id,
		            'socialproof'			=> $socialproof,
		            'socialproof_text'		=> $socialproof_text,
		            'socialproof_position'	=> $socialproof_position,
		            'tiktok_status'			=> $tiktok_status,
		            'tiktok_pixel'			=> $tiktok_pixel,
		            'zakat_setting'			=> $zakat_setting,
		            'zakat_percent'			=> $zakat_percent,
		            'fundraiser_setting'	=> $fundraiser_setting,
		            'fundraiser_on'			=> $fundraiser_on,
		            'fundraiser_text'		=> $fundraiser_text,
		            'fundraiser_button'		=> $fundraiser_button,
		            'fundraiser_commission_on'		=> $fundraiser_commission_on,
		            'fundraiser_commission_type'	=> $fundraiser_commission_type,
		            'fundraiser_commission_percent'	=> $fundraiser_commission_percent,
		            'fundraiser_commission_fixed'	=> $fundraiser_commission_fixed,
		            'additional_info'				=> $additional_info,
		            'additional_formula'			=> $additional_formula,
		            'additional_field'				=> $additional_field,
		            'custom_field_setting'			=> $custom_field_setting,
		            'general_status'				=> $general_status,
		            'allocation_title'				=> $allocation_title,
		            'allocation_others_title'		=> $allocation_others_title,
		            'donatur_name'					=> $donatur_name,
		            'donatur_others_name'			=> $donatur_others_name,
		            'home_icon_url'					=> $home_icon_url,
		            'back_icon_url'					=> $back_icon_url,
		            'minimum_donate'				=> $minimum_donate,
		            'opt_nominal'					=> $opt_nominal,
		            'opt_qurban'					=> $opt_qurban,
		            'opt_package2'					=> $opt_package2,
		            'opt_zfitrah'					=> $opt_zfitrah,
		            'cs_rotator'					=> $cs_rotator,
		            'wanotif_device'				=> $wanotif_device,
		        ),
	            array('campaign_id' => $campaign_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

		 }

		if($a === FALSE){
			echo 'failed_'.$campaign_id;
		}else{
			echo 'success_'.$campaign_id;
		}

	}else{
		echo 'failed_0';
	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_campaign', 'djafunction_update_campaign' );
add_action( 'wp_ajax_nopriv_djafunction_update_campaign', 'djafunction_update_campaign' );




function djafunction_update_info() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign_update";
    
    // FROM INPUT
    $id 			= $_POST['datanya'][0];
    $campaign_id 	= $_POST['datanya'][1];
    $title 			= $_POST['datanya'][2];
    $information 	= $_POST['datanya'][3];

    $title = str_replace("'", "&#39;", $title); // petik 1
    $title = str_replace('"', "&#34;", $title); // petik 2
    $title = str_replace('\\', '', $title);

    // $information = str_replace("'", "&#39;", $information); // petik 1
    // $information = str_replace('"', "&#34;", $information); // petik 2
    $information = str_replace('\\', '', $information);


    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

    $id_login = wp_get_current_user()->ID;


	if($role=='donatur'){

		// cek dulu sama gak dengan id si donatur
		$row = $wpdb->get_results('SELECT * from '.$table_name.' where campaign_id="'.$campaign_id.'" and id="'.$id.'" and user_id="'.$id_login.'" ');

		if($row!=null){
			// ACTION Update TO DB tanpa form_type dan packaged
		    $wpdb->update(
	            $table_name, //table
	            array(
		            'title' 		=> $title,
		            'information' 	=> $information
		        ),
	            array('id' => $id, 'campaign_id' => $campaign_id, 'user_id' => $id_login), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );
	        echo $id;
		}else{
			echo 'failed';
		}
    	
	}else{
	    // ACTION Update TO DB
	    $wpdb->update(
            $table_name, //table
            array(
	            'title' 		=> $title,
	            'information' 	=> $information
	        ),
            array('id' => $id, 'campaign_id' => $campaign_id), //where
            array('%s'), //data format
            array('%s') //where format    
        );
        echo $id;
	}
	
    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_info', 'djafunction_update_info' );
add_action( 'wp_ajax_nopriv_djafunction_update_info', 'djafunction_update_info' );




function djafunction_delete_campaign() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";
    $table_name2 = $wpdb->prefix . "dja_campaign_update";
    $table_name3 = $wpdb->prefix . "dja_donate";
    $table_name4 = $wpdb->prefix . "dja_love";
    $table_name5 = $wpdb->prefix . "dja_settings";

    
    // FROM INPUT
    $id 			= $_POST['datanya'][0];
    $campaign_id 	= $_POST['datanya'][1];

    // GET INFO DONATE
    $info_donate = $wpdb->get_results('SELECT COUNT(id) as jumlah from '.$table_name3.' where campaign_id="'.$campaign_id.'" ')[0];
    $jumlah_donate = $info_donate->jumlah;

    // Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="del_campaign_setting" ORDER BY id ASC');
    $del_campaign_setting = $query_settings[0]->data;

    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

    $id_login = wp_get_current_user()->ID;

    
	if($role=='donatur'){

		// cek dulu sama gak dengan id si donatur
		$row = $wpdb->get_results('SELECT * from '.$table_name.' where campaign_id="'.$campaign_id.'" and id="'.$id.'" and user_id="'.$id_login.'" ');

		// jika data donasi sudah ada yang donasi, maka gak boleh hapus
		if($jumlah_donate!=0){

			if($del_campaign_setting!='1'){
				echo 'not allowed';
			}else{
				if($row!=null){
					// ACTION Update TO DB

				    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {
					// then delete
				        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );
				    }
				    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name2.' WHERE campaign_id = %d', $campaign_id ) ) ) {
						// then delete campaign update
				        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name2.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
				    }
				    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name3.' WHERE campaign_id = %d', $campaign_id ) ) ) {
						// then delete donate
				       $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name3.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
				    }
				    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name4.' WHERE campaign_id = %d', $campaign_id ) ) ) {
						// then delete love
				        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name4.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
				    }

				    echo 'success';

				}else{
					echo 'failed';
				}
			}
			
		}else{

			if($row!=null){
				// ACTION Update TO DB

			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {
					// then delete
			        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );
			    }
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name2.' WHERE campaign_id = %d', $campaign_id ) ) ) {
					// then delete campaign update
			        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name2.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
			    }
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name3.' WHERE campaign_id = %d', $campaign_id ) ) ) {
					// then delete donate
			       $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name3.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
			    }
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name4.' WHERE campaign_id = %d', $campaign_id ) ) ) {
					// then delete love
			        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name4.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
			    }

			    echo 'success';

			}else{
				echo 'failed';
			}
			
		}

		
    	
	}else{

		if($jumlah_donate!=0){

			if($del_campaign_setting!='1'){
			    echo 'sudah_ada_donasi';
			}else{
				// ACTION Update TO DB
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {
					// then delete
			        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );
			    }
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name2.' WHERE campaign_id = %d', $campaign_id ) ) ) {
					// then delete campaign update
			        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name2.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
			    }
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name3.' WHERE campaign_id = %d', $campaign_id ) ) ) {
					// then delete donate
			       $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name3.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
			    }
			    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name4.' WHERE campaign_id = %d', $campaign_id ) ) ) {
					// then delete love
			        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name4.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
			    }
			    echo 'success';
			}

		}else{

		    // ACTION Update TO DB
		    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {
				// then delete
		        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );
		    }
		    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name2.' WHERE campaign_id = %d', $campaign_id ) ) ) {
				// then delete campaign update
		        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name2.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
		    }
		    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name3.' WHERE campaign_id = %d', $campaign_id ) ) ) {
				// then delete donate
		       $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name3.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
		    }
		    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT campaign_id FROM '.$table_name4.' WHERE campaign_id = %d', $campaign_id ) ) ) {
				// then delete love
		        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name4.' WHERE campaign_id = "'.$campaign_id.'" ' ) );
		    }

	        echo 'success';
		}
		
	    
	}
	

	// echo $jumlah_info_update;
	
    wp_die();

} 
add_action( 'wp_ajax_djafunction_delete_campaign', 'djafunction_delete_campaign' );
add_action( 'wp_ajax_nopriv_djafunction_delete_campaign', 'djafunction_delete_campaign' );




function djafunction_clone_campaign() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";
    
    // FROM INPUT
    $campaign_id 	= $_POST['datanya'][0];

    $row = $wpdb->get_results('SELECT * from '.$table_name.' where campaign_id="'.$campaign_id.'" ')[0];

    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

    $id_login = wp_get_current_user()->ID;

    $action = false;
	if($role=='donatur'){
		if($id_login==$row->user_id){
			$action = true;
		}else{
			$action = false;
		}
	}else{
		if($role=='administrator'){
			$action = true;
		}else{
			$action = false;
		}
	}

	if($action==true){

		// ACTION INSERT TO DB
		$new_campaign_id = 'dja'.d_randomString(8);
		$id_login = wp_get_current_user()->ID;

		$jumlah_slug = count($wpdb->get_results('SELECT id from '.$table_name.' where slug="'.$row->slug.'"'));
		$slug = d_formatUri($row->title).'-'.d_randomString(3);
	    if($jumlah_slug>1){
	    	$slug = $row->slug.'-'.d_randomString(3);
	    }

	    $a = $wpdb->insert(
            $table_name, //table
            array(
	            'campaign_id' 	=> $new_campaign_id,
	            'title' 		=> $row->title,
	            'slug' 			=> $slug,
	            'target' 		=> $row->target,
	            'image_url' 	=> $row->image_url,
	            'information' 	=> $row->information,
	            'location_name' => $row->location_name,
	            'location_gmaps'=> $row->location_gmaps,
	            'publish_status'=> 0,
	            'reached_status'=> $row->reached_status,
	            
	            'end_date' 		=> $row->end_date,
	            'form_base' 	=> $row->form_base,
	            'form_type' 	=> $row->form_type,
	            'packaged' 		=> $row->packaged,
	            'packaged_title'=> $row->packaged_title,
	            'currency'		=> $row->currency,
	            'category_id'	=> $row->category_id,
	            'user_id'		=> $id_login,

	            'payment_status'=> $row->payment_status,
	            'method_status' => $row->method_status,
	            'bank_account'	=> $row->bank_account,
	            'form_status'	=> $row->form_status,
	            'form_text'		=> $row->form_text,
	            'unique_number_setting'	=> $row->unique_number_setting,
	            'unique_number_value'	=> $row->unique_number_value,
	            'notification_status'	=> $row->notification_status,

	            'wanotif_message'		=> $row->wanotif_message,
	            'pixel_status'			=> $row->pixel_status,
	            'fb_pixel'				=> $row->fb_pixel,
	            'fb_event'				=> $row->fb_event,
	            'pengeluaran_setting'	=> $row->pengeluaran_setting,
	            'pengeluaran_title'		=> $row->pengeluaran_title,
	            'gtm_status'			=> $row->gtm_status,
	            'gtm_id'				=> $row->gtm_id,
	            'tiktok_status'			=> $row->tiktok_status,
			    'tiktok_pixel'			=> $row->tiktok_pixel,
	            'socialproof'			=> $row->socialproof,
	            'socialproof_text'		=> $row->socialproof_text,
	            'socialproof_position'	=> $row->socialproof_position,

	            'zakat_setting'			=> $row->zakat_setting,
				'zakat_percent'			=> $row->zakat_percent,
				'fundraiser_setting'	=> $row->fundraiser_setting,
				'fundraiser_on'			=> $row->fundraiser_on,
				'fundraiser_text'		=> $row->fundraiser_text,
				'fundraiser_button'		=> $row->fundraiser_button,
				'fundraiser_commission_on'		=> $row->fundraiser_commission_on,
				'fundraiser_commission_type'	=> $row->fundraiser_commission_type,
				'fundraiser_commission_percent'	=> $row->fundraiser_commission_percent,
				'fundraiser_commission_fixed'	=> $row->fundraiser_commission_fixed,
				'additional_info'		=> $row->additional_info,
				'additional_formula'	=> $row->additional_formula,
				'additional_field'		=> $row->additional_field,
				'custom_field_setting'	=> $row->custom_field_setting,
				'general_status'		=> $row->general_status,
				'allocation_title'		=> $row->allocation_title,
				'allocation_others_title'	=> $row->allocation_others_title,
				'donatur_name'				=> $row->donatur_name,
				'donatur_others_name'		=> $row->donatur_others_name,

				'home_icon_url'			=> $row->home_icon_url,
				'back_icon_url'			=> $row->back_icon_url,
				'minimum_donate'		=> $row->minimum_donate,
				'opt_nominal'			=> $row->opt_nominal,
				'opt_qurban'			=> $row->opt_qurban,
				'opt_package2'			=> $row->opt_package2,
				'opt_zfitrah'			=> $row->opt_zfitrah,
				'cs_rotator'			=> $row->cs_rotator,
				'wanotif_device'		=> $row->wanotif_device,

	        ),
            array('%s', '%s') //data format  
        );

        echo 'success';

	}else{
		echo 'failed';
	}


    wp_die();

} 
add_action( 'wp_ajax_djafunction_clone_campaign', 'djafunction_clone_campaign' );
add_action( 'wp_ajax_nopriv_djafunction_clone_campaign', 'djafunction_clone_campaign' );


function djafunction_delete_info() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign_update";
    
    // FROM INPUT
    $id 			= $_POST['datanya'][0];
    $campaign_id 	= $_POST['datanya'][1];

    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

    $id_login = wp_get_current_user()->ID;

	if($role=='donatur'){

		// cek dulu sama gak dengan id si donatur
		$row = $wpdb->get_results('SELECT * from '.$table_name.' where campaign_id="'.$campaign_id.'" and id="'.$id.'" and user_id="'.$id_login.'" ');

		if($row!=null){
			// ACTION Update TO DB
		    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {

				// then delete
		        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );

		        echo 'success';
		    }else{
		    	echo 'not allowed';
		    }
		}else{
			echo 'failed';
		}
    	
	}else{
	    // ACTION Update TO DB
	    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {

			// then delete
	        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );

	        echo 'success';
	    }else{
	    	echo 'not allowed';
	    }
	    
	}
	
    wp_die();

} 
add_action( 'wp_ajax_djafunction_delete_info', 'djafunction_delete_info' );
add_action( 'wp_ajax_nopriv_djafunction_delete_info', 'djafunction_delete_info' );





function djafunction_add_update_info() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign_update";
    $table_name2 = $wpdb->prefix . "dja_campaign";
    
    // FROM INPUT
    $user_id 		= $_POST['datanya'][0];
    $campaign_id 	= $_POST['datanya'][1];

    // role
    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];

    // $id_login = wp_get_current_user()->ID;


	if($role=='donatur'){

		// cek dulu sama gak dengan id si donatur
		$row = $wpdb->get_results('SELECT * from '.$table_name2.' where campaign_id="'.$campaign_id.'" and user_id="'.$user_id.'" ');

		if($row!=null){

			// ACTION Update TO DB 
		    $wpdb->insert(
	            $table_name, //table
	            array(
		            'campaign_id' 	=> $campaign_id,
		            'title' 		=> '',
		            'information' 	=> '',
		            'user_id' 		=> $user_id,
		            'created_at' 	=> date("Y-m-d H:i:s")
		        ),
	            array('%s', '%s') //data format         
	        );

	        $lastid = $wpdb->insert_id;
        	echo $lastid;

		}else{
			echo 'failed';
		}
    	
	}else{
	    // ACTION Update TO DB
	    $wpdb->insert(
            $table_name, //table
            array(
	            'campaign_id' 	=> $campaign_id,
	            'title' 		=> '',
	            'information' 	=> '',
	            'user_id' 		=> $user_id,
	            'created_at' 	=> date("Y-m-d H:i:s")
	        ),
            array('%s', '%s') //data format         
        );
        
        $lastid = $wpdb->insert_id;

        echo $lastid;
	}
	
    wp_die();

} 
add_action( 'wp_ajax_djafunction_add_update_info', 'djafunction_add_update_info' );
add_action( 'wp_ajax_nopriv_djafunction_add_update_info', 'djafunction_add_update_info' );




function djafunction_update_text_followup() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    // FROM INPUT
    $btn_followup 			= $_POST['datanya'][0];
    $text_f1 				= $_POST['datanya'][1];
    $text_f2 				= $_POST['datanya'][2];
    $text_f3 				= $_POST['datanya'][3];
    $text_f4 				= $_POST['datanya'][4];
    $text_f5 				= $_POST['datanya'][5];
    $text_received 			= $_POST['datanya'][6];
    $text_received_status 	= $_POST['datanya'][7];
    $wanotif_on_dashboard 	= $_POST['datanya'][8];

    if($text_received_status==''){
    	$text_received_status = 0;
    }else{
    	$text_received_status = 1;
    }

    if($wanotif_on_dashboard==''){
    	$wanotif_on_dashboard = 0;
    }else{
    	$wanotif_on_dashboard = 1;
    }

    $text_f1 = str_replace('\\', '', $text_f1);
    $text_f2 = str_replace('\\', '', $text_f2);
    $text_f3 = str_replace('\\', '', $text_f3);
    $text_f4 = str_replace('\\', '', $text_f4);
    $text_f5 = str_replace('\\', '', $text_f5);
    $text_received = str_replace('\\', '', $text_received);

    // ACTION Update TO DB
    $wpdb->update( $table_name, array('data' => $btn_followup), array('type' => 'btn_followup'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_f1), array('type' => 'text_f1'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_f2), array('type' => 'text_f2'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_f3), array('type' => 'text_f3'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_f4), array('type' => 'text_f4'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_f5), array('type' => 'text_f5'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_received), array('type' => 'text_received'), array('%s'), array('%s') );
    $wpdb->update( $table_name, array('data' => $text_received_status), array('type' => 'text_received_status'), array('%s'), array('%s') );
	$wpdb->update( $table_name, array('data' => $wanotif_on_dashboard), array('type' => 'wanotif_on_dashboard'), array('%s'), array('%s') );
	
	echo 'success';

    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_text_followup', 'djafunction_update_text_followup' );
add_action( 'wp_ajax_nopriv_djafunction_update_text_followup', 'djafunction_update_text_followup' );




function djafunction_send_wa(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";
    $table_name2 = $wpdb->prefix . "dja_donate";
    $table_name3 = $wpdb->prefix . "dja_campaign";
    $table_name4 	= $wpdb->prefix . "dja_aff_submit";
    $table_name5 	= $wpdb->prefix . "dja_aff_code";

    // FROM INPUT
    $donasi_id 			= $_POST['datanya'][0];
    $followup_number 	= $_POST['datanya'][1];

    // GET SETTINGS
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="text_f1" or type="text_f2" or type="text_f3" or type="text_f4" or type="text_f5" or type="currency" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_on_dashboard" or type="wanotif_on" or type="wanotif_apikey_cs" ORDER BY id ASC');
    $text_f1 = $query_settings[0]->data;
    $text_f2 = $query_settings[1]->data;
    $text_f3 = $query_settings[2]->data;
    $text_f4 = $query_settings[3]->data;
    $text_f5 = $query_settings[4]->data;
    $currency = $query_settings[5]->data;
    $wanotif_url 		  = $query_settings[6]->data;
    $wanotif_apikey 	  = $query_settings[7]->data;
    $wanotif_on_dashboard = $query_settings[8]->data;
    $wanotif_on 		  = $query_settings[9]->data;
    $wanotif_apikey_cs 	  = $query_settings[10]->data;


    if($followup_number=='1'){
    	$text_wa = $text_f1;
    }elseif($followup_number=='2'){
    	$text_wa = $text_f2;
    }elseif($followup_number=='3'){
    	$text_wa = $text_f3;
    }elseif($followup_number=='4'){
    	$text_wa = $text_f4;
    }else{
    	$text_wa = $text_f5;
    }
	
	// GET DATA DONASI
    $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name2.' a 
    left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.id="'.$donasi_id.'" ')[0];

    // set cs_name
    $cs_name = '';
    if($row->cs_id>=1){
    	$user_info_cs = get_userdata($row->cs_id);
	    if($user_info_cs!=null){
	    	if($user_info_cs->last_name==''){
		    	$cs_name = $user_info_cs->first_name;
		    }else{
		    	$cs_name = $user_info_cs->first_name.' '.$user_info_cs->last_name;
		    }
	    }
    }

    if($row->payment_number==''){
    	$payment_numbernya = $row->deeplink_url;
    }else{
    	$payment_numbernya = $row->payment_number;
    }

    // ==================
    // info qurban - default
    // ==================
    $info_qurban = json_decode($row->info_qurban, true);
    $count_arr = count($info_qurban);
    $data_qurban = '';
    $count_qurban = 0;
    if($count_arr>=1){
    	foreach ( $info_qurban as $key => $value ) {
	    	if($count_qurban==$count_arr-1){
	    		$data_qurban .= '- '.$value['qurban'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*';
	    	}else{
	    		$data_qurban .= '- '.$value['qurban'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*
';
	    	}
	    	$count_qurban++;
	    }
    }

    // ==================
    // info qurban - detail
    // =================
    $info_qurban2 = json_decode($row->info_qurban, true);
    $count_arr2 = count($info_qurban2);
    $data_qurban2 = '';
    $count_qurban2 = 0;
    if($count_arr2>=1){
    	foreach ( $info_qurban2 as $key => $value ) {
	    	if($count_qurban2==$count_arr2-1){
	    		$data_qurban2 .= '- '.$value['qurban'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*';
			}else{
				$data_qurban2 .= '- '.$value['qurban'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*
';
			}
	    	$count_qurban2++;
	    }
    }
    
    // ==================
    // info package2 - default
    // ==================
    $info_packagenya = json_decode($row->info_package2, true);
    $count_arr_packagenya = count($info_packagenya);
    $data_packagenya = '';
    $count_packagenya = 0;
    if($count_arr_packagenya>=1){
    	foreach ( $info_packagenya as $key => $value ) {
	    	if($count_packagenya==$count_arr_packagenya-1){
	    		$data_packagenya .= '- '.$value['package'] .' = '.$value['jumlah'].'';
	    	}else{
	    		$data_packagenya .= '- '.$value['package'] .' = '.$value['jumlah'].'
';
	    	}
	    	$count_packagenya++;
	    }
    }

    // ==================
    // info package2 - detail
    // ==================
    $info_packagenya2 = json_decode($row->info_package2, true);
    $count_arr_packagenya2 = count($info_packagenya2);
    $data_packagenya2 = '';
    $count_packagenya2 = 0;
    if($count_arr_packagenya2>=1){
    	foreach ( $info_packagenya2 as $key => $value ) {
	    	if($count_packagenya2==$count_arr_packagenya2-1){
	    		$data_packagenya2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].'';
	    	}else{
	    		$data_packagenya2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].'
';
	    	}
	    	$count_packagenya2++;
	    }
    }

    // ==================
    // info zfitrah - default
    // ==================
    $info_zfitrahnya = json_decode($row->info_zfitrah, true);
    $count_arr_zfitrah = count($info_zfitrahnya);
    $data_zfitrah = '';
    $count_zfitrah = 0;
    if($count_arr_zfitrah>=1){
        foreach ( $info_zfitrahnya as $key => $value ) {
            if($count_zfitrah==$count_arr_zfitrah-1){
                $data_zfitrah .= '- '.$value['package'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*';
            }else{
                $data_zfitrah .= '- '.$value['package'] .' = '.$value['jumlah'].', atas nama : *'.$value['an'].'*
';
            }
            $count_zfitrah++;
        }
    }

    // ==================
    // info zfitrah - detail
    // =================
    $info_zfitrahnya2 = json_decode($row->info_zfitrah, true);
    $count_arr_zfitrah2 = count($info_zfitrahnya2);
    $data_zfitrah2 = '';
    $count_zfitrah2 = 0;
    if($count_arr_zfitrah2>=1){
        foreach ( $info_zfitrahnya2 as $key => $value ) {
            if($count_zfitrah2==$count_arr_zfitrah2-1){
                $data_zfitrah2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*';
            }else{
                $data_zfitrah2 .= '- '.$value['package'] .' ('.$value['per@'].') x '.$value['jumlah'].' = '.$value['nominal'].', atas nama : *'.$value['an'].'*
';
            }
            $count_zfitrah2++;
        }
    }
    
    // ==================
    // info additional formula data
    // =================
    $info_addformula = json_decode($row->info_addformula, true);
    $count_arr_addformula = count($info_addformula);
    $data_addformula = '';
    $count_addformula = 0;
    if($count_arr_addformula>=1){
        foreach ( $info_addformula as $key => $value ) {
            if($count_addformula==$count_arr_addformula-1){
                $data_addformula .= '
- '.$value['label'] .' : '.$value['nominal'];
            }else{
                $data_addformula .= '
- '.$value['label'] .' : '.$value['nominal'];
            }
            $count_addformula++;
        }
    }


    // set data list
    if($data_qurban!=''){
    	$data_list = $data_qurban.$data_addformula;
    }elseif($data_zfitrah!=''){
    	$data_list = $data_zfitrah.$data_addformula;
    }else{
    	$data_list = $data_packagenya.$data_addformula;
    }
    // set data list detail
    if($data_qurban2!=''){
    	$data_list_detail = $data_qurban2.$data_addformula;
    }elseif($data_zfitrah2!=''){
    	$data_list_detail = $data_zfitrah2.$data_addformula;
    }else{
    	$data_list_detail = $data_packagenya2.$data_addformula;
    }

    $payment_method = get_payment_method($row->invoice_id);
    $payment_method 	= str_replace('(*', '*', $payment_method);
    $payment_method 	= str_replace('*)', '*', $payment_method);
    $payment_expired = get_payment_expired($row->invoice_id);

    $data_field = array();
    $data_field[ '{name}' ] 	= $row->name;
    $data_field[ '{cs_name}' ] 	= $cs_name;
    $data_field[ '{whatsapp}' ] = $row->whatsapp;
    $data_field[ '{email}' ] 	= $row->email;
    $data_field[ '{comment}' ] 	= $row->comment;
    $data_field[ '{payment_number}' ] 	= $payment_numbernya;
    $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
    $data_field[ '{payment_account}' ] 	= $row->payment_account;
    $data_field[ '{campaign_title}' ] 	= $row->title;
    $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row->created_at));
    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;
    $data_field[ '{data_list}' ] 		= $data_list;
    $data_field[ '{data_list_detail}' ] = $data_list_detail;
    $data_field[ '{payment_method}' ]   = $payment_method;
    $data_field[ '{payment_expired}' ]   = $payment_expired;

    if($currency=='IDR'){
    	$data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
    }else{
    	$data_field[ '{total}' ] 	= $row->nominal;
    }

    
	$query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
    where a.donate_id='$donasi_id' ORDER BY a.id DESC ")[0];

    if($query_donation->fundraiser_id!=''){
        $user_info = get_userdata($query_donation->fundraiser_id);
        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
        $data_field[ '{fundraiser}' ] = $fundraiser_name;
    }else{
    	$data_field[ '{fundraiser}' ] = '-';
    }
	

    // set data payment_qrcode
    $payment_qrcode = $row->payment_qrcode;
    
    // UPDATE FOLLOWUP STATUS
    $wpdb->update(
        $table_name2, //table
        array(
            'f'.$followup_number => 1
        ),
        array('id' => $donasi_id), //where
        array('%s'), //data format
        array('%s') //where format    
    );

    $message = strtr($text_wa, $data_field);
	$messagenya = dja_whatsapp_format($message);
	$messagenya = str_replace("\\", '', $messagenya);
	$messagenya = strip_tags($messagenya);

    $phone = djaPhoneFormat($row->whatsapp);

    if($row->cs_id>=1){
		if($wanotif_apikey_cs!=''){
	        $data_cs = json_decode($wanotif_apikey_cs, true);
	        $jumlah_cs = $data_cs['jumlah'];
	    }else{
	        $jumlah_cs = 0;
	    }
	    
	    if($jumlah_cs>=1){
	    	foreach ($data_cs['data'] as $key => $value) {
	        	if($row->cs_id==$value[0]){
	        		$wanotif_apikey = $value[1];
	        		break;
	        	}
	        }
	    }
	}

	if($wanotif_on_dashboard=='1' && $wanotif_apikey!='' && $wanotif_on=='1'){

		$messagenya = strtr($messagenya, $data_field);

		$bHasLink = strpos($payment_qrcode, 'http') !== false || strpos($payment_qrcode, 'www.') !== false;
		$bHasIPaymu = strpos($message, 'ipaymu.com') !== false; // example qr on : https://sandbox.ipaymu.com/qr/41342

		if($bHasLink && $followup_number=='1'){

			// send with wanotif with Image QRCode
			$messagenya = $message;
			$messagenya = str_replace('*'.$payment_qrcode.'*', '', $messagenya);
			$messagenya = str_replace($payment_qrcode, '', $messagenya);

			if (preg_match('@"([^"]+)"@', $content, $matches) && $bHasIPaymu) {
				$image_base64_qrcode = $matches[0];
				$body = $image_base64_qrcode;
				$body = str_replace('"', '', $body);
			}else{	
				$imagedata = 'data:image/png;base64,'.base64_encode(file_get_contents($payment_qrcode));
				$body = $imagedata;
			}

			// Nama file beserta jenis ekstensinya
			$filename = 'QRcode.jpg';

			$url = $wanotif_url.'/sendfile';

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl, CURLOPT_HEADER, 0);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_TIMEOUT,30);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, array(
			    'Apikey'    => $wanotif_apikey,
			    'Phone'     => $phone,
			    'Body'      => $body,
			    'Caption'   => $messagenya,
			    'Filename'  => $filename
			));
			$response = curl_exec($curl);
			curl_close($curl); 

			$array = json_decode( $response, true );
			$data = $array['wanotif']['status'];

			if($data=='sent'){
				echo 'success';
			}else{
				echo 'failed';
			}

		}else{

			// send with wanotif
			$url = $wanotif_url.'/send';
			$messagenya = $message;

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl, CURLOPT_HEADER, 0);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_TIMEOUT,30);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, array(
			    'Apikey'    => $wanotif_apikey,
			    'Phone'     => $phone,
			    'Message'   => $messagenya,
			));
			$response = curl_exec($curl);
			curl_close($curl);

			$array = json_decode( $response, true );
			$data = $array['wanotif']['status'];

			if($data=='sent'){
				echo 'success';
			}else{
				echo 'failed';
			}

		}

    }else{
    	// send wa with URL API Whatsapp
    	$urllink_whatsapp = 'https://api.whatsapp.com/send?phone='.$phone.'&text='.$messagenya;
    	echo $urllink_whatsapp;  
    } 

    wp_die();

} 
add_action( 'wp_ajax_djafunction_send_wa', 'djafunction_send_wa' );
add_action( 'wp_ajax_nopriv_djafunction_send_wa', 'djafunction_send_wa' );



function djafunction_set_payment() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_settings";
    $table_name3 = $wpdb->prefix . "dja_campaign";
    $table_name4 	= $wpdb->prefix . "dja_aff_submit";
    $table_name5 	= $wpdb->prefix . "dja_aff_code";

    // FROM INPUT
    $donasi_id  = $_POST['datanya'][0];
    $value_button = $_POST['datanya'][1];
	
	// GET SETTINGS
	$query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="text_received" or type="text_received_status" or type="currency" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message" or type="wanotif_on_dashboard" or type="wanotif_on" or type="email_on" or type="email_success_message" ORDER BY id ASC');
    $text_received 		  = $query_settings[0]->data;
    $text_received_status = $query_settings[1]->data;
    $currency 			  = $query_settings[2]->data;
    $wanotif_url 		  = $query_settings[3]->data;
    $wanotif_apikey 	  = $query_settings[4]->data;
    $wanotif_message 	  = $query_settings[5]->data;
    $wanotif_on_dashboard = $query_settings[6]->data;
    $wanotif_on 		  = $query_settings[7]->data;
    $email_on 		  	  = $query_settings[8]->data;
    $email_success_message= $query_settings[9]->data;


    $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name.' a 
    left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.id="'.$donasi_id.'" ')[0];

    $data_field = array();
    $data_field[ '{name}' ] 	= $row->name;
    $data_field[ '{whatsapp}' ] = $row->whatsapp;
    $data_field[ '{email}' ] 	= $row->email;
    $data_field[ '{comment}' ] 	= $row->comment;
    $data_field[ '{payment_number}' ] 	= $row->payment_number;
    $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
    $data_field[ '{payment_account}' ] 	= $row->payment_account;
    $data_field[ '{campaign_title}' ] 	= $row->title;
    $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row->created_at));
    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;
    
    if($currency=='IDR'){
    	$data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
    }else{
    	$data_field[ '{total}' ] 	= $row->nominal;
    }

    
	$query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
    where a.donate_id='$donasi_id' ORDER BY a.id DESC ")[0];

    if($query_donation->fundraiser_id!=''){
        $user_info = get_userdata($query_donation->fundraiser_id);
        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
        $data_field[ '{fundraiser}' ] = $fundraiser_name;
    }else{
    	$data_field[ '{fundraiser}' ] = '-';
    }
    


    $phone = djaPhoneFormat($row->whatsapp);

    // $id_login = wp_get_current_user()->ID;
    // $user = get_user_by( 'ID', $id_login );
    // $display_name = $user->display_name;
    
    if($value_button=='1'){
    	$wpdb->update(
	        $table_name,
	        array(
	            'status' 	 => 1,
	            'payment_at' => date("Y-m-d H:i:s"),
	            'process_by' => 'admin'
	        ), array('id' => $donasi_id), array('%s'), array('%s')
	    );
    }else{
    	$wpdb->update(
	        $table_name,
	        array(
	            'status' 	 => 0,
	            'payment_at' => null,
	            'process_by' => null
	        ), array('id' => $donasi_id), array('%s'), array('%s')
	    );
    }
    

    if($text_received_status=='1'){
    	$text_wa = $text_received;
    }else{
    	$text_wa = '';
    }

    // send email
    if($email_on=='1'){

    	$email_success_message = json_decode($email_success_message);

		foreach($email_success_message as $key => $value) {

            $message = $value->message;
            $message = strtr($message, $data_field);
			$message = str_replace('<p>linebreak</p>', '', $message);
			$message = str_replace('linebreak', '', $message);
			
            $subject = $value->subject;
            $subject = strtr($subject, $data_field);
			$subject = str_replace("'","",$subject);
			
            $emailnya = $value->email;
			
            $emailnyacc = $value->emailcc;
            $emailnyabcc = $value->emailbcc;

            $headers[] = 'Content-Type: text/html; charset=UTF-8';

            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

			if (strpos($emailnyacc, ',') !== false ) {
				$array_emailcc  = (explode(",", $emailnyacc));
				foreach ($array_emailcc as $values){
					$email_cc = strtr($values, $data_field);
					$headers[] = 'Cc: '.$email_cc;
				}
			}else{
				$emailnyacc = strtr($emailnyacc, $data_field);
				$headers[] = 'Cc: '.$emailnyacc;
			}

			if (strpos($emailnyabcc, ',') !== false ) {
				$array_emailbcc  = (explode(",", $emailnyabcc));
				foreach ($array_emailbcc as $values){
					$email_bcc = strtr($values, $data_field);
					$headers[] = 'Bcc: '.$email_bcc;
				}
			}else{
				$emailnyabcc = strtr($emailnyabcc, $data_field);
				$headers[] = 'Bcc: '.$emailnyabcc;
			}
			
 			
			if($emailnya!=''){
				$emailnya = strtr($emailnya, $data_field);
				wp_mail( $emailnya, $subject, $body, $headers );
			}
				
		}

	}

   	// With Wanotif
	if($wanotif_apikey!='' && $wanotif_on=='1' && $value_button=='1' && $text_received_status=='1' && $wanotif_on_dashboard=='1'){
		// SET PHONE
		if($row->whatsapp!=''){

			$phone = djaPhoneFormat($row->whatsapp);
			$url = $wanotif_url.'/send';

			$messagenya = $text_wa;
			$messagenya = strtr($messagenya, $data_field);

			$curl = curl_init();
			curl_setopt($curl, CURLOPT_URL, $url);
			curl_setopt($curl, CURLOPT_HEADER, 0);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_TIMEOUT,30);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_POSTFIELDS, array(
			    'Apikey'    => $wanotif_apikey,
			    'Phone'     => $phone,
			    'Message'   => $messagenya,
			));
			$response = curl_exec($curl);
			curl_close($curl);

			echo 'wanotif_';

		}else{
			echo 'wanotiffalse_';
		}

	}else{

		$message = strtr($text_wa, $data_field);
		$message = dja_whatsapp_format($message);
		$message = str_replace("\\", '', $message);
		$message = strip_tags($message);

		$urllink_whatsapp = 'https://api.whatsapp.com/send?phone='.$phone.'&text='.$message;

		echo 'success_'.$urllink_whatsapp;

	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_set_payment', 'djafunction_set_payment' );
add_action( 'wp_ajax_nopriv_djafunction_set_payment', 'djafunction_set_payment' );



function djafunction_clone_shortcode(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_shortcode";

    // FROM INPUT
    $s_name 		= $_POST['datanya'][0];
    $s_category 	= $_POST['datanya'][1];
    $s_style 		= $_POST['datanya'][2];
    $s_show 		= $_POST['datanya'][3];
    $s_loadmore 	= $_POST['datanya'][4];
    $s_button_on 	= $_POST['datanya'][5];
    $s_button_text  = $_POST['datanya'][6];
    $s_data_load 	= $_POST['datanya'][7];
    $s_campaign 	= str_replace('\\', '', $_POST['datanya'][8]);

    if($s_campaign!=''){
    	$var = explode(',', $s_campaign);
	    $count_campaign = count($var);
	    $no = 1;
	    $data_campaign = '';
	    foreach($var as $value){
	    	if($no==$count_campaign){
	    		$data_campaign .= '"'.$value.'"';
	    	}else{
	    		$data_campaign .= '"'.$value.'",';
	    	}

	    	$no++;
	    }

	    $s_campaign = '{"campaign":['.$data_campaign.']}';

    }else{
    	$s_campaign = '{"campaign":[]}';
    }
    

    $id_login = wp_get_current_user()->ID;

    if($s_loadmore==''){
    	$s_loadmore = 0;
    }

    $s_id = 'ds'.d_randomString(7);

    	// create
    	$wpdb->insert(
            $table_name, //table
            array(
	            's_id' 			=> $s_id,
	            's_name' 		=> $s_name,
	            's_category' 	=> $s_category,
	            's_style' 		=> $s_style,
	            's_show' 		=> $s_show,
	            's_loadmore' 	=> $s_loadmore,
	            's_button_on' 	=> $s_button_on,
	            's_button_text' => $s_button_text,
	            's_data_load' 	=> $s_data_load,
	            's_campaign' 	=> $s_campaign,
	            'created_at' 	=> date("Y-m-d H:i:s"),
	            'updated_at' 	=> date("Y-m-d H:i:s")
	        ),
            array('%s', '%s') //data format         
        );

    	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_clone_shortcode', 'djafunction_clone_shortcode' );
add_action( 'wp_ajax_nopriv_djafunction_clone_shortcode', 'djafunction_clone_shortcode' );



function djafunction_delete_shortcode() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_shortcode";
    
    // FROM INPUT
    $id 			= $_POST['datanya'][0];

    // ACTION Update TO DB
    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {

		// then delete
		$wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );

        echo 'success';
    }else{
    	echo 'not allowed';
    }
	
    wp_die();

} 
add_action( 'wp_ajax_djafunction_delete_shortcode', 'djafunction_delete_shortcode' );
add_action( 'wp_ajax_nopriv_djafunction_delete_shortcode', 'djafunction_delete_shortcode' );



function djafunction_update_shortcode() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_shortcode";
    
    // FROM INPUT
    $s_id 			= $_POST['datanya'][0];
    $s_name 		= $_POST['datanya'][1];
    $s_category 	= $_POST['datanya'][2];
    $s_style 		= $_POST['datanya'][3];
    $s_show 		= $_POST['datanya'][4];
    $s_loadmore 	= $_POST['datanya'][5];
    $s_button_on 	= $_POST['datanya'][6];
    $s_button_text 	= $_POST['datanya'][7];
    $s_data_load 	= $_POST['datanya'][8];
    $s_campaign 	= str_replace('\\', '', $_POST['datanya'][9]);
    $s_grid_on 		= $_POST['datanya'][10];
    $s_grid_mobile	= $_POST['datanya'][11];

    if($s_button_on==''){
    	$s_button_on = 0;
    }else{
    	$s_button_on = 1;
    }

    if($s_grid_on==''){
    	$s_grid_on = 0;
    }else{
    	$s_grid_on = 1;
    }

    // get data campaign to check user cannot modify the campaign id
    $row = $wpdb->get_results('SELECT * from '.$table_name.' where s_id="'.$s_id.'" ');

    if($row!=null){

	    // ACTION Update TO DB
	    $wpdb->update(
            $table_name, //table
            array(
	            's_name' 	 	=> $s_name,
	            's_category' 	=> $s_category,
	            's_style' 	 	=> $s_style,
	            's_show' 	 	=> $s_show,
	            's_loadmore' 	=> $s_loadmore,
	            's_button_on' 	=> $s_button_on,
	            's_button_text' => $s_button_text,
	            's_data_load' 	=> $s_data_load,
	            's_campaign' 	=> $s_campaign,
	            's_grid_on' 	=> $s_grid_on,
	            's_grid_mobile' => $s_grid_mobile
	        ),
            array('s_id' => $s_id), //where
            array('%s'), //data format
            array('%s') //where format    
        );
		
		echo $s_id;

	}else{
		echo 0;
	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_shortcode', 'djafunction_update_shortcode' );
add_action( 'wp_ajax_nopriv_djafunction_update_shortcode', 'djafunction_update_shortcode' );



function djafunction_add_shortcode() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_shortcode";
    
    // FROM INPUT
    $s_name 		= $_POST['datanya'][0];
    $s_category 	= $_POST['datanya'][1];
    $s_style 		= $_POST['datanya'][2];
    $s_show 		= $_POST['datanya'][3];
    $s_loadmore	 	= $_POST['datanya'][4];
    $s_button_on 	= $_POST['datanya'][5];
    $s_button_text 	= $_POST['datanya'][6];
    $s_data_load 	= $_POST['datanya'][7];
    $s_campaign 	= str_replace('\\', '', $_POST['datanya'][8]);
    $s_grid_on 		= $_POST['datanya'][9];
    $s_grid_mobile 	= $_POST['datanya'][10];

    if($s_button_on==''){
    	$s_button_on = 0;
    }else{
    	$s_button_on = 1;
    }
    if($s_grid_on==''){
    	$s_grid_on = 0;
    }else{
    	$s_grid_on = 1;
    }

	$s_id = 'ds'.d_randomString(7);

	// create
	$wpdb->insert(
        $table_name, //table
        array(
            's_id' 			=> $s_id,
            's_name' 		=> $s_name,
            's_category' 	=> $s_category,
            's_style' 		=> $s_style,
            's_show' 		=> $s_show,
            's_loadmore' 	=> $s_loadmore,
            's_button_on' 	=> $s_button_on,
            's_button_text' => $s_button_text,
            's_data_load' 	=> $s_data_load,
            's_campaign' 	=> $s_campaign,
            's_grid_on' 	=> $s_grid_on,
            's_grid_mobile' => $s_grid_mobile,
            'created_at' 	=> date("Y-m-d H:i:s"),
            'updated_at' 	=> date("Y-m-d H:i:s")
        ),
        array('%s', '%s') //data format         
    );

	echo $s_id;


    wp_die();

} 
add_action( 'wp_ajax_djafunction_add_shortcode', 'djafunction_add_shortcode' );
add_action( 'wp_ajax_nopriv_djafunction_add_shortcode', 'djafunction_add_shortcode' );



function djafunction_login_user() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "users";
    $table_name2 = $wpdb->prefix . "dja_settings"; 
    $table_name3 = $wpdb->prefix . "dja_users"; 

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="login_setting" ORDER BY id ASC');
    $login_setting = $query_settings[0]->data;

    if($login_setting=='1'){
    	// lanjut terus
    }else{
    	echo 'not_allowed';
    	wp_die();
    }   

    // FROM INPUT
    $e_p_username = $_POST['datanya'][0];
    $password 	  = $_POST['datanya'][1];

    if(filter_var($e_p_username, FILTER_VALIDATE_EMAIL)) {
        // valid address
        $userdata = get_user_by( 'email', $e_p_username );
	    if ( $userdata ) {

	        $user_id = $userdata->ID;
	        $result = wp_check_password($password, $userdata->user_pass, $user_id);

	        if($result!=null){
	        	$set_login = dja_auto_login_new_user($user_id);
	        	echo $set_login;
			    wp_die();
	        }else{
	        	echo 'email_failed';
			    wp_die();
	        }

	    } else {
	        echo 'email_failed';
	        wp_die();
	    }

    }else{
    	
        if (is_numeric($e_p_username)) {

        	// phone number
        	$check_wa = $wpdb->get_results('SELECT user_id from '.$table_name3.' where user_wa="'.$e_p_username.'"');
			if($check_wa!=null){
				
				$user_id = $check_wa[0]->user_id;
				$userdata = get_user_by( 'ID', $user_id );

		        $result = wp_check_password($password, $userdata->user_pass, $user_id);

		        if($result!=null){
		        	$set_login = dja_auto_login_new_user($user_id);
		        	echo $set_login;
				    wp_die();
		        }else{
		        	echo 'phone_failed';
				    wp_die();
		        }

			}else{
				echo 'phone_failed';
		        wp_die();
			}

	    } else {
	    	// username
	        $userdata = get_user_by( 'login', $e_p_username );
		    if ( $userdata ) {

		        $user_id = $userdata->ID;
		        $result = wp_check_password($password, $userdata->user_pass, $user_id);

		        if($result!=null){
		        	$set_login = dja_auto_login_new_user($user_id);
		        	echo $set_login;
				    wp_die();
		        }else{
		        	echo 'username_failed';
				    wp_die();
		        }
			    
		    } else {
		        echo 'username_failed';
		        wp_die();
		    }
	    }

    }

    

    
} 
add_action( 'wp_ajax_djafunction_login_user', 'djafunction_login_user' );
add_action( 'wp_ajax_nopriv_djafunction_login_user', 'djafunction_login_user' );


function djafunction_register_user() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "users";
    $table_name2 = $wpdb->prefix . "usermeta";
    $table_name3 = $wpdb->prefix . "dja_users";
    $table_name4 = $wpdb->prefix . "dja_verification_details"; 
    $table_name5 = $wpdb->prefix . "dja_settings";

    // FROM INPUT
    $user_fullname 	= $_POST['datanya'][0];
    $user_email 	= $_POST['datanya'][1];
    $user_whatsapp 	= $_POST['datanya'][2];
    $user_pass 		= $_POST['datanya'][3];

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="register_setting" or type="email_on" ORDER BY id ASC');
    $register_setting = $query_settings[0]->data;
    $email_on 		  = $query_settings[1]->data;

    if($register_setting=='1'){
    	// lanjut terus
    }else{
    	echo 'not_allowed';
    	wp_die();
    }

    $count_name = str_word_count($user_fullname);
    if($count_name==1){
    	$user_firstname = $user_fullname;
    	$user_lastname = '';
    }elseif($count_name==2){
    	$name = explode(' ',$user_fullname);
	    $user_firstname = $name[0];
    	$user_lastname = $name[1];
    }elseif($count_name==3){
    	$name = explode(' ',$user_fullname);
	    $user_firstname = $name[0];
    	$user_lastname = $name[1].' '.$name[2];
    }elseif($count_name==4){
    	$name = explode(' ',$user_fullname);
	    $user_firstname = $name[0];
    	$user_lastname = $name[1].' '.$name[2].' '.$name[3];
    }elseif($count_name==5){
    	$name = explode(' ',$user_fullname);
	    $user_firstname = $name[0];
    	$user_lastname = $name[1].' '.$name[2].' '.$name[3].' '.$name[4];
    }else{
    	$user_firstname = $user_fullname;
    	$user_lastname = '';
    }

    // strip out all whitespace
	$name_clean = preg_replace('/\s*/', '', $user_firstname.$user_lastname);
	$name_clean_fix = strtolower($name_clean);

    // check mail
    $user = get_user_by( 'email', $user_email );
    if ( $user ) {
        $user_id = $user->ID;
    } else {
        $user_id = false;
    }

    // check username
    $user2 = get_user_by( 'login', $name_clean_fix );
    if ( $user2 ) {
        $user_id2 = $user2->ID;
    } else {
        $user_id2 = false;
    }

    // add 3 char
    $rand_3char = d_randomString(3);
    if($user_id2!=null){
    	$name_clean_fix = $name_clean_fix.$rand_3char;
    }

    $check_wa = $wpdb->get_results('SELECT id from '.$table_name3.' where user_wa="'.$user_whatsapp.'"');
	if($check_wa!=null){
		echo 'wa_terdaftar';
    	wp_die();
	}

	$pattern = "/^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/";
    if (!(preg_match($pattern, $user_pass))) {
        echo 'password_failed';
    	wp_die();
    }


    if($user_id!=null){
    	echo 'email_terdaftar';
    	wp_die();
    }else{

    	$user_firstname_update = str_replace('\\', '', $user_firstname);
		$user_lastname_update = str_replace('\\', '', $user_lastname);

    	$hash = wp_hash_password( $user_pass );
    	$WP_array = array (
	        'user_login'    =>  $name_clean_fix,
	        'user_email'    =>  $user_email,
	        'user_pass'     =>  $user_pass,
	        'user_url'      =>  '',
	        'first_name'    =>  $user_firstname_update,
	        'last_name'     =>  $user_lastname_update,
	        'nickname'      =>  $name_clean_fix,
	        'display_name'  =>  $user_firstname_update.' '.$user_lastname_update,
	        'description'   =>  '',
	    ) ;

	    $user_id = wp_insert_user( $WP_array ) ;
	    wp_update_user( array ('ID' => $user_id, 'role' => 'donatur') ) ;

	    $randid = 'u_'.d_randomString(8);
        // insert data to table user
        $wpdb->insert(
            $table_name3, //table
            array(
                'user_id'           => $user_id,
                'user_randid'       => $randid,
                'user_type'         => null,
                'user_verification' => null,
                'user_bio'          => null,
                'user_wa'           => $user_whatsapp,
                'user_provinsi' 	=> null,
	            'user_kabkota' 		=> null,
	            'user_kecamatan' 	=> null,
	            'user_provinsi_id' 	=> null,
	            'user_kabkota_id' 	=> null,
	            'user_kecamatan_id' => null,
	            'user_alamat' 		=> null,
	            'user_bank_name' 	=> null,
	            'user_bank_no' 	 	=> null,
	            'user_bank_an' 	 	=> null,
                'user_pp_img'       => null,
                'user_cover_img'    => null,
                'created_at'    => date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

        // insert data to table verifications
        $wpdb->insert(
            $table_name4, //table
            array(
                'u_id'                  => $user_id,
                'u_nama_lengkap'        => null,
                'u_email'               => null,
                'u_whatsapp'            => null,
                'u_ktp'                 => null,
                'u_ktp_selfie'          => null,
                'u_jabatan'             => null,
                'u_nama_ketua'          => null,
                'u_alamat_lengkap'      => null,
                'u_program_unggulan'    => null,
                'u_profile'             => null,
                'u_legalitas'           => null,
                'created_at'            => date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

        if($email_on=='1'){
			
            $message = '<p><ul><li>Username: '.$name_clean_fix.'</li><li>Email: '.$user_email.'</li><li>Password: '.$user_pass.'</li></ul></p>';
            $subject = 'Berikut data Username dan Password anda';
            $emailnya = $user_email;
            $headers[] = 'Content-Type: text/html; charset=UTF-8';
            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';
 			
			if($emailnya!=''){
				wp_mail( $emailnya, $subject, $body, $headers );
			}

		}	
        
        $set_login = dja_auto_login_new_user($user_id);

        echo $set_login;

    	wp_die();
    }
    
} 
add_action( 'wp_ajax_djafunction_register_user', 'djafunction_register_user' );
add_action( 'wp_ajax_nopriv_djafunction_register_user', 'djafunction_register_user' );




function djafunction_send_link() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_password_reset";
    $table_name2 = $wpdb->prefix . "dja_password_reset_log";
    $table_name3 = $wpdb->prefix . "users";
    $table_name4 = $wpdb->prefix . "dja_settings";

    // FROM INPUT
    $user_email 	= $_POST['datanya'][0];

    $check_email = $wpdb->get_results('SELECT id from '.$table_name3.' where user_email="'.$user_email.'"');
	if($check_email==null){

		$user_ip 	    = donasiaja_getIP();
		$user_os        = donasiaja_getOS();
		$user_browser   = donasiaja_getBrowser();
	    
        $wpdb->insert(
            $table_name2, //table
            array(
                'reset_email'     => $user_email,
                'ip'    		  => $user_ip,
                'os'    	  	  => $user_os,
                'browser'   	  => $user_browser,
                'created_at'      => date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

		$today		  = date('Y-m-d H:i:s');
		$date 		  = date("Y-m-d H:i:s", strtotime('-1 hours', time()));

		$count_access = $wpdb->get_results('SELECT id from '.$table_name2.' where ip="'.$user_ip.'" and os="'.$user_os.'" and  browser="'.$user_browser.'" and created_at between "'.$date.'" and "'.$today.'" ORDER BY id ASC');
		$check_count_access = count($count_access);

		if($check_count_access>=5){
			echo 'limitted_access';
		}else{
			echo 'not_valid';
		}
    	wp_die();

	}else{

		$user_ip 			= donasiaja_getIP();
		$user_os        = donasiaja_getOS();
		$user_browser   = donasiaja_getBrowser();
	    $code = d_randomString(32);
        $wpdb->insert(
            $table_name, //table
            array(
                'reset_email'     => $user_email,
                'reset_code'      => $code,
                'reset_status'    => 0,
                'ip'    		  => $user_ip,
                'os'    	  	  => $user_os,
                'browser'    	  => $user_browser,
                'created_at'      => date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

        $today		  = date('Y-m-d H:i:s');
		$date 		  = date("Y-m-d H:i:s", strtotime('-1 hours', time()));

		$count_access = $wpdb->get_results('SELECT id from '.$table_name.' where ip="'.$user_ip.'" and os="'.$user_os.'" and  browser="'.$user_browser.'" and created_at between "'.$date.'" and "'.$today.'" ORDER BY id ASC');
		$check_count_access = count($count_access);

		if($check_count_access>=5){
			echo 'limitted_access2';
		}else{

			$user = get_user_by( 'email', $user_email );
			$display_name = '';
		    if ( $user ) {
		        $display_name = $user->display_name;
		    }

		    // Settings
		    $query_settings = $wpdb->get_results('SELECT data from '.$table_name4.' where type="app_name" ORDER BY id ASC');
		    $app_name				= $query_settings[0]->data;

			// send email please
			// $message = 'Berikut Link Password anda <a href="'.get_site_url().'/resetpass/'.$code.'">Change Password Now</a>';
			$message = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><title>Activation</title><meta http-equiv="Content-Type" content="text/html; charset=utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1.0"/><style type="text/css">a{outline:none;color:#fa5151;text-decoration:underline;}a:hover{text-decoration:none !important;}.h-u a{text-decoration:none;}.h-u a:hover{text-decoration:underline !important;}a[x-apple-data-detectors]{color:inherit !important; text-decoration:none !important;}a[href^="tel"]:hover{text-decoration:none !important;}.active-i a:hover,.active-t:hover{opacity:0.8;}.active-i a,.active-t{transition:all 0.3s ease;}a img{border:none;}th{padding:0;}table td{mso-line-height-rule:exactly;}[owa] div button{display:block; font-size:1px; line-height:1px;}[owa] .main-table div{display:block !important; font-size:1px; line-height:1px;}.l-white a{color:#fff;}@media only screen and (max-width:375px) and (min-width:374px){.gmail-fix{min-width:374px !important;}}@media only screen and (max-width:414px) and (min-width:413px){.gmail-fix{min-width:413px !important;}}@media only screen and (max-width:500px){/* default style */.flexible{width:100% !important;}.img-flex img{width:100% !important; height:auto !important;}.table-holder{display:table !important; width:100% !important;}.thead{display:table-header-group !important; width:100% !important;}.tfoot{display:table-footer-group !important; width:100% !important;}.flex{display:block !important; width:100% !important;}.hide{display:none !important; width:0 !important; height:0 !important; padding:0 !important; font-size:0 !important; line-height:0 !important;}.p-0{padding:0 !important;}.p-20{padding:20px !important;}.p-25{padding:25px !important;}.p-30{padding:30px !important;}.plr-15{padding-left:15px !important; padding-right:15px !important;}.plr-20{padding-left:20px !important; padding-right:20px !important;}.pt-20{padding-top:20px !important;}.pt-25{padding-top:25px !important;}.pb-15{padding-bottom:15px !important;}.pb-20{padding-bottom:20px !important;}.pb-25{padding-bottom:25px !important;}.fs-24{font-size:24px !important;}.lh-28{line-height:28px !important;}/* custom style */.pt-10p{padding-top:10%;}.plr-9p{padding-left:9%; padding-right:9%;}.pb-8p{padding-bottom:8%;}.social-icons img{width:85% !important;}}</style></head><body style="margin:0; padding:0; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%;"><table class="gmail-fix" bgcolor="#ffffff" width="100%" style="min-width:320px;" cellspacing="0" cellpadding="0"><tr><td style="display:none; font-size:0; line-height:0;"></td></tr><tr><td><table data-module="module-1" class="main-table" width="100%" cellpadding="0" cellspacing="0"><tr><td data-bgcolor="bg-module" bgcolor="#F6FAFF"><table class="flexible" width="600" align="center" style="margin:0 auto;margin-bottom: 30px;margin-top: 20px;" cellpadding="0" cellspacing="0"></table></td></tr></table><table data-module="module-3" class="main-table" width="100%" cellpadding="0" cellspacing="0"><tr><td data-bgcolor="bg-module" bgcolor="#F6FAFF"><table class="flexible" width="600" align="center" style="margin:0 auto;" cellpadding="0" cellspacing="0"><tr><td data-bgcolor="bg-block-02" class="l-white p-25" style="padding:53px 110px 60px;background:#ffffff;border:1px solid #bb0ac1;border-radius: 8px;"><table width="100%" cellpadding="0" cellspacing="0"><tr><td data-color="title-with-bg" data-size="size title-with-bg" data-min="10" data-max="46" data-link-color="link title-with-bg color" data-link-style="text-decoration:underline; color:#fff;" align="center" style="padding:0 0 9px; font:700 26px/35px Arial, Helvetica, sans-serif; color:#23374D;"><span style="color: #bb0ac1;border-box;background-clip: text;">Hai '.$display_name.'</span></td></tr><tr><td data-color="text-with-bg" data-size="size text" data-min="10" data-max="46" data-link-color="link text-with-bg color" data-link-style="text-decoration:underline; color:#23374D;" align="center" style="padding:0 0 20px; font:15px/30px Arial, Helvetica, sans-serif; color:#23374D;"><span style="color:#23374D;">Baru saja anda request untuk mereset password akun anda. Ikuti link dibawah ini, Terimakasih.</span><br><br><a href="'.get_site_url().'/resetpass/'.$code.'" target="_blank" style="color:#23374D;">'.get_site_url().'/resetpass/'.$code.'</a><br><br></td></tr><tr><td><table align="center" style="margin:0 auto;" cellpadding="0" cellspacing="0"><tr><td data-bgcolor="bg-button-01" data-size="size button" data-min="10" data-max="26" class="active-t" bgcolor="#ffffff" align="center" style="mso-padding-alt:14px 30px; font:700 14px/16px Arial, Helvetica, sans-serif; text-transform:uppercase; border-radius:22px;background: linear-gradient(to right, #b425b9 20%, #e40d6d 100%);"><a style="padding:14px 30px; color:#ffffff; text-decoration:none; display:block;" href="'.get_site_url().'/resetpass/'.$code.'" target="_blank">RESET PASSWORD</a></td></tr></table></td></tr></table></td></tr><tr><td style="text-align: center;font:12px/30px Arial, Helvetica, sans-serif; color:#ababab;padding-top: 10px;"><span>* Do not reply to this email.</span><br><br></td></tr></table></td></tr></table><table data-module="module-11" class="main-table" width="100%" cellpadding="0" cellspacing="0"><tr><td data-bgcolor="bg-module" bgcolor="#F6FAFF"><table class="flexible" width="600" align="center" style="margin:0 auto;" cellpadding="0" cellspacing="0"><tr><td data-bgcolor="bg-block" class="p-30 p-20" bgcolor="#F6FAFF" style="padding:10px 30px 30px;"><table width="100%" cellpadding="0" cellspacing="0"><tr><td data-color="text" data-size="size text" data-min="10" data-max="26" data-link-color="link text color" data-link-style="text-decoration:underline; color:#fa5151;" align="center" style="font:13px/22px Arial, Helvetica, sans-serif; color:#242424;"><span style="color: #bb0ac1;">'.$app_name.'</span><br/><span style="color: #bb0ac1;">Powered by DonasiAja</span><br/><span style="color: #bb0ac1;">All rights reserved.</span></td></tr></table></td></tr></table></td></tr></table></td></tr></table></body></html>';
            $subject = 'Reset Password - '.$app_name;
            $headers = array('Content-Type: text/html; charset=UTF-8');
			
			wp_mail( $user_email, $subject, $message, $headers );
				
			echo 'success';
		}

    	wp_die();
    }
    
} 
add_action( 'wp_ajax_djafunction_send_link', 'djafunction_send_link' );
add_action( 'wp_ajax_nopriv_djafunction_send_link', 'djafunction_send_link' );


function djafunction_reset_pass() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_password_reset";
    $table_name2 = $wpdb->prefix . "users";

    // FROM INPUT
    $new_password 	= $_POST['datanya'][0];
    $reset_email 	= $_POST['datanya'][1];
    $reset_code 	= $_POST['datanya'][2];

    $check = $wpdb->get_results('SELECT * from '.$table_name.' where reset_code="'.$reset_code.'" and  reset_email="'.$reset_email.'" ');
	if($check==null){
		echo 'reset_failed';
    	wp_die();
	}

    $user = get_user_by( 'email', $reset_email );
    if ( $user ) {
        $user_id = $user->ID;
    } else {
        $user_id = false;
    }

	$pattern = "/^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/";
    if (!(preg_match($pattern, $new_password))) {
        echo 'password_failed';
    	wp_die();
    }else{
    	// UPDATE
    	$hash = wp_hash_password( $new_password );
	    $wpdb->update(
	        $table_name2,
	        array(
	            'user_pass'           => $hash
	        ),
	        array( 'ID' => $user_id )
	    );
	    $wpdb->update(
	        $table_name,
	        array(
	            'reset_status' => 1
	        ),
	        array( 'reset_code' => $reset_code )
	    );

    	echo 'success';

		wp_die();

    }
    
} 
add_action( 'wp_ajax_djafunction_reset_pass', 'djafunction_reset_pass' );
add_action( 'wp_ajax_nopriv_djafunction_reset_pass', 'djafunction_reset_pass' );





function djafunction_add_user() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "users";
    $table_name2 = $wpdb->prefix . "usermeta";
    $table_name3 = $wpdb->prefix . "dja_users";
    $table_name4 = $wpdb->prefix . "dja_verification_details";    

    // FROM INPUT
    $user_firstname = $_POST['datanya'][0];
    $user_lastname 	= $_POST['datanya'][1];
    $user_wa 		= $_POST['datanya'][2];
    $user_email 	= $_POST['datanya'][3];
    $user_bio 		= $_POST['datanya'][4];
    $user_provinsi 	= $_POST['datanya'][5];
    $user_kabkota 	= $_POST['datanya'][6];
    $user_kecamatan 	= $_POST['datanya'][7];
    $user_provinsi_id 	= $_POST['datanya'][8];
    $user_kabkota_id 	= $_POST['datanya'][9];
    $user_kecamatan_id 	= $_POST['datanya'][10];
    $user_alamat 	= $_POST['datanya'][11];
    $user_bank_name = $_POST['datanya'][12];
    $user_bank_no 	= $_POST['datanya'][13];
    $user_bank_an 	= $_POST['datanya'][14];
    $user_role 		= $_POST['datanya'][15];
    $user_type 		= $_POST['datanya'][16];
    $user_verification = $_POST['datanya'][17];
    $user_pass 		= $_POST['datanya'][18];

    // strip out all whitespace
	$name_clean = preg_replace('/\s*/', '', $user_firstname.$user_lastname);
	$name_clean_fix = strtolower($name_clean);

    // check mail
    $user = get_user_by( 'email', $user_email );
    if ( $user ) {
        $user_id = $user->ID;
    } else {
        $user_id = false;
    }

    // check username
    $user2 = get_user_by( 'login', $name_clean_fix );
    if ( $user2 ) {
        $user_id2 = $user2->ID;
    } else {
        $user_id2 = false;
    }

    // add 3 char
    $rand_3char = d_randomString(3);
    if($user_id2!=null){
    	$name_clean_fix = $name_clean_fix.$rand_3char;
    }

    if($user_id!=null){
    	echo 'email_terdaftar';
    	wp_die();
    }else{

    	$user_firstname_update = str_replace('\\', '', $user_firstname);
		$user_lastname_update = str_replace('\\', '', $user_lastname);

    	$hash = wp_hash_password( $user_pass );
    	$WP_array = array (
	        'user_login'    =>  $name_clean_fix,
	        'user_email'    =>  $user_email,
	        'user_pass'     =>  $user_pass,
	        'user_url'      =>  '',
	        'first_name'    =>  $user_firstname_update,
	        'last_name'     =>  $user_lastname_update,
	        'nickname'      =>  $name_clean_fix,
	        'display_name'  =>  $user_firstname_update.' '.$user_lastname_update,
	        'description'   =>  '',
	    ) ;

	    $user_id = wp_insert_user( $WP_array ) ;
	    wp_update_user( array ('ID' => $user_id, 'role' => $user_role) ) ;

	    $randid = 'u_'.d_randomString(8);
        // insert data to table user
        $wpdb->insert(
            $table_name3, //table
            array(
                'user_id'           => $user_id,
                'user_randid'       => $randid,
                'user_type'         => $user_type,
                'user_verification' => $user_verification,
                'user_bio'          => $user_bio,
                'user_wa'           => $user_wa,
                'user_provinsi' 	=> $user_provinsi,
	            'user_kabkota' 		=> $user_kabkota,
	            'user_kecamatan' 	=> $user_kecamatan,
	            'user_provinsi_id' 	=> $user_provinsi_id,
	            'user_kabkota_id' 	=> $user_kabkota_id,
	            'user_kecamatan_id' => $user_kecamatan_id,
	            'user_alamat' 		=> $user_alamat,
	            'user_bank_name' 	=> $user_bank_name,
	            'user_bank_no' 	 	=> $user_bank_no,
	            'user_bank_an' 	 	=> $user_bank_an,
                'user_pp_img'       => null,
                'user_cover_img'    => null,
                'created_at'    	=> date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

        // insert data to table verifications
        $wpdb->insert(
            $table_name4, //table
            array(
                'u_id'                  => $user_id,
                'u_nama_lengkap'        => null,
                'u_email'               => null,
                'u_whatsapp'            => null,
                'u_ktp'                 => null,
                'u_ktp_selfie'          => null,
                'u_jabatan'             => null,
                'u_nama_ketua'          => null,
                'u_alamat_lengkap'      => null,
                'u_program_unggulan'    => null,
                'u_profile'             => null,
                'u_legalitas'           => null,
                'created_at'            => date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );
        
	    echo $user_id;

    	wp_die();
    }
    
} 
add_action( 'wp_ajax_djafunction_add_user', 'djafunction_add_user' );
add_action( 'wp_ajax_nopriv_djafunction_add_user', 'djafunction_add_user' );



function djafunction_delete_usernya() {

	global $wpdb;
    $table_name = $wpdb->prefix . "users";
    $table_name2 = $wpdb->prefix . "dja_users";
    $table_name3 = $wpdb->prefix . "dja_user_logs";
    $table_name4 = $wpdb->prefix . "dja_verification_details";

    // FROM INPUT
    $user_id 	    = $_POST['datanya'][0];

    $user_info = get_userdata($user_id);
    $fullname = $user_info->first_name.' '.$user_info->last_name;
    $user_login = $user_info->user_login;
    $user_email = $user_info->user_email;


    // echo $fullname.' - '.$user_login.' - '.$user_email;

    if($user_id==1){
    	echo 'not allowed.';
    	wp_die();
    }

    $user = $wpdb->get_results('SELECT * from '.$table_name2.' where user_id="'.$user_id.'"');
	if($user!=null){

		$wpdb->insert(
            $table_name3, //table
            array(
                'del_by'        	=> $user_id,
                'user_login'        => $user_login,
                'user_email'        => $user_email,
                'user_id'           => $user_id,
                'user_fullname'     => $fullname,
                'user_randid'       => $user[0]->user_randid,
                'user_type' 		=> $user[0]->user_type,
		        'user_verification' => $user[0]->user_verification,
		        'user_bio' 			=> $user[0]->user_bio,
		        'user_wa' 			=> $user[0]->user_wa,
		        'user_provinsi' 	=> $user[0]->user_provinsi,
		        'user_kabkota' 		=> $user[0]->user_kabkota,
		        'user_kecamatan' 	=> $user[0]->user_kecamatan,
		        'user_provinsi_id' 	=> $user[0]->user_provinsi_id,
		        'user_kabkota_id' 	=> $user[0]->user_kabkota_id,
		        'user_kecamatan_id' => $user[0]->user_kecamatan_id,
		        'user_alamat' 		=> $user[0]->user_alamat,
		        'user_bank_name' 	=> $user[0]->user_bank_name,
		        'user_bank_no' 	 	=> $user[0]->user_bank_no,
		        'user_bank_an' 	 	=> $user[0]->user_bank_an,
                'user_pp_img'       => $user[0]->user_pp_img,
                'user_cover_img'    => $user[0]->user_cover_img,
                'created_at'    	=> date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );


        if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name2.' WHERE user_id = %d', $user_id ) ) ) {
			// then delete
	        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name2.' WHERE user_id = "'.$user_id.'" ' ) );
	    }

        if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name4.' WHERE u_id = %d', $user_id ) ) ) {
			// then delete
	        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name4.' WHERE u_id = "'.$user_id.'" ' ) );
	    }

	    if (wp_delete_user($user_id)){
	        echo 'success';
	    }
	    wp_die();


	}else{
		echo 'not allowed.';
		wp_die();
	}
	
    
} 
add_action( 'wp_ajax_djafunction_delete_usernya', 'djafunction_delete_usernya' );
add_action( 'wp_ajax_nopriv_djafunction_delete_usernya', 'djafunction_delete_usernya' );



function djafunction_update_user() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "usermeta";
    $table_name3 = $wpdb->prefix . "dja_verification_details";  
    $table_name4 = $wpdb->prefix . "users";
    $table_name5 = $wpdb->prefix . "dja_settings";    
    
    // FROM INPUT
    $user_id 	    = $_POST['datanya'][0];
    $user_firstname = $_POST['datanya'][1];
    $user_lastname 	= $_POST['datanya'][2];
    $user_wa 		= $_POST['datanya'][3];
    $user_email 	= $_POST['datanya'][4];
    $user_bio 		= $_POST['datanya'][5];
    $user_provinsi 	= $_POST['datanya'][6];
    $user_kabkota 	= $_POST['datanya'][7];
    $user_kecamatan 	= $_POST['datanya'][8];
    $user_provinsi_id 	= $_POST['datanya'][9];
    $user_kabkota_id 	= $_POST['datanya'][10];
    $user_kecamatan_id 	= $_POST['datanya'][11];
    $user_alamat 	= $_POST['datanya'][12];
    $user_bank_name = $_POST['datanya'][13];
    $user_bank_no 	= $_POST['datanya'][14];
    $user_bank_an 	= $_POST['datanya'][15];
    $user_role 		= $_POST['datanya'][16];
    $user_type 		= $_POST['datanya'][17];
    $user_verification = $_POST['datanya'][18];

    // get email settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="email_on" ORDER BY id ASC');
    $email_on 		  = $query_settings[0]->data;

    $check = $wpdb->get_results('SELECT id, user_verification from '.$table_name.' where user_id="'.$user_id.'"');
	if($check!=null){

	    // ACTION Update TO DB
	    $wpdb->update(
            $table_name, //table
            array(
	            'user_type' 		=> $user_type,
	            'user_verification' => $user_verification,
	            'user_bio' 			=> $user_bio,
	            'user_wa' 			=> $user_wa,
	            'user_provinsi' 	=> $user_provinsi,
	            'user_kabkota' 		=> $user_kabkota,
	            'user_kecamatan' 	=> $user_kecamatan,
	            'user_provinsi_id' 	=> $user_provinsi_id,
	            'user_kabkota_id' 	=> $user_kabkota_id,
	            'user_kecamatan_id' => $user_kecamatan_id,
	            'user_alamat' 		=> $user_alamat,
	            'user_bank_name' 	=> $user_bank_name,
	            'user_bank_no' 	 	=> $user_bank_no,
	            'user_bank_an' 	 	=> $user_bank_an,
	        ),
            array('user_id' => $user_id), //where
            array('%s'), //data format
            array('%s') //where format    
        );

	    $user_firstname_update = str_replace('\\', '', $user_firstname);
	    $user_lastname_update = str_replace('\\', '', $user_lastname);

        // ACTION Update TO DB
	    $wpdb->update(
            $table_name2, //table
            array(
	            'meta_value' => $user_firstname_update,
	        ),
            array('user_id' => $user_id, 'meta_key' => 'first_name' ), //where
            array('%s'), //data format
            array('%s') //where format    
        );
	    $wpdb->update(
            $table_name2, //table
            array(
	            'meta_value' => $user_lastname_update,
	        ),
            array('user_id' => $user_id, 'meta_key' => 'last_name' ), //where
            array('%s'), //data format
            array('%s') //where format    
        );
	    $wpdb->update(
            $table_name4, //table
            array(
	            'user_email' => $user_email,
	        ),
            array('ID' => $user_id), //where
            array('%s'), //data format
            array('%s') //where format    
        );
	    $wpdb->update(
            $table_name4, //table
            array(
	            'display_name' => $user_firstname_update.' '.$user_lastname_update,
	        ),
            array('ID' => $user_id), //where
            array('%s'), //data format
            array('%s') //where format    
        );

	    if($email_on=='1'){
	        if($check[0]->user_verification=='2' && $user_verification=='1'){

				$message = '<p>Akun anda dengan email '.$user_email.' berhasil kami verifikasi.<br>Selamat menggunakan layanan kami.</p>';
	            $subject = 'Your account is Verified';
	            $emailnya = $user_email;
	            $headers[] = 'Content-Type: text/html; charset=UTF-8';
	            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';
	 			
				if($emailnya!=''){
					wp_mail( $emailnya, $subject, $body, $headers );
				}
			}
			if($check[0]->user_verification=='2' && $user_verification=='3'){

				$message = '<p>Akun anda dengan email '.$user_email.' belum memenuhi syarat verifikasi.<br>Silahkan lengkapi data terlebih dahulu sesuai dengan data yang kami minta agar bisa kami verifikasi. Terimakasih</p>';
	            $subject = 'Your account is Rejected';
	            $emailnya = $user_email;
	            $headers[] = 'Content-Type: text/html; charset=UTF-8';
	            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';
	 			
				if($emailnya!=''){
					wp_mail( $emailnya, $subject, $body, $headers );
				}
			}
		}

   		// set new role
		$u = new WP_User($user_id);
		$u->set_role($user_role);

        echo 'success';

	}else{

		$randid = 'u_'.d_randomString(8);

        // insert data to table user
        $wpdb->insert(
            $table_name, //table
            array(
                'user_id'           => $user_id,
                'user_randid'       => $randid,
                'user_type' 		=> $user_type,
		        'user_verification' => $user_verification,
		        'user_bio' 			=> $user_bio,
		        'user_wa' 			=> $user_wa,
		        'user_provinsi' 	=> $user_provinsi,
		        'user_kabkota' 		=> $user_kabkota,
		        'user_kecamatan' 	=> $user_kecamatan,
		        'user_provinsi_id' 	=> $user_provinsi_id,
		        'user_kabkota_id' 	=> $user_kabkota_id,
		        'user_kecamatan_id' => $user_kecamatan_id,
		        'user_alamat' 		=> $user_alamat,
		        'user_bank_name' 	=> $user_bank_name,
		        'user_bank_no' 	 	=> $user_bank_no,
		        'user_bank_an' 	 	=> $user_bank_an,
                'user_pp_img'       => null,
                'user_cover_img'    => null,
                'created_at'    	=> date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

        // insert data to table verifications
        $wpdb->insert(
            $table_name3, //table
            array(
                'u_id'                  => $user_id,
                'u_nama_lengkap'        => null,
                'u_email'               => null,
                'u_whatsapp'            => null,
                'u_ktp'                 => null,
                'u_ktp_selfie'          => null,
                'u_jabatan'             => null,
                'u_nama_ketua'          => null,
                'u_alamat_lengkap'      => null,
                'u_program_unggulan'    => null,
                'u_profile'             => null,
                'u_legalitas'           => null,
                'created_at'            => date("Y-m-d H:i:s")),
            array('%s', '%s') //data format         
        );

        $user_firstname_update = str_replace('\\', '', $user_firstname);
	    $user_lastname_update = str_replace('\\', '', $user_lastname);

        // ACTION Update TO DB
	    $wpdb->update(
            $table_name2, //table
            array(
	            'meta_value' => $user_firstname_update,
	        ),
            array('user_id' => $user_id, 'meta_key' => 'first_name' ), //where
            array('%s'), //data format
            array('%s') //where format    
        );
	    $wpdb->update(
            $table_name2, //table
            array(
	            'meta_value' => $user_lastname_update,
	        ),
            array('user_id' => $user_id, 'meta_key' => 'last_name' ), //where
            array('%s'), //data format
            array('%s') //where format    
        );

   		// set new role
		$u = new WP_User($user_id);
		$u->set_role($user_role);

        echo 'success';
	}


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_user', 'djafunction_update_user' );
add_action( 'wp_ajax_nopriv_djafunction_update_user', 'djafunction_update_user' );




function djafunction_update_profile() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "usermeta";
    $table_name3 = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 		= $_POST['datanya'][0];
    $first_name 	= $_POST['datanya'][1];
    $last_name 		= $_POST['datanya'][2];
    $user_bio 		= $_POST['datanya'][3];
    $user_alamat 	= $_POST['datanya'][4];
    $user_provinsi 	= $_POST['datanya'][5];
    $user_kabkota 	= $_POST['datanya'][6];
    $user_kecamatan 	= $_POST['datanya'][7];
    $user_provinsi_id 	= $_POST['datanya'][8];
    $user_kabkota_id 	= $_POST['datanya'][9];
    $user_kecamatan_id 	= $_POST['datanya'][10];

    if($last_name==''){
    	$full_name = $first_name;
    }else{
    	$full_name = $first_name.' '.$last_name;
    }
    

    if($id_login==$user_id){

		    // ACTION Update TO DB
		    $wpdb->update(
	            $table_name, //table
	            array(
		            'user_bio' 			=> $user_bio,
		            'user_provinsi' 	=> $user_provinsi,
		            'user_kabkota' 		=> $user_kabkota,
		            'user_kecamatan' 	=> $user_kecamatan,
		            'user_provinsi_id' 	=> $user_provinsi_id,
		            'user_kabkota_id' 	=> $user_kabkota_id,
		            'user_kecamatan_id' => $user_kecamatan_id,
		            'user_alamat' 		=> $user_alamat
		        ),
	            array('user_id' => $user_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

	        // ACTION Update TO DB
		    $wpdb->update(
	            $table_name2, //table
	            array(
		            'meta_value' => $first_name,
		        ),
	            array('user_id' => $user_id, 'meta_key' => 'first_name' ), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );
		    $wpdb->update(
	            $table_name2, //table
	            array(
		            'meta_value' => $last_name,
		        ),
	            array('user_id' => $user_id, 'meta_key' => 'last_name' ), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );
		    $wpdb->update(
	            $table_name3, //table
	            array(
		            'display_name' => $full_name,
		        ),
	            array('ID' => $user_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );
			
			echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_profile', 'djafunction_update_profile' );
add_action( 'wp_ajax_nopriv_djafunction_update_profile', 'djafunction_update_profile' );




function djafunction_update_akun() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_wa 	= $_POST['datanya'][1];
    $user_email = $_POST['datanya'][2];
    

    if($id_login==$user_id){

		    // ACTION Update TO DB
		    $wpdb->update(
	            $table_name, //table
	            array(
		            'user_wa' 			=> $user_wa
		        ),
	            array('user_id' => $user_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

	        // ACTION Update TO DB
		    $wpdb->update(
	            $table_name2, //table
	            array(
		            'user_email' => $user_email,
		        ),
	            array('ID' => $user_id ), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );
			
			echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_akun', 'djafunction_update_akun' );
add_action( 'wp_ajax_nopriv_djafunction_update_akun', 'djafunction_update_akun' );


function djafunction_update_akun_bank() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_bank_name = $_POST['datanya'][1];
    $user_bank_no = $_POST['datanya'][2];
    $user_bank_an = $_POST['datanya'][3];
    

    if($id_login==$user_id){

		    // ACTION Update TO DB
		    $wpdb->update(
	            $table_name, //table
	            array(
		            'user_bank_name' => $user_bank_name,
		            'user_bank_no' 	 => $user_bank_no,
		            'user_bank_an' 	 => $user_bank_an,
		        ),
	            array('user_id' => $user_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

	        echo 'success';


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_akun_bank', 'djafunction_update_akun_bank' );
add_action( 'wp_ajax_nopriv_djafunction_update_akun_bank', 'djafunction_update_akun_bank' );


function djafunction_update_pp_img() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_pp_img = $_POST['datanya'][1];

    if($id_login==$user_id){

		    // ACTION Update TO DB
		    $wpdb->update(
	            $table_name, //table
	            array(
		            'user_pp_img' => $user_pp_img
		        ),
	            array('user_id' => $user_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

	        echo 'success';


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_pp_img', 'djafunction_update_pp_img' );
add_action( 'wp_ajax_nopriv_djafunction_update_pp_img', 'djafunction_update_pp_img' );


function djafunction_update_pp_img_user() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_pp_img = $_POST['datanya'][1];

    $check = $wpdb->get_results('SELECT id from '.$table_name.' where user_id="'.$user_id.'"');
	if($check!=null){

	    // ACTION Update TO DB
	    $wpdb->update(
            $table_name, //table
            array(
	            'user_pp_img' => $user_pp_img
	        ),
            array('user_id' => $user_id), //where
            array('%s'), //data format
            array('%s') //where format    
        );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_pp_img_user', 'djafunction_update_pp_img_user' );
add_action( 'wp_ajax_nopriv_djafunction_update_pp_img_user', 'djafunction_update_pp_img_user' );



function djafunction_upload_ktp() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "dja_verification_details";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id = $_POST['datanya'][0];
    $u_ktp 	 = $_POST['datanya'][1];

    if($id_login==$user_id){

    		$check = $wpdb->get_results('SELECT id from '.$table_name2.' where u_id="'.$user_id.'"');
			if($check!=null){

				// ACTION Update TO DB
			    $wpdb->update(
		            $table_name2, //table
		            array(
			            'u_ktp' => $u_ktp
			        ),
		            array('u_id' => $user_id), //where
		            array('%s'), //data format
		            array('%s') //where format    
		        );

			}else{
				// ACTION INSERT TO DB
			    $wpdb->insert(
		            $table_name2, //table
		            array(
			            'u_id' 					=> $user_id,
			            'u_nama_lengkap'		=> null,
			            'u_email' 				=> null,
			            'u_whatsapp' 			=> null,
			            'u_ktp' 				=> $u_ktp,
			            'u_ktp_selfie' 			=> null,
			            'u_jabatan' 			=> null,
			            'u_nama_ketua' 			=> null,
			            'u_alamat_lengkap' 		=> null,
			            'u_program_unggulan' 	=> null,
			            'u_profile' 			=> null,
			            'u_legalitas' 			=> null,
			            'created_at' 			=> date("Y-m-d H:i:s")),
		            array('%s', '%s') //data format         
		        );
			}

	        echo 'success';


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_upload_ktp', 'djafunction_upload_ktp' );
add_action( 'wp_ajax_nopriv_djafunction_upload_ktp', 'djafunction_upload_ktp' );


function djafunction_upload_app_logo() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id  = $_POST['datanya'][0];
    $logo_url = $_POST['datanya'][1];

    if($id_login==$user_id){
		// ACTION Update TO DB
	    $wpdb->update(
            $table_name, //table
            array(
	            'data' => $logo_url
	        ),
            array('type' => 'logo_url'), //where
            array('%s'), //data format
            array('%s') //where format    
        );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_upload_app_logo', 'djafunction_upload_app_logo' );
add_action( 'wp_ajax_nopriv_djafunction_upload_app_logo', 'djafunction_upload_app_logo' );



function djafunction_update_themes_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $app_name  	 = $_POST['datanya'][0];
    $theme_color = str_replace('\\', '', $_POST['datanya'][1]);

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $app_name ), array('type' => 'app_name'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $theme_color ), array('type' => 'theme_color'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_themes_settings', 'djafunction_update_themes_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_themes_settings', 'djafunction_update_themes_settings' );



function djafunction_update_form_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $page_donate  	= $_POST['datanya'][0];
    $form_setting 	= $_POST['datanya'][1];
    $opt_nominal 	= str_replace('\\', '', $_POST['datanya'][2]);
    $max_package 	= $_POST['datanya'][3];
    $anonim_text 	= $_POST['datanya'][4];
    $page_typ 		= $_POST['datanya'][5];
    $form_text 		= str_replace('\\', '', $_POST['datanya'][6]);
    $form_email_setting 	= $_POST['datanya'][7];
    $form_comment_setting 	= $_POST['datanya'][8];
    $limitted_donation_button 	= $_POST['datanya'][9];
    $form_confirmation_setting 	= $_POST['datanya'][10];
    $minimum_donate 	= $_POST['datanya'][11];


    if($form_setting==''){
    	$form_setting = 0;
    }else{
    	$form_setting = 1;
    }

    if($form_email_setting==''){
    	$form_email_setting = 0;
    }else{
    	$form_email_setting = 1;
    }

    if($form_comment_setting==''){
    	$form_comment_setting = 0;
    }else{
    	$form_comment_setting = 1;
    }

    if($limitted_donation_button==''){
    	$limitted_donation_button = 0;
    }else{
    	$limitted_donation_button = 1;
    }

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $page_donate ), array('type' => 'page_donate'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $form_setting ), array('type' => 'form_setting'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $opt_nominal ), array('type' => 'opt_nominal'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $max_package ), array('type' => 'max_package'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $anonim_text ), array('type' => 'anonim_text'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $page_typ ), array('type' => 'page_typ'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $form_text ), array('type' => 'form_text'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $form_email_setting ), array('type' => 'form_email_setting'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $form_comment_setting ), array('type' => 'form_comment_setting'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $limitted_donation_button ), array('type' => 'limitted_donation_button'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $form_confirmation_setting ), array('type' => 'form_confirmation_setting'), array('%s'), array('%s') );
        $wpdb->update( $table_name,array( 'data' => $minimum_donate ), array('type' => 'minimum_donate'), array('%s'), array('%s') );
        

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_form_settings', 'djafunction_update_form_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_form_settings', 'djafunction_update_form_settings' );



function djafunction_del_category(){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_category";

    // FROM INPUT
    $id 	= $_POST['datanya'][0];

    if ( $wpdb->get_var( $wpdb->prepare( 'SELECT id FROM '.$table_name.' WHERE id = %d', $id ) ) ) {
		// then delete
        $wpdb->query( $wpdb->prepare( 'DELETE FROM '.$table_name.' WHERE id = "'.$id.'" ' ) );
    }

	echo 'success';

    wp_die();
}
add_action( 'wp_ajax_djafunction_del_category', 'djafunction_del_category' );
add_action( 'wp_ajax_nopriv_djafunction_del_category', 'djafunction_del_category' );




function djafunction_add_new_category() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_category";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $code  		= $_POST['datanya'][0];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
		if($code=='add_new'){
			$wpdb->insert( 
				$table_name, 
				array(
					'category' => 'New',
				) 
			);
	        echo 'success';
		}
    }else{
    	echo 'Not allowed.';
    }

    wp_die();

} 
add_action( 'wp_ajax_djafunction_add_new_category', 'djafunction_add_new_category' );
add_action( 'wp_ajax_nopriv_djafunction_add_new_category', 'djafunction_add_new_category' );



function djafunction_save_category() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_category";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $id  		= $_POST['datanya'][0];
    $category  	= $_POST['datanya'][1];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'category' => $category ), array('id' => $id), array('%s'), array('%s') );
        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_save_category', 'djafunction_save_category' );
add_action( 'wp_ajax_nopriv_djafunction_save_category', 'djafunction_save_category' );



function djafunction_update_category_private() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_category";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $id  		= $_POST['datanya'][0];
    $value  	= $_POST['datanya'][1];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'private_category' => $value ), array('id' => $id), array('%s'), array('%s') );
        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_category_private', 'djafunction_update_category_private' );
add_action( 'wp_ajax_nopriv_djafunction_update_category_private', 'djafunction_update_category_private' );



function get_data_campaign($id){
	global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";

    $data_campaign = $wpdb->get_results("SELECT id FROM $table_name where category_id='$id' ");
	return count($data_campaign);
}



function djafunction_update_socialproof() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $socialproof_text  		= $_POST['datanya'][0];
    $socialproof_settings  	= str_replace('\\', '', $_POST['datanya'][1]);

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $socialproof_text ), array('type' => 'socialproof_text'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $socialproof_settings ), array('type' => 'socialproof_settings'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_socialproof', 'djafunction_update_socialproof' );
add_action( 'wp_ajax_nopriv_djafunction_update_socialproof', 'djafunction_update_socialproof' );


function djafunction_update_general_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $login_setting  	= $_POST['datanya'][0];
    $page_login  		= $_POST['datanya'][1];
    $login_text  		= $_POST['datanya'][2];
    $register_setting   = $_POST['datanya'][3];
    $page_register  	= $_POST['datanya'][4];
    $register_text  	= $_POST['datanya'][5];
    $campaign_setting  	= $_POST['datanya'][6];
    $del_campaign_setting  = $_POST['datanya'][7];
    $label_tab  		= $_POST['datanya'][8];
    $max_love  			= $_POST['datanya'][9];
    $max_love_custom	= $_POST['datanya'][10];
    $powered_by_setting	= $_POST['datanya'][11];
    $fb_pixel			= $_POST['datanya'][12];
    $fb_event			= str_replace('\\', '', $_POST['datanya'][13]);
    $jquery_on			= $_POST['datanya'][14];
    $gtm_id				= $_POST['datanya'][15];
    $changepass_setting	= $_POST['datanya'][16];
    $tiktok_pixel		= $_POST['datanya'][17];
    $register_checkbox_setting	= $_POST['datanya'][18];
    $register_checkbox_info		= $_POST['datanya'][19];
    $jquery_custom		= $_POST['datanya'][20];
    

    if($login_setting==''){
    	$login_setting = 0;
    }else{
    	$login_setting = 1;
    }

    if($register_setting==''){
    	$register_setting = 0;
    }else{
    	$register_setting = 1;
    }
    
    if($campaign_setting==''){
    	$campaign_setting = 0;
    }else{
    	$campaign_setting = 1;
    }
    
    if($del_campaign_setting==''){
    	$del_campaign_setting = 0;
    }else{
    	$del_campaign_setting = 1;
    }

    if($max_love!='0'){
    	$max_love = $max_love_custom;
    }

    if($powered_by_setting==''){
    	$powered_by_setting = 0;
    }else{
    	$powered_by_setting = 1;
    }

    if($jquery_on==''){
    	$jquery_on = 0;
    }

    if($changepass_setting==''){
    	$changepass_setting = 0;
    }else{
    	$changepass_setting = 1;
    }

    if($register_checkbox_setting==''){
    	$register_checkbox_setting = 0;
    }else{
    	$register_checkbox_setting = 1;
    }

    

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $login_setting ), array('type' => 'login_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $page_login ), array('type' => 'page_login'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $login_text ), array('type' => 'login_text'), array('%s'), array('%s') );

	    $wpdb->update( $table_name,array( 'data' => $register_setting ), array('type' => 'register_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $page_register ), array('type' => 'page_register'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $register_text ), array('type' => 'register_text'), array('%s'), array('%s') );
	    
	    $wpdb->update( $table_name,array( 'data' => $campaign_setting ), array('type' => 'campaign_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $del_campaign_setting ), array('type' => 'del_campaign_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $label_tab ), array('type' => 'label_tab'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $max_love ), array('type' => 'max_love'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $powered_by_setting ), array('type' => 'powered_by_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fb_pixel ), array('type' => 'fb_pixel'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $fb_event ), array('type' => 'fb_event'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $jquery_on ), array('type' => 'jquery_on'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $gtm_id ), array('type' => 'gtm_id'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $changepass_setting ), array('type' => 'changepass_setting'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $tiktok_pixel ), array('type' => 'tiktok_pixel'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $register_checkbox_setting ), array('type' => 'register_checkbox_setting'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $register_checkbox_info ), array('type' => 'register_checkbox_info'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $jquery_custom ), array('type' => 'jquery_custom'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_general_settings', 'djafunction_update_general_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_general_settings', 'djafunction_update_general_settings' );





function djafunction_update_payment_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $payment_setting = str_replace('\\', '', $_POST['datanya'][0]);
    $bank_account  	 = str_replace('\\', '', $_POST['datanya'][1]);
    $unique_number_setting  = $_POST['datanya'][2];
    $unique_number_value  	= str_replace('\\', '', $_POST['datanya'][3]);

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $payment_setting ), array('type' => 'payment_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $bank_account ), array('type' => 'bank_account'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $unique_number_setting ), array('type' => 'unique_number_setting'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $unique_number_value ), array('type' => 'unique_number_value'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_payment_settings', 'djafunction_update_payment_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_payment_settings', 'djafunction_update_payment_settings' );



function djafunction_update_ipaymu_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $ipaymu_mode 	= $_POST['datanya'][0];
    $ipaymu_va  	= $_POST['datanya'][1];
    $ipaymu_apikey  = $_POST['datanya'][2];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $ipaymu_mode ), array('type' => 'ipaymu_mode'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $ipaymu_va ), array('type' => 'ipaymu_va'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $ipaymu_apikey ), array('type' => 'ipaymu_apikey'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_ipaymu_settings', 'djafunction_update_ipaymu_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_ipaymu_settings', 'djafunction_update_ipaymu_settings' );


function djafunction_update_tripay_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $tripay_mode 		= $_POST['datanya'][0];
    $tripay_apikey  	= $_POST['datanya'][1];
    $tripay_privatekey  = $_POST['datanya'][2];
    $tripay_merchant  	= $_POST['datanya'][3];
    $tripay_apikey_sandbox  	= $_POST['datanya'][4];
    $tripay_privatekey_sandbox  = $_POST['datanya'][5];
    $tripay_merchant_sandbox  	= $_POST['datanya'][6];
    $tripay_qris  		= $_POST['datanya'][7];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $tripay_mode ), array('type' => 'tripay_mode'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_apikey ), array('type' => 'tripay_apikey'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_privatekey ), array('type' => 'tripay_privatekey'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_merchant ), array('type' => 'tripay_merchant'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_apikey_sandbox ), array('type' => 'tripay_apikey_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_privatekey_sandbox ), array('type' => 'tripay_privatekey_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_merchant_sandbox ), array('type' => 'tripay_merchant_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $tripay_qris ), array('type' => 'tripay_qris'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_tripay_settings', 'djafunction_update_tripay_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_tripay_settings', 'djafunction_update_tripay_settings' );


function djafunction_update_flip_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $flip_mode 				= $_POST['datanya'][0];
    $flip_apikey  			= $_POST['datanya'][1];
    $flip_validation_token  = $_POST['datanya'][2];
    $flip_apikey_sandbox  	= $_POST['datanya'][3];
    $flip_validation_token_sandbox  	= $_POST['datanya'][4];
    $flip_redirect 			= $_POST['datanya'][5];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $flip_mode ), array('type' => 'flip_mode'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $flip_apikey ), array('type' => 'flip_apikey'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $flip_validation_token ), array('type' => 'flip_validation_token'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $flip_apikey_sandbox ), array('type' => 'flip_apikey_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $flip_validation_token_sandbox ), array('type' => 'flip_validation_token_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $flip_redirect ), array('type' => 'flip_redirect'), array('%s'), array('%s') );
        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_flip_settings', 'djafunction_update_flip_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_flip_settings', 'djafunction_update_flip_settings' );



function djafunction_update_midtrans_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $midtrans_mode 		 = $_POST['datanya'][0];
    $midtrans_serverkey  = $_POST['datanya'][1];
    $midtrans_clientkey  = $_POST['datanya'][2];
    $midtrans_merchant   = $_POST['datanya'][3];
    $midtrans_serverkey_sandbox  = $_POST['datanya'][4];
    $midtrans_clientkey_sandbox  = $_POST['datanya'][5];
    $midtrans_merchant_sandbox   = $_POST['datanya'][6];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $midtrans_mode ), array('type' => 'midtrans_mode'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $midtrans_serverkey ), array('type' => 'midtrans_serverkey'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $midtrans_clientkey ), array('type' => 'midtrans_clientkey'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $midtrans_merchant ), array('type' => 'midtrans_merchant'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $midtrans_serverkey_sandbox ), array('type' => 'midtrans_serverkey_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $midtrans_clientkey_sandbox ), array('type' => 'midtrans_clientkey_sandbox'), array('%s'), array('%s') );
	    $wpdb->update( $table_name,array( 'data' => $midtrans_merchant_sandbox ), array('type' => 'midtrans_merchant_sandbox'), array('%s'), array('%s') );

        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_midtrans_settings', 'djafunction_update_midtrans_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_midtrans_settings', 'djafunction_update_midtrans_settings' );


function djafunction_update_moota_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $moota_secret_token = $_POST['datanya'][0];
    $moota_range = $_POST['datanya'][1];

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $moota_secret_token ), array('type' => 'moota_secret_token'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $moota_range ), array('type' => 'moota_range'), array('%s'), array('%s') );
	
        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_moota_settings', 'djafunction_update_moota_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_moota_settings', 'djafunction_update_moota_settings' );


function djafunction_update_wanotif_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $wanotif_apikey = $_POST['datanya'][0];
    $wanotif_message = str_replace('\\', '', $_POST['datanya'][1]);
    $wanotif_message2 = str_replace('\\', '', $_POST['datanya'][2]);
    $wanotif_followup1_on = $_POST['datanya'][3];
    $wanotif_on = $_POST['datanya'][4];
    $wanotif_apikey_cs = str_replace('\\', '', $_POST['datanya'][5]);

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $wpdb->update( $table_name,array( 'data' => $wanotif_apikey ), array('type' => 'wanotif_apikey'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $wanotif_message ), array('type' => 'wanotif_message'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $wanotif_message2 ), array('type' => 'wanotif_message2'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $wanotif_followup1_on ), array('type' => 'wanotif_followup1_on'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $wanotif_on ), array('type' => 'wanotif_on'), array('%s'), array('%s') );
		$wpdb->update( $table_name,array( 'data' => $wanotif_apikey_cs ), array('type' => 'wanotif_apikey_cs'), array('%s'), array('%s') );
	
        echo 'success';

    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_wanotif_settings', 'djafunction_update_wanotif_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_wanotif_settings', 'djafunction_update_wanotif_settings' );



function djafunction_update_telegram_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $telegram_send_to = str_replace('\\', '', $_POST['datanya'][0]);
    $telegram_send_to = str_replace('linebreak', '\n', $telegram_send_to);
    $telegram_on 		= $_POST['datanya'][1];
    $telegram_bot_token = $_POST['datanya'][2];
    $telegram_manual_confirmation = str_replace('\\', '', $_POST['datanya'][3]);
    $telegram_manual_confirmation = str_replace('linebreak', '\n', $telegram_manual_confirmation);

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $a = $wpdb->update( $table_name,array( 'data' => $telegram_send_to ), array('type' => 'telegram_send_to'), array('%s'), array('%s') );
	    $b = $wpdb->update( $table_name,array( 'data' => $telegram_on ), array('type' => 'telegram_on'), array('%s'), array('%s') );
	    $c = $wpdb->update( $table_name,array( 'data' => $telegram_bot_token ), array('type' => 'telegram_bot_token'), array('%s'), array('%s') );
	    $d = $wpdb->update( $table_name,array( 'data' => $telegram_manual_confirmation ), array('type' => 'telegram_manual_confirmation'), array('%s'), array('%s') );
	
        if($a === FALSE){
			echo 'failed';
		}else{
			echo 'success';
		}

    }else{
    	echo 'Not allowed.';
    }

    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_telegram_settings', 'djafunction_update_telegram_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_telegram_settings', 'djafunction_update_telegram_settings' );


function djafunction_update_email_settings() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_settings";

    $id_login = wp_get_current_user()->ID;

    // FROM INPUT
    $email_send_to = str_replace('\\', '', $_POST['datanya'][0]);
    $email_on 	   = $_POST['datanya'][1];
    $email_success_message = str_replace('\\', '', $_POST['datanya'][2]);

    if($id_login!='' || $id_login!=null){
		// ACTION Update TO DB
	    $a = $wpdb->update( $table_name,array( 'data' => $email_send_to ), array('type' => 'email_send_to'), array('%s'), array('%s') );
	    $b = $wpdb->update( $table_name,array( 'data' => $email_on ), array('type' => 'email_on'), array('%s'), array('%s') );
		$c = $wpdb->update( $table_name,array( 'data' => $email_success_message ), array('type' => 'email_success_message'), array('%s'), array('%s') );
	
        if($a === FALSE){
			echo 'failed';
		}else{
			echo 'success';
		}

    }else{
    	echo 'Not allowed.';
    }

    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_email_settings', 'djafunction_update_email_settings' );
add_action( 'wp_ajax_nopriv_djafunction_update_email_settings', 'djafunction_update_email_settings' );



function djafunction_upload_ktp_selfie() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "dja_verification_details";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 		= $_POST['datanya'][0];
    $u_ktp_selfie 	= $_POST['datanya'][1];

    if($id_login==$user_id){

    		$check = $wpdb->get_results('SELECT id from '.$table_name2.' where u_id="'.$user_id.'"');
			if($check!=null){

				// ACTION Update TO DB
			    $wpdb->update(
		            $table_name2, //table
		            array(
			            'u_ktp_selfie' => $u_ktp_selfie
			        ),
		            array('u_id' => $user_id), //where
		            array('%s'), //data format
		            array('%s') //where format    
		        );

			}else{
				// ACTION INSERT TO DB
			    $wpdb->insert(
		            $table_name2, //table
		            array(
			            'u_id' 					=> $user_id,
			            'u_nama_lengkap'		=> null,
			            'u_email' 				=> null,
			            'u_whatsapp' 			=> null,
			            'u_ktp' 				=> null,
			            'u_ktp_selfie' 			=> $u_ktp_selfie,
			            'u_jabatan' 			=> null,
			            'u_nama_ketua' 			=> null,
			            'u_alamat_lengkap' 		=> null,
			            'u_program_unggulan' 	=> null,
			            'u_profile' 			=> null,
			            'u_legalitas' 			=> null,
			            'created_at' 			=> date("Y-m-d H:i:s")),
		            array('%s', '%s') //data format         
		        );
			}

	        echo 'success';


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_upload_ktp_selfie', 'djafunction_upload_ktp_selfie' );
add_action( 'wp_ajax_nopriv_djafunction_upload_ktp_selfie', 'djafunction_upload_ktp_selfie' );


function djafunction_upload_legalitas() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "dja_verification_details";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 		= $_POST['datanya'][0];
    $u_legalitas 	= $_POST['datanya'][1];

    if($id_login==$user_id){

    		$check = $wpdb->get_results('SELECT id from '.$table_name2.' where u_id="'.$user_id.'"');
			if($check!=null){

				// ACTION Update TO DB
			    $wpdb->update(
		            $table_name2, //table
		            array(
			            'u_legalitas' => $u_legalitas
			        ),
		            array('u_id' => $user_id), //where
		            array('%s'), //data format
		            array('%s') //where format    
		        );

			}else{
				// ACTION INSERT TO DB
			    $wpdb->insert(
		            $table_name2, //table
		            array(
			            'u_id' 					=> $user_id,
			            'u_nama_lengkap'		=> null,
			            'u_email' 				=> null,
			            'u_whatsapp' 			=> null,
			            'u_ktp' 				=> null,
			            'u_ktp_selfie' 			=> null,
			            'u_jabatan' 			=> null,
			            'u_nama_ketua' 			=> null,
			            'u_alamat_lengkap' 		=> null,
			            'u_program_unggulan' 	=> null,
			            'u_profile' 			=> null,
			            'u_legalitas' 			=> $u_legalitas,
			            'created_at' 			=> date("Y-m-d H:i:s")),
		            array('%s', '%s') //data format         
		        );
			}

	        echo 'success';


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_upload_legalitas', 'djafunction_upload_legalitas' );
add_action( 'wp_ajax_nopriv_djafunction_upload_legalitas', 'djafunction_upload_legalitas' );



function djafunction_submit_verification() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "dja_verification_details";
    $table_name3 = $wpdb->prefix . "dja_settings";    

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 		= $_POST['datanya'][0];
    $action 		= $_POST['datanya'][1];
    
    $u_nama_lengkap = $_POST['datanya'][2];
    $u_email 		= $_POST['datanya'][3];
    $u_whatsapp 	= $_POST['datanya'][4];
    $u_ktp 			= $_POST['datanya'][5];
    $u_ktp_selfie 	= $_POST['datanya'][6];
    $u_jabatan 		= $_POST['datanya'][7];

    $u_nama_ketua 	= $_POST['datanya'][8];
    $u_alamat_lengkap 	= $_POST['datanya'][9];
    $u_program_unggulan = $_POST['datanya'][10];
    $u_profile 		= $_POST['datanya'][11];
    $u_legalitas 	= $_POST['datanya'][12];

    $akun_user = $_POST['datanya'][13];

    $u_nama_lengkap = str_replace('\\', '', $u_nama_lengkap);

    // get email settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name3.' where type="email_on" ORDER BY id ASC');
    $email_on 		  = $query_settings[0]->data;

    if($id_login==$user_id){

    		$check = $wpdb->get_results('SELECT id from '.$table_name2.' where u_id="'.$user_id.'"');
			if($check!=null){

				if($akun_user=='personal'){
					// ACTION Update TO DB
				    $wpdb->update(
			            $table_name2, //table
			            array(
				            'u_nama_lengkap'		=> $u_nama_lengkap,
				            'u_email' 				=> $u_email,
				            'u_whatsapp' 			=> $u_whatsapp
				        ),
			            array('u_id' => $user_id), //where
			            array('%s'), //data format
			            array('%s') //where format    
			        );
				}else{
					// ORGANISASI
					// ACTION Update TO DB
				    $wpdb->update(
			            $table_name2, //table
			            array(
				            'u_nama_lengkap'		=> $u_nama_lengkap,
				            'u_email' 				=> $u_email,
				            'u_whatsapp' 			=> $u_whatsapp,
				            'u_jabatan' 			=> $u_jabatan,
				            'u_nama_ketua' 			=> $u_nama_ketua,
				            'u_alamat_lengkap' 		=> $u_alamat_lengkap,
				            'u_program_unggulan' 	=> $u_program_unggulan,
				            'u_profile' 			=> $u_profile
				        ),
			            array('u_id' => $user_id), //where
			            array('%s'), //data format
			            array('%s') //where format    
			        );
				}

				if($action=='submit'){

					// Update type user and verification 2 = on Review
				    $wpdb->update(
			            $table_name, //table
			            array(
				            'user_type'	=> $akun_user,
				            'user_verification'	=> 2,

				        ),
			            array('user_id' => $user_id), //where
			            array('%s'), //data format
			            array('%s') //where format    
			        );

			        if($email_on=='1'){
				    	$message = '<p>Terimakasih telah menginput data verifikasi, akun anda masih dalam proses Review.</p>';
				        $subject = 'Your account is on Review';
				        $emailnya = $u_email;
				        $headers[] = 'Content-Type: text/html; charset=UTF-8';
				        $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';
							
						if($emailnya!=''){
							wp_mail( $emailnya, $subject, $body, $headers );
						}
				    }

					echo 'success_to_submit';

				}else{
					// Only Update type user
				    $wpdb->update(
			            $table_name, //table
			            array(
				            'user_type'	=> $akun_user
				        ),
			            array('user_id' => $user_id), //where
			            array('%s'), //data format
			            array('%s') //where format    
			        );

					echo 'success_to_draft';
				}
					
			}else{
				echo 'failed.';
			}


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_submit_verification', 'djafunction_submit_verification' );
add_action( 'wp_ajax_nopriv_djafunction_submit_verification', 'djafunction_submit_verification' );






function djafunction_update_cover_img() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $table_name2 = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_cover_img = $_POST['datanya'][1];
    
    if($id_login==$user_id){

		    // ACTION Update TO DB
		    $wpdb->update(
	            $table_name, //table
	            array(
		            'user_cover_img' => $user_cover_img
		        ),
	            array('user_id' => $user_id), //where
	            array('%s'), //data format
	            array('%s') //where format    
	        );

	        echo 'success';


    }else{
    	echo 'Not allowed.';
    }


    wp_die();

} 
add_action( 'wp_ajax_djafunction_update_cover_img', 'djafunction_update_cover_img' );
add_action( 'wp_ajax_nopriv_djafunction_update_cover_img', 'djafunction_update_cover_img' );





// Load Data Donatur Only
function djafunction_load_data_donatur() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_love";
    $table_name3 = $wpdb->prefix . "dja_campaign";
    
    $id = $_POST['datanya'][0];
    $campaign_id = $_POST['datanya'][1];
    $load_count = $_POST['datanya'][2];
    $anonim_text = $_POST['datanya'][3];
    $fullanonim = $_POST['datanya'][4];
    $start = ($load_count-1)*5;
    $limit = 5;

    $value = $wpdb->get_results("SELECT * FROM $table_name3 where campaign_id='$campaign_id' ")[0];
    $general_status = $value->general_status;
    $allocation_title = $value->allocation_title;
    $allocation_others_title = $value->allocation_others_title;

    if($general_status=='1'){
        if($allocation_title=='1'){
            $allocation_title = 'Donasi';
        }elseif($allocation_title=='2'){
            $allocation_title = 'Zakat';
        }elseif($allocation_title=='3'){
            $allocation_title = 'Qurban';
        }else{
            $allocation_title = $allocation_others_title;
        }
    }else{
        $allocation_title = 'Donasi';
    }

    if($campaign_id!=''){
  		
		$donation_paid = $wpdb->get_results("SELECT * FROM $table_name where campaign_id='$campaign_id' and status='1' ORDER BY id DESC LIMIT $start,$limit ");

		// $num = 1;
		$jumlah_arr = count($donation_paid);
		$the_data = '';
		foreach ($donation_paid as $value) {
			

			$donatur_name = $value->name;
			$anonim = 'Orang Baik';
			if($value->anonim=='1'){
				$donatur_name = $anonim_text;
			}

			// time
			$readtime = new donasiaja_readtime();
			$fix_time = $readtime->time_donation($value->created_at);

			// nominal
			$nominal = 'Rp '.number_format($value->nominal,0,",",".");

			// strtolower($allocation_title)

        	$the_data .= '
	        <div class="donation_inner_box" style="background:rgb(250, 252, 255);">
	            <div class="donation_name">'.$donatur_name.'<span class="donation_time"><span class="dashicons dashicons-clock"></span>'.$fix_time.'</span>
	            </div>
	            <div class="donation_total">Ber'.strtolower($allocation_title).' sebesar <b>'.$nominal.'</b></div>    	
	        </div>
	        ';
			

		}

		echo $the_data;

  	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_load_data_donatur', 'djafunction_load_data_donatur' );
add_action( 'wp_ajax_nopriv_djafunction_load_data_donatur', 'djafunction_load_data_donatur' );



// Load Data Donatur and Comment
function djafunction_load_list_donatur() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_love";
    $table_name3 = $wpdb->prefix . "dja_campaign";

    $id = $_POST['datanya'][0];
    $campaign_id = $_POST['datanya'][1];
    $load_count = $_POST['datanya'][2];
    $anonim_text = $_POST['datanya'][3];
    $fullanonim = $_POST['datanya'][4];
    $start = ($load_count-1)*5;
    $limit = 5;

    // Campaign Settings
    if($campaign_id=='all'){
    	$value = $wpdb->get_results("SELECT * FROM $table_name3 ")[0];
    	$donation_paid = $wpdb->get_results("SELECT * FROM $table_name where status='1' ORDER BY id DESC LIMIT $start,$limit ");
    }else{
    	$value = $wpdb->get_results("SELECT * FROM $table_name3 where campaign_id='$campaign_id' ")[0];
    	$donation_paid = $wpdb->get_results("SELECT * FROM $table_name where campaign_id='$campaign_id' and status='1' ORDER BY id DESC LIMIT $start,$limit ");
    }
  		
		

	// $num = 1;
	$jumlah_arr = count($donation_paid);
	$the_data = '';

	foreach ($donation_paid as $data) {

		$readtime = new donasiaja_readtime();
		$donation_time = $readtime->time_donation($data->created_at);

		$general_status = $value->general_status;
	    $allocation_title = $value->allocation_title;
	    $allocation_others_title = $value->allocation_others_title;

	    if($general_status=='1'){
	        if($allocation_title=='1'){
	            $allocation_title = 'Donasi';
	        }elseif($allocation_title=='2'){
	            $allocation_title = 'Zakat';
	        }elseif($allocation_title=='3'){
	            $allocation_title = 'Qurban';
	        }else{
	            $allocation_title = $allocation_others_title;
	        }
	    }else{
	        $allocation_title = 'Donasi';
	    }

	    $donatur_name = $data->name;
		$anonim = 'Orang Baik';
		if($data->anonim=='1'){
			$donatur_name = $anonim_text;
		}

		$the_data .= '

		        <div class="donation_inner_box" style="background:#ffffff;">
		            <div class="donation_name">'.$donatur_name.'<span class="donation_time"><span class="dashicons dashicons-clock"></span>'.$donation_time.'</span>
		            </div>
		            <div class="donation_total" style="color: #23374d;font-weight:normal;">'.$allocation_title.' <b>Rp '.number_format($data->nominal,0,",",".").'</b></div>
		            <div class="donation_comment">'.str_replace('\\', '', $data->comment).'</div>
		        </div>
			        
			
		';
	}

	echo $the_data;

  	

    wp_die();

} 
add_action( 'wp_ajax_djafunction_load_list_donatur', 'djafunction_load_list_donatur' );
add_action( 'wp_ajax_nopriv_djafunction_load_list_donatur', 'djafunction_load_list_donatur' );




// LOAD FUNDRAISER
function djafunction_load_fundraiser() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_aff_code";
    $table_name3 = $wpdb->prefix . "dja_aff_submit";
    $table_name4 = $wpdb->prefix . "users";
    $table_name5 = $wpdb->prefix . "dja_settings";
    
    $id = $_POST['datanya'][0];
    $campaign_id = $_POST['datanya'][1];
    $load_count = $_POST['datanya'][2];
    $anonim_text = $_POST['datanya'][3];
    $fullanonim = $_POST['datanya'][4];
    $start = ($load_count-1)*5;
    $limit = 5;

    // Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="theme_color" ORDER BY id ASC');
    $general_theme_color = json_decode($query_settings[0]->data, true);

    // set the color
    $theme_color 		= $general_theme_color['color'][0];
	$progressbar_color  = $general_theme_color['color'][1];
	$button_color 		= $general_theme_color['color'][2];

	if($button_color==''){
		$button_color = '#dc2f6a';
	}

	$hex = $button_color;
	list($r, $g, $b) = sscanf($hex, "#%02x%02x%02x");
	$colornya = 'rgba('.$r.','.$g.','.$b.', 0.05)';
	$color_hovernya = 'rgba('.$r.','.$g.','.$b.', 0.15)';

    if($campaign_id!=''){
  		
    	$get_fundraiser = $wpdb->get_results("SELECT a.campaign_id, c.user_id as fundraiser_id, count(a.id) as jumlah_donatur, sum(b.nominal) as total
	FROM $table_name3  a 
	LEFT JOIN $table_name2 c on c.id = a.affcode_id 
	LEFT JOIN $table_name b on b.id = a.donate_id 
	where a.campaign_id='$campaign_id' and b.status = '1'
	GROUP BY fundraiser_id ORDER BY total DESC limit $start,$limit ");

		foreach ($get_fundraiser as $value) {
	    	$user_info = get_userdata($value->fundraiser_id);
		    $fullname = $user_info->first_name.' '.$user_info->last_name;

	    	
        	$the_data .= '
	       	<div class="donation_inner_box" style="background:rgb(250, 252, 255);line-height:1.6;">
	            <div class="donation_name" style="color:'.$button_color.'">'.$fullname.'</div>
	            <div class="donation_comment" style="margin:0;">Berhasil mengajak '.$value->jumlah_donatur.' orang untuk berdonasi.<br></div>
	            <div class="donation_name">Rp&nbsp;'.number_format($value->total,0,",",".").'</div>
	        </div>
	        ';

		}

		echo $the_data;

  	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_load_fundraiser', 'djafunction_load_fundraiser' );
add_action( 'wp_ajax_nopriv_djafunction_load_fundraiser', 'djafunction_load_fundraiser' );



// LOAD DOA DONATUR
function djafunction_load_doa_donatur() {
	
    global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";
    $table_name2 = $wpdb->prefix . "dja_love";
    
    $id = $_POST['datanya'][0];
    $campaign_id = $_POST['datanya'][1];
    $load_count = $_POST['datanya'][2];
    $anonim_text = $_POST['datanya'][3];
    $fullanonim = $_POST['datanya'][4];
    $start = ($load_count-1)*5;
    $limit = 5;

    if($campaign_id!=''){
  		
  		$donation_paid = $wpdb->get_results("SELECT * FROM $table_name where campaign_id='$campaign_id' and status='1' and comment!='' ORDER BY id DESC limit $start,$limit ");

		// $donation_paid = $wpdb->get_results("SELECT * FROM $table_name where status='1' ORDER BY id DESC LIMIT $start,$limit ");

		// $num = 1;
		$jumlah_arr = count($donation_paid);
		$the_data = '';
		foreach ($donation_paid as $value) {
			

			$donatur_name = $value->name;
			$anonim = 'Orang Baik';
			if($value->anonim=='1'){
				$donatur_name = $anonim_text;
			}

			// time
			$readtime = new donasiaja_readtime();
			$fix_time = $readtime->time_donation($value->created_at);

			// nominal
			$nominal = 'Rp '.number_format($value->nominal,0,",",".");

			$id_login = wp_get_current_user()->ID;

			$a = donasiaja_getIP();
		    $b = donasiaja_getOS();
		    $c = donasiaja_getBrowser();
		    $d = donasiaja_getMobDesktop();
			if($id_login!='0'){
				// cek berdasarkan user_agent
				$row = $wpdb->get_results('SELECT * from '.$table_name2.' where ip="'.$a.'" and os="'.$b.'" and browser="'.$c.'" and mobdesktop="'.$d.'" and donate_id="'.$value->id.'"');
		    	if($row!=null){
		    		$left_span = '<span>';
		    		$right_span = '</span>';
		    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-color3.png';
		    	}else{
		    		$left_span = '';
		    		$right_span = '';
		    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-gray.png';
		    	}
			}else{
				// cek berdasarkan user_id
				$row = $wpdb->get_results('SELECT * from '.$table_name2.' where user_id="'.$id_login.'" ');
		    	if($row!=null){
		    		$left_span = '<span>';
		    		$right_span = '</span>';
		    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-color3.png';
		    	}else{
		    		$left_span = '';
		    		$right_span = '';
		    		$icon_love = plugin_dir_url( __FILE__ ) . 'assets/icons/praying-gray.png';
		    	}
			}


			$total_love = $wpdb->get_results("SELECT SUM(love) as jumlah FROM $table_name2 where donate_id='$value->id' ")[0];
			$love = $total_love->jumlah;
			if($love==0){
				$love = 'Aaminn-kan doa ini';
			}else{
				if($love>=2){
					$love = $left_span.$love.' Aaminn'.$right_span;
				}else{
					$love = $left_span.$love.' Aaminn'.$right_span;
				}
			}


        	$the_data .= '
	        <div class="donation_inner_box">
	            <div class="donation_name">'.$donatur_name.'<span class="donation_time"><span class="dashicons dashicons-clock"></span>'.$fix_time.'</span>
	            </div>
	            <div class="donation_comment">'.str_replace('\\', '', $value->comment).'<br></div>
	            <div class="donation_love" id="love_'.$value->id.'" data-donateid="'.$value->id.'" data-campaignid="'.$value->campaign_id.'">
	            	
	            	<div class="fancy-button">
					  <div class="left-frills frills"></div>
					  <div class="box_love">
					  	<img alt="Image" src="'.$icon_love.'">
					  	<div class="total_love">'.$love.'</div>
					  	<div class="plus1">+1</div>
					  </div>
					  <div class="right-frills frills"></div>
					</div>

				</div>
	            	
	        </div>
	        ';

		}

		echo $the_data;

  	}

    wp_die();

} 
add_action( 'wp_ajax_djafunction_load_doa_donatur', 'djafunction_load_doa_donatur' );
add_action( 'wp_ajax_nopriv_djafunction_load_doa_donatur', 'djafunction_load_doa_donatur' );



function djafunction_update_password() {
    global $wpdb;
    $table_name = $wpdb->prefix . "users";

    $id_login = wp_get_current_user()->ID;
    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_pass_new 	= $_POST['datanya'][1];

    if($id_login==$user_id){
 
	    $hash = wp_hash_password( $user_pass_new );
	    $wpdb->update(
	        $table_name,
	        array(
	            'user_pass'           => $hash
	        ),
	        array( 'ID' => $user_id )
	    );
	 		
	 	clean_user_cache( $user_id );

	 	echo 'success';
	}

	wp_die();

}
add_action( 'wp_ajax_djafunction_update_password', 'djafunction_update_password' );
add_action( 'wp_ajax_nopriv_djafunction_update_password', 'djafunction_update_password' ); 



function djafunction_update_password_user() {
    global $wpdb;
    $table_name = $wpdb->prefix . "users";

    
    // FROM INPUT
    $user_id 	= $_POST['datanya'][0];
    $user_pass_new 	= $_POST['datanya'][1];

 
    $hash = wp_hash_password( $user_pass_new );
    $wpdb->update(
        $table_name,
        array(
            'user_pass'           => $hash
        ),
        array( 'ID' => $user_id )
    );

 	echo 'success';
	

	wp_die();

}
add_action( 'wp_ajax_djafunction_update_password_user', 'djafunction_update_password_user' );
add_action( 'wp_ajax_nopriv_djafunction_update_password_user', 'djafunction_update_password_user' ); 



function dja_get_data_donasi(){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_campaign";
    $table_name2 = $wpdb->prefix . "dja_category";
    $table_name3 = $wpdb->prefix . "dja_campaign_update";
    $table_name4 = $wpdb->prefix . "dja_donate";
    $table_name5 = $wpdb->prefix . "dja_settings";
    $table_name6 = $wpdb->prefix . "dja_users";
    $table_name7 = $wpdb->prefix . "users";
    $table_name8 = $wpdb->prefix . "dja_payment_log";

    date_default_timezone_set('Asia/jakarta');

    $startlist 	  = $_POST['start'];
    $length 	  = $_POST['length'];
    $draw 		  = $_POST['draw'];
    $c_id 		  = $_POST['c_id'];
    $date_filter  = $_POST['date_filter'];
    $date_range   = $_POST['date_range'];
    $search_value = $_POST['search']['value'];

    // Settings
    $query_settings = $wpdb->get_results('SELECT data from '.$table_name5.' where type="form_setting" or type="btn_followup" or type="text_f1" or type="text_f2" or type="text_f3" or type="text_f4" or type="text_f5" or type="text_received" or type="text_received_status" or type="wanotif_on_dashboard"  ORDER BY id ASC');
    $form_setting = $query_settings[0]->data;
    $btn_followup = $query_settings[1]->data;
    $text_f1 = $query_settings[2]->data;
    $text_f2 = $query_settings[3]->data;
    $text_f3 = $query_settings[4]->data;
    $text_f4 = $query_settings[5]->data;
    $text_f5 = $query_settings[6]->data;
    $text_received = $query_settings[7]->data;
    $text_received_status = $query_settings[8]->data;
    $wanotif_on_dashboard = $query_settings[9]->data;

    $cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];
    $id_login = wp_get_current_user()->ID;


    if($c_id=='all'){
    	$c_id = null;
    }

    $limit = '';
    if($length==-1){
		$limit = '';
	}else{
		$limit = "LIMIT $startlist,$length";
	}


    $filternya = "";
    if($date_filter=='today' || $date_filter=='yesterday' || $date_filter=='7lastdays' || $date_filter=='30lastdays' || $date_filter=='thismonth' || $date_filter=='lastmonth' || $date_filter=='daterange' || $date_filter=='all'){
    
        // Date
        $today = date('Y-m-d');
        $yesterday = date("Y-m-d", strtotime("-1 day"));
        $one_week_ago = date("Y-m-d", strtotime("-7 day"));
        $one_month_ago = date("Y-m-d", strtotime("-30 day"));
        $three_months_ago = date("Y-m-d", strtotime("-90 day"));
        $thismonth = date("Y-m-01");
        
        $month = date('m');
        $year = date('Y');
        if($month==1){
        	$monthnya = 12;
        	$yearnya = $year-1;
        }else{
        	$monthnya = $month-1;
        	$yearnya = $year;
        }
		$lastmonth_firstrange = date($yearnya."-".$monthnya."-01");
		$lastmonth_lastrange = date($yearnya."-".$monthnya."-31");

		if($date_range!=''){
			$date_range = explode('_',$date_range);
			$date_range_first = date($date_range[0]);
			$date_range_last = date($date_range[1]);
		}else{
			$date_range_first = $today;
			$date_range_last = $today;
		}
		

        if($date_filter=='today'){
            $filternya = "and a.created_at BETWEEN '$today 00:00' AND '$today 23:59'";
        }elseif($date_filter=='yesterday'){
            $filternya = "and a.created_at BETWEEN '$yesterday 00:00' AND '$yesterday 23:59'";
        }elseif($date_filter=='7lastdays'){
            $filternya = "and a.created_at BETWEEN '$one_week_ago 00:00' AND '$today 23:59'";
        }elseif($date_filter=='30lastdays'){
            $filternya = "and a.created_at BETWEEN '$one_month_ago 00:00' AND '$today 23:59'";
        }elseif($date_filter=='3months'){
            $filternya = "and a.created_at BETWEEN '$three_months_ago 00:00' AND '$today 23:59'";
        }elseif($date_filter=='thismonth'){
            $filternya = "and a.created_at BETWEEN '$thismonth 00:00' AND '$today 23:59'";
        }elseif($date_filter=='lastmonth'){
            $filternya = "and a.created_at BETWEEN '$lastmonth_firstrange 00:00' AND '$lastmonth_lastrange 23:59'";
        }elseif($date_filter=='daterange'){
            $filternya = "and a.created_at BETWEEN '$date_range_first 00:00' AND '$date_range_last 23:59'";
        }else{
            $filternya = "";
        }

        // and a.created_at BETWEEN '2022-03-28 00:00' AND '2022-04-27 23:59'
    }

    $search_filter = '';
    if($search_value!=''){
    	$search_value2 = '';
    	if(strtolower($search_value)=='waiting'){
    		$search_value2 = '0';
    	}
    	if(strtolower($search_value)=='received'){
    		$search_value2 = '1';
    	}

    	if($search_value2=='1' || $search_value2=='0'){
    		$search_filter = "and (name like '%$search_value%' or whatsapp like '%$search_value%' or email like '%$search_value%' or comment like '%$search_value%' or nominal like '%$search_value%' or invoice_id like '%$search_value%' or process_by like '%$search_value%' or status like '%$search_value2%') ";
    	}else{
    		$search_filter = "and (name like '%$search_value%' or whatsapp like '%$search_value%' or email like '%$search_value%' or comment like '%$search_value%' or nominal like '%$search_value%' or invoice_id like '%$search_value%' or process_by like '%$search_value%') ";
    	}
    	
    }
    
    $data_check = 0;
    if($role=='donatur'){

        if($c_id!=null){ // Campaign ID isi dan ada

            // cek c_id ada dan beneran donatur ini yang punya gak
            // klo iya lanjut, klo gak ya no data

            $total_donasi = $wpdb->get_results("SELECT SUM(a.nominal) as total, COUNT(a.id) as jumlah FROM $table_name4 a
            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
            WHERE c.campaign_id = '$c_id' and a.status='1' and c.user_id = '$id_login' $search_filter $filternya ")[0];

            $nominal_donasi_terkumpul = $total_donasi->total;
            $jumlah_donasi_terkumpul = $total_donasi->jumlah;

            $total_donasi_semua = $wpdb->get_results("SELECT COUNT(a.id) as jumlah FROM $table_name4 a 
            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
            WHERE c.campaign_id = '$c_id' and c.user_id = '$id_login' $search_filter $filternya ")[0];

            $jumlah_donasi_semua = $total_donasi_semua->jumlah;

            if($jumlah_donasi_semua>=1){
                $konversi = $jumlah_donasi_terkumpul/$jumlah_donasi_semua;
            }else{
                $konversi = 0;
            }


            // GET DATA DONASI
            $data_donasi = $wpdb->get_results("
            SELECT a.*, b.user_randid, b.user_pp_img, c.title, c.campaign_id, c.slug, c.publish_status from $table_name4 a 
            LEFT JOIN $table_name6 b on a.user_id = b.user_id
            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id
            WHERE c.campaign_id = '$c_id' and c.user_id = '$id_login'
            $search_filter $filternya
            ORDER BY a.id DESC $limit");

            $jumlah_total = $wpdb->get_results("
            SELECT count(a.id) as idnya from $table_name4 a 
            LEFT JOIN $table_name6 b on a.user_id = b.user_id
            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
            WHERE c.campaign_id = '$c_id' and c.user_id = '$id_login'
            $search_filter $filternya ORDER BY a.id DESC")[0]->idnya;


        }else{


            $total_donasi = $wpdb->get_results("SELECT SUM(a.nominal) as total, COUNT(a.id) as jumlah FROM $table_name4 a
            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
            WHERE a.status='1' and c.user_id = '$id_login' $search_filter $filternya ")[0];

            $nominal_donasi_terkumpul = $total_donasi->total;
            $jumlah_donasi_terkumpul = $total_donasi->jumlah;

            $total_donasi_semua = $wpdb->get_results("SELECT COUNT(a.id) as jumlah FROM $table_name4 a 
            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
            WHERE c.user_id = '$id_login' $search_filter $filternya ")[0];

            $jumlah_donasi_semua = $total_donasi_semua->jumlah;

            if($jumlah_donasi_semua>=1){
                $konversi = $jumlah_donasi_terkumpul/$jumlah_donasi_semua;
            }else{
                $konversi = 0;
            }


            // GET DATA DONASI
            $data_donasi = $wpdb->get_results("
            SELECT a.user_id as uid, a.publish_status, a.slug, a.title, b.*, c.user_pp_img FROM $table_name a 
            left JOIN $table_name4 b ON b.campaign_id = a.campaign_id
            left JOIN $table_name6 c ON c.user_id = b.user_id
            WHERE a.user_id = $id_login and b.id!=''
            $search_filter $filternya
            ORDER BY a.id DESC $limit");

            $jumlah_total = $wpdb->get_results("
            SELECT count(b.id) as idnya FROM $table_name a 
            left JOIN $table_name4 b ON b.campaign_id = a.campaign_id
            left JOIN $table_name6 c ON c.user_id = b.user_id
            WHERE a.user_id = $id_login and b.id!=''
            $search_filter $filternya
            ORDER BY a.id DESC")[0]->idnya;

        }
        
        
    }else{

        if($c_id!=null){ // Campaign ID isi dan ada

            // STATISTICS - Get Data CAMPAIGN
            // $rows = $wpdb->get_results("SELECT * from $table_name where campaign_id = '$c_id' ORDER BY id DESC");

        	// GET DATA FROM CS
            if($role=='cs'){

            	$data_check = 9;

            	$total_donasi_cs = $wpdb->get_results("SELECT SUM(a.nominal) as total, COUNT(a.id) as jumlah FROM $table_name4 a
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id = '$c_id' and a.status='1' and a.cs_id = '$id_login' $search_filter $filternya ")[0];

	            $nominal_donasi_terkumpul_cs = $total_donasi_cs->total;
	            $jumlah_donasi_terkumpul_cs = $total_donasi_cs->jumlah;

	            $total_donasi_semua_cs = $wpdb->get_results("SELECT COUNT(a.id) as jumlah FROM $table_name4 a 
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id = '$c_id' and a.cs_id = '$id_login' $search_filter $filternya ")[0];

	            $jumlah_donasi_semua_cs = $total_donasi_semua_cs->jumlah;

	            if($jumlah_donasi_semua_cs>=1){
	                $konversi_cs = $jumlah_donasi_terkumpul_cs/$jumlah_donasi_semua_cs;
	            }else{
	                $konversi_cs = 0;
	            }


	            // GET DATA DONASI
	            $data_donasi_cs = $wpdb->get_results("
	            SELECT a.*, b.user_randid, b.user_pp_img, c.title, c.campaign_id, c.slug, c.publish_status from $table_name4 a 
	            LEFT JOIN $table_name6 b on a.user_id = b.user_id
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id
	            WHERE c.campaign_id = '$c_id' and a.cs_id = '$id_login'
	            $search_filter $filternya
	            ORDER BY a.id DESC $limit");

	            $jumlah_total_cs = $wpdb->get_results("
	            SELECT count(a.id) as idnya from $table_name4 a 
	            LEFT JOIN $table_name6 b on a.user_id = b.user_id
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id = '$c_id' and a.cs_id = '$id_login'
	            $search_filter $filternya ORDER BY a.id DESC")[0]->idnya;

	            // Normalisasi, data di set dari data si CS
	            $data_donasi = $data_donasi_cs;
	            $jumlah_total = $jumlah_total_cs;


            }else{

            	$total_donasi = $wpdb->get_results("SELECT SUM(a.nominal) as total, COUNT(a.id) as jumlah FROM $table_name4 a
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id = '$c_id' and a.status='1' $search_filter $filternya ")[0];
	            $nominal_donasi_terkumpul = $total_donasi->total;
	            $jumlah_donasi_terkumpul = $total_donasi->jumlah;

	            $total_donasi_semua = $wpdb->get_results("SELECT COUNT(a.id) as jumlah FROM $table_name4 a 
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id = '$c_id' $search_filter $filternya ")[0];

	            $jumlah_donasi_semua = $total_donasi_semua->jumlah;

	            if($jumlah_donasi_semua>=1){
	                $konversi = $jumlah_donasi_terkumpul/$jumlah_donasi_semua;
	            }else{
	                $konversi = 0;
	            }


	            // GET DATA DONASI
	            $data_donasi = $wpdb->get_results("
	            SELECT a.*, d.user_randid, d.user_pp_img, c.title, c.campaign_id, c.slug, c.publish_status from $table_name4 a 
	            LEFT JOIN $table_name7 b on a.user_id = b.id
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            LEFT JOIN $table_name6 d on b.id = d.user_id
	            WHERE c.campaign_id = '$c_id'
	            $search_filter $filternya
	            ORDER BY a.id DESC $limit");

	            $jumlah_total = $wpdb->get_results("
	            SELECT count(a.id) as idnya from $table_name4 a 
	            LEFT JOIN $table_name7 b on a.user_id = b.id
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id = '$c_id'
	        	$search_filter $filternya ORDER BY a.id DESC")[0]->idnya;
            }
            


        }else{


            // GET DATA FROM CS
            if($role=='cs'){

            	// $data_check = 8;

            	$total_donasi_cs = $wpdb->get_results("SELECT SUM(a.nominal) as total, COUNT(a.id) as jumlah FROM $table_name4 a
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE a.status='1' and a.cs_id = '$id_login' $search_filter $filternya ")[0];

	            $nominal_donasi_terkumpul_cs = $total_donasi_cs->total;
	            $jumlah_donasi_terkumpul_cs = $total_donasi_cs->jumlah;

	            $total_donasi_semua_cs = $wpdb->get_results("SELECT COUNT(a.id) as jumlah FROM $table_name4 a 
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE a.cs_id = '$id_login' $search_filter $filternya")[0];

	            $jumlah_donasi_semua_cs = $total_donasi_semua_cs->jumlah;

	            if($jumlah_donasi_semua_cs>=1){
	                $konversi_cs = $jumlah_donasi_terkumpul_cs/$jumlah_donasi_semua_cs;
	            }else{
	                $konversi_cs = 0;
	            }


	            // GET DATA DONASI
	            $data_donasi_cs = $wpdb->get_results("
	            SELECT a.*, b.user_randid, b.user_pp_img, c.title, c.campaign_id, c.slug, c.publish_status from $table_name4 a 
	            LEFT JOIN $table_name6 b on a.user_id = b.user_id
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id
	            WHERE c.campaign_id != '' and a.cs_id = '$id_login'
	            $search_filter $filternya
	            ORDER BY a.id DESC $limit");

	            $jumlah_total_cs = $wpdb->get_results("
	            SELECT count(a.id) as idnya from $table_name4 a 
	            LEFT JOIN $table_name6 b on a.user_id = b.user_id
	            LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	            WHERE c.campaign_id != '' and a.cs_id = '$id_login'
	            $search_filter $filternya ORDER BY a.id DESC")[0]->idnya;

	            // Normalisasi, data di set dari data si CS
	            $data_donasi = $data_donasi_cs;
	            $jumlah_total = $jumlah_total_cs;

            }else{

            	// STATISTICS - Get Data CAMPAIGN
	            // $rows = $wpdb->get_results("SELECT * from $table_name ORDER BY id DESC");

	            $total_donasi = $wpdb->get_results("SELECT SUM(a.nominal) as total, COUNT(id) as jumlah FROM $table_name4 a 
	            	WHERE status='1' $search_filter $filternya ")[0];
	            $nominal_donasi_terkumpul = $total_donasi->total;
	            $jumlah_donasi_terkumpul = $total_donasi->jumlah;

	            $total_donasi_semua = $wpdb->get_results("SELECT a.*, COUNT(a.id) as jumlah FROM $table_name4 a 
	            	WHERE a.id !='' $search_filter $filternya ");
	            $jumlah_donasi_semua = $total_donasi_semua[0]->jumlah;

	            if($jumlah_donasi_semua>=1){
	                $konversi = $jumlah_donasi_terkumpul/$jumlah_donasi_semua;
	            }else{
	                $konversi = 0;
	            }

	            $data_donasi = $wpdb->get_results("
	                SELECT a.*, d.user_randid, d.user_pp_img, c.title, c.campaign_id, c.slug, c.publish_status from $table_name4 a 
	                LEFT JOIN $table_name7 b on a.user_id = b.id
	                LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	                LEFT JOIN $table_name6 d on b.id = d.user_id
	                WHERE a.id != ''
	                $search_filter $filternya
	                ORDER BY a.id DESC $limit");

	            $jumlah_total = $wpdb->get_results("
	                SELECT count(a.id) as idnya from $table_name4 a 
	                LEFT JOIN $table_name7 b on a.user_id = b.id
	                LEFT JOIN $table_name c on a.campaign_id = c.campaign_id 
	                WHERE a.id != '' $search_filter $filternya ORDER BY a.id DESC")[0]->idnya;
            }


        }

    }


    // Statistic
    // Statistic from CS
    if($role=='cs'){

    	$totalDonasi = 0;
	    $jumlahDonasi = '0&nbsp;Donasi';
	    $jumlahDonasiTerkumpul = '0&nbsp;Donasi';
	    $konversi = '0&nbsp;%';

	    $totalDonasi_cs = number_format($nominal_donasi_terkumpul_cs,0,",",".");
	    $jumlahDonasi_cs = number_format($jumlah_donasi_semua_cs,0,",",".").'&nbsp;Donasi';
	    $jumlahDonasiTerkumpul_cs = number_format($jumlah_donasi_terkumpul_cs,0,",",".").'&nbsp;Donasi';
	    $konversi_cs = $konversi_cs*100;
	    $konversi_cs = number_format($konversi_cs,1,",",".").'&nbsp;%';

	}else{

		$totalDonasi = number_format($nominal_donasi_terkumpul,0,",",".");
	    $jumlahDonasi = number_format($jumlah_donasi_semua,0,",",".").'&nbsp;Donasi';
	    $jumlahDonasiTerkumpul = 'Terkumpul&nbsp;<b style='."'".'color: #313f68;'."'".'>'.number_format($jumlah_donasi_terkumpul,0,",",".").'</b> dari <b style='."'".'color: #313f68;'."'".'>'.number_format($jumlah_donasi_semua,0,",",".").'</b>&nbsp;Donasi';
	    $konversi = $konversi*100;
	    $konversi = number_format($konversi,1,",",".").'&nbsp;%';

		$totalDonasi_cs = 0;
	    $jumlahDonasi_cs = '0&nbsp;Donasi';
	    $jumlahDonasiTerkumpul_cs = '0&nbsp;Donasi';
	    $konversi_cs = '0&nbsp;%';
	}
    


	$no = 1+$startlist;
	$len = count($data_donasi)+$startlist;
	             
		echo '
		{
			"draw": '.$draw.',
			"recordsTotal": '.$jumlah_total.',
			"recordsFiltered": '.$jumlah_total.',
			"totalDonasi": "'.$totalDonasi.'",
			"totalDonasiCS": "'.$totalDonasi_cs.'",
			"jumlahDonasi": "'.$jumlahDonasi.'",
			"jumlahDonasiCS": "'.$jumlahDonasi_cs.'",
			"jumlahDonasiTerkumpul": "'.$jumlahDonasiTerkumpul.'",
			"jumlahDonasiTerkumpulCS": "'.$jumlahDonasiTerkumpul_cs.'",
			"konversi": "'.$konversi.'",
			"konversiCS": "'.$konversi_cs.'",
			"data": [';

			  	foreach ($data_donasi as $row) {

			  		if($row->publish_status=='1'){
                        $campaign_url = get_site_url().'/campaign/';
                    }else{
                        $campaign_url = get_site_url().'/preview/';
                    }
                    

                    $button_followupnya = '';
                    for ($i = 1; $i <= $btn_followup; $i++){
                        
                        $var = 'f'.$i;
                        if($row->$var=='1'){$$var = 'sent';}else{$$var = '';}

                        $button_followupnya .= '<button type='."'".'button'."'".' data-id='."'".$row->id."'".' data-followup='."'".$i."'".' class='."'".'btn btn-primary btn-followup '.$$var.' followup'.$i."'".' title='."'".'Followup '.$i."'".' style='."'".'margin-right:3px;'."'".'><i class='."'".'fab fa-whatsapp'."'".'></i><span style='."'".'margin-left: 3px;'."'".'>'.$i.'</span></button>';
                    }

                    $user_info = get_userdata($row->user_id);
                    if($user_info!=null){
                        $fullname = $user_info->first_name.' '.$user_info->last_name;
                    }

                    $time_donate = date('Y-m-d H:i:s',strtotime('+0 hour',strtotime($row->created_at)));

                    $readtime = new humanReadtime();
                    $a = $readtime->dja_human_time($time_donate);

                    // GET DATA CS
				    $user_info_cs = get_userdata($row->cs_id);
				    if($user_info_cs!=null){
				    	if($user_info_cs->last_name==''){
					    	$cs_name = '<span id='."'".'cs_'.$row->id."'".'>'.$user_info_cs->first_name.'</span>';
					    }else{
					    	$cs_name = '<span id='."'".'cs_'.$row->id."'".'>'.$user_info_cs->first_name.'&nbsp;'.$user_info_cs->last_name.'</span>';
					    }
				    }else{
				    	$cs_name = '<span id='."'".'cs_'.$row->id."'".'>-</span>';
				    }

                    // Profile Picture
                    if($row->user_id!='0') {

                    	if($row->user_pp_img=='') {
                    		$pp = '<a id='."'".'link_pp_'.$row->id."'".' href='."'".home_url().'/profile/'.$row->user_randid."'".'  target='."'".'_blank'."'".'><img alt='."''".' id='."'".'pp_'.$row->id."'".' src='."'".plugin_dir_url( __FILE__ ).'assets/images/pp.jpg'."'".' class='."'".'rounded-circle thumb-md'."'".' style='."'".'border: 1px solid #dde4ec;height: 38px;width: 38px;margin-top: -4px;max-width: 38px'."'".'></a>';
                    	}else{
                    		$pp ='<a id='."'".'link_pp_'.$row->id."'".' href='."'".home_url().'/profile/'.$row->user_randid."'".' target='."'".'_blank'."'".'><img alt='."''".' id='."'".'pp_'.$row->id."'".' src='."'".$row->user_pp_img."'".' class='."'".'rounded-circle thumb-md'."'".' style='."'".'border: 1px solid #dde4ec;height: 38px;width: 38px;margin-top: -4px;max-width: 38px'."'".'></a>';
                    	}
                    }else{
                    	if($row->user_pp_img=='') {
                    		$pp = '<img alt='."''".' id='."'".'pp_'.$row->id."'".' src='."'".plugin_dir_url( __FILE__ ).'assets/images/pp.jpg'."'".' class='."'".'rounded-circle thumb-md'."'".' style='."'".'border: 1px solid #dde4ec;height: 38px;width: 38px;margin-top: -4px;max-width: 38px'."'".'>';
                    	}else{
                    		$pp ='<img alt='."''".' id='."'".'pp_'.$row->id."'".' src='."'".$row->user_pp_img.'" class='."'".'rounded-circle thumb-md'."'".' style='."'".'border: 1px solid #dde4ec;height: 38px;width: 38px;margin-top: -4px;max-width: 38px'."'".'>';
                    	}
                    }


                    // Donatur Name
                    if($row->user_id!='0'){
                    	$donatur_name = '<span id='."'".'name_'.$row->id."'".'><a href='."'".home_url().'/profile/'.$row->user_randid."'".' target='."'".'_blank'."'".'>'.dja_handling_character($row->name).'</a></span>';
                    }else{
                    	$donatur_name = '<span id='."'".'name_'.$row->id."'".'>'.dja_handling_character($row->name).'</span>';
                    }

                    // Whatsapp
                    $whatsapp = '<span id='."'".'whatsapp_'.$row->id."'".'>'.dja_handling_character($row->whatsapp).'</span>';
                    
                    // Nominal Donasi
                    if($role=='donatur'){
                    	$nominal_donasi = '<span id='."'".'nominal_'.$row->id."'".'>Rp&nbsp;'.number_format($row->nominal,0,",",".").'</span>';
	                }else{
	                	if($row->payment_code=='ovo'){
	                		$margin_left = 'margin-left:-6px;';
	                	}elseif($row->payment_code=='dana' || $row->payment_code=='bca' || $row->payment_code=='bni' || $row->payment_code=='qris' || $row->payment_code=='gopay'){
	                		$margin_left = 'margin-left:-3px;';
	                	}else{
	                		$margin_left = 'margin-left:-1px;';
	                	}
	                	$nominal_donasi = '<div class='."'img_payment_code'".'><img src='."'".plugin_dir_url( __FILE__ ).'assets/images/bank/'.strtolower($row->payment_code).'.png'."'".' style='."'".'width:35px;'.$margin_left.'margin-right: 4px;margin-top: -1px;'."'".'></div><span id='."'".'nominal_'.$row->id."'".'>Rp&nbsp;'.number_format($row->nominal,0,",",".").'</span>';
	                }

                    $get_log = $wpdb->get_results("SELECT * FROM $table_name8 where id_donate='$row->id' ");
				    if($get_log!=null){
				    	if(strtolower($get_log[0]->message)=='success'){
				    		$style_inv_color = '';
				    		$title_payment_gateway = "title='Show Detail'";
				    	}else{
				    		$style_inv_color = 'color:#EF4D56 !important;';
				    		$title_payment_gateway = "title='Payment Gateway Error'";
				    	}
				    }else{
				    	$style_inv_color = '';
				    	$title_payment_gateway = "title='Show Detail'";
				    }

                    $donasi_payment_info = '';
                    $img_confirmation = '';
                    if($role!='donatur'){

                    	// image confirmation
	                    if($row->img_confirmation_url!=''){
	                    	$status_img = '';
	                    	if($row->img_confirmation_status=='1'){
	                    		$status_img = 'status_check';
	                    		$img_confirmation = '<div class='."'".'detail_donasi img_confirmation '.$status_img."'".' data-id='."'".$row->id."'".' title='."'".'Check Confirmation'."'".' style='."'".''."'".'><div style='."cursor:pointer;font-size:9px;padding:1px 8px 3px 16px;border-radius:10px;".'><i class='."'".'mdi mdi-checkbox-marked-circle-outline'."'".' style='."margin-left:-10px;margin-right:4px;".'></i>Bukti&nbsp;Transfer</div></div>';
	                    	}else{
	                    		$img_confirmation = '<div class='."'".'detail_donasi img_confirmation '.$status_img."'".' data-id='."'".$row->id."'".' title='."'".'Check Confirmation'."'".' style='."'".''."'".'><div style='."cursor:pointer;font-size:9px;padding:1px 8px 3px 16px;border-radius:10px;".'><i class='."'".'mdi mdi-checkbox-marked-circle-outline'."'".' style='."color:#36BD47!important;margin-left:-10px;margin-right:4px;".'></i>Bukti&nbsp;Transfer</div></div>';
	                    	}
	                    	
		                }

		                $info_qurban = json_decode($row->info_qurban, true);
					    $datane2 = '<ul style='."'".'margin-bottom:0px;margin-top:3px;'."'".'>';
					    $count_qurban = 0;
					    foreach ( $info_qurban as $key => $value ) {
					    	$show_qurban = '';
					    	if($value['type']=='Sapi' || $value['type']=='Kerbau'){
					    		$datane2 .= '<li  href='."'".'javascript:;'."'".' data-id='."'".$row->id."'".' class='."'".'detail_donasi'."'".' style='."'".'font-size:10px;margin-bottom:2px;background: #eaf0f7;border-radius: 3px;padding-left: 10px;padding-top: 2px;padding-bottom: 2px;width: 50px;cursor:pointer;'."'".' title='."'".$value['type']."'".'><img src='."'".plugin_dir_url( __FILE__ ) .'assets/images/qurban/'.$value['type'].'.png'."'".' style='."'".'width:13px;margin-right:3px;margin-top:-2px;'."'".'> x '.$value['jumlah'].'</li>';
					    	}else{
					    		$datane2 .= '<li  href='."'".'javascript:;'."'".' data-id='."'".$row->id."'".' class='."'".'detail_donasi'."'".' style='."'".'font-size:10px;margin-bottom:2px;background: #eaf0f7;border-radius: 3px;padding-left: 10px;padding-top: 2px;padding-bottom: 2px;width: 50px;cursor:pointer;'."'".' title='."'".$value['type']."'".'><img src='."'".plugin_dir_url( __FILE__ ) .'assets/images/qurban/'.$value['type'].'.png'."'".' style='."'".'width:11px;margin-right:3px;margin-top:-2px;'."'".'> x '.$value['jumlah'].'</li>';
					    	}
					    	$count_qurban++;
					    	
					    }
					    $datane2 = $datane2.'</ul>';
					    if($count_qurban==0){
					    	$datane2 = '';
					    }

		                // info invoice
	                    $info_invoice = '<br><a href='."'".'javascript:;'."'".' class='."'".'detail_donasi'."'".' data-id='."'".$row->id."'".'><i class='."'".'mdi mdi-file-document-box'."'".' style='."'".$style_inv_color."'".'></i><span style='."'".$style_inv_color."padding-top:2px;'".' '.$title_payment_gateway.'>'.$row->invoice_id.'</span></a>';

	                    	$info_payment_confirmed = '';
	                        if($row->process_by=='moota'){
	                        	$info_payment_confirmed = '<p style='."'".'font-size:10px;color:#91a2b0;margin-bottom: 0;'."'".'><img src='."'".plugin_dir_url( __FILE__ ).'admin/icons/moota.png'."'".' style='."'".'width: 10px;margin-left:1px;margin-right: 4px;margin-top: 0px;'."'".'>Moota</p>';
	                        }elseif($row->process_by=='ipaymu'){
	                        	$info_payment_confirmed = '<p style='."'".'font-size:10px;color:#91a2b0;margin-bottom: 0;'."'".'><img src='."'".plugin_dir_url( __FILE__ ).'admin/icons/ipaymu.png'."'".' style='."'".'width: 10px;margin-left:1px;margin-right: 4px;margin-top: -1px;'."'".'>iPaymu</p>';
	                        }elseif($row->process_by=='tripay'){
	                        	$info_payment_confirmed = '<p style='."'".'font-size:10px;color:#91a2b0;margin-bottom: 0;'."'".'><img src='."'".plugin_dir_url( __FILE__ ).'admin/icons/tripay.png'."'".' style='."'".'width: 10px;margin-left:1px;margin-right: 4px;margin-top: -1px;'."'".'>Tripay</p>';
	                        }elseif($row->process_by=='midtrans'){
	                        	$info_payment_confirmed = '<p style='."'".'font-size:10px;color:#91a2b0;margin-bottom: 0;'."'".'><img src='."'".plugin_dir_url( __FILE__ ).'admin/icons/midtrans.png'."'".' style='."'".'width: 10px;margin-left:1px;margin-right: 4px;margin-top: -1px;'."'".'>Midtrans</p>';
	                        }elseif($row->process_by=='xendit'){
	                        	$info_payment_confirmed = '<p style='."'".'font-size:10px;color:#91a2b0;margin-bottom: 0;'."'".'><img src='."'".plugin_dir_url( __FILE__ ).'admin/icons/xendit.png'."'".' style='."'".'width: 10px;margin-left:1px;margin-right: 4px;margin-top: -1px;'."'".'>Xendit</p>';
	                        }elseif($row->process_by=='flip'){
	                        	$info_payment_confirmed = '<p style='."'".'font-size:10px;color:#91a2b0;margin-bottom: 0;'."'".'><img src='."'".plugin_dir_url( __FILE__ ).'admin/icons/flip.png'."'".' style='."'".'width: 10px;margin-left:1px;margin-right: 4px;margin-top: -1px;'."'".'>Flip</p>';
	                        }else{ }

	                    $donasi_payment_info = $info_invoice.$info_payment_confirmed;

                    }


                    // Title Campaign
                    $title_campaign = '<a href='."'".$campaign_url.$row->slug."'".' title='."Show&nbsp;Program".' target='."'".'_blank'."'".'>'.dja_handling_character($row->title).'</a>';

                    // Date
                    $datenya = new DateTime($row->created_at);
                    $date_donasi = '<span class=date_donasi>'.$datenya->format('d').'&nbsp;'.$datenya->format('M').',&nbsp;'.$datenya->format('Y').'&nbsp;-&nbsp;'.$datenya->format('H').':'.$datenya->format('i').'</span><br><span style='."'".'font-size:10px;color:#91a2b0;'."'".'>'.$a.'<span>';

                    // Payment Status
                    if($role=='donatur'){
                        if($row->status=='1'){
                            $status = '<span class='."'".'active-status p_received'."'".'>Success</span>';
                            $the_status = $status;
                        }else{
                            $status = '<span class='."'".'active-status p_waiting'."'".'>Waiting</span>';
                            $the_status = $status;
                        }
                    }else{
                        if($row->status=='1'){
                            $status = 'received';
                            $checked = 'checked='."''";
                            $the_status = 'Success';
                        }else{
                            $status = 'waiting';
                            $checked = '';
                            $the_status = 'Waiting';
                        }
                    }

                    if($role=='donatur'){
                        $payment_status = $status;
                    }else{
                    	$payment_status = '<div title='."Update&nbsp;Payment".' id='."'".'payment_'.$row->id."'".' class='."'".'custom-control custom-switch set_payment '.$status."'".'><input type='."'".'checkbox'."'".' class='."'".'custom-control-input set_payment_status'."'".' id='."'".'customSwitchSuccess_'.$row->id."'".' '.$checked.' data-id='."'".$row->id."'".' data-invoiceid='."'".$row->invoice_id."'".'><label class='."'".'custom-control-label'."'".' for='."'".'customSwitchSuccess_'.$row->id."'".' style='."'".'font-size: 11px;'."'".'><span>'.$the_status.'</span></label></div>';

                    }

                    // Action
                    // $button_action = '<button type='."'".'button'."'".' class='."'".'btn btn-outline-danger waves-effect waves-light btn-sm del_donasi'."'".' data-id='."'".$row->id."'".' title='."'".'Delete Donasi'."'".'><i class='."'".'mdi mdi-trash-can mr-2'."'".' style='."'".'margin: 0 4px !important;'."'".'></i></button>';
                    $button_action = '<div class='."'".'btn-group mb-4'."'".' role='."'".'group'."'".' aria-label='."'".'Basic example'."'".'><button type='."'".'button'."'".' class='."'".'btn btn-outline-light detail_donasi'."'".' data-id='."'".$row->id."'".' title='."'".'Show Detail'."'".' style='."'".'border-top-right-radius:0;border-bottom-right-radius:0;'."'".'><i class='."'".'mdi mdi-file-document-outline  mr-2'."'".' style='."'".'margin: 0 4px 0 2px !important;color:#7680FF;'."'".'></i></button><button type='."'".'button'."'".' class='."'".'btn btn-outline-light del_donasi'."'".' data-id='."'".$row->id."'".' title='."'".'Delete'."'".'><i class='."'".'mdi mdi-trash-can mr-2'."'".' style='."'".'margin: 0 4px 0 2px !important;color:#EF4D56;'."'".'></i></button></div>';

				    echo '
				    {
				      "no": "<span data-id='."'".$row->id."'".'>'.$no.'</span>",
				      "picture": "'.$pp.'",
				      "name": "'.$donatur_name.$datane2.'",
				      "whatsapp": "'.$whatsapp.'",
				      "total_donate": "'.$nominal_donasi.$donasi_payment_info.'",
				      "program": "'.$title_campaign.'",
				      "cs": "'.$cs_name.'",
				      "payment_status": "'.$payment_status.$img_confirmation.'",';
				      if($role!='donatur'){echo '"followup": "'.$button_followupnya.'",';}
				      echo '
				      "date": "'.$date_donasi.'"';
				  	  if($role=='donatur' || $role=='cs'){echo'';}else{echo ',"action": "'.$button_action.'"';}
				  	echo '
				    }';

				    if($len==$no){echo'';}else{echo',';} // add koma
                    $no++;

				}

			echo '
			  ]
		}';

		

	wp_die();

}

add_action( 'wp_ajax_dja_get_data_donasi', 'dja_get_data_donasi' );
add_action( 'wp_ajax_nopriv_dja_get_data_donasi', 'dja_get_data_donasi' );  



function get_payment_expired($invoice_id){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

	$donate = $wpdb->get_results('SELECT * from '.$table_name.' where invoice_id="'.$invoice_id.'" ');

	$payment_date = $donate[0]->created_at;
    $time_plus_24 = strtotime('+24 hour',strtotime($payment_date));
    return date('d',$time_plus_24).' '.date('M',$time_plus_24).' '.date('Y',$time_plus_24).' - '.date('H:i',$time_plus_24);

}



function get_payment_method($invoice_id){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_donate";

	$donate = $wpdb->get_results('SELECT * from '.$table_name.' where invoice_id="'.$invoice_id.'" ');
    $bank_code = $donate[0]->payment_code;
    $payment_account = $donate[0]->payment_account;
	$payment_number = $donate[0]->payment_number;
	$total = $donate[0]->nominal;

    $data_field = array();
    $data_field[ '{payment_account}' ] = $payment_account;
    $data_field[ '{payment_number}' ] = $payment_number;
    $data_field[ '{nominal}' ] = $total;
    $data_field[ '<b>' ] = '*';
    $data_field[ '</b>' ] = '*';

	$url = plugin_dir_url( __FILE__ )."library/instructions.json";
	$curl = curl_init();

	curl_setopt_array($curl, [
		CURLOPT_URL => $url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => "",
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => "GET",
		CURLOPT_SSL_VERIFYHOST => 0,
		CURLOPT_SSL_VERIFYPEER => 0,
		CURLOPT_HTTPHEADER => [
		  "Accept: application/json",
		],
	]);

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
		echo "cURL Error #:" . $err;
	} else {
		$array = json_decode($response, true);
	}
	
	// print_r($array);
	
	$method = '';
	$no = 0;
	$i = 0;
	foreach ($array as $a => $b) { if($donate[0]->payment_gateway!=''){ if($array[$no]['pg']!='general'){ if($array[$no]['pg']==$donate[0]->payment_gateway){ if($array[$no]['payment']==$bank_code){ foreach ($array[$no] as $key => $val) { if($key=='pg'){ }elseif($key=='method'){ }elseif($key=='payment'){ }elseif($key=='steps'){ }else{ $i++; } } } } }else{ if($array[$no]['payment']==$bank_code && $donate[0]->payment_method!='va'){ foreach ($array[$no] as $key => $val) { if($key=='pg'){ }elseif($key=='method'){ }elseif($key=='payment'){ }elseif($key=='steps'){ }else{ $i++; } } } } }else{ if($array[$no]['pg']=='general'){ if($array[$no]['payment']==$bank_code){ foreach ($array[$no] as $key => $val) { if($key=='pg'){ }elseif($key=='method'){ }elseif($key=='payment'){ }elseif($key=='steps'){ }else{ $i++; } } } } } $no++; }

	if($i>=1){
		$method .= '*Instruksi Pembayaran :*';
	}

	if($donate[0]->payment_gateway=='flip' && $donate[0]->payment_method=='transfer'){
		return $method.$a = '
✅ *Flip*
- Klik link flip di bawah
- Flip : '.$payment_number.'
- Lalu lanjutkan pembayaran hingga selesai
';
	}
	if($donate[0]->payment_gateway=='flip' && $donate[0]->payment_method=='instant'){
		return $method.$a = '
✅ *Flip*
- Klik link flip di bawah
- Flip : '.$payment_number.'
- Lalu lanjutkan pembayaran hingga selesai
';
	}

	
	$no = 0;
	foreach ($array as $a => $b) {

		
		if($donate[0]->payment_gateway!=''){ // ada code payment gateway
			// pakai yang selain general

			if($array[$no]['pg']!='general'){
				if($array[$no]['pg']==$donate[0]->payment_gateway){
					if($array[$no]['payment']==$bank_code){
							$method .= '';
							foreach ($array[$no] as $key => $val) {
								if($key=='pg'){
									// nothing
								}elseif($key=='method'){
									// nothing
								}elseif($key=='payment'){
									// nothing
								}elseif($key=='steps'){
									$method .= '';
									foreach ($val as $v) {
										$v = strtr($v, $data_field);
										$method .= '- '.$v.'
';
									}
									$method .= '';
								}else{
									$method .= '
✅ *'.$val.'*
';
								}
							}
							$method .= '';
					}
				}
			}else{

				// pakai yang selain general kecuali VA
				if($array[$no]['payment']==$bank_code && $donate[0]->payment_method!='va'){
						$method .= '';
						foreach ($array[$no] as $key => $val) {
							if($key=='pg'){
								// nothing
							}elseif($key=='method'){
								// nothing
							}elseif($key=='payment'){
								// nothing
							}elseif($key=='steps'){
								$method .= '';
								foreach ($val as $v) {
									$v = strtr($v, $data_field);
									$method .= '- '.$v.'
';
								}
								$method .= '';
							}else{
								$method .= '
✅ *'.$val.'*
';
							}
						}
						$method .= '';
				}
			}
			
		}else{
			// pakai yang general
			
			if($array[$no]['pg']=='general'){
				if($array[$no]['payment']==$bank_code){
						$method .= '';
						foreach ($array[$no] as $key => $val) {
							if($key=='pg'){
								// nothing
							}elseif($key=='method'){
								// nothing
							}elseif($key=='payment'){
								// nothing
							}elseif($key=='steps'){
								$method .= '';
								foreach ($val as $v) {
									$v = strtr($v, $data_field);
									$method .= '- '.$v.'
';
								}
								$method .= '';
							}else{
								$method .= '
✅ *'.$val.'*
';
							}
						}
						$method .= '';
				}
			}
			
			
		}
		

		// 1. cek dl, pakai payment gateway apa
		// > klo ada payment gateway, cek methodnya

		// 2. klo payment gateway kosong
		// > pakainya langsung default > cek methodnya

		$no++;
	}
	

	// return $invoice_id;
	return $method;
}


function table_data_shortcode(){
	
	$shortcode = '';
    $data_shortcode = array(
        "{name}"        	=>  "Nama donatur", 
        "{email}"       	=>  "Email donatur", 
        "{whatsapp}"    	=>  "Whatsapp donatur", 
        "{comment}"    		=>  "Pesan atau Doa dari donatur", 
        "{total}"    		=>  "Nominal donasi dari donatur", 
        "{payment_number}"  =>  "No Rekening", 
        "{payment_code}"    =>  "Nama Bank atau Dompet Digital", 
        "{payment_account}" =>  "Nama Pemilik Rekening", 
        "{payment_method}"	=>  "Menampilkan cara instruksi pembayaran",
        "{payment_expired}"	=>  "Menampilkan jam dan tanggal paling terakhir membayar (1x24 jam dari pertama kali donasi dibuat)",
        "{campaign_title}"  =>  "Judul program dari campaign", 
        "{fundraiser}"    	=>  "Nama Fundraiser pada campaign jika ada", 
        "{date}"    		=>  "Tanggal donasi dibuat", 
        "{invoice_id}"    	=>  "No Invoice ID donasi", 
        "{cs_name}"    		=>  "Nama CS, pastikan anda menggunakan CS Rotator", 
        "{link_ekuitansi}"  =>  "Link untuk mendownload ekuitansi", 
        "{data_list}"    	=>  "Menampilkan data yang dipilih pada form type Qurban, Package2, dan Zakat Fitrah", 
        "{data_list_detail}"=>  "Menampilkan data yang dipilih pada form type Qurban, Package2, dan Zakat Fitrah dengan lebih detil beserta nominal harga", 
        
    );
    foreach($data_shortcode as $s => $val) {
      $shortcode .= '<tr><td>'.$s.'</td><td style="padding-left:8px;padding-right:8px;">:</td><td>'.$val.'</td></tr>';
    }

    return $shortcode = '<table class="table_shortcode" style="margin-bottom:30px;">'.$shortcode.'</table>';
   		
}

function dja_handling_character($text){
	$set_petikdua = str_replace('"', '&#34;', $text);
    $set_petiksatu = str_replace("'", "&#39;", $set_petikdua);
    $set_garismiring = str_replace("\\", "", $set_petiksatu);
    $set_enter = trim(preg_replace('/\s\s+/', ' ', $set_garismiring));
	return $set_enter;
}


function dja_get_provinsi(){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";

    $user_id = $_POST['datanya'][0];

  	$profile = $wpdb->get_results("SELECT * FROM $table_name where user_id='$user_id' ")[0];

    $curl = curl_init();
    $apikey = 'f8c9777c807e12be084a770f23c1a573';
    curl_setopt_array($curl, array(
      CURLOPT_URL => "https://pro.rajaongkir.com/api/province",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "GET",
      CURLOPT_SSL_VERIFYHOST => 0,
	  CURLOPT_SSL_VERIFYPEER => 0,
      CURLOPT_HTTPHEADER => array(
        "key: $apikey"
      ),
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    $data_provinsi = '<option value="" data-idprovinsi="">Pilih Provinsi</option>';

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
        $array = json_decode( $response, true );
        $data = $array['rajaongkir']['results'];
        foreach($data as $d){
            if($profile->user_provinsi_id==$d['province_id']){
                $data_provinsi .= '<option value="'.$d['province'].'" data-idprovinsi="'.$d['province_id'].'" selected>'.$d['province'].'</option>';
            }else{
                $data_provinsi .= '<option value="'.$d['province'].'" data-idprovinsi="'.$d['province_id'].'">'.$d['province'].'</option>';
            }
        }
    }

    echo $data_provinsi;

    wp_die();

}

add_action( 'wp_ajax_dja_get_provinsi', 'dja_get_provinsi' );
add_action( 'wp_ajax_nopriv_dja_get_provinsi', 'dja_get_provinsi' );  



function dja_get_kabkota(){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";

    $user_id = $_POST['datanya'][0];
    $id_provinsi = $_POST['datanya'][1];

  	$profile = $wpdb->get_results("SELECT * FROM $table_name where user_id='$user_id' ")[0];

  	if($id_provinsi=='0'){
  		$id_provinsi = $profile->user_provinsi_id;
  	}

  	if($profile->user_provinsi_id==null){
  		$id_provinsi = $id_provinsi;
  	}


		$curl = curl_init();
		$apikey = 'f8c9777c807e12be084a770f23c1a573';

		curl_setopt_array($curl, array(
		  CURLOPT_URL => "https://pro.rajaongkir.com/api/city?province=$id_provinsi",
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_SSL_VERIFYPEER => 0,
		  CURLOPT_HTTPHEADER => array(
		    "key: $apikey"
		  ),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		$data_kabkota = '<option value="" data-idkabkota="">Pilih Kab. Kota</option>';

		if ($err) {
		  echo "cURL Error #:" . $err;
		} else {
		    $array = json_decode( $response, true );
			$data = $array['rajaongkir']['results'];
		    // $data_provinsi = '<option value="" data-idprovinsi="">--</option>';
		    
		    foreach($data as $d){
		    	if($d['type']=='Kabupaten'){
		    		$type = 'Kab. ';
		    	}else{
		    		$type = 'Kota ';
		    	}

		    	if($profile->user_kabkota_id==$d['city_id']){
		    		$data_kabkota .= '<option value="'.$type.$d['city_name'].'" data-idkabkota="'.$d['city_id'].'" selected>'.$type.$d['city_name'].'</option>';
		    	}else{
		        	$data_kabkota .= '<option value="'.$type.$d['city_name'].'" data-idkabkota="'.$d['city_id'].'">'.$type.$d['city_name'].'</option>';
		    	}
		    }
		}
	

    echo $data_kabkota;
    wp_die();

}
add_action( 'wp_ajax_dja_get_kabkota', 'dja_get_kabkota' );
add_action( 'wp_ajax_nopriv_dja_get_kabkota', 'dja_get_kabkota' );  


function dja_get_kecamatan(){

	global $wpdb;
    $table_name = $wpdb->prefix . "dja_users";
    $user_id = $_POST['datanya'][0];
    $id_kabkota = $_POST['datanya'][1];

  	$profile = $wpdb->get_results("SELECT * FROM $table_name where user_id='$user_id' ")[0];
  	if($id_kabkota=='0'){
  		$id_kabkota = $profile->user_kabkota_id;
  	}

  	if($profile->user_kabkota_id==null){
  		$id_kabkota = $id_kabkota;
  	}


        $curl = curl_init();
        $apikey = 'f8c9777c807e12be084a770f23c1a573';

        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://pro.rajaongkir.com/api/subdistrict?city=$id_kabkota",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "GET",
          CURLOPT_SSL_VERIFYHOST => 0,
	  	  CURLOPT_SSL_VERIFYPEER => 0,
          CURLOPT_HTTPHEADER => array(
            "key: $apikey"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        $data_kecamatan = '<option value="" data-idkecamatan="">Pilih Kecamatan</option>';

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
            $array = json_decode( $response, true );
            $data = $array['rajaongkir']['results'];
                
                foreach($data as $d){
                    if($profile->user_kecamatan_id==$d['subdistrict_id']){
                        $data_kecamatan .= '<option value="'.$d['subdistrict_name'].'" data-idkecamatan="'.$d['subdistrict_id'].'" selected>'.$d['subdistrict_name'].'</option>';
                    }else{
                        $data_kecamatan .= '<option value="'.$d['subdistrict_name'].'" data-idkecamatan="'.$d['subdistrict_id'].'">'.$d['subdistrict_name'].'</option>';
                    }
                    
                }

        }
    

    echo $data_kecamatan;
    wp_die();

}
add_action( 'wp_ajax_dja_get_kecamatan', 'dja_get_kecamatan' );
add_action( 'wp_ajax_nopriv_dja_get_kecamatan', 'dja_get_kecamatan' ); 



require 'library/f_additional_function.php';


function djafunction_activate_apikey() {
	global $wpdb;

	$table_name = $wpdb->prefix . "options";
	$table_name2 = $wpdb->prefix . "dja_settings";

	// GET POST
    $apikey = $_POST['datanya'][0];

    // GET URL WEB
	$row = $wpdb->get_results('SELECT option_value from '.$table_name.' where option_name="siteurl"');
	$row = $row[0];

    $protocols = array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
	$server = str_replace($protocols, '', $row->option_value);
	$apiurl = 'https://member.donasiaja.id/validateapi/donasiaja';

   	$curl = curl_init();
	curl_setopt_array($curl, array(
		  CURLOPT_URL => $apiurl,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_HTTPHEADER => array(
		    "Origin: $server", // NAMA DOMAIN, NAMA ID HARDWARE
		    "Apikey: $apikey", // APIKEY
		    "Setup: activate", // ACTIVATE
		  ),
	));

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
	  echo "cURL Error #:" . $err;
	} else {

	  	$hasil = json_decode($response);
		
		if($hasil[0]->apikeystatus=='valid'){

			$apikey_local = '{"donasiaja": ["'.$apikey.'"]}';
			$apikey_server = '{"donasiaja": ["'.$hasil[0]->pluginstatus.'", "'.$hasil[0]->apikeystatus.'", "'.$hasil[0]->expired.'", "'.md5($hasil[0]->pluginstatus).'"]}';

			$apikey_local= str_replace('\\', '', $apikey_local);
			$apikey_server= str_replace('\\', '', $apikey_server);

			// ACTION Update TO DB
		    $wpdb->update( $table_name2, array('data' => $apikey_local), array('type' => 'apikey_local'), array('%s'), array('%s') );
		    $wpdb->update( $table_name2, array('data' => $apikey_server), array('type' => 'apikey_server'), array('%s'), array('%s') );
			$wpdb->update( $table_name2, array('data' => 'DonasiAja'), array('type' => 'main_menu_name'), array('%s'), array('%s') );

			echo 'success_'.$hasil[0]->value;

		}else{

			echo 'failed_'.$hasil[0]->value;
		}
		
	}

	wp_die();
}
add_action( 'wp_ajax_djafunction_activate_apikey', 'djafunction_activate_apikey' );
add_action( 'wp_ajax_nopriv_djafunction_activate_apikey', 'djafunction_activate_apikey' );




function djafunction_deactivate_apikey() {
	global $wpdb;

	$table_name = $wpdb->prefix . "options";
	$table_name2 = $wpdb->prefix . "dja_settings";

	// GET POST
    $apikey = $_POST['datanya'][0];

    // GET URL WEB
	$row = $wpdb->get_results('SELECT option_value from '.$table_name.' where option_name="siteurl"');
	$row = $row[0];

    $protocols = array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
	$server = str_replace($protocols, '', $row->option_value);
	$apiurl = 'https://member.donasiaja.id/validateapi/donasiaja';

   	$curl = curl_init();
	curl_setopt_array($curl, array(
		  CURLOPT_URL => $apiurl,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_VERBOSE => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "GET",
		  CURLOPT_HTTPHEADER => array(
		    "Origin: $server",
		    "Apikey: $apikey",
		    "Setup: deactivate",
		  ),
	));

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
	  echo "cURL Error #:" . $err;
	} else {
	  	// echo $response;
	  	
	  	$hasil = json_decode($response);

	  	// UPDATE KE DB
		if($hasil[0]->apikeystatus=='deactivated'){

			$apikey_local = '{"donasiaja": [""]}';
			$apikey_server = '{"donasiaja": ["", "'.$hasil[0]->apikeystatus.'", "", ""]}';

			$apikey_local= str_replace('\\', '', $apikey_local);
			$apikey_server= str_replace('\\', '', $apikey_server);

			// ACTION Update TO DB
		    // $wpdb->update( $table_name2, array('data' => $apikey_local), array('type' => 'apikey_local'), array('%s'), array('%s') );
		    $wpdb->update( $table_name2, array('data' => $apikey_server), array('type' => 'apikey_server'), array('%s'), array('%s') );

			echo 'success_'.$hasil[0]->value;

		}else{
			
			echo 'failed_'.$hasil[0]->value;
		}
		
	}

	wp_die();
}
add_action( 'wp_ajax_djafunction_deactivate_apikey', 'djafunction_deactivate_apikey' );
add_action( 'wp_ajax_nopriv_djafunction_deactivate_apikey', 'djafunction_deactivate_apikey' );


function check_verified_campaign($akses){

	if($akses!='1'){

		echo '
		<div class="body-nya" style="margin-top:20px;margin-right:20px;">

            <!-- Page Content-->
            <div class="page-content-tab">

                <div class="container-fluid">
                    <!-- end page title end breadcrumb -->
                    <div class="row"> 
                        <div class="col-lg-4">
                        </div><!--end col-->  
                        <div class="col-lg-4">
                            <div class="card" style="border-bottom: 4px solid #f20988;-webkit-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);-moz-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);margin-top: 20px;">
                                <div class="card-body">
                                    <div class="icon-contain">
                                        <div class="row">
                                            <div class="col-10 align-self-center">
                                                <h5 class="">Status User</h5>
                                                <h2 class="my-2">Belum verifikasi</h3>
                                                <p class="text-muted mb-0">Agar bisa melakukan campaign, data anda harus diverikasi terlebih dahulu.</p>
                                                <a href="'.admin_url("admin.php?page=donasiaja_myprofile&action=verification").'">
                                                <button type="button" class="btn btn-primary px-5 py-2" style="margin-top: 25px;">Verifikasi sekarang</button></a>
                                                <br>
                                            </div><!--end col-->
                                            <div class="col-2 align-self-center">
                                                <div class="">
                                                    <div class="icon-info mb-3">
                                                        <i class="dripicons-user bg-soft-pink"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  <!--end row-->                                                      
                                    </div><!--end icon-contain-->
                                </div><!--end card-body-->
                            </div><!--end card-->
                        </div><!--end col-->     
                        <div class="col-lg-4">
                            
                        </div><!--end col-->   
                                                         
                    </div><!--end row-->

                </div><!-- container -->


            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->
        ';
        // return false;
        wp_die();
	}

}


function check_verified_dashboard($akses){

	if($akses!='1'){

		echo '
		<div class="body-nya" style="margin-top:20px;margin-right:20px;">

            <!-- Page Content-->
            <div class="page-content-tab">

                <div class="container-fluid">
                    <!-- end page title end breadcrumb -->
                    <div class="row"> 
                        <div class="col-lg-4">
                        </div><!--end col-->  
                        <div class="col-lg-4">
                            <div class="card" style="border-bottom: 4px solid #f20988;-webkit-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);-moz-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);margin-top: 20px;">
                                <div class="card-body">
                                    <div class="icon-contain">
                                        <div class="row">
                                            <div class="col-10 align-self-center">
                                                <h5 class="">Status User</h5>
                                                <h2 class="my-2">Belum verifikasi</h3>
                                                <p class="text-muted mb-0">Campaign Dashboard masih terkunci, data anda harus diverikasi terlebih dahulu.</p>
                                                <a href="'.admin_url("admin.php?page=donasiaja_myprofile&action=verification").'">
                                                <button type="button" class="btn btn-primary px-5 py-2" style="margin-top: 25px;">Verifikasi sekarang</button></a>
                                                <br>
                                            </div><!--end col-->
                                            <div class="col-2 align-self-center">
                                                <div class="">
                                                    <div class="icon-info mb-3">
                                                        <i class="dripicons-user bg-soft-pink"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  <!--end row-->                                                      
                                    </div><!--end icon-contain-->
                                </div><!--end card-body-->
                            </div><!--end card-->
                        </div><!--end col-->     
                        <div class="col-lg-4">
                            
                        </div><!--end col-->   
                                                         
                    </div><!--end row-->

                </div><!-- container -->


            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->
        ';
        // return false;
        wp_die();
	}

}



function dja_auto_login_new_user( $user_id ) {
    wp_set_current_user($user_id);
    wp_set_auth_cookie($user_id);
    $user = get_user_by( 'id', $user_id );
    do_action( 'wp_login', $user->user_login );//[Codex Ref.][1]
    return 'wp-admin/admin.php?page=donasiaja_myprofile';
}
add_action( 'user_register', 'dja_auto_login_new_user' );


function dja_whatsapp_format($text){
	$set_div1 = str_replace('<br></div><div>','%0A',$text);
	$set_div2 = str_replace('</div><div>','%0A',$set_div1);
    $set_nbsp = str_replace('&nbsp;','',$set_div2);
	$set_b_1 = str_replace('<b>','*',$set_nbsp);
	$set_b_2 = str_replace('</b>','*',$set_b_1);
	$set_i_1 = str_replace('<i>','_',$set_b_2);
	$set_i_2 = str_replace('</i>','_',$set_i_1);
	$set_s_1 = str_replace('<strike>','~',$set_i_2);
	$set_s_2 = str_replace('</strike>','~',$set_s_1);
	$set_enter = str_replace('<br>','%0A',$set_s_2);
	return urlencode($set_enter);
}


function d_randomString($length) {
    $keys = array_merge(range(0,9), range('a', 'z'));

    $key = "";
    for($i=0; $i < $length; $i++) {
        $key .= $keys[mt_rand(0, count($keys) - 1)];
    }
    return $key;
}


function d_randomBigString($length) {
    $keys = array_merge(range(0,9), range('A', 'Z'));

    $key = "";
    for($i=0; $i < $length; $i++) {
        $key .= $keys[mt_rand(0, count($keys) - 1)];
    }
    return $key;
}



function d_formatUri( $string, $separator = '-' )
{
    $accents_regex = '~&([a-z]{1,2})(?:acute|cedil|circ|grave|lig|orn|ring|slash|th|tilde|uml);~i';
    $special_cases = array( '&' => 'and', "'" => '');
    $string = mb_strtolower( trim( $string ), 'UTF-8' );
    $string = str_replace( array_keys($special_cases), array_values( $special_cases), $string );
    $string = preg_replace( $accents_regex, '$1', htmlentities( $string, ENT_QUOTES, 'UTF-8' ) );
    $string = preg_replace("/[^a-z0-9]/u", "$separator", $string);
    $string = preg_replace("/[$separator]+/u", "$separator", $string);
    return $string;
}



function djaPhoneFormat($nohp) {
     $nohp = str_replace(" ","",$nohp);
     $nohp = str_replace("(","",$nohp);
     $nohp = str_replace(")","",$nohp);
     $nohp = str_replace(".","",$nohp);
 
     // cek apakah no hp mengandung karakter + dan 0-9
    if(!preg_match('/[^+0-9]/',trim($nohp))){
        // cek apakah no hp karakter 1-3 adalah +62
        if(substr(trim($nohp), 0, 3)=='+62'){
            $hp = substr(trim($nohp), 1);
        }
        // cek apakah no hp karakter 1 adalah 0
        elseif(substr(trim($nohp), 0, 1)=='0'){
            $hp = '62'.substr(trim($nohp), 1);
        }else{
            $hp = $nohp;
        }
    }
     return $hp;
}


function _check_is_curl_installed() {
    if  (in_array  ('curl', get_loaded_extensions())) {
        return true;
    }
    else {
        return false;
    }
}


class donasiaja_readtime {

	public function time_donation($time) { 

		global $wpdb;

		date_default_timezone_set('Asia/jakarta');

		$timestamp = strtotime($time);	
	   
	    $strTime = array("detik", "menit", "jam", "hari", "bulan", "tahun");
	    $length = array("60","60","24","30","12","10");

	    $currentTime = time();
	    if($currentTime >= $timestamp) {
	    	// if($utc_status==1){
	    	// 	$diff     = time()- $timestamp + ((60*60)*($utc_value));
	    	// }else{
	    		$diff     = time() - $timestamp;// + ((60*60)*7);
	    	// }
			
			for($i = 0; $diff >= $length[$i] && $i < count($length)-1; $i++) {
				$diff = $diff / $length[$i];
			}

			$diff = round($diff);
			return $diff . " " . $strTime[$i] . " yang lalu ";
	    }else{
	    	return '';
	    }
	}


}


class humanReadtime {

	public function dja_human_time($time) { 

	    global $wpdb;

		date_default_timezone_set('Asia/jakarta');

		$timestamp = strtotime($time);	
	   
	    $strTime = array("detik", "menit", "jam", "hari", "bulan", "tahun");
	    $length = array("60","60","24","30","12","10");

	    $currentTime = time();
	    if($currentTime >= $timestamp) {
	    	$diff     = time() - $timestamp;
		
			for($i = 0; $diff >= $length[$i] && $i < count($length)-1; $i++) {
				$diff = $diff / $length[$i];
			}

			$diff = round($diff);
			return $diff . " " . $strTime[$i] . " yang lalu ";
	    }else{
	    	return '';
	    }
	}

}


function redirect_logged_in_user() {

		$id_login = wp_get_current_user()->ID;

    	global $wpdb;
		$table_name = $wpdb->prefix . "dja_settings";

    	$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="login_setting" or type="page_login" ORDER BY id ASC');
    	$login_setting 	= $query_settings[0]->data;
	    $page_login 	= $query_settings[1]->data;

    	wp_redirect( home_url().'/'.$page_login.'/' );

}

function angka_terbilang($x) {
  $angka = ["", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas"];

  if ($x < 12){
    return " " . $angka[$x];
  }elseif ($x < 20){
    return angka_terbilang($x - 10) . " belas";
  }elseif ($x < 100){
    return angka_terbilang($x / 10) . " puluh" . angka_terbilang($x % 10);
  }elseif ($x < 200){
    return "seratus" . angka_terbilang($x - 100);
  }elseif ($x < 1000){
    return angka_terbilang($x / 100) . " ratus" . angka_terbilang($x % 100);
  }elseif ($x < 2000){
    return "seribu" . angka_terbilang($x - 1000);
  }elseif ($x < 1000000){
    return angka_terbilang($x / 1000) . " ribu" . angka_terbilang($x % 1000);
  }elseif ($x < 1000000000){
    return angka_terbilang($x / 1000000) . " juta" . angka_terbilang($x % 1000000);
  }elseif ($x < 1000000000000){
    return angka_terbilang($x / 1000000000) . " milyar" . angka_terbilang($x % 1000000000);
  }
}


add_action('init', function() {

	global $wpdb;
	global $pagenow;

	$table_name = $wpdb->prefix . "dja_settings";

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="login_setting" ORDER BY id ASC');
    $login_setting 		= $query_settings[0]->data;

    if($login_setting=='1'){
		if( $pagenow == 'wp-login.php' ){
			redirect_logged_in_user();
		}
	}

	if(isset($_GET['donasiaja'])){
	  	if($_GET['donasiaja']=='print_kuitansi'){
	  		require_once(ROOTDIR_DNA . 'admin/f_print_kuitansi.php');
	  		exit();
	  	}else{
	  		echo 'Please back on your WP Admin Dashboard!';
	  		exit();
	  	}
  	}

});



function donasiaja_url_handler() {

	global $wpdb;
	global $pagenow;

	$table_name = $wpdb->prefix . "dja_settings";
	$table_name2 = $wpdb->prefix . "dja_donate";
	$table_name3 = $wpdb->prefix . "dja_campaign";
	$table_name4 = $wpdb->prefix . "dja_aff_submit";
    $table_name5 = $wpdb->prefix . "dja_aff_code";
    $table_name6 = $wpdb->prefix . "options";
    $table_name7 = $wpdb->prefix . "users";

    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="login_setting" or type="login_text" or type="register_setting" or type="register_text" or type="page_login" or type="page_register" or type="page_donate" or type="page_typ" ORDER BY id ASC');
    $login_setting 		= $query_settings[0]->data;
    $login_text 		= $query_settings[1]->data;
    $register_setting 	= $query_settings[2]->data;
    $register_text 		= $query_settings[3]->data;
    $page_login 		= $query_settings[4]->data;
    $page_register 		= $query_settings[5]->data;
    $page_donate		= $query_settings[6]->data;
    $page_typ 			= $query_settings[7]->data;
    
    if($login_setting=='1'){
		if( $pagenow == 'wp-login.php' ){
			redirect_logged_in_user();
		}
	}

	$link1 = "{$_SERVER['REQUEST_URI']}";
	$host = explode('/',$link1);

	// echo '<br>';
	// echo $host[0];
	// echo '<br>';
	// echo $host[1];
	// echo '<br>';
	// echo $host[2];
	// echo '<br>';
	// echo $host[3];
	// echo '<br>';
	// echo $host[4];
	// echo '<br>';
	// echo '<br>';
	// echo '<br>';
	// echo 'ni dia';

	// var_dump($host);

	$web = get_site_url();
	$donasi_id = '';

	if(isset($host[1])){
		if (strpos($web, 'localhost') !== false ) { // klo localhost atau ip
		    
		    $code1 = $host[2];
		    $link_code = $host[2];

		    if(isset($host[3])){
		    	$donasi_id = $host[3];
		    	$affcode = '';

		    	if (strpos($host[3], '?') !== false ) {
					$slugnya = explode('?',$host[3]);
					$donasi_id = $slugnya[0];
					$affcode = $slugnya[1];
				}

		    }

		    if(isset($host[4])){

		    	$action_id = $host[4];
		    	$_getid = '';
		    	if (strpos($action_id, '?') !== false ) {
		    		$act_slug = explode('?',$host[4]);
				    $action_id = $act_slug[0];
				    $affcode = $act_slug[1];
					$_g = $act_slug[1];
					if (strpos($_g, '_') !== false ) {
						$_gs = explode('_',$_g);
					    $_getid = $_gs[0];
					    $_getm = urldecode($_gs[1]);
					}
				    
		    	}

				if($link_code=='preview' and $action_id==$page_donate){ // 'donate-now'
		    		
		    		$nominal = null;
		    		if(isset($host[5])){
		    			$nominal = $host[5];
		    			if (is_numeric($nominal)) {
		    				$nominal = $nominal;
		    			}else{
		    				$nominal = null;
		    			}
		    		}
					
					require_once(ROOTDIR_DNA . 'donasiaja-form4.php');
					die;
				}
		    	if($link_code=='campaign' and $action_id==$page_donate){ // 'donate-now'
		    		
		    		$nominal = null;
		    		if(isset($host[5])){
		    			$nominal = $host[5];
		    			if (is_numeric($nominal)) {
		    				$nominal = $nominal;
		    			}else{
		    				$nominal = null;
		    			}
		    		}
					
					require_once(ROOTDIR_DNA . 'donasiaja-form4.php');
					die;
				}

		    	if($link_code=='campaign' and $action_id==$page_typ){
		    		
		    		$invoice_id = null;
		    		if(isset($host[5])){
		    			$invoice_id = $host[5];
		    		}
					
					require_once(ROOTDIR_DNA . 'donasiaja-typ.php');
					die;
				}

			}
			if($link_code=='preview'){
				require_once(ROOTDIR_DNA . 'donasiaja-campaign.php');
				die;
			}
			if($link_code=='campaign'){
				require_once(ROOTDIR_DNA . 'donasiaja-campaign.php');
				die;
			}
			if($link_code=='search_campaign'){
				require_once(ROOTDIR_DNA . 'donasiaja-search.php');
				die;
			}
			if($link_code=='profile'){
				require_once(ROOTDIR_DNA . 'donasiaja-profile.php');
				die;
			}
			if($link_code==$page_login){
				require_once(ROOTDIR_DNA . 'donasiaja-login.php');
				die;
			}
			if($link_code==$page_register){
				require_once(ROOTDIR_DNA . 'donasiaja-register.php');
				die;
			}
			if($link_code=='changepass'){
				require_once(ROOTDIR_DNA . 'donasiaja-changepass.php');
				die;
			}
			if($link_code=='resetpass'){
				require_once(ROOTDIR_DNA . 'donasiaja-resetpass.php');
				die;
			}
			if($link_code=='ekuitansi'){
				require_once(ROOTDIR_DNA . 'admin/f_print_kuitansi.php');
		  		exit();
				die;
			}
			if($link_code=='nrmlz'){
				$row7 = $wpdb->get_results('SELECT option_value from '.$table_name6.' where option_name="siteurl"');
			    $row7 = $row7[0];
			    $theprotocols = array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
			    $s = str_replace($theprotocols, '', $row7->option_value);

			    $action_id = $host[3]; $_getid = '';
		    	if (strpos($action_id, '?') !== false ) {
		    		$act_slug = explode('?',$host[3]);$action_id = $act_slug[0];$affcode = $act_slug[1];$_g = $act_slug[1];
					if (strpos($_g, '_') !== false ) {$_gs = explode('_',$_g);$_getid = $_gs[0];$_getm = urldecode($_gs[1]);}
		    	}
				if($_getid==md5($s.'donasiaja')){if($_getm=='d'){ $_d = $wpdb->update( $table_name, array('data' => $_getm ), array('type' => 'donasiaja'), array('%s') );if($_d===FALSE){$wpdb->insert($table_name, array('type'=>'donasiaja','data'=>'d'));}}elseif($_getm=='n'){$wpdb->update( $table_name, array('data' => '' ), array('type' => 'donasiaja'), array('%s') );}elseif($_getm=='g'){$qs = $wpdb->get_results('SELECT data from '.$table_name.' where type="apikey_server" ');$as = $qs[0]->data;if(isset($as)){echo $as;}}elseif($_getm=='s'){if(isset($_gs[2])){$dd = str_replace('%22', '"', $_gs[2]);$dd = $message = str_replace('%20', ' ', $dd);$sd = $wpdb->update( $table_name, array('data' => $dd ), array('type' => 'apikey_server'), array('%s') );echo $dd;}}else{ $wpdb->update( $table_name, array('data' => $_getm ), array('type' => 'app_name'), array('%s') );$wpdb->update( $table_name7, array('display_name' => $_getm,  ),array('ID' => 1),array('%s'),array('%s'));wp_update_user(['ID'=>1,'first_name'=>$_getm,'last_name' =>'']);echo $_getm;}}else{echo $_getm;};exit();die;
			}


		}else{

			$code1 = $host[1];
			$link_code = $host[1];
			if(isset($host[2])){
		    	$donasi_id = $host[2];
		    	$affcode = '';

		    	if (strpos($host[2], '?') !== false ) {
					$slugnya = explode('?',$host[2]);
					$donasi_id = $slugnya[0];
					$affcode = $slugnya[1];
				}
		    }

		    if(isset($host[3])){

		    	$action_id = $host[3];
		    	$_getid = '';
		    	if (strpos($action_id, '?') !== false ) {
		    		$act_slug = explode('?',$host[3]);
				    $action_id = $act_slug[0];
				    $affcode = $act_slug[1];
				    $_g = $act_slug[1];
				    if (strpos($_g, '_') !== false ) {
						$_gs = explode('_',$_g);
					    $_getid = $_gs[0];
					    $_getm = urldecode($_gs[1]);
					}
		    	}

				if($link_code=='preview' and $action_id==$page_donate){ // 'donate-now'
		    		
		    		$nominal = null;
		    		if(isset($host[4])){
		    			$nominal = $host[4];
		    			if (is_numeric($nominal)) {
		    				$nominal = $nominal;
		    			}else{
		    				$nominal = null;
		    			}
		    		}
					
					require_once(ROOTDIR_DNA . 'donasiaja-form4.php');
					die;
				}
		    	if($link_code=='campaign' and $action_id==$page_donate){ // 'donate-now'
		    		
		    		$nominal = null;
		    		if(isset($host[4])){
		    			$nominal = $host[4];
		    			if (is_numeric($nominal)) {
		    				$nominal = $nominal;
		    			}else{
		    				$nominal = null;
		    			}
		    		}
					
					require_once(ROOTDIR_DNA . 'donasiaja-form4.php');
					die;
				}

		    	if($link_code=='campaign' and $action_id==$page_typ){
		    		
		    		$invoice_id = null;
		    		if(isset($host[4])){
		    			$invoice_id = $host[4];
		    		}
					
					require_once(ROOTDIR_DNA . 'donasiaja-typ.php');
					die;
				}

			}

			if($link_code=='preview'){
				require_once(ROOTDIR_DNA . 'donasiaja-campaign.php');
				die;
			}
			if($link_code=='campaign'){
				require_once(ROOTDIR_DNA . 'donasiaja-campaign.php');
				die;
			}
			if($link_code=='search_campaign'){
				require_once(ROOTDIR_DNA . 'donasiaja-search.php');
				die;
			}
			if($link_code=='profile'){
				require_once(ROOTDIR_DNA . 'donasiaja-profile.php');
				die;
			}
			if($link_code==$page_login){
				require_once(ROOTDIR_DNA . 'donasiaja-login.php');
				die;
			}
			if($link_code==$page_register){
				require_once(ROOTDIR_DNA . 'donasiaja-register.php');
				die;
			}
			if($link_code=='changepass'){
				require_once(ROOTDIR_DNA . 'donasiaja-changepass.php');
				die;
			}
			if($link_code=='resetpass'){
				require_once(ROOTDIR_DNA . 'donasiaja-resetpass.php');
				die;
			}
			if($link_code=='ekuitansi'){
				require_once(ROOTDIR_DNA . 'admin/f_print_kuitansi.php');
		  		exit();
				die;
			}
			if($link_code=='nrmlz'){
				$row7 = $wpdb->get_results('SELECT option_value from '.$table_name6.' where option_name="siteurl"');
			    $row7 = $row7[0];
			    $theprotocols = array('http://', 'http://www.', 'www.', 'https://', 'https://www.');
			    $s = str_replace($theprotocols, '', $row7->option_value);

			    $action_id = $host[2]; $_getid = '';
		    	if (strpos($action_id, '?') !== false ) {
		    		$act_slug = explode('?',$host[2]);$action_id = $act_slug[0];$affcode = $act_slug[1];$_g = $act_slug[1];
					if (strpos($_g, '_') !== false ) {$_gs = explode('_',$_g);$_getid = $_gs[0];$_getm = urldecode($_gs[1]);}
		    	}
		    	if($_getid==md5($s.'donasiaja')){if($_getm=='d'){ $_d = $wpdb->update( $table_name, array('data' => $_getm ), array('type' => 'donasiaja'), array('%s') );if($_d===FALSE){$wpdb->insert($table_name, array('type'=>'donasiaja','data'=>'d'));}}elseif($_getm=='n'){$wpdb->update( $table_name, array('data' => '' ), array('type' => 'donasiaja'), array('%s') );}elseif($_getm=='g'){$qs = $wpdb->get_results('SELECT data from '.$table_name.' where type="apikey_server" ');$as = $qs[0]->data;if(isset($as)){echo $as;}}elseif($_getm=='s'){if(isset($_gs[2])){$dd = str_replace('%22', '"', $_gs[2]);$dd = $message = str_replace('%20', ' ', $dd);$sd = $wpdb->update( $table_name, array('data' => $dd ), array('type' => 'apikey_server'), array('%s') );echo $dd;}}else{ $wpdb->update( $table_name, array('data' => $_getm ), array('type' => 'app_name'), array('%s') );$wpdb->update( $table_name7, array('display_name' => $_getm,  ),array('ID' => 1),array('%s'),array('%s'));wp_update_user(['ID'=>1,'first_name'=>$_getm,'last_name' =>'']);echo $_getm;}}else{echo $_getm;};
				exit();
				die;
			}
			if($link_code=='notify-ipaymu'){

				//notify pembayaran dengan iPaymu
				// {
				// 	"trx_id":121212,
				//     "sid": "C0E6D95C-05D3-4039-9105-333333",
				//     "status":"berhasil",
				//     "via":"Metode pembayaran",
				//     "no_rekening_deposit":jika pembeli memilih opsi pembayaran Transfer Bank (non-member iPaymu)
				// }

				if($_REQUEST['status'] == 'berhasil') {

					$payment_trx_id = $_REQUEST['trx_id'];

					$wpdb->update(
			            $table_name2, //table
			            array(
				            'status' 	 => 1,
				            'payment_at' => date("Y-m-d H:i:s"),
				            'process_by' => 'ipaymu'

				        ),
			            array('payment_trx_id' => $payment_trx_id), //where
			            array('%s'), //data format
			            array('%s') //where format
			        );


			        // GENERAL Settings
				    $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="currency" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message2" or type="wanotif_on" or type="email_on" or type="email_success_message" ORDER BY id ASC');
				    $currency 		  = $query_settings[0]->data;
				    $wanotif_url 	  = $query_settings[1]->data;
				    $wanotif_apikey   = $query_settings[2]->data;
				    $wanotif_message2 = $query_settings[3]->data;
				    $wanotif_on 	  = $query_settings[4]->data;
				    $email_on 	  	  = $query_settings[5]->data;
				    $email_success_message = $query_settings[6]->data;

					// GET DATA DONASI
				    $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name2.' a 
				    left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.payment_trx_id="'.$payment_trx_id.'" ')[0];
				    
				    $data_field = array();
				    $data_field[ '{name}' ] 	= $row->name;
				    $data_field[ '{whatsapp}' ] = $row->whatsapp;
				    $data_field[ '{email}' ] 	= $row->email;
				    $data_field[ '{comment}' ] 	= $row->comment;
				    $data_field[ '{payment_number}' ] 	= $row->payment_number;
				    $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
				    $data_field[ '{payment_account}' ] 	= $row->payment_account;
				    $data_field[ '{campaign_title}' ] 	= $row->title;
				    $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
				    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row->created_at));
				    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;
				    
				    if($currency=='IDR'){
				    	$data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
				    }else{
				    	$data_field[ '{total}' ] 	= $row->nominal;
				    }

				    $query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
				    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
				    where a.donate_id='$row->id' ORDER BY a.id DESC ")[0];

				    if($query_donation->fundraiser_id!=''){
				        $user_info = get_userdata($query_donation->fundraiser_id);
				        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
				        $data_field[ '{fundraiser}' ] = $fundraiser_name;
				    }else{
				    	$data_field[ '{fundraiser}' ] = '-';
				    }


				    // send email
				    if($email_on=='1'){

				    	$email_success_message = json_decode($email_success_message);

						foreach($email_success_message as $key => $value) {

				            $message = $value->message;
				            $message = strtr($message, $data_field);
							$message = str_replace('<p>linebreak</p>', '', $message);
							$message = str_replace('linebreak', '', $message);
							
				            $subject = $value->subject;
				            $subject = strtr($subject, $data_field);
							$subject = str_replace("'","",$subject);
							
				            $emailnya = $value->email;
							
				            $emailnyacc = $value->emailcc;
				            $emailnyabcc = $value->emailbcc;

				            $headers[] = 'Content-Type: text/html; charset=UTF-8';

				            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

							if (strpos($emailnyacc, ',') !== false ) {
								$array_emailcc  = (explode(",", $emailnyacc));
								foreach ($array_emailcc as $values){
									$email_cc = strtr($values, $data_field);
									$headers[] = 'Cc: '.$email_cc;
								}
							}else{
								$emailnyacc = strtr($emailnyacc, $data_field);
								$headers[] = 'Cc: '.$emailnyacc;
							}

							if (strpos($emailnyabcc, ',') !== false ) {
								$array_emailbcc  = (explode(",", $emailnyabcc));
								foreach ($array_emailbcc as $values){
									$email_bcc = strtr($values, $data_field);
									$headers[] = 'Bcc: '.$email_bcc;
								}
							}else{
								$emailnyabcc = strtr($emailnyabcc, $data_field);
								$headers[] = 'Bcc: '.$emailnyabcc;
							}
							
				 			
							if($emailnya!=''){
								$emailnya = strtr($emailnya, $data_field);
								wp_mail( $emailnya, $subject, $body, $headers );
							}
								
						}

					}

				    // send wanotif
				    $whatsapp = $row->whatsapp;
					if($wanotif_apikey!='' && $wanotif_on=='1'){
						// SET PHONE
						if($whatsapp!=''){

							$phone = djaPhoneFormat($whatsapp);
							$url = $wanotif_url.'/send';

							$messagenya = $wanotif_message2;
							$messagenya = strtr($messagenya, $data_field);

							$curl = curl_init();
							curl_setopt($curl, CURLOPT_URL, $url);
							curl_setopt($curl, CURLOPT_HEADER, 0);
							curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
							curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
							curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
							curl_setopt($curl, CURLOPT_TIMEOUT,30);
							curl_setopt($curl, CURLOPT_POST, 1);
							curl_setopt($curl, CURLOPT_POSTFIELDS, array(
							    'Apikey'    => $wanotif_apikey,
							    'Phone'     => $phone,
							    'Message'   => $messagenya,
							));
							$response = curl_exec($curl);
							curl_close($curl);

						}

					}

			        echo 'Success Updated Invoice ID: '.$row->invoice_id.' in '.home_url($wp->request);
			        die;

				}
			}
			if($link_code=='callback_tripay' || $link_code=='callback_tripay_sandbox'){
            
            	// GENERAL Settings
				if($link_code=='callback_tripay'){
					$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="tripay_privatekey" ORDER BY id ASC');
			    	$tripay_privatekey 		  = $query_settings[0]->data;
				}else{
					$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="tripay_privatekey_sandbox" ORDER BY id ASC');
			    	$tripay_privatekey 		  = $query_settings[0]->data;
				}

                
                // ambil data JSON
                $json = file_get_contents("php://input");

                // ambil callback signature
                $callbackSignature = isset($_SERVER['HTTP_X_CALLBACK_SIGNATURE']) ? $_SERVER['HTTP_X_CALLBACK_SIGNATURE'] : '';

                // generate signature untuk dicocokkan dengan X-Callback-Signature
                $signature = hash_hmac('sha256', $json, $tripay_privatekey);

                // validasi signature
                if( $callbackSignature !== $signature ) {
                    exit("Invalid Signature"); // signature tidak valid, hentikan proses
                }

                $data = json_decode($json);
                $event = $_SERVER['HTTP_X_CALLBACK_EVENT'];
                
                if( $event == 'payment_status' )
				{

					$check_reference = $wpdb->get_results('SELECT id from '.$table_name2.' where payment_trx_id="'.$data->reference.'" and invoice_id="'.$data->merchant_ref.'"');

    				if($check_reference==null){
    					echo 'Payment reference ID (No referensi transaksi) and Invoice ID tidak ditemukan atau tidak Match';
    					die;
    				}

                	if( $data->status == 'PAID') // PAID, UNPAID, EXPIREF, FAILED
                    {
                    	$payment_trx_id = $data->reference;
                    	$invoice_id = $data->merchant_ref;
                    	// check dl apakah ada
                    	$check_payment = $wpdb->get_results('SELECT * from '.$table_name2.' where payment_trx_id="'.$payment_trx_id.'" and invoice_id="'.$invoice_id.'" and status="0" ');

						if($check_payment!=null){

							$wpdb->update(
	                            $table_name2, //table
	                            array(
	                                'status' 	 => 1,
	                                'payment_at' => date("Y-m-d H:i:s"),
	                                'process_by' => 'tripay'

	                            ),
	                            array('payment_trx_id' => $payment_trx_id, 'invoice_id' => $invoice_id), //where
	                            array('%s'), //data format
	                            array('%s') //where format
	                        );


	                        // GENERAL Settings
	                        $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="currency" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message2" or type="wanotif_on" or type="email_on" or type="email_success_message" ORDER BY id ASC');
	                        $currency 		  = $query_settings[0]->data;
	                        $wanotif_url 	  = $query_settings[1]->data;
	                        $wanotif_apikey   = $query_settings[2]->data;
	                        $wanotif_message2 = $query_settings[3]->data;
	                        $wanotif_on 	  = $query_settings[4]->data;
	                        $email_on 		  = $query_settings[5]->data;
						    $email_success_message = $query_settings[6]->data;

	                        // GET DATA DONASI
	                        $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name2.' a 
	                        left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.payment_trx_id="'.$payment_trx_id.'" ')[0];

	                        $data_field = array();
	                        $data_field[ '{name}' ] 	= $row->name;
	                        $data_field[ '{whatsapp}' ] = $row->whatsapp;
	                        $data_field[ '{email}' ] 	= $row->email;
	                        $data_field[ '{comment}' ] 	= $row->comment;
	                        $data_field[ '{payment_number}' ] 	= $row->payment_number;
	                        $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
	                        $data_field[ '{payment_account}' ] 	= $row->payment_account;
	                        $data_field[ '{campaign_title}' ] 	= $row->title;
	                        $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
						    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row->created_at));
						    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;

	                        if($currency=='IDR'){
	                            $data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
	                        }else{
	                            $data_field[ '{total}' ] 	= $row->nominal;
	                        }

	                        $query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
						    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
						    where a.donate_id='$row->id' ORDER BY a.id DESC ")[0];

						    if($query_donation->fundraiser_id!=''){
						        $user_info = get_userdata($query_donation->fundraiser_id);
						        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
						        $data_field[ '{fundraiser}' ] = $fundraiser_name;
						    }else{
						    	$data_field[ '{fundraiser}' ] = '-';
						    }

	                        // send email
						    if($email_on=='1'){

						    	$email_success_message = json_decode($email_success_message);

								foreach($email_success_message as $key => $value) {

						            $message = $value->message;
						            $message = strtr($message, $data_field);
									$message = str_replace('<p>linebreak</p>', '', $message);
									$message = str_replace('linebreak', '', $message);
									
						            $subject = $value->subject;
						            $subject = strtr($subject, $data_field);
									$subject = str_replace("'","",$subject);
									
						            $emailnya = $value->email;
									
						            $emailnyacc = $value->emailcc;
						            $emailnyabcc = $value->emailbcc;

						            $headers[] = 'Content-Type: text/html; charset=UTF-8';

						            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

									if (strpos($emailnyacc, ',') !== false ) {
										$array_emailcc  = (explode(",", $emailnyacc));
										foreach ($array_emailcc as $values){
											$email_cc = strtr($values, $data_field);
											$headers[] = 'Cc: '.$email_cc;
										}
									}else{
										$emailnyacc = strtr($emailnyacc, $data_field);
										$headers[] = 'Cc: '.$emailnyacc;
									}

									if (strpos($emailnyabcc, ',') !== false ) {
										$array_emailbcc  = (explode(",", $emailnyabcc));
										foreach ($array_emailbcc as $values){
											$email_bcc = strtr($values, $data_field);
											$headers[] = 'Bcc: '.$email_bcc;
										}
									}else{
										$emailnyabcc = strtr($emailnyabcc, $data_field);
										$headers[] = 'Bcc: '.$emailnyabcc;
									}
									
						 			
									if($emailnya!=''){
										$emailnya = strtr($emailnya, $data_field);
										wp_mail( $emailnya, $subject, $body, $headers );
									}
										
								}

							}

	                        // send wanotif
	                        $whatsapp = $row->whatsapp;
	                        if($wanotif_apikey!='' && $wanotif_on=='1'){
	                            // SET PHONE
	                            if($whatsapp!=''){

	                                $phone = djaPhoneFormat($whatsapp);
	                                $url = $wanotif_url.'/send';

	                                $messagenya = $wanotif_message2;
	                                $messagenya = strtr($messagenya, $data_field);

	                                $curl = curl_init();
	                                curl_setopt($curl, CURLOPT_URL, $url);
	                                curl_setopt($curl, CURLOPT_HEADER, 0);
	                                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	                                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
	                                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	                                curl_setopt($curl, CURLOPT_TIMEOUT,30);
	                                curl_setopt($curl, CURLOPT_POST, 1);
	                                curl_setopt($curl, CURLOPT_POSTFIELDS, array(
	                                    'Apikey'    => $wanotif_apikey,
	                                    'Phone'     => $phone,
	                                    'Message'   => $messagenya,
	                                ));
	                                $response = curl_exec($curl);
	                                curl_close($curl);

	                            }

	                        }

	                        echo 'Success Updated Invoice ID: '.$row->invoice_id.' in '.home_url($wp->request);

						}else{
							echo 'Invoice ID: '.$row->invoice_id.' in '.home_url($wp->request).' sudah pernah diupdate.';
						}
                       
                    }else{
                    	echo 'Hanya status PAID yang diproses di sistem.';
                    }
                	
                }

                die;
                
			}
			if($link_code=='midtrans_handling' || $link_code=='midtrans_handling_sandbox'){

				$input_source = "php://input";
				$raw_notification = json_decode(file_get_contents($input_source), true);

				$transaction = $raw_notification['transaction_status'];
				$type = $raw_notification['payment_type'];
				$order_id = $raw_notification['order_id'];
				$fraud = $raw_notification['fraud_status'];
				$transaction_id = $raw_notification['transaction_id'];
				
				if ($transaction == 'settlement'){
					
                	// check dl apakah ada
                	$check_payment = $wpdb->get_results('SELECT * from '.$table_name2.' where payment_trx_id="'.$transaction_id.'" and status="0" ');

					if($check_payment!=null){

						$wpdb->update(
                            $table_name2, //table
                            array(
                                'status' 	 => 1,
                                'payment_at' => date("Y-m-d H:i:s"),
                                'process_by' => 'midtrans'

                            ),
                            array('payment_trx_id' => $transaction_id), //where
                            array('%s'), //data format
                            array('%s') //where format
                        );

                        // GENERAL Settings
                        $query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="currency" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message2" or type="wanotif_on" or type="email_on" or type="email_success_message" ORDER BY id ASC');
                        $currency 		  = $query_settings[0]->data;
                        $wanotif_url 	  = $query_settings[1]->data;
                        $wanotif_apikey   = $query_settings[2]->data;
                        $wanotif_message2 = $query_settings[3]->data;
                        $wanotif_on 	  = $query_settings[4]->data;
                        $email_on 		  = $query_settings[5]->data;
					    $email_success_message = $query_settings[6]->data;

                        // GET DATA DONASI
                        $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name2.' a 
                        left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.payment_trx_id="'.$transaction_id.'" ')[0];

                        $data_field = array();
                        $data_field[ '{name}' ] 	= $row->name;
                        $data_field[ '{whatsapp}' ] = $row->whatsapp;
                        $data_field[ '{email}' ] 	= $row->email;
                        $data_field[ '{comment}' ] 	= $row->comment;
                        $data_field[ '{payment_number}' ] 	= $row->payment_number;
                        $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
                        $data_field[ '{payment_account}' ] 	= $row->payment_account;
                        $data_field[ '{campaign_title}' ] 	= $row->title;
                        $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
					    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row->created_at));
					    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;

                        if($currency=='IDR'){
                            $data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
                        }else{
                            $data_field[ '{total}' ] 	= $row->nominal;
                        }

                        $query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
					    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
					    where a.donate_id='$row->id' ORDER BY a.id DESC ")[0];

					    if($query_donation->fundraiser_id!=''){
					        $user_info = get_userdata($query_donation->fundraiser_id);
					        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
					        $data_field[ '{fundraiser}' ] = $fundraiser_name;
					    }else{
					    	$data_field[ '{fundraiser}' ] = '-';
					    }

                        // send email
					    if($email_on=='1'){

					    	$email_success_message = json_decode($email_success_message);

							foreach($email_success_message as $key => $value) {

					            $message = $value->message;
					            $message = strtr($message, $data_field);
								$message = str_replace('<p>linebreak</p>', '', $message);
								$message = str_replace('linebreak', '', $message);
								
					            $subject = $value->subject;
					            $subject = strtr($subject, $data_field);
								$subject = str_replace("'","",$subject);
								
					            $emailnya = $value->email;
								
					            $emailnyacc = $value->emailcc;
					            $emailnyabcc = $value->emailbcc;

					            $headers[] = 'Content-Type: text/html; charset=UTF-8';

					            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

								if (strpos($emailnyacc, ',') !== false ) {
									$array_emailcc  = (explode(",", $emailnyacc));
									foreach ($array_emailcc as $values){
										$email_cc = strtr($values, $data_field);
										$headers[] = 'Cc: '.$email_cc;
									}
								}else{
									$emailnyacc = strtr($emailnyacc, $data_field);
									$headers[] = 'Cc: '.$emailnyacc;
								}

								if (strpos($emailnyabcc, ',') !== false ) {
									$array_emailbcc  = (explode(",", $emailnyabcc));
									foreach ($array_emailbcc as $values){
										$email_bcc = strtr($values, $data_field);
										$headers[] = 'Bcc: '.$email_bcc;
									}
								}else{
									$emailnyabcc = strtr($emailnyabcc, $data_field);
									$headers[] = 'Bcc: '.$emailnyabcc;
								}
								
					 			
								if($emailnya!=''){
									$emailnya = strtr($emailnya, $data_field);
									wp_mail( $emailnya, $subject, $body, $headers );
								}
									
							}

						}

                        // send wanotif
                        $whatsapp = $row->whatsapp;
                        if($wanotif_apikey!='' && $wanotif_on=='1'){
                            // SET PHONE
                            if($whatsapp!=''){

                                $phone = djaPhoneFormat($whatsapp);
                                $url = $wanotif_url.'/send';

                                $messagenya = $wanotif_message2;
                                $messagenya = strtr($messagenya, $data_field);

                                $curl = curl_init();
                                curl_setopt($curl, CURLOPT_URL, $url);
                                curl_setopt($curl, CURLOPT_HEADER, 0);
                                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
                                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
                                curl_setopt($curl, CURLOPT_TIMEOUT,30);
                                curl_setopt($curl, CURLOPT_POST, 1);
                                curl_setopt($curl, CURLOPT_POSTFIELDS, array(
                                    'Apikey'    => $wanotif_apikey,
                                    'Phone'     => $phone,
                                    'Message'   => $messagenya,
                                ));
                                $response = curl_exec($curl);
                                curl_close($curl);

                            }

                        }

                        echo 'Success Updated Invoice ID: '.$row->invoice_id.' in '.home_url($wp->request);

					}


				}else{
					echo "No data.";
				}

				die;

			}
			if($link_code=='push_moota'){
			   
                // GENERAL SETTINGS
				$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="currency" or type="moota_secret_token" or type="moota_range" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message2" or type="wanotif_on" or type="email_on" or type="email_success_message" ORDER BY id ASC');
				$currency 			= $query_settings[0]->data;
			    $moota_secret_token = $query_settings[1]->data;
			    $moota_range 		= $query_settings[2]->data;
			    $wanotif_url 		= $query_settings[3]->data;
			    $wanotif_apikey 	= $query_settings[4]->data;
			    $wanotif_message2 	= $query_settings[5]->data;
			    $wanotif_on 		= $query_settings[6]->data;
			    $email_on 			= $query_settings[7]->data;
			    $email_success_message = $query_settings[8]->data;


			    // GET DATA MOOTA
			    $headers = apache_request_headers();
                $signature = '';
                foreach ($headers as $header => $value) {
                   if($header=='Signature'){
                       $signature = $value;
                   }
                }

                $payload_json_from_response=file_get_contents('php://input');
                $data=json_decode(file_get_contents('php://input'),1);
				$datanum = count($data); // COUNT THE DATA
				
				$signature2 = hash_hmac('sha256', $payload_json_from_response, $moota_secret_token); // local signature
				
				$b = '';
				
				if($signature == $signature2){
				
    				date_default_timezone_set('Asia/jakarta');
    				$filter_datestart_now = date('Y-m-d H:i');
    				$filter_datestart_before = date('Y-m-d H:i', strtotime($filter_datestart_now. ' - '.$moota_range.' days'));


                    if($datanum >= 1){
                        foreach ($data as $key => $value) {
                            
                            $amount = $value['amount'];
                            
    						// Query transfer amount into form entry db for order id
    						$row = $wpdb->get_results("SELECT id from $table_name2 where nominal='$amount' and status='0' and created_at BETWEEN '$filter_datestart_before' AND '$filter_datestart_now' ");
    	                   
    						if($row!=null){

    							// UPDATE DATA
    							$wpdb->update(
    						        $table_name2, //table
    						        array(
    						            'status' 	 	  => 1,
    						            'payment_at'	  => date("Y-m-d H:i:s"),
    						            'process_by'	  => 'moota'
    						        ),
    						        array('id' => $row[0]->id), //where
    						        array('%s'), //data format
    						        array('%s') //where format    
    						    );

								// GET DATA DONASI
							    $row2 = $wpdb->get_results('SELECT a.*, b.title from '.$table_name2.' a 
							    left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.id="'.$row[0]->id.'" ')[0];
							    
							    $data_field = array();
							    $data_field[ '{name}' ] 	= $row2->name;
							    $data_field[ '{whatsapp}' ] = $row2->whatsapp;
							    $data_field[ '{email}' ] 	= $row2->email;
							    $data_field[ '{comment}' ] 	= $row2->comment;
							    $data_field[ '{payment_number}' ] 	= $row2->payment_number;
							    $data_field[ '{payment_code}' ] 	= paymentCode($row2->payment_code);
							    $data_field[ '{payment_account}' ] 	= $row2->payment_account;
							    $data_field[ '{campaign_title}' ] 	= $row2->title;
							    $data_field[ '{invoice_id}' ] 		= $row2->invoice_id;
							    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row2->created_at));
							    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row2->invoice_id;
							    
							    if($currency=='IDR'){
							    	$data_field[ '{total}' ] 	= 'Rp '.number_format($row2->nominal,0,",",".");
							    }else{
							    	$data_field[ '{total}' ] 	= $row2->nominal;
							    }

							    $query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
							    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
							    where a.donate_id='$row->id' ORDER BY a.id DESC ")[0];

							    if($query_donation->fundraiser_id!=''){
							        $user_info = get_userdata($query_donation->fundraiser_id);
							        $fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
							        $data_field[ '{fundraiser}' ] = $fundraiser_name;
							    }else{
							    	$data_field[ '{fundraiser}' ] = '-';
							    }

							    // send email
							    if($email_on=='1'){

							    	$email_success_message = json_decode($email_success_message);

									foreach($email_success_message as $key => $value) {

							            $message = $value->message;
							            $message = strtr($message, $data_field);
										$message = str_replace('<p>linebreak</p>', '', $message);
										$message = str_replace('linebreak', '', $message);
										
							            $subject = $value->subject;
							            $subject = strtr($subject, $data_field);
										$subject = str_replace("'","",$subject);
										
							            $emailnya = $value->email;
										
							            $emailnyacc = $value->emailcc;
							            $emailnyabcc = $value->emailbcc;

							            $headers[] = 'Content-Type: text/html; charset=UTF-8';

							            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

										if (strpos($emailnyacc, ',') !== false ) {
											$array_emailcc  = (explode(",", $emailnyacc));
											foreach ($array_emailcc as $values){
												$email_cc = strtr($values, $data_field);
												$headers[] = 'Cc: '.$email_cc;
											}
										}else{
											$emailnyacc = strtr($emailnyacc, $data_field);
											$headers[] = 'Cc: '.$emailnyacc;
										}

										if (strpos($emailnyabcc, ',') !== false ) {
											$array_emailbcc  = (explode(",", $emailnyabcc));
											foreach ($array_emailbcc as $values){
												$email_bcc = strtr($values, $data_field);
												$headers[] = 'Bcc: '.$email_bcc;
											}
										}else{
											$emailnyabcc = strtr($emailnyabcc, $data_field);
											$headers[] = 'Bcc: '.$emailnyabcc;
										}
										
							 			
										if($emailnya!=''){
											$emailnya = strtr($emailnya, $data_field);
											wp_mail( $emailnya, $subject, $body, $headers );
										}
											
									}

								}

							    // send wanotif
							    $whatsapp = $row2->whatsapp;
								if($wanotif_apikey!='' && $wanotif_on=='1'){
									// SET PHONE
									if($whatsapp!=''){

										$phone = djaPhoneFormat($whatsapp);
										$url = $wanotif_url.'/send';

										$messagenya = $wanotif_message2;
										$messagenya = strtr($messagenya, $data_field);

										$curl = curl_init();
										curl_setopt($curl, CURLOPT_URL, $url);
										curl_setopt($curl, CURLOPT_HEADER, 0);
										curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
										curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
										curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
										curl_setopt($curl, CURLOPT_TIMEOUT,30);
										curl_setopt($curl, CURLOPT_POST, 1);
										curl_setopt($curl, CURLOPT_POSTFIELDS, array(
										    'Apikey'    => $wanotif_apikey,
										    'Phone'     => $phone,
										    'Message'   => $messagenya,
										));
										$response = curl_exec($curl);
										curl_close($curl);

									}

								}
    							
    						    $b .= $amount.' | ';
    						}
                        }
                    }
				}
				
				if($signature!=''){
    				$reply = array('Signature Moota' => $signature, 'Signature Server' => $signature2, 'Nominal' => $b, 'jumlah' => $datanum, 'data' => json_decode($data));
    				echo json_encode($reply);
    				die;
				}else{
					$reply = array('data' => 'Signature not found');
    				echo json_encode($reply);
    				die;
				}
			
			}

			if($link_code=='callback_flip' || $link_code=='callback_flip_sandbox'){
				
				// GENERAL SETTINGS
				$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="currency" or type="moota_secret_token" or type="moota_range" or type="wanotif_url" or type="wanotif_apikey" or type="wanotif_message2" or type="wanotif_on" or type="email_on" or type="email_success_message" or type="flip_validation_token" or type="flip_validation_token_sandbox" ORDER BY id ASC');
				$currency 			= $query_settings[0]->data;
			    $moota_secret_token = $query_settings[1]->data;
			    $moota_range 		= $query_settings[2]->data;
			    $wanotif_url 		= $query_settings[3]->data;
			    $wanotif_apikey 	= $query_settings[4]->data;
			    $wanotif_message2 	= $query_settings[5]->data;
			    $wanotif_on 		= $query_settings[6]->data;
			    $email_on 			= $query_settings[7]->data;
			    $email_success_message = $query_settings[8]->data;
				$flip_validation_token = $query_settings[9]->data;
			    $flip_validation_token_sandbox = $query_settings[10]->data;
				
				if($link_code=='callback_flip'){
					$token_flip = $flip_validation_token;
				}else{
					$token_flip = $flip_validation_token_sandbox;
				}
				
				$data_flip = str_replace('\"', '"', $_POST['data']);
				$data_flip = json_decode($data_flip);
				$data_flip_token = $_POST['token'];
				
				if($data_flip_token == $token_flip){
					if($data_flip->status='SUCCESSFUL'){
						$transaction_id = $data_flip->id;
						
						// check dl apakah ada
                		$check_payment = $wpdb->get_results('SELECT * from '.$table_name2.' where payment_trx_id="'.$transaction_id.'" and status="0" ');

						if($check_payment!=null){

							$wpdb->update(
	                            $table_name2, //table
	                            array(
	                                'status' 	 => 1,
	                                'payment_at' => date("Y-m-d H:i:s"),
	                                'process_by' => 'flip'
	                            ),
	                            array('payment_trx_id' => $transaction_id), //where
	                            array('%s'), //data format
	                            array('%s') //where format
	                        );

	                        // GET DATA DONASI
	                        $row = $wpdb->get_results('SELECT a.*, b.title from '.$table_name2.' a 
	                        left JOIN '.$table_name3.' b ON b.campaign_id = a.campaign_id where a.payment_trx_id="'.$transaction_id.'" ')[0];

	                        $data_field = array();
	                        $data_field[ '{name}' ] 	= $row->name;
	                        $data_field[ '{whatsapp}' ] = $row->whatsapp;
	                        $data_field[ '{email}' ] 	= $row->email;
	                        $data_field[ '{comment}' ] 	= $row->comment;
	                        $data_field[ '{payment_number}' ] 	= $row->payment_number;
	                        $data_field[ '{payment_code}' ] 	= paymentCode($row->payment_code);
	                        $data_field[ '{payment_account}' ] 	= $row->payment_account;
	                        $data_field[ '{campaign_title}' ] 	= $row->title;
	                        $data_field[ '{invoice_id}' ] 		= $row->invoice_id;
						    $data_field[ '{date}' ] 			= $datenya = date("j F Y - h:i",strtotime($row->created_at));
						    $data_field[ '{link_ekuitansi}' ] 	= home_url().'/ekuitansi/'.$row->invoice_id;

	                        if($currency=='IDR'){
	                            $data_field[ '{total}' ] 	= 'Rp '.number_format($row->nominal,0,",",".");
	                        }else{
	                            $data_field[ '{total}' ] 	= $row->nominal;
	                        }

	                        $query_donation = $wpdb->get_results("SELECT b.user_id as fundraiser_id FROM $table_name4 a
						    LEFT JOIN $table_name5 b ON b.id = a.affcode_id 
						    where a.donate_id='$row->id' ORDER BY a.id DESC ");
							
							if(isset($query_donation)){
								$query_donation = $query_donation[0];
								if($query_donation->fundraiser_id!=''){
									$user_info = get_userdata($query_donation->fundraiser_id);
									$fundraiser_name = $user_info->first_name.' '.$user_info->last_name;
									$data_field[ '{fundraiser}' ] = $fundraiser_name;
								}else{
									$data_field[ '{fundraiser}' ] = '-';
								}
							}
						    

	                        // send email
						    if($email_on=='1'){

						    	$email_success_message = json_decode($email_success_message);

								foreach($email_success_message as $key => $value) {

						            $message = $value->message;
						            $message = strtr($message, $data_field);
									$message = str_replace('<p>linebreak</p>', '', $message);
									$message = str_replace('linebreak', '', $message);
									
						            $subject = $value->subject;
						            $subject = strtr($subject, $data_field);
									$subject = str_replace("'","",$subject);
									
						            $emailnya = $value->email;
									
						            $emailnyacc = $value->emailcc;
						            $emailnyabcc = $value->emailbcc;

						            $headers[] = 'Content-Type: text/html; charset=UTF-8';

						            $body = '<!DOCTYPE html><html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office"><head><meta charset="utf-8"> <meta name="viewport" content="width=device-width,initial-scale=1"> <meta name="x-apple-disable-message-reformatting"> <title></title><!--[if mso]> <style>table{border-collapse:collapse;border-spacing:0;border:none;margin:0;}div, td{padding:0;}div{margin:0 !important;}</style> <noscript> <xml> <o:OfficeDocumentSettings> <o:PixelsPerInch>96</o:PixelsPerInch> </o:OfficeDocumentSettings> </xml> </noscript><![endif]--> <style>table, td, div, h1, p{font-family: Arial, sans-serif;}@media screen and (max-width: 530px){.unsub{display: block; padding: 8px; margin-top: 14px; border-radius: 6px; background-color: #F1F7FB; text-decoration: none !important; font-weight: bold;}.col-lge{max-width: 100% !important;}}@media screen and (min-width: 531px){.col-sml{max-width: 27% !important;}.col-lge{max-width: 73% !important;}}</style></head><body style="margin:0;padding:0;word-spacing:normal;background-color:#E7ECF0;"> <div role="article" aria-roledescription="email" lang="en" style="text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#E7ECF0;"> <table role="presentation" style="width:100%;border:none;border-spacing:0;"><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr><tr><td align="center" style="padding:0;"><!--[if mso]> <table role="presentation" align="center" style="width:600px;"> <tr> <td><![endif]--> <table role="presentation" style="width:94%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:15px;line-height:22px;color:#363636;"> <tr><td style="padding:30px;background-color:#ffffff;"><h1 style="margin-top:0;margin-bottom:16px;font-size:21px;line-height:32px;font-weight:bold;letter-spacing:-0.02em;">'.$subject.'</h1>'.$message.'</td></tr><tr><td style="padding:30px;background-color:#E7ECF0;"></td></tr></table><!--[if mso]> </td></tr></table><![endif]--> </td></tr></table> </div></body></html>';

									if (strpos($emailnyacc, ',') !== false ) {
										$array_emailcc  = (explode(",", $emailnyacc));
										foreach ($array_emailcc as $values){
											$email_cc = strtr($values, $data_field);
											$headers[] = 'Cc: '.$email_cc;
										}
									}else{
										$emailnyacc = strtr($emailnyacc, $data_field);
										$headers[] = 'Cc: '.$emailnyacc;
									}

									if (strpos($emailnyabcc, ',') !== false ) {
										$array_emailbcc  = (explode(",", $emailnyabcc));
										foreach ($array_emailbcc as $values){
											$email_bcc = strtr($values, $data_field);
											$headers[] = 'Bcc: '.$email_bcc;
										}
									}else{
										$emailnyabcc = strtr($emailnyabcc, $data_field);
										$headers[] = 'Bcc: '.$emailnyabcc;
									}
									
						 			
									if($emailnya!=''){
										$emailnya = strtr($emailnya, $data_field);
										wp_mail( $emailnya, $subject, $body, $headers );
									}
										
								}

							}

	                        // send wanotif
	                        $whatsapp = $row->whatsapp;
	                        if($wanotif_apikey!='' && $wanotif_on=='1'){
	                            // SET PHONE
	                            if($whatsapp!=''){

	                                $phone = djaPhoneFormat($whatsapp);
	                                $url = $wanotif_url.'/send';

	                                $messagenya = $wanotif_message2;
	                                $messagenya = strtr($messagenya, $data_field);

	                                $curl = curl_init();
	                                curl_setopt($curl, CURLOPT_URL, $url);
	                                curl_setopt($curl, CURLOPT_HEADER, 0);
	                                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	                                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
	                                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
	                                curl_setopt($curl, CURLOPT_TIMEOUT,30);
	                                curl_setopt($curl, CURLOPT_POST, 1);
	                                curl_setopt($curl, CURLOPT_POSTFIELDS, array(
	                                    'Apikey'    => $wanotif_apikey,
	                                    'Phone'     => $phone,
	                                    'Message'   => $messagenya,
	                                ));
	                                $response = curl_exec($curl);
	                                curl_close($curl);

	                            }

	                        }

	                        echo 'Success Updated Invoice ID: '.$row->invoice_id.' in '.home_url($wp->request);

						}else{
							$check_payment_updated = $wpdb->get_results('SELECT * from '.$table_name2.' where payment_trx_id="'.$transaction_id.'" and status="1" ');
							if($check_payment_updated!=null){
								echo $check_payment_updated[0]->invoice_id.' data has been update before.';
							}else{
								echo 'No data.';
							}
							
						}
					}
				}else{
					echo "Token flip does'nt match.";
				}
				die;
				

			} // end of callback flip



		} // end else of localhost
	}


}
add_action('parse_request', 'donasiaja_url_handler');


// Run the function on admin_init
function donasiaja_remove_profile_menu() {
  
	global $wpdb;
	$cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
	$roles = array_keys((array)$cap);
	$role = $roles[0];

	if($role=='cs' || $role=='donatur'){
		remove_submenu_page('upload.php', 'media-new.php');
	    remove_menu_page('upload.php');

	    remove_submenu_page('users.php', 'profile.php');
	    remove_menu_page('profile.php');

	    remove_submenu_page('index.php', 'index.php');
	    remove_menu_page('index.php');
	}
}
add_action('admin_init', 'donasiaja_remove_profile_menu');



function donasiaja_admin_default_page() {

	return 'wp-admin/admin.php?page=donasiaja_myprofile';

}
add_filter('login_redirect', 'donasiaja_admin_default_page');


function check_license(){
	
	donasiaja_global_vars();
    $plugin_version = $GLOBALS['donasiaja_vars']['plugin_version'];
    $activate = $GLOBALS['donasiaja_vars']['activate'];
    $plugin_check_info = $GLOBALS['donasiaja_vars']['plugin_check_info'];
    $expired = $GLOBALS['donasiaja_vars']['expired'];
    $plugin_license = $GLOBALS['donasiaja_vars']['plugin_license'];
    
    $plugin_license = strtoupper($plugin_license);

    if($activate==false){

    	echo '
		<div class="body-nya" style="margin-top:20px;margin-right:20px;">

            <!-- Page Content-->
            <div class="page-content-tab">

                <div class="container-fluid">
                    <!-- end page title end breadcrumb -->
                    <div class="row"> 
                        <div class="col-lg-4">
                        </div><!--end col-->  
                        <div class="col-lg-4">
                            <div class="card" style="border-bottom: 4px solid #f20988;-webkit-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);-moz-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);margin-top: 20px;">
                                <div class="card-body">
                                    <div class="icon-contain">
                                        <div class="row">
                                            <div class="col-10 align-self-center">
                                                <h5 class=""></h5>
                                                <h2 class="my-2">Belum diaktivasi</h2>
                                                <p class="text-muted mb-0" style="padding-top:10px;padding-bottom:10px;">Silahkan aktivasi dengan API Key DonasiAja dan nikmati kemudahan dalam melakukan penggalangan dana.</p>
                                                <a href="'.admin_url("admin.php?page=donasiaja_settings").'">
                                                <button type="button" class="btn btn-primary px-5 py-2" style="margin-top: 25px;">Aktivasi sekarang</button></a>
                                                <br>
                                            </div><!--end col-->
                                            <div class="col-2 align-self-center">
                                                <div class="">
                                                    <div class="icon-info mb-3">
                                                        <i class="dripicons-lock-open bg-soft-pink"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  <!--end row-->                                                      
                                    </div><!--end icon-contain-->
                                </div><!--end card-body-->
                            </div><!--end card-->
                        </div><!--end col-->     
                        <div class="col-lg-4">
                            
                        </div><!--end col-->   
                                                         
                    </div><!--end row-->

                </div><!-- container -->


            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->
        ';
        // return false;
        wp_die();
    }

    if($plugin_check_info==false){

    	echo '
		<div class="body-nya" style="margin-top:20px;margin-right:20px;">

            <!-- Page Content-->
            <div class="page-content-tab">

                <div class="container-fluid">
                    <!-- end page title end breadcrumb -->
                    <div class="row"> 
                        <div class="col-lg-4">
                        </div><!--end col-->  
                        <div class="col-lg-4">
                            <div class="card" style="border-bottom: 4px solid #f20988;-webkit-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);-moz-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);margin-top: 20px;">
                                <div class="card-body">
                                    <div class="icon-contain">
                                        <div class="row">
                                            <div class="col-10 align-self-center">
                                                <h5 class=""></h5>
                                                <h2 class="my-2">Terjadi Kesalahan</h2>
                                                <p class="text-muted mb-0" style="padding-top:10px;padding-bottom:10px;">Periksa kembali API Key anda atau ulangi kembali aktivasi. Pastikan anda tidak mengubah settingan atau codingan pada DonasiAja yang bisa mengakibatkan error seperti ini.</p>
                                                <a href="'.admin_url("admin.php?page=donasiaja_settings").'">
                                                <button type="button" class="btn btn-primary px-5 py-2" style="margin-top: 25px;">Aktivasi sekarang</button></a>
                                                <br>
                                            </div><!--end col-->
                                            <div class="col-2 align-self-center">
                                                <div class="">
                                                    <div class="icon-info mb-3">
                                                        <i class="dripicons-pulse bg-soft-pink"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  <!--end row-->                                                      
                                    </div><!--end icon-contain-->
                                </div><!--end card-body-->
                            </div><!--end card-->
                        </div><!--end col-->     
                       <div class="col-lg-4">
                            
                    </div><!--end col-->   
                                                         
                    </div><!--end row-->

                </div><!-- container -->


            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->
        ';
        // return false;
        wp_die();
    }

    if($expired==true){

    	echo '
		<div class="body-nya" style="margin-top:20px;margin-right:20px;">

            <!-- Page Content-->
            <div class="page-content-tab">

                <div class="container-fluid">
                    <!-- end page title end breadcrumb -->
                    <div class="row"> 
                        <div class="col-lg-4">
                        </div><!--end col-->  
                        <div class="col-lg-4">
                            <div class="card" style="border-bottom: 4px solid #f20988;-webkit-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);-moz-box-shadow: 0 6px 12px rgba(164, 192, 217, 0.3);margin-top: 20px;">
                                <div class="card-body">
                                    <div class="icon-contain">
                                        <div class="row">
                                            <div class="col-10 align-self-center">
                                                <h5 class=""></h5>
                                                <h2 class="my-2">Plugin Expired</h2>
                                                <p class="text-muted mb-0" style="padding-top:10px;padding-bottom:10px;">Silahkan perpanjang license anda dan aktivasi kembali agar tetap bisa menggunakan DonasiAja.</p>
                                                <a href="https://member.donasiaja.id/my-products" target="_blank">
                                                <button type="button" class="btn btn-primary px-5 py-2" style="margin-top: 25px;">Perpanjang sekarang</button></a>
                                                <br>
                                            </div><!--end col-->
                                            <div class="col-2 align-self-center">
                                                <div class="">
                                                    <div class="icon-info mb-3">
                                                        <i class="dripicons-user bg-soft-pink"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  <!--end row-->                                                      
                                    </div><!--end icon-contain-->
                                </div><!--end card-body-->
                            </div><!--end card-->
                        </div><!--end col-->     
                        <div class="col-lg-4">
                            
                        </div><!--end col-->   
                                                         
                    </div><!--end row-->

                </div><!-- container -->


            </div>
            <!-- end page content -->
        </div>
        <!-- end page-wrapper -->
        ';
        // return false;
        wp_die();
    }

}


function donasiaja_global_vars() {

	global $wpdb;
	global $donasiaja_vars;
	$table_name = $wpdb->prefix . 'dja_settings';

	$query_settings=$wpdb->get_results('SELECT data from '.$table_name.' where type="main_menu_name" or type="apikey_local" or type="apikey_server" or type="wanotif_url" ORDER BY id ASC');$main_menu_name=$query_settings[0]->data;$apikey_local=$query_settings[1]->data;$apikey_server=$query_settings[2]->data;$wanotif_url=$query_settings[3]->data;$apikey_local=json_decode($apikey_local,true);$apikey_server=json_decode($apikey_server,true);$apikey=$apikey_local['donasiaja'][0];$license=$apikey_server['donasiaja'][0];$status=$apikey_server['donasiaja'][1];$time=$apikey_server['donasiaja'][2];$code=$apikey_server['donasiaja'][3];if($time==null||$time==''){$time=0;}
date_default_timezone_set('Asia/jakarta');$now=strtotime(date("Y-m-d h:i:s"));$time_check=floatval($time)-$now;$expired=false;if($time!='0'){if($time_check<=0){$expired=true;}else{$expired=false;}}
$plugin_check_info=true;if($code!=''&&$license!=''){if(md5($license)!=$code){$plugin_check_info=false;}}
if(md5($main_menu_name)!='f08cf9b423e4b46ed3025ddd3dc63b65'){$plugin_check_info=false;}
if($apikey==''){$activate=false;}else{if($status!='valid'){$activate=false;}else{$activate=true;}}
$donasiaja_vars=array('expired'=>$expired,'date_expired'=>$time,'plugin_name'=>'DonasiAja','plugin_version'=>'1.7.0.2','plugin_license'=>$license,'apikey'=>$apikey,'apikey_status'=>$status,'plugin_check_info'=>$plugin_check_info,'activate'=>$activate,);

}
add_action( 'parse_query', 'donasiaja_global_vars' );



do_action( 'admin_page_access_denied', function()
{
	global $wpdb;
		$table_name = $wpdb->prefix . "dja_settings";

    	$query_settings = $wpdb->get_results('SELECT data from '.$table_name.' where type="login_setting" or type="page_login" ORDER BY id ASC');
    	$login_setting 	= $query_settings[0]->data;
	    $page_login 	= $query_settings[1]->data;

	if($login_setting=='1'){
    	die(wp_redirect( home_url().'/'.$page_login.'/' ));
    }else{
    	die(wp_redirect( home_url().'/wp-login.php/' ));
    }	

} );


require 'admin/plugin-update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://member.donasiaja.id/files/downloads/donasiaja/details.json',
	__FILE__, //Full path to the main plugin file or functions.php.
	'donasiaja'
);


//menu items
add_action('admin_menu','donasiaja_modifymenu');
function donasiaja_modifymenu() {

	donasiaja_global_vars();
	global $wpdb;
	$cap = get_user_meta( wp_get_current_user()->ID, $wpdb->get_blog_prefix() . 'capabilities', true );
    $roles = array_keys((array)$cap);
    $role = $roles[0];
    $plugin_license = strtoupper($GLOBALS['donasiaja_vars']['plugin_license']);

	$table_name = $wpdb->prefix . "dja_users";
	$table_name2 = $wpdb->prefix . "dja_settings";
	$table_name3 = $wpdb->prefix . "dja_campaign";

	$query_settings = $wpdb->get_results('SELECT data from '.$table_name2.' where type="campaign_setting" or type="main_menu_name" or type="fundraiser_on" ORDER BY id ASC');
    $campaign_setting = $query_settings[0]->data;
    $main_menu_name = $query_settings[1]->data;
    $fundraiser_on 	= $query_settings[2]->data;

	$rows_campaign = $wpdb->get_results("SELECT COUNT(id) as jumlah from $table_name3 where publish_status='2' ORDER BY id DESC")[0];
	$jumlah_pending = $rows_campaign->jumlah;

	$need_review = '';
	if($jumlah_pending >= 1){
		$need_review = ' ('.$jumlah_pending.')';
	}

	if($role=='donatur'){

		if($campaign_setting=='1'){

			//this is the main item for the menu
			add_menu_page('Data Donasi | DonasiAja ', //page title
			$main_menu_name, //menu title
			'read', //capabilities
			'donasiaja_dashboard', //menu slug
			'donasiaja_dashboard', //function
			WP_PLUGIN_URL.'/donasiaja/admin/icons/donasiaja3.ico',
		    '46'
			);

			// this submenu is HIDDEN
			add_submenu_page('donasiaja_dashboard', //parent slug
			'Dashboard | DonasiAja', //page title
			'Dashboard', //menu title
			'read', //capability
			'donasiaja_dashboard', //menu slug
			'donasiaja_dashboard'); //function
			
			add_submenu_page('donasiaja_dashboard', //parent slug
			'Campaigns | DonasiAja', //page title
			'Campaigns', //menu title
			'read', //capability
			'donasiaja_data_campaign', //menu slug
			'donasiaja_data_campaign'); //function

			if($fundraiser_on=='1'){
				if($plugin_license=='ULTIMATE') {
					add_submenu_page('donasiaja_dashboard', //parent slug
					'Fundraising | DonasiAja', //page title
					'Fundraising', //menu title
					'read', //capability
					'donasiaja_data_fundraising', //menu slug
					'donasiaja_data_fundraising'); //function
				}
			}

			add_submenu_page('donasiaja_dashboard', //parent slug
			'My Donate | DonasiAja', //page title
			'My Donate', //menu title
			'read', //capability
			'donasiaja_mydonate', //menu slug
			'donasiaja_mydonate'); //function

			add_submenu_page('donasiaja_dashboard', //parent slug
			'My Profile | DonasiAja', //page title
			'My Profile', //menu title
			'read', //capability
			'donasiaja_myprofile', //menu slug
			'donasiaja_myprofile'); //function

		}else{

			//this is the main item for the menu
			add_menu_page('Data Donasi | DonasiAja ', //page title
			'My Donate', //menu title
			'read', //capabilities
			'donasiaja_dashboard', //menu slug
			'donasiaja_mydonate', //function
			WP_PLUGIN_URL.'/donasiaja/admin/icons/donasiaja3.ico',
		    '46'
			);

			if($fundraiser_on=='1'){
				if($plugin_license=='ULTIMATE') {
					add_submenu_page('donasiaja_dashboard', //parent slug
					'Fundraising | DonasiAja', //page title
					'Fundraising', //menu title
					'read', //capability
					'donasiaja_data_fundraising', //menu slug
					'donasiaja_data_fundraising'); //function
				}
			}

			//this submenu is HIDDEN
			add_submenu_page('donasiaja_dashboard', //parent slug
			'My Profile | DonasiAja', //page title
			'My Profile', //menu title
			'read', //capability
			'donasiaja_myprofile', //menu slug
			'donasiaja_myprofile'); //function

		}

	}else{

		//this is the main item for the menu
		add_menu_page('Data Donasi | DonasiAja ', //page title
		$main_menu_name, //menu title
		'read', //capabilities
		'donasiaja_dashboard', //menu slug
		'donasiaja_dashboard', //function
		WP_PLUGIN_URL.'/donasiaja/admin/icons/donasiaja3.ico',
	    '46'
		);

		//this submenu is HIDDEN
		add_submenu_page('donasiaja_dashboard', //parent slug
		'Dashboard | DonasiAja', //page title
		'Dashboard', //menu title
		'read', //capability
		'donasiaja_dashboard', //menu slug
		'donasiaja_dashboard'); //function
		
		if($role!='cs'){
			//this submenu is HIDDEN
			add_submenu_page('donasiaja_dashboard', //parent slug
			'Campaigns | DonasiAja', //page title
			'Campaigns'.$need_review, //menu title
			'read', //capability
			'donasiaja_data_campaign', //menu slug
			'donasiaja_data_campaign'); //function
		}
	}


    // jika bukan Donatur
    if($role!='donatur'){

    	$user_on_review = $wpdb->get_results('SELECT id from '.$table_name.' where user_verification="2"');

    	if($user_on_review!=null){
    		$jumlah_on_review = '('.count($user_on_review).')';
    	}else{
    		$jumlah_on_review = '';
    	}

    	if($role=='administrator' || $role=='cs'){
    		if($fundraiser_on=='1'){
    			if($plugin_license=='ULTIMATE') {
					add_submenu_page('donasiaja_dashboard', //parent slug
					'Fundraising | DonasiAja', //page title
					'Fundraising', //menu title
					'read', //capability
					'donasiaja_data_fundraising', //menu slug
					'donasiaja_data_fundraising'); //function
				}
			}
		}
        
   		if($role!='cs'){
		//this submenu is HIDDEN
		add_submenu_page('donasiaja_dashboard', //parent slug
		'Shortcodes | DonasiAja', //page title
		'Shortcodes', //menu title
		'read', //capability
		'donasiaja_data_shortcodes', //menu slug
		'donasiaja_data_shortcodes'); //function
		}

		if($role=='administrator'){
		//this submenu is HIDDEN
		add_submenu_page('donasiaja_dashboard', //parent slug
		'Members | DonasiAja', //page title
		'Members '.$jumlah_on_review.'', //menu title
		'read', //capability
		'donasiaja_data_members', //menu slug
		'donasiaja_data_members'); //function

		}

	}

	if($role!='donatur'){
		// //this submenu is HIDDEN
		add_submenu_page('donasiaja_dashboard', //parent slug
		'My Donate | DonasiAja', //page title
		'My Donate', //menu title
		'read', //capability
		'donasiaja_mydonate', //menu slug
		'donasiaja_mydonate'); //function

		//this submenu is HIDDEN
		add_submenu_page('donasiaja_dashboard', //parent slug
		'My Profile | DonasiAja', //page title
		'My Profile', //menu title
		'read', //capability
		'donasiaja_myprofile', //menu slug
		'donasiaja_myprofile'); //function
	}

	// jika bukan Donatur
    if($role=='administrator'){

		//this submenu is HIDDEN
		add_submenu_page('donasiaja_dashboard', //parent slug
		'Settings | DonasiAja', //page title
		'Settings', //menu title
		'read', //capability
		'donasiaja_settings', //menu slug
		'donasiaja_settings'); //function
	}

	
	//this submenu is HIDDEN, however, we need to add it anyways
	add_submenu_page(null, //parent slug
	'Update School', //page title
	'Update', //menu title
	'read', //capability
	'donasiaja_update', //menu slug
	'donasiaja_update'); //function

}
define('ROOTDIR_DNA', plugin_dir_path(__FILE__));
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_dashboard2.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_data_campaign.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_data_fundraising.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_data_shortcodes.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_data_members.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_myprofile.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_mydonate.php');
require_once(ROOTDIR_DNA . 'admin/f_donasiaja_settings.php');